/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class WebLogicObjectName
extends ObjectName {
    public static final String WEBLOGIC = "weblogic";
    public static final String NAME = "Name";
    public static final String TYPE = "Type";
    public static final String LOCATION = "Location";
    private static final long serialVersionUID = 7351961731978894257L;
    private static final String[] ABSTRACT_TYPES = new String[]{"Configuration", "Deployment", "WebDeployment", "WebLogic"};
    private boolean isAdmin;
    private boolean isConfig;
    private boolean isRuntime;
    private WebLogicObjectName parent;
    private int hashCode;

    public WebLogicObjectName(String string) throws MalformedObjectNameException {
        super(WebLogicObjectName.extractDomain(string), WebLogicObjectName.extractProperties(string));
        this.validate();
    }

    public WebLogicObjectName(String string, String string2, String string3) throws MalformedObjectNameException {
        this(string3 + ":" + NAME + "=" + string + "," + TYPE + "=" + string2);
    }

    public WebLogicObjectName(String string, String string2, String string3, String string4) throws MalformedObjectNameException {
        this(string3 + ":" + NAME + "=" + string + "," + TYPE + "=" + string2 + "," + LOCATION + "=" + string4);
    }

    public WebLogicObjectName(String string, String string2, String string3, WebLogicObjectName webLogicObjectName) throws MalformedObjectNameException {
        this(string, string2, string3, null, webLogicObjectName);
    }

    public WebLogicObjectName(WebLogicObjectName webLogicObjectName, WebLogicObjectName webLogicObjectName2) throws MalformedObjectNameException {
        this(webLogicObjectName.getName(), webLogicObjectName.getType(), webLogicObjectName.getDomain(), webLogicObjectName.getLocation(), webLogicObjectName2);
    }

    public WebLogicObjectName(String string, String string2, String string3, String string4, WebLogicObjectName webLogicObjectName) throws MalformedObjectNameException {
        super(string3, WebLogicObjectName.makePropertyTable(string, string2, string4, webLogicObjectName));
        this.parent = webLogicObjectName;
        this.validate();
    }

    public WebLogicObjectName(String string, String string2, WebLogicObjectName webLogicObjectName) throws MalformedObjectNameException {
        super(webLogicObjectName.getDomain(), WebLogicObjectName.makePropertyTable(string, string2, null, webLogicObjectName));
        this.parent = webLogicObjectName;
        this.validate();
    }

    public WebLogicObjectName(String string, Hashtable hashtable) throws MalformedObjectNameException {
        super(string, hashtable);
        this.validate();
    }

    public WebLogicObjectName(ObjectName objectName, String string) throws MalformedObjectNameException {
        this(objectName.getDomain(), WebLogicObjectName.localize(objectName, string));
        WebLogicObjectName webLogicObjectName;
        if (objectName instanceof WebLogicObjectName && (webLogicObjectName = ((WebLogicObjectName)objectName).getParent()) != null) {
            this.parent = new WebLogicObjectName((ObjectName)webLogicObjectName, string);
        }
        this.validate();
    }

    public static boolean isAdmin(ObjectName objectName) {
        String string = objectName.getKeyProperty(LOCATION);
        return string == null;
    }

    public static boolean isConfig(ObjectName objectName) {
        String string = objectName.getKeyProperty(TYPE);
        return string != null && string.endsWith("Config");
    }

    public static boolean isRuntime(ObjectName objectName) {
        String string = objectName.getKeyProperty(TYPE);
        return string != null && string.endsWith("Runtime");
    }

    public static String extractDomain(String string) throws MalformedObjectNameException {
        String string2;
        int n = string.indexOf(":");
        if (n >= 1 && !(string2 = string.substring(0, n)).equals("null")) {
            return string2;
        }
        throw new MalformedObjectNameException("Domain name either missing or null");
    }

    private static Hashtable extractProperties(String string) throws MalformedObjectNameException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = string.indexOf(":");
        if (n > -1) {
            string = string.substring(n + 1, string.length());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf("=");
            if (n2 < 1) {
                throw new MalformedObjectNameException("bad object name property: " + string2);
            }
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1, string2.length());
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    private static Hashtable makePropertyTable(String string, String string2, String string3, WebLogicObjectName webLogicObjectName) throws MalformedObjectNameException {
        if (string2 == null) {
            throw new MalformedObjectNameException("type cannot be null");
        }
        Hashtable hashtable = null;
        if (webLogicObjectName == null) {
            hashtable = new Hashtable(2);
        } else {
            hashtable = (Hashtable)webLogicObjectName.getKeyPropertyList().clone();
            if (!webLogicObjectName.getType().equals("Domain")) {
                hashtable.put(webLogicObjectName.getType(), webLogicObjectName.getName());
            }
        }
        hashtable.put(NAME, string);
        hashtable.put(TYPE, string2);
        if (string3 != null) {
            hashtable.put(LOCATION, string3);
        }
        return hashtable;
    }

    private static Hashtable localize(ObjectName objectName, String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = objectName.getKeyPropertyList();
        Iterator iterator = hashtable2.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)hashtable2.get(string2);
            if (string2.equals(NAME)) {
                hashtable.put(string2, string3);
                continue;
            }
            if (string2.equals(TYPE)) {
                hashtable.put(string2, string3 + "Config");
                continue;
            }
            hashtable.put(string2 + "Config", string3);
        }
        hashtable.put(LOCATION, string);
        return hashtable;
    }

    public String getName() {
        return this.getKeyProperty(NAME);
    }

    public String getType() {
        return this.getKeyProperty(TYPE);
    }

    public String getLocation() {
        return this.getKeyProperty(LOCATION);
    }

    public WebLogicObjectName getParent() {
        return this.parent;
    }

    public String getNormalizedToStringName() {
        StringBuffer stringBuffer = new StringBuffer(this.getDomain() + ":");
        Hashtable hashtable = this.getKeyPropertyList();
        String string = (String)hashtable.remove(NAME);
        String string2 = (String)hashtable.remove(TYPE);
        String string3 = (String)hashtable.remove(LOCATION);
        if (string != null) {
            stringBuffer.append("Name=" + string + ",");
        }
        if (string2 != null) {
            stringBuffer.append("Type=" + string2 + ",");
        }
        if (string3 != null) {
            stringBuffer.append("Location=" + string3 + ",");
        }
        Iterator iterator = hashtable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append((String)entry.getKey() + "=" + (String)entry.getValue() + ",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        if (string != null) {
            hashtable.put(NAME, string);
        }
        if (string2 != null) {
            hashtable.put(TYPE, string2);
        }
        if (string3 != null) {
            hashtable.put(LOCATION, string3);
        }
        return stringBuffer.toString();
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isConfig() {
        return this.isConfig;
    }

    public boolean isRuntime() {
        return this.isRuntime;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode();
        }
        return this.hashCode;
    }

    public static final boolean isAbstract(String string) {
        for (int i = 0; i < ABSTRACT_TYPES.length; ++i) {
            if (!ABSTRACT_TYPES[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private void validate() throws MalformedObjectNameException {
        String string = this.getType();
        if (WebLogicObjectName.isAbstract(string)) {
            throw new MalformedObjectNameException("Cannot create abstract MBean, name: " + this.toString());
        }
        boolean bl = this.isAdmin = this.getLocation() == null;
        if (string != null) {
            this.isConfig = string.endsWith("Config");
            this.isRuntime = string.endsWith("Runtime");
        }
    }
}

