/*
 * Decompiled with CFR 0.152.
 */
package weblogic.math;

import java.math.BigInteger;
import weblogic.security.RandomBitsSource;

public final class Bignum {
    byte[] data;
    boolean padded = false;
    static String[] digit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public Bignum() {
        this.data = new byte[]{0};
    }

    public Bignum(int n) {
        int n2 = this.dataLength(n);
        this.data = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            this.data[i] = (byte)n;
            n >>>= 8;
        }
    }

    public Bignum(byte[] byArray) {
        if ((byArray[0] & 0x80) == 128) {
            this.data = new byte[byArray.length + 1];
            this.data[0] = 0;
            System.arraycopy(byArray, 0, this.data, 1, byArray.length);
            this.padded = true;
        } else {
            this.data = byArray;
        }
    }

    public Bignum(byte[] byArray, boolean bl) {
        this.data = byArray;
    }

    public byte[] toBytes() {
        return this.data;
    }

    public byte[] unsignedBytes() {
        if (this.padded) {
            byte[] byArray = new byte[this.data.length - 1];
            System.arraycopy(this.data, 1, byArray, 0, byArray.length);
            return byArray;
        }
        return this.data;
    }

    public int dataLength(int n) {
        boolean bl = false;
        if (n < 0) {
            throw new Error("unexpected negative number");
        }
        return n < 32768 ? (n < 128 ? 1 : 2) : (n < 0x800000 ? 3 : 4);
    }

    public int intValue() {
        if (this.data.length > 4) {
            throw new Error("cannot represent as int");
        }
        int n = this.data[0];
        for (int i = 1; i < this.data.length; ++i) {
            n <<= 8;
            n |= this.data[i] & 0xFF;
        }
        return n;
    }

    public static Bignum randomBignum(int n, RandomBitsSource randomBitsSource) {
        byte[] byArray = new byte[(n - 1) / 8 + 1];
        byArray = randomBitsSource.randomBytes(byArray);
        return new Bignum(byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.data.length).append(" byte Bignum value=");
        for (int i = 0; i < this.data.length; ++i) {
            stringBuffer.append(digit[this.data[i] >> 4 & 0xF]).append(digit[this.data[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public BigInteger getValue() {
        return new BigInteger(this.toBytes());
    }
}

