/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import weblogic.security.RandomBitsSource;

public final class SpinnerRandomBitsSource
extends RandomBitsSource
implements Runnable {
    private static int MAX_TIMEOUT = 10;
    private volatile long spinTimeout = 0L;
    private volatile int spinCount = 0;
    private final Thread t;
    private final Object syncLock = new Object();

    public synchronized void seed(byte[] byArray) {
    }

    public SpinnerRandomBitsSource() {
        this.t = new Thread((Runnable)this, "weblogic.security.SpinnerRandomSource");
        this.t.setDaemon(true);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte randomByte() {
        int n = this.spinCount;
        do {
            long l = System.currentTimeMillis();
            int n2 = Math.max(((int)l + n) % MAX_TIMEOUT, 1);
            Object object = this.syncLock;
            synchronized (object) {
                this.spinTimeout = l + (long)n2;
                this.syncLock.notify();
            }
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (Math.abs(this.spinCount - n) < 128);
        return (byte)(this.spinCount & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (System.currentTimeMillis() > this.spinTimeout) {
                Object object = this.syncLock;
                synchronized (object) {
                    try {
                        this.syncLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (Thread.interrupted()) {
                    return;
                }
            }
            ++this.spinCount;
        }
    }

    protected void finalize() {
        this.t.interrupt();
    }
}

