/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.pcs;

import com.sonicsw.security.pcs.CipherSuiteInfo;
import com.sonicsw.security.pcs.EInvalidCipherSuiteException;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import com.sonicsw.security.pcs.PluggableCipherSuite;
import com.sonicsw.security.pcs.PluggableMessageProtection;
import com.sonicsw.security.pcs.SonicCipherSuite;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import progress.message.crypto.KeyGen;
import progress.message.zclient.IMessageProtection;

public abstract class AbstractCipherSuite
implements IPluggableCipherSuite {
    static final String fp_ = "AES";
    static final String gp_ = "Blowfish";
    static final String hp_ = "DES";
    static final String ip_ = "DESEDE";
    static final String jp_ = "ECB";
    private static Class kp_;
    private static Class lp_;
    public static boolean m_isSonicCipherSuite;
    public static String m_cipherProviderName;
    public static String m_cipherProviderVersion;
    public static String m_cipherTransformation;
    static String mp_;
    private static boolean np_;
    static int op_;
    public static boolean m_isKeySizeSupplied;
    static int oZ_;
    public static String m_digestProviderName;
    public static String m_digestProviderVersion;
    public static String m_digestAlgorithm;
    static int pp_;

    protected AbstractCipherSuite(String string, String string2, String string3, int n, String string4, String string5, String string6) throws EInvalidCipherSuiteException {
        if (string != null && string.equalsIgnoreCase("SonicSoftware") && string2 != null && string2.equalsIgnoreCase("1.0") && string3 != null && string3.equalsIgnoreCase(hp_) && string4 != null && string4.equalsIgnoreCase("SonicSoftware") && string5 != null && string5.equalsIgnoreCase("1.0") && string6 != null && string6.equalsIgnoreCase("MD5")) {
            this.ul_();
        } else {
            this.tl_(string, string2, string3, n, string4, string5, string6);
        }
    }

    public static final IPluggableCipherSuite getCipherSuiteInstance(CipherSuiteInfo cipherSuiteInfo) throws EInvalidCipherSuiteException {
        String[] stringArray = null;
        String[] stringArray2 = null;
        stringArray = cipherSuiteInfo.getTransformation(0);
        String[] stringArray3 = AbstractCipherSuite.getTransformationAndKeySize(stringArray[2]);
        if (stringArray3 == null || stringArray3.length == 0 || stringArray3[0] == null) {
            throw new EInvalidCipherSuiteException("Invalid transformation " + stringArray[2]);
        }
        String string = stringArray3[0];
        String string2 = stringArray3[1];
        int n = 0;
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        stringArray2 = cipherSuiteInfo.getDigest(0);
        return AbstractCipherSuite.getCipherSuiteInstance(stringArray[0], stringArray[1], string, n, stringArray2[0], stringArray2[1], stringArray2[2]);
    }

    public static IPluggableCipherSuite getCipherSuiteInstance(String string, String string2, String string3, int n, String string4, String string5, String string6) throws EInvalidCipherSuiteException {
        if (string != null && string.equalsIgnoreCase("SonicSoftware") && string2 != null && string2.equalsIgnoreCase("1.0") && string3 != null && string3.equalsIgnoreCase(hp_) && string4 != null && string4.equalsIgnoreCase("SonicSoftware") && string5 != null && string5.equalsIgnoreCase("1.0") && string6 != null && string6.equalsIgnoreCase("MD5")) {
            return SonicCipherSuite.getInstance();
        }
        return PluggableCipherSuite.co_(string, string2, string3, n, string4, string5, string6);
    }

    private final void tl_(String string, String string2, String string3, int n, String string4, String string5, String string6) throws EInvalidCipherSuiteException {
        Provider[] providerArray;
        Provider provider = null;
        Provider provider2 = null;
        if (string != null && string.trim().length() != 0 && string2 != null && string2.trim().length() != 0 && string4 != null && string4.trim().length() != 0 && string5 != null && string5.trim().length() != 0 && ((providerArray = Security.getProviders()) != null || providerArray.length > 0)) {
            int n2 = 0;
            while (n2 < providerArray.length) {
                Provider provider3 = providerArray[n2];
                double d = Double.parseDouble(string2);
                if (provider3 != null && d == provider3.getVersion() && provider3.getName().equalsIgnoreCase(string)) {
                    provider = provider3;
                }
                d = Double.parseDouble(string5);
                if (provider3 != null && d == provider3.getVersion() && provider3.getName().equalsIgnoreCase(string5)) {
                    provider2 = provider3;
                }
                if (provider != null && provider2 != null) break;
                ++n2;
            }
        }
        if (provider != null) {
            try {
                providerArray = Cipher.getInstance(string3, provider.getName());
                Provider provider4 = providerArray.getProvider();
                m_cipherProviderName = provider4.getName();
                m_cipherProviderVersion = Double.toString(provider4.getVersion());
                m_cipherTransformation = string3;
                int n3 = 0;
                n3 = m_cipherTransformation.indexOf("/");
                if (n3 != -1) {
                    String string7;
                    mp_ = m_cipherTransformation.substring(0, n3);
                    if (m_cipherTransformation.indexOf("/", n3 + 1) != -1 && (string7 = m_cipherTransformation.substring(n3 + 1, m_cipherTransformation.indexOf("/", n3 + 1))) != null && !string7.equalsIgnoreCase(jp_)) {
                        np_ = false;
                    }
                } else {
                    mp_ = m_cipherTransformation;
                }
                if ((oZ_ = providerArray.getBlockSize()) == 0) {
                    provider = null;
                }
                if (n == 0) {
                    m_isKeySizeSupplied = false;
                    KeyGenerator keyGenerator = null;
                    SecretKey secretKey = null;
                    byte[] byArray = null;
                    keyGenerator = KeyGenerator.getInstance(mp_);
                    secretKey = keyGenerator.generateKey();
                    byArray = secretKey.getEncoded();
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, mp_);
                    byArray = secretKeySpec.getEncoded();
                    op_ = byArray.length;
                } else {
                    m_isKeySizeSupplied = true;
                    op_ = n;
                }
                if (op_ == 0) {
                    provider = null;
                }
            }
            catch (Exception exception) {
                provider = null;
            }
        }
        if (provider2 != null) {
            try {
                providerArray = MessageDigest.getInstance(string6, provider2.getName());
                Provider provider5 = providerArray.getProvider();
                m_digestProviderName = provider5.getName();
                m_digestProviderVersion = Double.toString(provider5.getVersion());
                pp_ = providerArray.getDigestLength();
                m_digestAlgorithm = string6;
            }
            catch (Exception exception) {
                provider2 = null;
            }
        }
        if (provider == null) {
            this.vl_(string3);
            this.wl_(string3, n);
        }
        if (provider2 == null) {
            this.xl_(string6);
        }
    }

    private final void ul_() {
        m_isSonicCipherSuite = true;
        m_cipherProviderName = "SonicSoftware";
        m_cipherProviderVersion = "1.0";
        mp_ = m_cipherTransformation = hp_;
        op_ = 8;
        oZ_ = 8;
        m_digestProviderName = "SonicSoftware";
        m_digestProviderVersion = "1.0";
        m_digestAlgorithm = "MD5";
        pp_ = 16;
    }

    private final void vl_(String string) throws EInvalidCipherSuiteException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EInvalidCipherSuiteException(string + ": " + noSuchAlgorithmException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EInvalidCipherSuiteException(generalSecurityException.getMessage());
        }
        Provider provider = cipher.getProvider();
        m_cipherProviderName = provider.getName();
        m_cipherProviderVersion = Double.toString(provider.getVersion());
        m_cipherTransformation = string;
        int n = 0;
        n = m_cipherTransformation.indexOf("/");
        if (n != -1) {
            String string2;
            mp_ = m_cipherTransformation.substring(0, n);
            if (m_cipherTransformation.indexOf("/", n + 1) != -1 && (string2 = m_cipherTransformation.substring(n + 1, m_cipherTransformation.indexOf("/", n + 1))) != null && !string2.equalsIgnoreCase(jp_)) {
                np_ = false;
            }
        } else {
            mp_ = m_cipherTransformation;
        }
        if ((oZ_ = cipher.getBlockSize()) == 0) {
            throw new EInvalidCipherSuiteException("Unable to generate the appropriate block size: " + oZ_ + " using " + m_cipherProviderName + ". " + m_cipherProviderVersion);
        }
    }

    private final void wl_(String string, int n) throws EInvalidCipherSuiteException {
        if (n == 0) {
            m_isKeySizeSupplied = false;
            int n2 = 0;
            n2 = string.indexOf("/");
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            KeyGenerator keyGenerator = null;
            SecretKey secretKey = null;
            byte[] byArray = null;
            try {
                keyGenerator = KeyGenerator.getInstance(string);
                secretKey = keyGenerator.generateKey();
                byArray = secretKey.getEncoded();
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
                byArray = secretKeySpec.getEncoded();
                op_ = byArray.length;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new EInvalidCipherSuiteException(string + ": " + noSuchAlgorithmException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new EInvalidCipherSuiteException(string + ": " + ((Throwable)nullPointerException).getMessage());
            }
        } else {
            m_isKeySizeSupplied = true;
            op_ = n;
        }
        if (op_ == 0) {
            throw new EInvalidCipherSuiteException("Unable to generate the appropriate secret key length: " + op_ + " using " + m_cipherProviderName + ". " + m_cipherProviderVersion);
        }
    }

    private final void xl_(String string) throws EInvalidCipherSuiteException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EInvalidCipherSuiteException(string + ": " + noSuchAlgorithmException.getMessage());
        }
        Provider provider = messageDigest.getProvider();
        m_digestProviderName = provider.getName();
        m_digestProviderVersion = Double.toString(provider.getVersion());
        pp_ = messageDigest.getDigestLength();
        m_digestAlgorithm = string;
    }

    public static final Cipher getNewCipherInstance(String string) throws EInvalidCipherSuiteException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EInvalidCipherSuiteException(string + ": " + noSuchAlgorithmException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EInvalidCipherSuiteException(generalSecurityException.getMessage());
        }
        return cipher;
    }

    public static final MessageDigest getNewMessageDigestInstance(String string) throws EInvalidCipherSuiteException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EInvalidCipherSuiteException(string + ": " + noSuchAlgorithmException.getMessage());
        }
        return messageDigest;
    }

    public static final IMessageProtection getNewMessageProtectionInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        IMessageProtection iMessageProtection = null;
        try {
            if (m_isSonicCipherSuite) {
                if (kp_ == null) {
                    kp_ = Class.forName("progress.message.crypto.MessageProtection");
                }
                iMessageProtection = (IMessageProtection)kp_.newInstance();
            } else {
                if (lp_ == null) {
                    lp_ = Class.forName("com.sonicsw.security.pcs.PluggableMessageProtection");
                }
                iMessageProtection = (IMessageProtection)lp_.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            throw instantiationException;
        }
        return iMessageProtection;
    }

    public static final IMessageProtection getNewMessageProtectionInstance(IPluggableCipherSuite iPluggableCipherSuite) throws ClassNotFoundException, IllegalAccessException, InstantiationException, EInvalidCipherSuiteException {
        IMessageProtection iMessageProtection = null;
        try {
            if (iPluggableCipherSuite.isSonicCipherSuite()) {
                if (kp_ == null) {
                    kp_ = Class.forName("progress.message.crypto.MessageProtection");
                }
                iMessageProtection = (IMessageProtection)kp_.newInstance();
            } else {
                PluggableMessageProtection pluggableMessageProtection = new PluggableMessageProtection(iPluggableCipherSuite);
                iMessageProtection = pluggableMessageProtection;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            throw instantiationException;
        }
        catch (EInvalidCipherSuiteException eInvalidCipherSuiteException) {
            throw eInvalidCipherSuiteException;
        }
        return iMessageProtection;
    }

    public CipherSuiteInfo getCipherSuiteInfo() {
        CipherSuiteInfo cipherSuiteInfo = new CipherSuiteInfo();
        if (m_isKeySizeSupplied) {
            cipherSuiteInfo.setCipherInfo(m_cipherProviderName, m_cipherProviderVersion, m_cipherTransformation + "/" + op_);
        } else {
            cipherSuiteInfo.setCipherInfo(m_cipherProviderName, m_cipherProviderVersion, m_cipherTransformation);
        }
        cipherSuiteInfo.setDigestInfo(m_digestProviderName, m_digestProviderVersion, m_digestAlgorithm);
        return cipherSuiteInfo;
    }

    public String getCipherTransformation() {
        return m_cipherTransformation;
    }

    public String getCipherAlgorithm() {
        return mp_;
    }

    public String getDigestAlgorithm() {
        return m_digestAlgorithm;
    }

    public int getSecretKeyLength() {
        return op_;
    }

    public int getBlockSize() {
        return oZ_;
    }

    public int getHashLength() {
        return pp_;
    }

    public final boolean isSonicCipherSuite() {
        return m_isSonicCipherSuite;
    }

    public static final boolean isCipherModeECB() {
        return np_;
    }

    public static final AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[oZ_];
        byte[] byArray3 = KeyGen.getIV((byte[])byArray);
        if (byArray3.length >= byArray2.length) {
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        } else {
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            int n3 = byArray3.length;
            while (n3 < byArray2.length) {
                byArray2[n3] = 48;
                ++n3;
            }
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 0, byArray2.length);
        return ivParameterSpec;
    }

    public static final String[] getTransformationAndKeySize(String string) {
        String string2;
        String string3 = string2 = string;
        String string4 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 != -1) {
            if ((n2 = string2.indexOf("/", n2 + 1)) == -1) continue;
            ++n3;
        }
        if (n3 == 3) {
            string3 = string2.substring(0, string2.lastIndexOf("/"));
            if ((string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.length())) != null) {
                try {
                    n = Integer.parseInt(string2);
                    string4 = string2;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        }
        String[] stringArray = new String[]{string3, string4};
        return stringArray;
    }

    static {
        m_cipherProviderName = null;
        m_cipherProviderVersion = null;
        m_cipherTransformation = null;
        mp_ = null;
        np_ = true;
        op_ = 0;
        oZ_ = 0;
        m_digestProviderName = null;
        m_digestProviderVersion = null;
        m_digestAlgorithm = null;
        pp_ = 0;
    }
}

