/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.util.debug;

import com.sonicsw.util.debug.DebugConstants;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;

public final class Debug
implements DebugConstants {
    private static final String PROPERTY_KEY_TRACEFILE = "debug.tracefile";
    private static final String PROPERTY_KEY_RESULTFILE = "debug.outputfile";
    private static final String TRACE_LABEL = "TRACE:";
    private static final Object m_syncObject = new byte[0];
    private static ArrayList m_classnameList;
    private static FileOutputStream m_fileOutputStream;
    private static ByteArrayOutputStream m_byteArrayOutputStream;
    private static PrintWriter m_printWriter;

    private Debug() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void trace(String string) {
        if (m_classnameList != null) {
            Object object = m_syncObject;
            synchronized (object) {
                String string2 = Debug.generateTraceInfo(string);
                if (string2 != null) {
                    System.err.println(string2);
                    if (m_fileOutputStream != null) {
                        try {
                            m_fileOutputStream.write((string2 + "\r\n").getBytes());
                            m_fileOutputStream.flush();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            m_fileOutputStream = null;
                        }
                    }
                }
            }
        }
    }

    private static boolean getTraceableClassNames() {
        String string = System.getProperty(PROPERTY_KEY_TRACEFILE);
        if (string == null) {
            return false;
        }
        File file = new File(string);
        FileReader fileReader = null;
        if (!file.isFile()) {
            return false;
        }
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        m_classnameList = new ArrayList();
        String string2 = null;
        while (true) {
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return false;
            }
            if (string2 == null) break;
            if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
            m_classnameList.add(string2);
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            m_classnameList = null;
            return false;
        }
        if (m_classnameList.size() == 0) {
            m_classnameList = null;
            return false;
        }
        return true;
    }

    private static void allocateOutputStreams() {
        m_byteArrayOutputStream = new ByteArrayOutputStream();
        m_printWriter = new PrintWriter(m_byteArrayOutputStream);
        String string = System.getProperty(PROPERTY_KEY_RESULTFILE);
        if (string == null) {
            return;
        }
        try {
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                File file2 = new File(file.getPath() + Long.toString(new Date().getTime()) + ".log");
                file.renameTo(file2);
            }
            m_fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            m_fileOutputStream = null;
            iOException.printStackTrace();
        }
    }

    private static String generateTraceInfo(String string) {
        Exception exception = new Exception();
        exception.printStackTrace(m_printWriter);
        m_printWriter.flush();
        String string2 = m_byteArrayOutputStream.toString();
        m_byteArrayOutputStream.reset();
        int n = -1;
        int n2 = 0;
        while (n2 < 3) {
            n = string2.indexOf(40, n + 1);
            ++n2;
        }
        int n3 = string2.indexOf(41, n + 1);
        int n4 = string2.lastIndexOf(32, n);
        String string3 = string2.substring(n4 + 1, n);
        String string4 = string2.substring(n4 + 1, n3 + 1);
        int n5 = string2.lastIndexOf(46, n - 1);
        String string5 = string2.substring(n4 + 1, n5);
        String string6 = null;
        if (m_classnameList.contains(string5) || m_classnameList.contains("ALL")) {
            string6 = TRACE_LABEL + string4 + ": " + string;
        }
        return string6;
    }

    public static final void main(String[] stringArray) {
    }

    static {
        if (Debug.getTraceableClassNames()) {
            Debug.allocateOutputStreams();
        }
    }
}

