/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import com.sonicsw.security.pass.client.ILogin;
import java.applet.Applet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import progress.message.client.prAccessor;
import progress.message.jimpl.BrokerName;
import progress.message.zclient.SessionConfig;

public class ConnectionFactory
implements javax.jms.ConnectionFactory,
Referenceable,
Serializable {
    static final long serialVersionUID = -8933574000518832624L;
    public static final String ENABLE_LOCAL_STORE = "EnableLocalStore";
    public static final String LOCAL_STORE_DIRECTORY = "LocalStoreDirectory";
    public static final String LOCAL_STORE_SIZE = "LocalStoreSize";
    public static final String RECONNECT_TIMEOUT = "ReconnectTimeout";
    public static final String RECONNECT_INTERVAL = "ReconnectInterval";
    public static final String LOCAL_STORE_LISTENER_FACTORY_CLASS = "LocalStoreListenerFactoryClass";
    public static final String PING_INTERVAL = "pingInterval";
    public static final String FAULT_TOLERANT = "faultTolerant";
    public static final String FAULT_TOLERANT_RECONNECT_TIMEOUT = "faultTolerantReconnectTimeout";
    public static final String INITIAL_CONNECT_TIMEOUT = "initialConnectTimeout";
    public static final String CLIENT_TRANSACTION_BUFFER_SIZE = "clientTransactionBufferSize";
    public static final String FLOW_TO_DISK = "FLOW_TO_DISK";
    public static final String TCP = "tcp";
    public static final String HTTP = "http";
    public static final String SSL = "ssl";
    protected static final String CF_EMPTY_PASSWORD = "";
    protected static final String CF_EMPTY_USERNAME = "";
    public static final String LOGIN_SPI_OBJECT = "login_spi_object";
    protected Hashtable env;
    private String brokerURL;
    private String connectID;
    private String defaultUserName;
    private String defaultPassword;
    private String brokerHostName = "localhost";
    private String brokerProtocol = "tcp";
    private int brokerPort;
    private String clientID;
    private Applet applet = null;
    static Class class$progress$message$jclient$ConnectionFactory;
    static Class class$progress$message$jclient$AdministeredObjectFactory;

    public ConnectionFactory() throws JMSException {
        this("localhost");
    }

    protected ConnectionFactory(Hashtable hashtable) throws JMSException {
        this((String)hashtable.get("brokerURL"), (String)hashtable.get("connectID"), (String)hashtable.get("defaultUserName"), (String)hashtable.get("defaultPassword"));
        String string = (String)hashtable.get("clientID");
        if (string != null) {
            this.setClientID(string);
        }
        this.env = hashtable;
        this.setDefaultProperties();
    }

    public ConnectionFactory(String string) throws JMSException {
        this(string, null, "", "");
    }

    public ConnectionFactory(String string, String string2) throws JMSException {
        this(string, string2, "", "");
    }

    public ConnectionFactory(String string, String string2, String string3) throws JMSException {
        this(string, null, string2, string3);
    }

    public ConnectionFactory(String string, String string2, String string3, String string4) throws JMSException {
        this.setDefaultProperties();
        this.connectID = string2;
        this.brokerURL = string;
        this.defaultUserName = string3 == null ? "" : string3;
        this.defaultPassword = string4 == null ? "" : string4;
        BrokerName brokerName = new BrokerName(string);
        this.brokerHostName = brokerName.getBrokerHostName();
        this.brokerPort = brokerName.getBrokerPort();
        this.brokerProtocol = brokerName.getBrokerProtocol();
    }

    public ConnectionFactory(String string, int n, String string2, String string3, String string4) throws JMSException {
        this(string, n, string2, null, string3, string4);
    }

    public ConnectionFactory(String string, int n, String string2, String string3, String string4, String string5) throws JMSException {
        this.setDefaultProperties();
        this.connectID = string3;
        this.defaultUserName = string4 == null ? "" : string4;
        this.defaultPassword = string5 == null ? "" : string5;
        BrokerName brokerName = new BrokerName(string, n, string2);
        this.brokerHostName = brokerName.getBrokerHostName();
        this.brokerPort = brokerName.getBrokerPort();
        this.brokerProtocol = brokerName.getBrokerProtocol();
        this.brokerURL = brokerName.getBrokerURL();
    }

    protected void setDefaultProperties() {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        if (this.env.get(ENABLE_LOCAL_STORE) == null) {
            this.env.put(ENABLE_LOCAL_STORE, new Boolean(false));
        }
        if (this.env.get(LOCAL_STORE_DIRECTORY) == null) {
            try {
                this.env.put(LOCAL_STORE_DIRECTORY, System.getProperty("user.dir"));
            }
            catch (SecurityException securityException) {
                this.env.put(LOCAL_STORE_DIRECTORY, "");
            }
        }
        if (this.env.get(LOCAL_STORE_SIZE) == null) {
            this.env.put(LOCAL_STORE_SIZE, new Long(10000L));
        }
        if (this.env.get(RECONNECT_TIMEOUT) == null) {
            this.env.put(RECONNECT_TIMEOUT, new Integer(0));
        }
        if (this.env.get(RECONNECT_INTERVAL) == null) {
            this.env.put(RECONNECT_INTERVAL, new Integer(30));
        }
        if (this.env.get(FAULT_TOLERANT) == null) {
            this.env.put(FAULT_TOLERANT, new Boolean(false));
        }
        if (this.env.get(FAULT_TOLERANT_RECONNECT_TIMEOUT) == null) {
            this.env.put(FAULT_TOLERANT_RECONNECT_TIMEOUT, new Integer(60));
        }
        if (this.env.get(INITIAL_CONNECT_TIMEOUT) == null) {
            this.env.put(INITIAL_CONNECT_TIMEOUT, new Integer(30));
        }
        if (this.env.get(CLIENT_TRANSACTION_BUFFER_SIZE) == null) {
            this.env.put(CLIENT_TRANSACTION_BUFFER_SIZE, new Long(0L));
        }
        if (this.env.get(FLOW_TO_DISK) == null) {
            this.env.put(FLOW_TO_DISK, new Integer(0));
        }
    }

    public void setEnableLocalStore(boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(ENABLE_LOCAL_STORE, new Boolean(bl));
    }

    public void setEnableLocalStoreBoolean(Boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(ENABLE_LOCAL_STORE, bl);
    }

    public boolean isEnableLocalStore() {
        return (Boolean)this.env.get(ENABLE_LOCAL_STORE);
    }

    public Boolean isEnableLocalStoreBoolean() {
        return (Boolean)this.env.get(ENABLE_LOCAL_STORE);
    }

    public void setLocalStoreDirectory(String string) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(LOCAL_STORE_DIRECTORY, string);
    }

    public String getLocalStoreDirectory() {
        return (String)this.env.get(LOCAL_STORE_DIRECTORY);
    }

    public void setLocalStoreSize(long l) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(LOCAL_STORE_SIZE, new Long(l));
    }

    public void setLocalStoreSizeLong(Long l) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(LOCAL_STORE_SIZE, l);
    }

    public long getLocalStoreSize() {
        return (Long)this.env.get(LOCAL_STORE_SIZE);
    }

    public Long getLocalStoreSizeLong() {
        return (Long)this.env.get(LOCAL_STORE_SIZE);
    }

    public void setReconnectTimeout(int n) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(RECONNECT_TIMEOUT, new Integer(n));
    }

    public void setReconnectTimeoutInteger(Integer n) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(RECONNECT_TIMEOUT, n);
    }

    public int getReconnectTimeout() {
        return (Integer)this.env.get(RECONNECT_TIMEOUT);
    }

    public Integer getReconnectTimeoutInteger() {
        return (Integer)this.env.get(RECONNECT_TIMEOUT);
    }

    public void setReconnectInterval(int n) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(RECONNECT_INTERVAL, new Integer(n));
    }

    public void setReconnectIntervalInteger(Integer n) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(RECONNECT_INTERVAL, n);
    }

    public int getReconnectInterval() {
        return (Integer)this.env.get(RECONNECT_INTERVAL);
    }

    public Integer getReconnectIntervalInteger() {
        return (Integer)this.env.get(RECONNECT_INTERVAL);
    }

    public String getUrlsOrUrl() {
        String string = (String)this.env.get("brokerList");
        if (string != null && string.length() > 0) {
            return string;
        }
        return this.getBrokerURL();
    }

    public void setLoginSPI(String string) {
        this.env.put("login_spi_classname", string);
    }

    public String getLoginSPI() {
        return (String)this.env.get("login_spi_classname");
    }

    public void setSelectorAtBroker(Boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("selectorAtBroker", bl);
    }

    public Boolean getSelectorAtBroker() {
        if (this.env.containsKey("selectorAtBroker")) {
            return (Boolean)this.env.get("selectorAtBroker");
        }
        return Boolean.FALSE;
    }

    public void setDurableMessageOrder(Boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("durableSubscriberMessageOrder", bl);
    }

    public Boolean getDurableMessageOrder() {
        if (this.env.containsKey("durableSubscriberMessageOrder")) {
            return (Boolean)this.env.get("durableSubscriberMessageOrder");
        }
        return Boolean.FALSE;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference((class$progress$message$jclient$ConnectionFactory == null ? (class$progress$message$jclient$ConnectionFactory = ConnectionFactory.class$("progress.message.jclient.ConnectionFactory")) : class$progress$message$jclient$ConnectionFactory).getName(), (class$progress$message$jclient$AdministeredObjectFactory == null ? (class$progress$message$jclient$AdministeredObjectFactory = ConnectionFactory.class$("progress.message.jclient.AdministeredObjectFactory")) : class$progress$message$jclient$AdministeredObjectFactory).getName(), null);
        this.addReferences(reference);
        return reference;
    }

    protected void addReferences(Reference reference) {
        if (this.env != null) {
            String string;
            if (this.env.get(ENABLE_LOCAL_STORE) != null) {
                reference.add(new StringRefAddr(ENABLE_LOCAL_STORE, String.valueOf(this.isEnableLocalStore())));
            }
            if (this.env.get(LOCAL_STORE_DIRECTORY) != null) {
                reference.add(new StringRefAddr(LOCAL_STORE_DIRECTORY, this.getLocalStoreDirectory()));
            }
            if (this.env.get(LOCAL_STORE_SIZE) != null) {
                reference.add(new StringRefAddr(LOCAL_STORE_SIZE, String.valueOf(this.getLocalStoreSize())));
            }
            if (this.env.get(RECONNECT_TIMEOUT) != null) {
                reference.add(new StringRefAddr(RECONNECT_TIMEOUT, String.valueOf(this.getReconnectTimeout())));
            }
            if (this.env.get(RECONNECT_INTERVAL) != null) {
                reference.add(new StringRefAddr(RECONNECT_INTERVAL, String.valueOf(this.getReconnectInterval())));
            }
            if (this.env.get(FAULT_TOLERANT) != null) {
                reference.add(new StringRefAddr(FAULT_TOLERANT, String.valueOf(this.getFaultTolerant())));
            }
            if (this.env.get(FAULT_TOLERANT_RECONNECT_TIMEOUT) != null) {
                reference.add(new StringRefAddr(FAULT_TOLERANT_RECONNECT_TIMEOUT, String.valueOf(this.getFaultTolerantReconnectTimeout())));
            }
            if (this.env.get(INITIAL_CONNECT_TIMEOUT) != null) {
                reference.add(new StringRefAddr(INITIAL_CONNECT_TIMEOUT, String.valueOf(this.getInitialConnectTimeout())));
            }
            if (this.env.get(CLIENT_TRANSACTION_BUFFER_SIZE) != null) {
                reference.add(new StringRefAddr(CLIENT_TRANSACTION_BUFFER_SIZE, String.valueOf(this.getClientTransactionBufferSize())));
            }
            if (this.env.get(FLOW_TO_DISK) != null) {
                reference.add(new StringRefAddr(FLOW_TO_DISK, String.valueOf(this.getFlowToDisk())));
            }
            if ((string = (String)this.env.get("login_spi_classname")) != null && string.length() > 0) {
                reference.add(new StringRefAddr("login_spi_classname", string));
            }
            if (this.env.get("defaultTxnBatchSize") != null) {
                reference.add(new StringRefAddr("defaultTxnBatchSize", String.valueOf(this.getDefaultTxnBatchSize())));
            }
        }
        reference.add(new StringRefAddr("brokerURL", this.brokerURL));
        if (this.connectID != null) {
            if (this.connectID.length() == 0) {
                reference.add(new StringRefAddr("connectID", "\"\""));
            } else {
                reference.add(new StringRefAddr("connectID", this.connectID));
            }
        }
        reference.add(new StringRefAddr("defaultUserName", this.defaultUserName));
        reference.add(new StringRefAddr("defaultPassword", this.defaultPassword));
        if (this.clientID != null) {
            if (this.clientID.length() == 0) {
                reference.add(new StringRefAddr("clientID", "\"\""));
            } else {
                reference.add(new StringRefAddr("clientID", this.clientID));
            }
        }
        reference.add(new StringRefAddr("versionID", "5.0.2"));
        if (this.env != null) {
            if (this.env.get("brokerList") != null) {
                reference.add(new StringRefAddr("brokerList", (String)this.env.get("brokerList")));
            }
            if (this.env.get("randomizeBrokers") != null) {
                reference.add(new StringRefAddr("randomizeBrokers", (String)this.env.get("randomizeBrokers")));
            }
            if (this.env.get("loadBalancing") != null) {
                reference.add(new StringRefAddr("loadBalancing", (String)this.env.get("loadBalancing")));
            }
            if (this.env.get("persistentDelivery") != null) {
                reference.add(new StringRefAddr("persistentDelivery", (String)this.env.get("persistentDelivery")));
            }
            if (this.env.get("monitorInterval") != null) {
                reference.add(new StringRefAddr("monitorInterval", (String)this.env.get("monitorInterval")));
            }
            if (this.env.get(PING_INTERVAL) != null) {
                reference.add(new StringRefAddr(PING_INTERVAL, (String)this.env.get(PING_INTERVAL)));
            }
            if (this.env.get("prefetchCount") != null) {
                reference.add(new StringRefAddr("prefetchCount", (String)this.env.get("prefetchCount")));
            }
            if (this.env.get("prefetchThreshold") != null) {
                reference.add(new StringRefAddr("prefetchThreshold", (String)this.env.get("prefetchThreshold")));
            }
            if (this.env.get("selectorAtBroker") != null) {
                reference.add(new StringRefAddr("selectorAtBroker", ((Boolean)this.env.get("selectorAtBroker")).toString()));
            }
            if (this.env.get("durableSubscriberMessageOrder") != null) {
                reference.add(new StringRefAddr("durableSubscriberMessageOrder", ((Boolean)this.env.get("durableSubscriberMessageOrder")).toString()));
            }
        }
    }

    void setEnv(Hashtable hashtable) {
        this.env = hashtable;
        this.setDefaultProperties();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setDefaultProperties();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public void setPingInterval(long l) {
        this.setPingIntervalLong(new Long(l));
    }

    public long getPingInterval() {
        return this.getPingIntervalLong();
    }

    public void setPingIntervalLong(Long l) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(PING_INTERVAL, l.toString());
    }

    public Long getPingIntervalLong() {
        if (this.env == null) {
            return new Long(0L);
        }
        String string = (String)this.env.get(PING_INTERVAL);
        return string == null ? new Long(0L) : Long.valueOf(string.trim());
    }

    public void setMonitorInterval(Integer n) {
        if (n < 0) {
            throw new IllegalArgumentException(prAccessor.getString("INVALID_INTERVAL"));
        }
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("monitorInterval", n.toString());
    }

    public Integer getMonitorInterval() {
        if (this.env == null) {
            return new Integer(0);
        }
        String string = (String)this.env.get("monitorInterval");
        return string == null ? new Integer(0) : Integer.valueOf(string.trim());
    }

    public void setFaultTolerant(Boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(FAULT_TOLERANT, bl);
    }

    public Boolean getFaultTolerant() {
        return (Boolean)this.env.get(FAULT_TOLERANT);
    }

    public void setFaultTolerantReconnectTimeout(Integer n) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(FAULT_TOLERANT_RECONNECT_TIMEOUT, n);
    }

    public Integer getFaultTolerantReconnectTimeout() {
        return (Integer)this.env.get(FAULT_TOLERANT_RECONNECT_TIMEOUT);
    }

    public void setInitialConnectTimeout(Integer n) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(INITIAL_CONNECT_TIMEOUT, n);
    }

    public Integer getInitialConnectTimeout() {
        return (Integer)this.env.get(INITIAL_CONNECT_TIMEOUT);
    }

    public void setClientTransactionBufferSize(Long l) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(CLIENT_TRANSACTION_BUFFER_SIZE, l);
    }

    public Long getClientTransactionBufferSize() {
        return (Long)this.env.get(CLIENT_TRANSACTION_BUFFER_SIZE);
    }

    public void setFlowToDisk(Integer n) {
        if (n > 2 || n < 0) {
            return;
        }
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put(FLOW_TO_DISK, n);
    }

    public Integer getFlowToDisk() {
        if (this.env.containsKey(FLOW_TO_DISK)) {
            return (Integer)this.env.get(FLOW_TO_DISK);
        }
        return new Integer(0);
    }

    protected Hashtable getEnv() {
        return this.env;
    }

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String string) {
        this.brokerURL = string;
    }

    public String getConnectID() {
        return this.connectID;
    }

    public void setConnectID(String string) {
        this.connectID = string;
    }

    public String getDefaultUser() {
        return this.defaultUserName;
    }

    public void setDefaultUser(String string) {
        this.defaultUserName = string;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String string) {
        this.defaultPassword = string;
    }

    public String getBrokerHostName() {
        return this.brokerHostName;
    }

    public void setBrokerHostName(String string) {
        this.brokerHostName = string;
    }

    public String getBrokerProtocol() {
        return this.brokerProtocol;
    }

    public void setBrokerProtocol(String string) {
        this.brokerProtocol = string;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public void setBrokerPort(int n) {
        this.brokerPort = n;
    }

    public void setApplet(Applet applet) {
        this.applet = applet;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String string) throws JMSException {
        if (string.indexOf("#") != -1 || string.indexOf("*") != -1 || string.indexOf("$") != -1 || string.indexOf(".") != -1) {
            throw new InvalidClientIDException(prAccessor.getString("CONN_INVALID_CLIENT_ID") + string);
        }
        this.clientID = string;
    }

    public void setLoadBalancing(boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("loadBalancing", new Boolean(bl).toString());
    }

    public void setLoadBalancingBoolean(Boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("loadBalancing", bl.toString());
    }

    public boolean getLoadBalancing() {
        if (this.env == null) {
            return false;
        }
        String string = (String)this.env.get("loadBalancing");
        return string != null ? Boolean.valueOf(string.trim()) : false;
    }

    public Boolean getLoadBalancingBoolean() {
        if (this.env == null) {
            return Boolean.FALSE;
        }
        String string = (String)this.env.get("loadBalancing");
        return string != null ? Boolean.valueOf(string.trim()) : Boolean.FALSE;
    }

    public void setConnectionURLs(String string) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("brokerList", string);
    }

    public String getConnectionURLs() {
        if (this.env == null) {
            return null;
        }
        return (String)this.env.get("brokerList");
    }

    public void setSequential(boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("randomizeBrokers", new Boolean(!bl).toString());
    }

    public void setSequentialBoolean(Boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("randomizeBrokers", new Boolean(bl == false).toString());
    }

    public boolean getSequential() {
        if (this.env == null) {
            return true;
        }
        String string = (String)this.env.get("randomizeBrokers");
        return !(string != null ? Boolean.valueOf(string.trim()) : false);
    }

    public Boolean getSequentialBoolean() {
        if (this.env == null) {
            return Boolean.TRUE;
        }
        String string = (String)this.env.get("randomizeBrokers");
        return new Boolean(!(string != null ? Boolean.valueOf(string.trim()) : false));
    }

    public void setPersistentDelivery(boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("persistentDelivery", new Boolean(bl).toString());
    }

    public void setPersistentDeliveryBoolean(Boolean bl) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("persistentDelivery", bl.toString());
    }

    public boolean getPersistentDelivery() {
        if (this.env == null) {
            return false;
        }
        String string = (String)this.env.get("persistentDelivery");
        return string != null ? Boolean.valueOf(string.trim()) : false;
    }

    public Boolean getPersistentDeliveryBoolean() {
        if (this.env == null) {
            return Boolean.FALSE;
        }
        String string = (String)this.env.get("persistentDelivery");
        return string != null ? Boolean.valueOf(string.trim()) : Boolean.FALSE;
    }

    public void setPrefetchCount(int n) {
        this.setPrefetchCountInteger(new Integer(n));
    }

    public int getPrefetchCount() {
        return this.getPrefetchCountInteger();
    }

    public void setPrefetchCountInteger(Integer n) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("prefetchCount", n.toString());
    }

    public Integer getPrefetchCountInteger() {
        if (this.env == null) {
            return new Integer(-1);
        }
        String string = (String)this.env.get("prefetchCount");
        return string == null ? new Integer(-1) : Integer.valueOf(string.trim());
    }

    public void setPrefetchThreshold(int n) {
        this.setPrefetchThresholdInteger(new Integer(n));
    }

    public int getPrefetchThreshold() {
        return this.getPrefetchThresholdInteger();
    }

    public void setPrefetchThresholdInteger(Integer n) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("prefetchThreshold", n.toString());
    }

    public Integer getPrefetchThresholdInteger() {
        if (this.env == null) {
            return new Integer(-1);
        }
        String string = (String)this.env.get("prefetchThreshold");
        return string == null ? new Integer(-1) : Integer.valueOf(string.trim());
    }

    protected void checkSPILoginBind() throws JMSSecurityException {
        String string;
        ILogin iLogin;
        if (this.env != null && !this.env.containsKey(LOGIN_SPI_OBJECT) && (iLogin = SessionConfig.createILoginInstance(string = (String)this.env.get("login_spi_classname"))) != null) {
            this.env.put(LOGIN_SPI_OBJECT, iLogin);
        }
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.defaultUserName, this.defaultPassword);
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        this.checkSPILoginBind();
        return new progress.message.jimpl.Connection(this.brokerURL, this.connectID, string, string2, this.applet, this.clientID, this.env);
    }

    public void setDefaultTxnBatchSize(int n) {
        this.setDefaultTxnBatchSizeInteger(new Integer(n));
    }

    public int getDefaultTxnBatchSize() {
        return this.getDefaultTxnBatchSizeInteger();
    }

    public void setDefaultTxnBatchSizeInteger(Integer n) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        this.env.put("defaultTxnBatchSize", n);
    }

    public Integer getDefaultTxnBatchSizeInteger() {
        if (this.env == null) {
            return new Integer(51200);
        }
        Integer n = null;
        Integer n2 = (Integer)this.env.get("defaultTxnBatchSize");
        n = n2 == null ? new Integer(51200) : n2;
        return n;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

