/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import progress.message.client.EGeneralException;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.prAccessor;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.zclient.Envelope;

public class BytesMessage
extends Message
implements progress.message.jclient.BytesMessage {
    public BytesMessage() {
        super((short)2);
    }

    BytesMessage(Envelope envelope) {
        super(envelope);
    }

    private BytesMessage(BytesMessage bytesMessage) {
        super(bytesMessage);
    }

    public boolean readBoolean() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readBoolean();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public byte readByte() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readByte();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            if (iOException instanceof EOFException) {
                throw new MessageEOFException(iOException.getMessage());
            }
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public int readUnsignedByte() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readUnsignedByte();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public short readShort() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readShort();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public int readUnsignedShort() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readUnsignedShort();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public char readChar() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readChar();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public int readInt() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readInt();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public long readLong() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readLong();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public float readFloat() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readFloat();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public double readDouble() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            return this.kTB_.getMessage().readDouble();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public String readUTF() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        try {
            if (this.getBooleanProperty("JMS_SonicMQ_CTS_Message")) {
                return this.kTB_.getMessage().readShortUTF();
            }
            return this.kTB_.getMessage().readUTF();
        }
        catch (ESecurityGeneralException eSecurityGeneralException) {
            throw JMSExceptionUtil.createJMSSecurityException(eSecurityGeneralException);
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public int readBytes(byte[] byArray) throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        if (this.kTB_.getMessage().countUnread() == 0) {
            return -1;
        }
        return this.kTB_.getMessage().read(byArray, 0, byArray.length);
    }

    public int readBytes(byte[] byArray, int n) throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        if (n < 0 || n > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.kTB_.getMessage().countUnread() == 0) {
            return -1;
        }
        return this.kTB_.getMessage().read(byArray, 0, n);
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        this.kTB_.getMessage().writeBoolean(bl);
    }

    public void writeByte(byte by) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        this.kTB_.getMessage().writeByte(by);
    }

    public void writeShort(short s) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        this.kTB_.getMessage().writeShort(s);
    }

    public void writeChar(char c) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        this.kTB_.getMessage().writeChar(c);
    }

    public void writeInt(int n) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        this.kTB_.getMessage().writeInt(n);
    }

    public void writeLong(long l) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        this.kTB_.getMessage().writeLong(l);
    }

    public void writeFloat(float f) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        this.kTB_.getMessage().writeFloat(f);
    }

    public void writeDouble(double d) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        this.kTB_.getMessage().writeDouble(d);
    }

    public void writeUTF(String string) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            this.kTB_.getMessage().writeUTF(string);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.kTB_.getMessage().write(byArray);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        if (byArray == null || n2 == 0) {
            throw new NullPointerException();
        }
        this.kTB_.getMessage().write(byArray, n, n2);
    }

    public void writeObject(Object object) throws JMSException {
        if (this.nTB_) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof String) {
            this.writeUTF(object.toString());
        } else {
            if (object == null) {
                throw new NullPointerException();
            }
            throw new MessageFormatException(prAccessor.getString("INVALID_OBJECT_TYPE"));
        }
    }

    public void reset() throws JMSException {
        try {
            this.nTB_ = true;
            if (this.kTB_.getMessage().cap() != 0) {
                this.kTB_.getMessage().gotoByte(0);
            }
        }
        catch (EGeneralException eGeneralException) {
            throw JMSExceptionUtil.createJMSException(eGeneralException);
        }
        catch (IOException iOException) {
            throw JMSExceptionUtil.createJMSException(iOException);
        }
    }

    public Object clone() {
        BytesMessage bytesMessage = new BytesMessage(this);
        bytesMessage.kTB_ = (Envelope)this.kTB_.deepClone();
        return bytesMessage;
    }

    public Object protectedClone() {
        BytesMessage bytesMessage = new BytesMessage(this);
        bytesMessage.kTB_ = (Envelope)this.kTB_.protectedClone();
        return bytesMessage;
    }

    public long getBodyLength() throws JMSException {
        if (!this.nTB_) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
        return this.kTB_.getMessage().length();
    }

    public static void main(String[] stringArray) {
        BytesMessage bytesMessage = new BytesMessage();
        System.out.println("Successfully instantiated BytesMessage.");
        try {
            bytesMessage.writeUTF("It is time for all good men to run");
            System.out.println("Marshalled and Unmarshalled Message String: " + bytesMessage.readUTF());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

