/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import progress.message.client.EUnsupportedMgramException;
import progress.message.client.prAccessor;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.v26.MgramCreator;
import progress.message.resources.prMessageFormat;
import progress.message.util.AutoVec;
import progress.message.xa.XidImpl;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.FastVector;
import progress.message.zclient.ISaverOp;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.IStateEvent;

public class MgramFactory {
    private static MgramFactory yV_ = null;
    private MgramCreator zV_ = new MgramCreator();

    private MgramFactory() {
    }

    public static MgramFactory getMgramFactory() {
        if (yV_ == null) {
            yV_ = new MgramFactory();
        }
        return yV_;
    }

    public static IMgramConverter getMgramConverter(int n) throws EUnsupportedMgramException {
        if (n == 26) {
            return new MgramCreator();
        }
        IMgramConverter iMgramConverter = null;
        try {
            Class<?> clazz = Class.forName("progress.message.msg.v26.MgramConverter" + n);
            iMgramConverter = (IMgramConverter)clazz.newInstance();
        }
        catch (Exception exception) {
            String string = prAccessor.getString("UNSUPPORTED_MGRAM");
            Object[] objectArray = new String[]{"" + n};
            String string2 = prMessageFormat.format(string, objectArray);
            throw new EUnsupportedMgramException(string2);
        }
        return iMgramConverter;
    }

    public IMgram createMgram(InputStream inputStream) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return this.zV_.createMgram(inputStream);
    }

    public IMgram createMgram(boolean bl) {
        return this.zV_.createMgram(bl);
    }

    public IMgram createMgram(byte[] byArray) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return this.zV_.createMgram(byArray);
    }

    public IMgram buildAck(long l, long l2, short s, int n) {
        return MgramCreator.buildAck(l, l2, s, n);
    }

    public IMgram buildAck(long l, short s, int n) {
        return MgramCreator.buildAck(l, -1L, s, n);
    }

    public IMgram buildAck(long l, short s, boolean bl, long l2, boolean bl2, int n, int n2) {
        return MgramCreator.buildAck(l, -1L, s, bl, l2, bl2, n, n2);
    }

    public IMgram buildWindowAck(long l, long l2, short s, boolean bl, long l3, boolean bl2, int n, int n2) {
        return MgramCreator.buildWindowAck(l, l2, s, bl, l3, bl2, n, n2);
    }

    public IMgram buildAck(long l, long l2, short s, boolean bl, long l3, boolean bl2, int n, int n2) {
        return MgramCreator.buildAck(l, l2, s, bl, l3, bl2, n, n2);
    }

    public IMgram buildQAck(long l, long l2, short s, boolean bl, long l3, boolean bl2, int n, int n2) {
        return MgramCreator.buildQAck(l, l2, s, bl, l3, bl2, n, n2);
    }

    public IMgram buildQAck(long l, short s, int n) {
        return MgramCreator.buildQAck(l, -1L, s, false, 0L, false, 0, n);
    }

    public IMgram buildAckList() {
        return MgramCreator.buildAckList();
    }

    public IMgram buildQueueGetRequestMgram(boolean bl, int n, short s, int n2, String string) {
        return MgramCreator.buildQueueGetRequestMgram(bl, n, s, n2, string);
    }

    public IMgram buildQueueOpenRemoteReceiverMgram(boolean bl, int n, String string, String string2) {
        return MgramCreator.buildQueueOpenRemoteReceiverMgram(bl, n, string, string2);
    }

    public IMgram buildQueueCloseRemoteReceiverMgram(boolean bl, int n, String string, String string2) {
        return MgramCreator.buildQueueCloseRemoteReceiverMgram(bl, n, string, string2);
    }

    public IMgram buildPingRequest(byte[] byArray, int n) {
        return MgramCreator.buildPingRequest(byArray, n);
    }

    public IMgram buildPingReply(IMgram iMgram) {
        return MgramCreator.buildPingReply(iMgram);
    }

    public IMgram buildDisconnectRequest(int n, boolean bl) {
        return MgramCreator.buildDisconnectRequest(n, bl);
    }

    public IMgram buildFlowControlMgram(byte by, int n) {
        return MgramCreator.buildFlowControlMgram(by, n);
    }

    public IMgram buildVersionMgram(int n, byte by) {
        return MgramCreator.buildVersionMgram(n, by);
    }

    public IMgram buildVersionMgram(int n, byte by, byte by2) {
        return MgramCreator.buildVersionMgram(n, by, by2);
    }

    public IMgram buildVersionMgram(int n) {
        return this.buildVersionMgram(n, (byte)26);
    }

    public IMgram buildConnectMgram(byte[] byArray, int n) {
        return MgramCreator.buildConnectMgram(byArray, n);
    }

    public IMgram buildErrorMgram(int n, int n2, IMgram iMgram, int n3) {
        return MgramCreator.buildErrorMgram(n, n2, iMgram, n3);
    }

    public IMgram buildBeginTxnRequest(boolean bl, int n, long l, int n2) {
        return MgramCreator.buildBeginTxnRequest(bl, n, l, n2);
    }

    public IMgram buildAbortTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3) {
        return MgramCreator.buildAbortTxnRequest(bl, bl2, n, n2, l, n3);
    }

    public IMgram buildTxnRequest(boolean bl, int n, int n2, long l, int n3) {
        return MgramCreator.buildTxnRequest(bl, n, n2, l, n3);
    }

    public IMgram buildCommitTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3) {
        return MgramCreator.buildCommitTxnRequest(bl, bl2, n, n2, l, n3);
    }

    public IMgram buildNoDupCommitTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3, String string, long l2) {
        return MgramCreator.buildNoDupCommitTxnRequest(bl, bl2, n, n2, l, n3, string, l2);
    }

    public IMgram buildNoDupChannelCommitTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3, String string, long l2, int n4, String string2) {
        return MgramCreator.buildNoDupChannelCommitTxnRequest(bl, bl2, n, n2, l, n3, string, l2, n4, string2);
    }

    public IMgram buildNoDupChannelDeleteTxnRequest(boolean bl, int n, long l, int n2, String string, String string2) {
        return this.zV_.buildNoDupChannelDeleteTxnRequest(bl, n, l, n2, string, string2);
    }

    public IMgram buildNoDupChannelUpdateTxnRequest(boolean bl, int n, long l, int n2, String string, long l2, int n3, String string2) {
        return this.zV_.buildNoDupChannelUpdateTxnRequest(bl, n, l, n2, string, l2, n3, string2);
    }

    public IMgram buildTxnReply(short s, int n, int n2, int n3) {
        return MgramCreator.buildTxnReply(s, n, n2, n3);
    }

    public IMgram buildTxnActiveReply(long l, int n, int n2, int n3) {
        return MgramCreator.buildTxnActiveReply(l, n, n2, n3);
    }

    public IMgram buildExtendedTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3, XidImpl xidImpl, int n4) {
        return this.zV_.buildExtendedTxnRequest(bl, bl2, n, n2, l, n3, xidImpl, n4);
    }

    public IMgram buildTxnBatchMgram(IMgram iMgram, int n) {
        return MgramCreator.buildTxnBatchMgram(iMgram, n);
    }

    public IMgram buildBatchMgram(IMgram iMgram) {
        return MgramCreator.buildBatchMgram(iMgram);
    }

    public IMgram buildDisconnectReply(int n, boolean bl) {
        return MgramCreator.buildDisconnectReply(n, bl);
    }

    public IMgram buildGRConvertMgram(long l, long l2, int n, long l3) {
        return MgramCreator.buildGRConvertMgram(l, l2, n, l3);
    }

    public IMgram buildIBConvertMgram(long l, int n) {
        return MgramCreator.buildIBConvertMgram(l, n);
    }

    public IMgram buildFailoverStatusNotification(int n, String[] stringArray, String[] stringArray2) {
        return this.zV_.buildFailoverStatusNotification(n, stringArray, stringArray2);
    }

    public List buildIDRMgramList(boolean bl, boolean bl2, boolean bl3, List list, List list2, List list3, List list4, List list5, List list6) {
        return MgramCreator.buildIDRMgramList(bl, bl2, bl3, list, list2, list3, list4, list5, list6);
    }

    public IMgram buildIDRAckMgram() {
        return MgramCreator.buildIDRAckMgram();
    }

    public IMgram buildConnectionSyncMgram(AutoVec autoVec) {
        return MgramCreator.buildConnectionSyncMgram(autoVec);
    }

    public IMgram buildFirstMessageNotification(long l) {
        return MgramCreator.buildFirstMessageNotification(l);
    }

    public IMgram buildDeliveryFinished(long l) {
        return MgramCreator.buildDeliveryFinished(l);
    }

    public IMgram buildSingleTargetMessage(long l, IMgram iMgram) {
        return MgramCreator.buildSingleTargetMessage(l, iMgram);
    }

    public IMgram buildLBSTargetMessage(IMgram iMgram, FastVector fastVector) {
        return MgramCreator.buildLBSTargetMessage(iMgram, fastVector);
    }

    public IMgram buildLBSTargetMessage(IMgram iMgram, int n, byte[] byArray, int n2) {
        return MgramCreator.buildLBSTargetMessage(iMgram, n, byArray, n2);
    }

    public IMgram buildLastMessageNotification(long l) {
        return MgramCreator.buildLastMessageNotification(l);
    }

    public IMgram buildTxnEOFMarker() {
        return MgramCreator.buildTxnEOFMarker();
    }

    public IMgram buildTxnSavePointMarker() {
        return MgramCreator.buildTxnSavePointMarker();
    }

    public IMgram buildRemoteRestorePhasesDoneMgram(long l) {
        return MgramCreator.buildRemoteRestorePhasesDoneMgram(l);
    }

    public IMgram buildGuarFormatMgram(IMgram iMgram) {
        return MgramCreator.buildGuarFormatMgram(iMgram);
    }

    public IMgram buildResumeMgram(int n, byte[] byArray, int n2, boolean bl) {
        return MgramCreator.buildResumeMgram(n, byArray, n2, bl);
    }

    public IMgram buildBlockMgram(int n, byte[] byArray, int n2, boolean bl) {
        return MgramCreator.buildBlockMgram(n, byArray, n2, bl);
    }

    public IMgram buildNack(long l, int n) {
        return MgramCreator.buildNack(l, n);
    }

    public IMgram buildRouteRequest(int n, int n2, long l, int n3, byte[] byArray) {
        return MgramCreator.buildRouteRequest(n, n2, l, n3, byArray);
    }

    public IMgram buildStateEventMgram(IStateEvent iStateEvent, boolean bl) {
        return MgramCreator.buildStateEventMgram(iStateEvent, bl);
    }

    public IMgram buildDatabaseMgram(ISaverOp iSaverOp) {
        return MgramCreator.buildDatabaseMgram(iSaverOp);
    }

    public IMgram buildReplicatedMgram(IMgram iMgram, boolean bl) {
        return MgramCreator.buildReplicatedMgram(iMgram, bl);
    }

    public IMgram buildOperationMgram(int n) {
        return MgramCreator.buildOperationMgram(n);
    }

    public ISidebandData buildSidebandData() {
        return MgramCreator.buildSidebandData();
    }
}

