/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg;

import java.io.IOException;
import java.io.InputStream;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMsgTooBigException;
import progress.message.zclient.SessionConfig;

public final class StreamUtilCounter {
    private int MN_ = 0;
    private boolean fj_ = false;

    public StreamUtilCounter(boolean bl) {
        this.fj_ = bl;
    }

    public short readShort(InputStream inputStream) throws IOException {
        this.incrementCounter(2);
        return StreamUtil.readShort(inputStream);
    }

    public long readLong(InputStream inputStream) throws IOException {
        this.incrementCounter(8);
        return StreamUtil.readLong(inputStream);
    }

    public long read6ByteLong(InputStream inputStream) throws IOException {
        this.incrementCounter(6);
        return StreamUtil.read6ByteLong(inputStream);
    }

    public int readInt(InputStream inputStream) throws IOException {
        this.incrementCounter(4);
        return StreamUtil.readInt(inputStream);
    }

    public byte[] readUTFString(InputStream inputStream) throws IOException {
        byte[] byArray = StreamUtil.readUTFString(inputStream);
        this.incrementCounter(byArray.length);
        return byArray;
    }

    public void readBytes(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        this.incrementCounter(n2);
        StreamUtil.readBytes(inputStream, byArray, n, n2);
    }

    public byte readByte(InputStream inputStream) throws IOException {
        this.incrementCounter(1);
        return StreamUtil.readByte(inputStream);
    }

    public void resetCounter() {
        this.MN_ = 0;
    }

    public int getCounter() {
        return this.MN_;
    }

    public void skip(InputStream inputStream, int n) throws IOException {
        this.incrementCounter(n);
        StreamUtil.skip(inputStream, n);
    }

    public final void incrementCounter(int n) throws IOException {
        this.MN_ += n;
        if (this.fj_ && SessionConfig.MAX_MSG_SIZE > 0 && this.MN_ > SessionConfig.MAX_MSG_SIZE) {
            throw new EMsgTooBigException(this.MN_, SessionConfig.MAX_MSG_SIZE);
        }
    }
}

