/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IMgram;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.DefaultPayload;
import progress.message.msg.v26.Mgram;
import progress.message.util.StreamUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.SecurityLogic;

public class BatchPayload
extends DefaultPayload
implements IBatchHandle {
    private ArrayList qJB_ = null;
    private byte rJB_;
    private int SG_ = -1;
    static final int sJB_ = 1;
    static final int tJB_ = 2;
    static final int uJB_ = 3;

    public BatchPayload(Mgram mgram) {
        super(mgram);
    }

    public BatchPayload(BatchPayload batchPayload, Mgram mgram) {
        super(batchPayload, mgram);
        this.qJB_ = batchPayload.qJB_;
        this.rJB_ = batchPayload.rJB_;
        this.SG_ = batchPayload.SG_;
    }

    public Object clone(Mgram mgram) throws CloneNotSupportedException {
        BatchPayload batchPayload = new BatchPayload(this, mgram);
        this.jC_(batchPayload);
        if (this.qJB_ != null) {
            this.qJB_ = (ArrayList)this.qJB_.clone();
        }
        return batchPayload;
    }

    public Object shallowClone(Mgram mgram) throws CloneNotSupportedException {
        BatchPayload batchPayload = new BatchPayload(this, mgram);
        this.kC_(batchPayload);
        if (this.qJB_ != null) {
            this.qJB_ = (ArrayList)this.qJB_.clone();
        }
        return batchPayload;
    }

    public Object protectedClone(Mgram mgram) throws CloneNotSupportedException {
        this.lC_();
        BatchPayload batchPayload = new BatchPayload(this, mgram);
        this.mC_(batchPayload);
        if (this.qJB_ != null) {
            this.qJB_ = (ArrayList)this.qJB_.clone();
        }
        return batchPayload;
    }

    public boolean isPubSub() {
        return this.getOperationType() == 0;
    }

    public boolean isPTP() {
        return this.getOperationType() == 1;
    }

    public LinkedList getMgramList() {
        return super.NE_();
    }

    public void syncBatch() {
        this.WKB_();
        this.VKB_();
    }

    public Iterator getBatchIterator() {
        LinkedList linkedList = super.NE_();
        if (linkedList != null) {
            return linkedList.iterator();
        }
        return null;
    }

    public int getBatchSize() {
        LinkedList linkedList = super.NE_();
        if (linkedList == null) {
            return 0;
        }
        return linkedList.size();
    }

    void UKB_(IMgram iMgram) {
        this.YKB_(iMgram, this.YG_);
        this.ZKB_(iMgram, this.YG_);
        if (iMgram.isTTE()) {
            this.YG_.setTTE(iMgram.getTTE());
            this.aKB_(true);
        }
        this.YG_.setPriority(iMgram.getPriority());
        this.YG_.setJMSPersistent(iMgram.isJMSPersistent());
        this.YG_.setRouteLimit(iMgram.getRouteLimit());
        if (iMgram.isPTP()) {
            this.YG_.getOperationHandle().setOperationType(1);
        } else if (iMgram.isPubSub()) {
            this.YG_.getOperationHandle().setOperationType(0);
        }
        if (iMgram.getJMSClientHandle().isPerMsgEncrypted()) {
            if (this.qJB_ == null) {
                this.qJB_ = new ArrayList();
            }
            this.qJB_.add(iMgram);
        }
        super.addMgram(iMgram);
    }

    public void addMgram(IMgram iMgram) {
        if (iMgram.isJMSPersistent() && !this.YG_.isJMSPersistent()) {
            this.YG_.setJMSPersistent(true);
        }
        if (iMgram.getPriority() > this.YG_.getPriority()) {
            this.YG_.setPriority(iMgram.getPriority());
        }
        if (iMgram.isTTE()) {
            this.aKB_(true);
        }
        if (iMgram.isTTE() && this.YG_.isTTE()) {
            long l = iMgram.getTTE();
            if (this.YG_.getTTE() < l) {
                this.YG_.setTTE(l);
            }
        } else if (this.YG_.isTTE() && !iMgram.isTTE()) {
            this.YG_.removeTTE();
        }
        if (iMgram.getJMSClientHandle().isPerMsgEncrypted()) {
            if (this.qJB_ == null) {
                this.qJB_ = new ArrayList();
            }
            this.qJB_.add(iMgram);
        }
        super.addMgram(iMgram);
    }

    public int getDurableBatchSerializedLength() {
        if (this.NE_() == null || this.NE_().size() == 0) {
            return 0;
        }
        int n = 0;
        Iterator iterator = this.NE_().iterator();
        while (iterator.hasNext()) {
            IMgram iMgram = (IMgram)iterator.next();
            int n2 = iMgram.getBrokerHandle().getTrackedSize();
            iMgram.getBrokerHandle().setTrackedSize(n2);
            n += n2;
        }
        return n;
    }

    public byte[] encryptMessageWithMessageKey(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.VKB_();
        this.WKB_();
        return super.encryptMessageWithMessageKey(iMessageProtection);
    }

    public void macMgramListMessagesWithMessageKey(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.VKB_();
        this.WKB_();
        super.macMgramListMessagesWithMessageKey(iMessageProtection);
    }

    public void macMgramListHeadersWithMessageKey(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.VKB_();
        this.WKB_();
        super.macMgramListHeadersWithMessageKey(iMessageProtection);
    }

    boolean QE_() {
        return true;
    }

    void IF_(byte by) {
        switch (by) {
            case 12: {
                this.YG_.getOperationHandle().setOperationType(1);
                this.XKB_(by);
                break;
            }
            case 2: {
                this.YG_.getOperationHandle().setOperationType(0);
                this.XKB_(by);
                break;
            }
        }
    }

    private void VKB_() {
        LinkedList linkedList = this.NE_();
        if (linkedList != null && linkedList.size() > 0) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Mgram mgram = (Mgram)iterator.next();
                if (mgram.isPerMsgEncrypted()) continue;
                this.ZKB_(this.YG_, mgram);
            }
        }
    }

    private void WKB_() {
        LinkedList linkedList = this.NE_();
        if (linkedList != null && linkedList.size() > 0) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Mgram mgram = (Mgram)iterator.next();
                this.YKB_(this.YG_, mgram);
            }
        }
    }

    private void XKB_(byte by) {
        LinkedList linkedList = this.NE_();
        if (linkedList != null && linkedList.size() > 0) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Mgram mgram = (Mgram)iterator.next();
                mgram.setType(by);
            }
        }
    }

    private void YKB_(IMgram iMgram, IMgram iMgram2) {
        if (iMgram2.isSecure() && iMgram2.getBrokerHandle().isEncrypted()) {
            return;
        }
        if (iMgram.hasTxn()) {
            iMgram2.setTxn(iMgram.getTxnId());
        }
        if (iMgram.getBrokerHandle().isTransactionalPublish()) {
            if (iMgram.getBrokerHandle().isTxnPublishFromLog()) {
                iMgram2.getBrokerHandle().setTxnPublishFromLog(true);
            }
            iMgram2.getBrokerHandle().setTxnPublish(iMgram.getBrokerHandle().getTxnPublishTid(), iMgram.getBrokerHandle().getTxnPublishTidSeqNo());
        }
        iMgram2.getBrokerHandle().setSenderID(iMgram.getBrokerHandle().getSenderID());
        iMgram2.getBrokerHandle().setFromRemoteBroker(iMgram.getBrokerHandle().isFromRemoteBroker());
        iMgram2.setSubject(iMgram.getSubject());
        iMgram2.setDestinationAddress(iMgram.getDestinationAddress());
        iMgram2.setDestinationAddressFormat(iMgram.getDestinationAddressFormat());
        iMgram2.getRoutingHandle().setRouting(iMgram.getRoutingHandle().getAllRoutingString());
        iMgram2.getRoutingHandle().setGSAPublication(iMgram.getRoutingHandle().isGSAPublication());
        iMgram2.setChannel(iMgram.getChannel());
        iMgram2.setRouteLimit(iMgram.getRouteLimit());
        iMgram2.setSuccessor(iMgram.isSuccessor());
    }

    private void ZKB_(IMgram iMgram, IMgram iMgram2) {
        if (iMgram.isSecure()) {
            iMgram2.setMgramSecure(iMgram.getMessageProtection());
            iMgram2.setSecurityAttribute(iMgram.getSecurity());
            iMgram2.setMessageKey(iMgram.getMessageKey());
        }
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        super.writeToStream(outputStream);
    }

    protected void JF_(OutputStream outputStream, StreamUtilCounter streamUtilCounter) throws IOException {
        super.JF_(outputStream, streamUtilCounter);
    }

    public void writePreSecureData(OutputStream outputStream) throws IOException {
        StreamUtil.writeByte(this.rJB_, outputStream);
        if ((this.rJB_ & 3) > 0) {
            StreamUtil.writeInt(this.SG_, outputStream);
        }
    }

    public void readPreSecureData(InputStream inputStream) throws IOException {
        this.rJB_ = StreamUtil.readByte(inputStream);
        if ((this.rJB_ & 3) > 0) {
            this.SG_ = StreamUtil.readInt(inputStream);
        }
    }

    public void syncPerMsgEnc(ClientSecurityContext clientSecurityContext, IMessageProtection iMessageProtection) throws ESecurityInvalidLogistics {
        if (this.qJB_ != null && this.qJB_.size() > 0) {
            byte by = SecurityLogic.AttribsFromPublic((byte)1, (byte)2);
            int n = 0;
            while (n < this.qJB_.size()) {
                IMgram iMgram = (IMgram)this.qJB_.get(n);
                iMgram.setMgramSecure(iMessageProtection);
                iMgram.setSecurityAttribute(by);
                ++n;
            }
        }
    }

    public void setAtomic(boolean bl) {
        this.rJB_ = bl ? (byte)(this.rJB_ | 1) : (byte)(this.rJB_ & 0xFFFFFFFE);
    }

    private void aKB_(boolean bl) {
        this.rJB_ = bl ? (byte)(this.rJB_ | 2) : (byte)(this.rJB_ & 0xFFFFFFFD);
    }

    public boolean isAtomic() {
        return (this.rJB_ & 1) > 0;
    }

    public boolean hasAnyTTE() {
        return (this.rJB_ & 2) > 0;
    }

    public IBatchHandle getBatchHandle() {
        return this;
    }

    public void setTid(int n) {
        this.rJB_ = (byte)(this.rJB_ | 3);
        this.SG_ = n;
    }

    public boolean hasTid() {
        return (this.rJB_ & 3) > 0;
    }

    public int getTid() {
        return this.SG_;
    }

    public void secureHeader(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        if (this.YG_.isSecure()) {
            byte by = this.YG_.getSecurity();
            if (SecurityLogic.isMKeyEncryption(by)) {
                this.YG_.cH_(iMessageProtection);
                this.AE_(iMessageProtection);
            } else if (SecurityLogic.isMKeyMacHeader(by)) {
                this.YG_.jH_(iMessageProtection);
            } else if (SecurityLogic.isMKeyDigest(by)) {
                this.YG_.cH_(iMessageProtection);
            }
        }
    }

    public void syncBatchSecurity() {
        this.VKB_();
    }
}

