/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IAckHandle;
import progress.message.msg.IAckListHandle;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IBrokerHandle;
import progress.message.msg.IConnectionSyncHandle;
import progress.message.msg.IErrorHandle;
import progress.message.msg.IExtendedTXNRequestHandle;
import progress.message.msg.IFailoverStatusNotificationHandle;
import progress.message.msg.IFlowControlHandle;
import progress.message.msg.IIDRHandle;
import progress.message.msg.IJMSClientHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramConverterHandle$IDynamicHeader;
import progress.message.msg.IMgramConverterHandle$IPayload;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.IOperationHandle;
import progress.message.msg.IQueueFlowControlHandle;
import progress.message.msg.IReplicatedMgramHandle;
import progress.message.msg.IRoutingHandle;
import progress.message.msg.ISaverOpHandle;
import progress.message.msg.IStateEventHandle;
import progress.message.msg.ITXNRequestHandle;
import progress.message.msg.IWindowAckHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.AckListPayload;
import progress.message.msg.v26.AckPayload;
import progress.message.msg.v26.BatchPayload;
import progress.message.msg.v26.DefaultDynamicHeader;
import progress.message.msg.v26.DefaultPayload;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.MgramCreator;
import progress.message.msg.v26.Payload;
import progress.message.msg.v26.SecureDynamicHeader;
import progress.message.msg.v26.SidebandData;
import progress.message.msg.v26.StaticHeader;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.IndexedList;
import progress.message.util.LongHashTable;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Connection;
import progress.message.zclient.CryptoInfoLinkedList;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

public final class Mgram
implements Cloneable,
IMgram,
IMgramConverterHandle,
IBrokerHandle,
IJMSClientHandle {
    private static final boolean YE_ = false;
    static final int vB_ = 8;
    public static final int RRS_SEND = 0;
    public static final int RRS_REQUEST = 2;
    public static final int RRS_REPLY = 3;
    static final int zB_ = 0;
    static final int AC_ = 1;
    static final int BC_ = 2;
    static final int CC_ = 3;
    static final int DC_ = 0;
    static final int EC_ = 1;
    static final int FC_ = 2;
    static final int GC_ = 3;
    static final int HC_ = 16;
    private int IC_ = 0;
    private IMgramStatusListener JC_ = null;
    private byte[] KC_ = null;
    private DynamicHeader LC_ = null;
    private byte[] EH_ = null;
    private Payload MC_ = null;
    private byte[] FH_ = null;
    private int GH_ = -1;
    private int HH_ = -1;
    private boolean NC_ = false;
    private long IH_ = -1L;
    private long qD_;
    private volatile Object JH_;
    private volatile boolean KH_;
    private boolean LH_;
    private int MH_;
    private int NH_;
    private boolean OH_;
    private boolean dJ_ = false;
    private long eJ_ = -1L;
    private boolean PH_;
    private boolean QH_;
    private IndexedList fJ_ = null;
    private byte RH_ = (byte)27;
    private boolean SH_ = false;
    private long TH_ = 0L;
    private IMgram UH_;
    private boolean VH_ = false;
    private int WH_;
    public static final byte CURR_VERSION = 26;
    static final int XH_ = MemoryUtil.estimateBaseSize(oJ_ == null ? (oJ_ = Mgram.lH_("progress.message.msg.v26.Mgram")) : oJ_);
    private String YH_;
    private boolean ZH_ = false;
    private boolean aH_ = false;
    private long bH_ = -1L;
    private boolean cH_ = false;
    private LongHashTable dH_;
    private boolean eH_ = false;
    private boolean gJ_ = false;
    private Connection hJ_ = null;
    private boolean iJ_ = false;
    private int jJ_;
    private boolean kJ_ = false;
    private long lJ_;
    private boolean mJ_ = false;
    private int nJ_ = -1;
    static Class oJ_;

    public Mgram(boolean bl) {
        this.JC_ = null;
        if (bl) {
            this.KC_ = StaticHeader.getDefaultByteArray();
            this.LC_ = new DefaultDynamicHeader(this);
            this.MC_ = new DefaultPayload(this);
        }
        this.setStatus(3);
    }

    void OH_(IMgramStatusListener iMgramStatusListener) {
        this.JC_ = iMgramStatusListener;
    }

    public void setStaticHeader(byte[] byArray) {
        this.KC_ = byArray;
        this.NC_ = false;
    }

    public void setDynamicHeader(DynamicHeader dynamicHeader) {
        this.LC_ = dynamicHeader;
        this.EH_ = null;
    }

    public void setPayload(Payload payload) {
        this.MC_ = payload;
        this.FH_ = null;
    }

    Mgram(byte[] byArray) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.JC_ = null;
        this.initMgramFromStream(new ByteArrayInputStream(byArray));
    }

    Mgram(Mgram mgram) {
        this.IC_ = mgram.IC_;
        this.JC_ = mgram.JC_;
        this.KC_ = mgram.KC_;
        this.LC_ = mgram.LC_;
        this.EH_ = mgram.EH_;
        this.MC_ = mgram.MC_;
        this.FH_ = mgram.FH_;
        this.GH_ = mgram.GH_;
        this.HH_ = mgram.HH_;
        this.NC_ = mgram.NC_;
        this.IH_ = mgram.IH_;
        this.qD_ = mgram.qD_;
        this.JH_ = mgram.JH_;
        this.KH_ = mgram.KH_;
        this.LH_ = mgram.LH_;
        this.MH_ = mgram.MH_;
        this.NH_ = mgram.NH_;
        this.OH_ = mgram.OH_;
        this.dJ_ = mgram.dJ_;
        this.PH_ = mgram.PH_;
        this.QH_ = mgram.QH_;
        this.RH_ = mgram.RH_;
        this.SH_ = mgram.SH_;
        this.TH_ = mgram.TH_;
        this.UH_ = mgram.UH_;
        this.VH_ = mgram.VH_;
        this.WH_ = mgram.WH_;
        this.YH_ = mgram.YH_;
        this.ZH_ = mgram.ZH_;
        this.aH_ = mgram.aH_;
        this.bH_ = mgram.bH_;
        this.cH_ = mgram.cH_;
        this.dH_ = mgram.dH_;
        this.eH_ = mgram.eH_;
        this.gJ_ = mgram.gJ_;
        this.hJ_ = mgram.hJ_;
        this.dJ_ = mgram.dJ_;
        this.eJ_ = mgram.eJ_;
        this.jJ_ = mgram.jJ_;
        this.iJ_ = mgram.iJ_;
        this.kJ_ = mgram.kJ_;
        this.lJ_ = mgram.lJ_;
        this.fJ_ = mgram.fJ_;
        this.mJ_ = mgram.mJ_;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        Mgram mgram = new Mgram(this);
        if (this.LC_ != null) {
            mgram.LC_ = (DynamicHeader)this.LC_.clone(mgram);
        }
        if (this.MC_ != null) {
            mgram.MC_ = (Payload)this.MC_.clone(mgram);
        }
        if (this.KC_ != null) {
            mgram.KC_ = new byte[this.KC_.length];
            System.arraycopy(this.KC_, 0, mgram.KC_, 0, this.KC_.length);
        }
        if (this.EH_ != null) {
            mgram.EH_ = new byte[this.EH_.length];
            System.arraycopy(this.EH_, 0, mgram.EH_, 0, this.EH_.length);
        }
        if (this.FH_ != null) {
            mgram.FH_ = new byte[this.FH_.length];
            System.arraycopy(this.FH_, 0, mgram.FH_, 0, this.FH_.length);
        }
        mgram.NC_ = false;
        return mgram;
    }

    public synchronized Object shallowClone() throws CloneNotSupportedException {
        Mgram mgram = new Mgram(this);
        if (this.LC_ != null) {
            mgram.LC_ = (DynamicHeader)this.LC_.shallowClone(mgram);
        }
        if (this.MC_ != null) {
            mgram.MC_ = (Payload)this.MC_.shallowClone(mgram);
        }
        return mgram;
    }

    public synchronized Object protectedClone() throws CloneNotSupportedException {
        Mgram mgram = new Mgram(this);
        mgram.NC_ = true;
        if (this.LC_ != null) {
            mgram.LC_ = (DynamicHeader)this.LC_.protectedClone(mgram);
        }
        if (this.MC_ != null) {
            mgram.MC_ = (Payload)this.MC_.protectedClone(mgram);
        }
        this.protect();
        return mgram;
    }

    public synchronized void protect() {
        this.NC_ = true;
        if (this.LC_ != null) {
            this.LC_.protect();
        }
        if (this.MC_ != null) {
            this.MC_.protect();
        }
    }

    private void PH_() {
        if (this.NC_) {
            if (this.KC_ != null) {
                byte[] byArray = new byte[this.KC_.length];
                System.arraycopy(this.KC_, 0, byArray, 0, this.KC_.length);
                this.KC_ = byArray;
            }
            this.NC_ = false;
        }
    }

    public synchronized void unprotectSuccessor() {
        this.PH_();
    }

    public void initMgramFromStream(InputStream inputStream) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.initMgramFromStream(inputStream, null, null, null, false, null);
    }

    public void initMgramFromStream(InputStream inputStream, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, boolean bl, StreamUtilCounter streamUtilCounter) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (streamUtilCounter != null) {
            streamUtilCounter.resetCounter();
        }
        this.SH_(inputStream, this.JC_, bl);
        if (this.getType() == 4) {
            return;
        }
        this.QH_(inputStream, iSecureInputStream, iMessageProtection, clientSecurityContext, streamUtilCounter);
    }

    public void initMgramFromStream(byte by, InputStream inputStream, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, boolean bl, StreamUtilCounter streamUtilCounter) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (streamUtilCounter != null) {
            streamUtilCounter.resetCounter();
        }
        this.TH_(by, inputStream, this.JC_, bl);
        if (this.getType() == 4) {
            return;
        }
        this.QH_(inputStream, iSecureInputStream, iMessageProtection, clientSecurityContext, streamUtilCounter);
    }

    public void initMgramFromStreamNonSecure(byte by, InputStream inputStream, boolean bl, StreamUtilCounter streamUtilCounter) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (streamUtilCounter != null) {
            streamUtilCounter.resetCounter();
        }
        this.TH_(by, inputStream, this.JC_, bl);
        if (this.getType() == 4) {
            return;
        }
        this.RH_(inputStream, streamUtilCounter);
    }

    private void QH_(InputStream inputStream, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, StreamUtilCounter streamUtilCounter) throws EMgramVersionMismatch, EMgramFormatError, IOException {
        boolean bl = StaticHeader.qw_(this.KC_);
        this.LC_ = Mgram.initDynamicHeaderFromStream(inputStream, bl, iMessageProtection, this);
        this.MC_ = Mgram.initPayloadFromStream(inputStream, iSecureInputStream, iMessageProtection, clientSecurityContext, this.KC_, this.LC_, this, streamUtilCounter);
    }

    private void RH_(InputStream inputStream, StreamUtilCounter streamUtilCounter) throws EMgramVersionMismatch, EMgramFormatError, IOException {
        boolean bl = StaticHeader.qw_(this.KC_);
        this.LC_ = Mgram.initDynamicHeaderFromStream(inputStream, bl, null, this);
        this.MC_ = Mgram.initPayloadFromStream(inputStream, null, null, null, this.KC_, this.LC_, this, streamUtilCounter);
    }

    private void SH_(InputStream inputStream, IMgramStatusListener iMgramStatusListener, boolean bl) throws IOException, EMgramVersionMismatch {
        this.TH_((byte)-1, inputStream, iMgramStatusListener, bl);
    }

    private void TH_(byte by, InputStream inputStream, IMgramStatusListener iMgramStatusListener, boolean bl) throws IOException, EMgramVersionMismatch {
        int n = 0;
        this.KC_ = new byte[20];
        if (by == -1) {
            if (iMgramStatusListener != null) {
                iMgramStatusListener.setStatus((byte)0);
            }
            StreamUtil.readBytes(inputStream, this.KC_, n, 1);
        }
        ++n;
        if (iMgramStatusListener != null) {
            iMgramStatusListener.setStatus((byte)1);
        }
        StreamUtil.readBytes(inputStream, this.KC_, n, 20 - n);
        if (by != -1) {
            StaticHeader.Wx_(by, this.KC_);
        }
        if (StaticHeader.Px_(this.KC_) != 4 && StaticHeader.Vx_(this.KC_) != 26) {
            throw new EMgramVersionMismatch(StaticHeader.Vx_(this.KC_));
        }
        if (StaticHeader.Px_(this.KC_) == 4) {
            if (StaticHeader.ow_(this.KC_)) {
                this.RH_ = StreamUtil.readByte(inputStream);
            }
            return;
        }
        if (StaticHeader.uw_(this.KC_) && bl) {
            long l = StaticHeader.Hx_(this.KC_);
            StaticHeader.zw_(l += System.currentTimeMillis(), this.KC_);
            this.SH_ = false;
        }
    }

    public static DynamicHeader initDynamicHeaderFromStream(InputStream inputStream, boolean bl, IMessageProtection iMessageProtection, Mgram mgram) throws IOException, EMgramVersionMismatch {
        DynamicHeader dynamicHeader = null;
        if (bl) {
            dynamicHeader = new SecureDynamicHeader(mgram, iMessageProtection);
            dynamicHeader.GK_(inputStream);
        } else {
            dynamicHeader = new DefaultDynamicHeader(mgram);
            dynamicHeader.GK_(inputStream);
        }
        return dynamicHeader;
    }

    private Payload UH_(byte by) {
        return MgramCreator.getPayloadObject(by, this);
    }

    public static Payload initPayloadFromStream(InputStream inputStream, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, byte[] byArray, DynamicHeader dynamicHeader, Mgram mgram, StreamUtilCounter streamUtilCounter) throws EMgramFormatError, IOException {
        Payload payload = MgramCreator.getPayloadObject(StaticHeader.Px_(byArray), mgram);
        payload.readPreSecureData(inputStream);
        if (StaticHeader.qw_(byArray) && iSecureInputStream != null && iMessageProtection != null && clientSecurityContext != null) {
            Mgram.VH_(inputStream, dynamicHeader, payload, iSecureInputStream, iMessageProtection, clientSecurityContext, streamUtilCounter);
            Mgram.WH_(iMessageProtection, clientSecurityContext, byArray, dynamicHeader, payload);
        } else {
            payload.H_(inputStream, streamUtilCounter);
        }
        return payload;
    }

    private static Payload VH_(InputStream inputStream, DynamicHeader dynamicHeader, Payload payload, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, StreamUtilCounter streamUtilCounter) throws ESecurityGeneralException, IOException, EMgramFormatError {
        byte[] byArray = clientSecurityContext.getSessionKey();
        byte by = dynamicHeader.getSecurity();
        if (SecurityLogic.isMKeyDigest(by) || SecurityLogic.isMKeyMacHeader(by)) {
            int n = iMessageProtection.getSecretKeyLength();
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = dynamicHeader.getMessageKey();
            iMessageProtection.decryptWithSessionKey(byArray3, 0, byArray3.length, byArray2, 0);
            dynamicHeader.setMessageKey(byArray2);
            if (SecurityLogic.isMKeyEncryption(by)) {
                int n2 = dynamicHeader.getMessageKey().length;
                byte[] byArray4 = new byte[n2];
                System.arraycopy(dynamicHeader.getMessageKey(), 0, byArray4, 0, n2);
                iSecureInputStream.setMessageKey(byArray4);
                iSecureInputStream.bytesExpected(dynamicHeader.getMessageLength() + dynamicHeader.getMessagePad());
                InputStream inputStream2 = iSecureInputStream.getInputStream();
                payload.H_(inputStream2, streamUtilCounter);
                return payload;
            }
        } else if (SecurityLogic.isSKeyEncryption(by)) {
            iSecureInputStream.useSessionKey();
            iSecureInputStream.bytesExpected(dynamicHeader.getMessageLength() + dynamicHeader.getMessagePad());
            payload.H_(iSecureInputStream.getInputStream(), streamUtilCounter);
            return payload;
        }
        payload.H_(inputStream, streamUtilCounter);
        return payload;
    }

    private static void WH_(IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, byte[] byArray, DynamicHeader dynamicHeader, Payload payload) throws ESecurityGeneralException, EIntegrityCompromised {
        boolean bl;
        boolean bl2;
        byte[] byArray2;
        boolean bl3;
        CryptoInfoLinkedList cryptoInfoLinkedList = null;
        byte by = dynamicHeader.getSecurity();
        if (SecurityLogic.isSKeyDigest(by) || SecurityLogic.isMKeyDigest(by)) {
            cryptoInfoLinkedList = Mgram.XH_(payload);
        }
        if (SecurityLogic.isSKeyDigest(by) ? !(bl3 = iMessageProtection.verifyMac(byArray2 = clientSecurityContext.getDigestKey(), 0, byArray2.length, cryptoInfoLinkedList, dynamicHeader.getDigest(), 0, dynamicHeader.getDigest().length)) : (SecurityLogic.isMKeyDigest(by) ? !(bl2 = iMessageProtection.verifyMac(dynamicHeader.getMessageKey(), 0, dynamicHeader.getMessageKey().length, cryptoInfoLinkedList, dynamicHeader.getDigest(), 0, dynamicHeader.getDigest().length)) : SecurityLogic.isMKeyMacHeader(by) && !(bl = iMessageProtection.verifyMac(dynamicHeader.getMessageKey(), 0, dynamicHeader.getMessageKey().length, byArray, 0, 8, dynamicHeader.getDigest(), 0, dynamicHeader.getDigest().length)))) {
            throw new EIntegrityCompromised();
        }
    }

    public synchronized byte[] calculateMac(byte[] byArray, IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.iH_();
        CryptoInfoLinkedList cryptoInfoLinkedList = Mgram.XH_(this.MC_);
        IMessageProtection iMessageProtection2 = iMessageProtection;
        synchronized (iMessageProtection2) {
            byte[] byArray2 = new byte[iMessageProtection.getHashSize()];
            iMessageProtection.mac(byArray, 0, byArray.length, cryptoInfoLinkedList, byArray2, 0, byArray2.length);
            byte[] byArray3 = byArray2;
            return byArray3;
        }
    }

    public synchronized void recalculatePad(IMessageProtection iMessageProtection) {
        this.iH_();
        int n = this.MC_.length();
        int n2 = iMessageProtection.getOutputSize(n);
        this.hH_();
        this.LC_.NK_(n2 - n);
    }

    private static CryptoInfoLinkedList XH_(Payload payload) {
        return payload.CE_();
    }

    public synchronized IQueueFlowControlHandle getQueueFlowControlHandle() {
        this.iH_();
        return this.MC_.getQueueFlowControlHandle();
    }

    public synchronized IFlowControlHandle getFlowControlHandle() {
        this.iH_();
        return this.MC_.getFlowControlHandle();
    }

    public IBrokerHandle getBrokerHandle() {
        return this;
    }

    public synchronized IAckHandle getAckHandle() {
        this.iH_();
        return this.MC_.getAckHandle();
    }

    public synchronized IWindowAckHandle getWindowAckHandle() {
        this.iH_();
        return this.MC_.getWindowAckHandle();
    }

    public synchronized IAckListHandle getAckListHandle() {
        this.iH_();
        return this.MC_.GF_();
    }

    public synchronized IFailoverStatusNotificationHandle getFailoverStatusNotificationHandle() {
        this.iH_();
        return this.MC_.getFailoverStatusNotificationHandle();
    }

    public synchronized IIDRHandle getIDRHandle() {
        this.iH_();
        return this.MC_.getIDRHandle();
    }

    public synchronized IConnectionSyncHandle getConnectionSyncHandle() {
        this.iH_();
        return this.MC_.getConnectionSyncHandle();
    }

    public synchronized ITXNRequestHandle getTXNRequestHandle() {
        this.iH_();
        return this.MC_.getTXNRequestHandle();
    }

    public synchronized IExtendedTXNRequestHandle getExtendedTXNRequestHandle() {
        this.iH_();
        return this.MC_.getExtendedTXNRequestHandle();
    }

    public synchronized IErrorHandle getErrorHandle() {
        this.iH_();
        return this.MC_.getErrorHandle();
    }

    public final IMgramConverterHandle getMgramConverterHandle() {
        return this;
    }

    public final synchronized IStateEventHandle getStateEventHandle() {
        this.iH_();
        return this.MC_.getStateEventHandle();
    }

    public final synchronized IRoutingHandle getRoutingHandle() {
        this.iH_();
        return this.MC_.OE_();
    }

    public final synchronized IReplicatedMgramHandle getReplicatedMgramHandle() {
        this.iH_();
        return this.MC_.HF_();
    }

    public final synchronized boolean supportsRouting() {
        this.iH_();
        return this.MC_.PE_();
    }

    public boolean supportsOperationHandle() {
        return this.getType() == 25 || this.getType() == 27;
    }

    public final synchronized IMgramConverterHandle$IDynamicHeader getInternalDynamicHeader() {
        this.hH_();
        return this.LC_;
    }

    public final byte[] getInternalStaticHeader() {
        return this.KC_;
    }

    public final synchronized IMgramConverterHandle$IPayload getInternalPayload() {
        this.iH_();
        return this.MC_;
    }

    public boolean isSecure() {
        return StaticHeader.qw_(this.KC_);
    }

    public boolean isGuarenteed() {
        boolean bl = StaticHeader.ww_(this.KC_);
        if (this.mJ_) {
            bl = !bl;
        }
        return bl;
    }

    public boolean isGuarenteedInternal() {
        return StaticHeader.ww_(this.KC_);
    }

    public synchronized long getGuarenteedTrackingNum() {
        this.iH_();
        if (this.mJ_) {
            return this.lJ_;
        }
        return this.MC_.getGuarenteedTrackingNum();
    }

    public synchronized void setSuccessor(boolean bl) {
        this.PH_();
        StaticHeader.Kx_(bl, this.KC_);
    }

    public synchronized byte getSecurity() {
        this.hH_();
        return this.LC_.getSecurity();
    }

    public synchronized int getMessageLength() {
        this.hH_();
        return this.LC_.getMessageLength();
    }

    public synchronized int getBodyLength() {
        this.iH_();
        return this.MC_.vD_();
    }

    public synchronized int getMessagePad() {
        this.hH_();
        return this.LC_.getMessagePad();
    }

    public synchronized byte[] getMessageKey() {
        this.hH_();
        return this.LC_.getMessageKey();
    }

    public IMessageProtection getMessageProtection() {
        this.hH_();
        return this.LC_.HK_();
    }

    public synchronized int getDestinationAddressFormat() {
        return StaticHeader.Dx_(this.KC_);
    }

    public synchronized byte[] getDestinationAddress() {
        this.iH_();
        return this.MC_.XD_();
    }

    public synchronized void setDestinationAddress(byte[] byArray) {
        this.iH_();
        this.MC_.WD_(byArray);
    }

    public synchronized void setDestinationAddressFormat(int n) {
        if (StaticHeader.Dx_(this.KC_) != n) {
            this.PH_();
            StaticHeader.Sx_(n, this.KC_);
        }
    }

    public int getRequestReplyFieldType() {
        return StaticHeader.Fx_(this.KC_);
    }

    public byte getType() {
        return StaticHeader.Px_(this.KC_);
    }

    public synchronized void setType(byte by) {
        if (this.getType() != 27) {
            this.PH_();
            StaticHeader.setType(by, this.KC_);
        } else {
            this.iH_();
            this.MC_.IF_(by);
        }
    }

    public synchronized void sync() {
        this.PH_();
        if (this.LC_ != null) {
            this.LC_.QK_();
        }
        if (this.MC_ != null) {
            this.MC_.KF_();
        }
    }

    void YH_() {
        this.HH_ = -1;
    }

    void ZH_() {
        this.GH_ = -1;
    }

    public boolean hasTxn() {
        return StaticHeader.yw_(this.KC_);
    }

    public synchronized int getChannel() {
        return StaticHeader.Qx_(this.KC_);
    }

    public synchronized void setChannel(int n) {
        this.PH_();
        StaticHeader.setChannel(n, this.KC_);
    }

    public boolean isPostSV22() {
        return StaticHeader.nw_(this.KC_);
    }

    public boolean hasSessionVer() {
        return StaticHeader.ow_(this.KC_);
    }

    public synchronized void setSessionVer(byte by) {
        this.RH_ = by;
        StaticHeader.kw_(by, this.KC_);
    }

    public void setSenderID(long l) {
        this.IH_ = l;
    }

    public long getSenderID() {
        return this.IH_;
    }

    public boolean isTargeted() {
        return this.ZH_;
    }

    public void setTargeted(boolean bl) {
        this.ZH_ = bl;
    }

    public void setRedirectAckTarget(long l) {
        this.bH_ = l;
    }

    public long getRedirectAckTarget() {
        return this.bH_;
    }

    public void setProxyRecipsTable(LongHashTable longHashTable) {
        this.dH_ = longHashTable;
    }

    public LongHashTable getProxyRecipsTable() {
        return this.dH_;
    }

    public void setAckNoReply(boolean bl) {
        this.LH_ = bl;
    }

    public boolean isAckNoReply() {
        return this.LH_;
    }

    public boolean isFromDB() {
        return this.KH_;
    }

    public void setFromDB(boolean bl) {
        this.KH_ = bl;
    }

    public boolean isDBSaveRequested() {
        return this.PH_;
    }

    public void setDBSaveRequested(boolean bl) {
        this.PH_ = bl;
    }

    public boolean wasDBSaved() {
        return this.QH_;
    }

    public void setDBSaved(boolean bl) {
        this.QH_ = bl;
    }

    public void addMsgHeaderSaved(long l) {
        if (this.fJ_ == null) {
            this.fJ_ = new IndexedList();
        }
        this.fJ_.appendNoDup(l, (Object)new Long(l));
    }

    public void addMsgHeadersSaved(long[] lArray) {
        int n = 0;
        while (n < lArray.length) {
            this.addMsgHeaderSaved(lArray[n]);
            ++n;
        }
    }

    public boolean isMsgHeaderSaved(long l) {
        if (this.fJ_ != null) {
            return this.fJ_.get(l) != null;
        }
        return false;
    }

    public void clearMsgHeader(long l) {
        if (this.fJ_ != null) {
            this.fJ_.remove(l);
            if (this.fJ_.count() == 0) {
                this.fJ_ = null;
            }
        }
    }

    public void setLocalQueueName(String string) {
        this.YH_ = string;
    }

    public String getLocalQueueName() {
        return this.YH_;
    }

    public boolean isReply() {
        return StaticHeader.pw_(this.KC_);
    }

    public boolean isRequest() {
        return StaticHeader.lw_(this.KC_);
    }

    public boolean isSend() {
        return StaticHeader.mw_(this.KC_);
    }

    public byte getPriority() {
        return StaticHeader.Rx_(this.KC_);
    }

    public int getRouteLimit() {
        return StaticHeader.Gx_(this.KC_);
    }

    public synchronized void setRouteLimit(int n) {
        this.PH_();
        StaticHeader.Ix_(n, this.KC_);
    }

    public boolean isSuccessor() {
        return StaticHeader.Jx_(this.KC_);
    }

    public boolean isJMSPersistent() {
        return StaticHeader.Lx_(this.KC_);
    }

    public boolean isPubSub() {
        if (this.getType() == 2) {
            return true;
        }
        if (this.getType() == 27) {
            this.iH_();
            return this.MC_.isPubSub();
        }
        if (this.getType() == 25 && this.getOperationHandle().getOperationType() == 25) {
            return ((IMgram)this.getOperationHandle().getMgramList().getFirst()).isPubSub();
        }
        return false;
    }

    public boolean isPTP() {
        if (this.getType() == 12) {
            return true;
        }
        if (this.getType() == 27) {
            this.iH_();
            return this.MC_.isPTP();
        }
        if (this.getType() == 25 && this.getOperationHandle().getOperationType() == 25) {
            return ((IMgram)this.getOperationHandle().getMgramList().getFirst()).isPTP();
        }
        return false;
    }

    public synchronized int getReplyPriority() {
        this.iH_();
        return this.MC_.jD_();
    }

    public synchronized void setReplyPriority(int n) {
        this.iH_();
        this.MC_.kD_(n);
    }

    public boolean isTTE() {
        return StaticHeader.uw_(this.KC_);
    }

    public synchronized long getTTE() {
        this.aH_();
        return this.TH_;
    }

    private synchronized void aH_() {
        boolean bl = StaticHeader.uw_(this.KC_);
        if (bl && this.TH_ == 0L || bl && this.SH_) {
            this.TH_ = StaticHeader.Hx_(this.KC_);
            if (this.SH_) {
                this.TH_ = System.currentTimeMillis() + this.TH_;
                this.SH_ = false;
                StaticHeader.zw_(this.TH_, this.KC_);
            }
        }
    }

    void bH_(boolean bl) {
        this.SH_ = bl;
    }

    public synchronized void setTTE(long l) {
        this.PH_();
        StaticHeader.zw_(l, this.KC_);
        this.TH_ = l;
        this.SH_ = false;
    }

    public synchronized void removeTTE() {
        this.PH_();
        StaticHeader.vw_(false, this.KC_);
        this.TH_ = 0L;
    }

    public synchronized void setDiscardable(boolean bl) {
        if (bl != this.isDiscardable()) {
            this.PH_();
            StaticHeader.Nx_(bl, this.KC_);
        }
    }

    public boolean isDiscardable() {
        return StaticHeader.Ox_(this.KC_);
    }

    public synchronized void setJMSPersistent(boolean bl) {
        this.PH_();
        StaticHeader.Mx_(bl, this.KC_);
    }

    public synchronized void setSecurityAttribute(byte by) {
        this.hH_();
        this.LC_.MK_(by);
    }

    public synchronized void setMgramSecure(IMessageProtection iMessageProtection) {
        this.PH_();
        this.hH_();
        StaticHeader.rw_(true, this.KC_);
        this.hH_();
        this.LC_ = this.LC_.SK_(iMessageProtection);
    }

    public synchronized void setMessageKey(byte[] byArray) {
        this.hH_();
        this.LC_.setMessageKey(byArray);
    }

    public synchronized void setMgramNonSecure() {
        this.PH_();
        this.hH_();
        StaticHeader.rw_(false, this.KC_);
        this.hH_();
        this.LC_ = this.LC_.TK_();
    }

    public synchronized void setPriority(byte by) {
        this.PH_();
        StaticHeader.setPriority(by, this.KC_);
    }

    public synchronized boolean hasSubject() {
        this.iH_();
        return this.MC_.lD_();
    }

    public synchronized String getSubject() {
        this.iH_();
        return this.MC_.rD_();
    }

    public synchronized void setSubject(String string) {
        this.iH_();
        this.MC_.sD_(string);
    }

    public synchronized boolean hasBody() {
        this.iH_();
        return this.MC_.tD_();
    }

    public void setBody(byte[] byArray) {
        if (byArray != null) {
            this.setBody(byArray, byArray.length);
        } else {
            this.setBody(byArray, 0);
        }
    }

    public synchronized void setBody(byte[] byArray, int n) {
        this.iH_();
        this.MC_.uD_(byArray, n);
    }

    public synchronized int getPayloadLength() {
        if (this.MC_ == null) {
            return this.FH_.length;
        }
        return this.MC_.length();
    }

    public synchronized void setSidebandData(ISidebandData iSidebandData) {
        this.iH_();
        this.MC_.xD_(iSidebandData);
    }

    public synchronized ISidebandData getSidebandData() {
        this.iH_();
        return this.MC_.mD_();
    }

    public synchronized ISidebandData getSidebandDataReadOnly() {
        this.iH_();
        return this.MC_.nD_();
    }

    public synchronized boolean hasSidebandData() {
        this.iH_();
        return this.MC_.oD_();
    }

    public synchronized void createSidebandDataIfNeeded() {
        this.iH_();
        this.MC_.pD_();
    }

    public synchronized String getRouting() {
        return this.getRoutingHandle().getRouting();
    }

    public synchronized boolean forRemoteNode(String string) {
        String string2 = this.getRouting();
        return string2 != null && !string2.equals(string) && !string2.equals("");
    }

    public synchronized byte[] getRawBody() {
        this.iH_();
        return this.MC_.bD_();
    }

    public boolean hasID() {
        return StaticHeader.sw_(this.KC_);
    }

    public synchronized void setID(byte[] byArray) {
        this.PH_();
        this.iH_();
        StaticHeader.tw_(this.KC_);
        this.MC_.HD_(byArray);
    }

    public synchronized byte[] getID() {
        this.iH_();
        return this.MC_.GD_();
    }

    public synchronized long getSequenceNumber() {
        return this.qD_;
    }

    public void setSequenceNumber(long l) {
        this.qD_ = l;
    }

    public synchronized void clearID() {
        this.iH_();
        this.MC_.ND_();
    }

    public synchronized void clearAddresses() {
        this.PH_();
        this.iH_();
        StaticHeader.Ex_(this.KC_);
        this.MC_.OD_();
    }

    public synchronized void setRequestReplySend() {
        this.PH_();
        StaticHeader.setRequestReplyType(0, this.KC_);
    }

    public synchronized void setRequestReplyReply() {
        this.PH_();
        StaticHeader.setRequestReplyType(3, this.KC_);
    }

    public synchronized void setGuarenteed(long l) {
        this.PH_();
        this.iH_();
        this.mJ_ = false;
        StaticHeader.xw_(true, this.KC_);
        this.MC_.setGuarenteed(l);
    }

    public synchronized void setReliable() {
        this.PH_();
        this.iH_();
        this.mJ_ = false;
        StaticHeader.xw_(false, this.KC_);
        this.MC_.setGuarenteed(0L);
    }

    public synchronized void setTxn(int n) {
        this.PH_();
        this.iH_();
        StaticHeader.Ax_(true, this.KC_);
        this.MC_.setTxn(n);
    }

    public synchronized void setTxnPublish(int n, int n2) {
        this.PH_();
        StaticHeader.Bx_(true, this.KC_);
        this.MH_ = n;
        this.NH_ = n2;
    }

    public void setBatchedPublish(boolean bl) {
        this.dJ_ = bl;
    }

    public boolean isBatchedPublish() {
        return this.dJ_;
    }

    public void setBatchId(long l) {
        this.eJ_ = l;
    }

    public long getBatchId() {
        return this.eJ_;
    }

    public int getTxnPublishTid() {
        return this.MH_;
    }

    public int getTxnPublishTidSeqNo() {
        return this.NH_;
    }

    public synchronized int getTxnId() {
        this.iH_();
        return this.MC_.getTxnId();
    }

    public synchronized void removeTxn() {
        this.PH_();
        this.iH_();
        StaticHeader.Ax_(false, this.KC_);
        this.MC_.removeTxn();
    }

    public synchronized void setRequest(long l, byte[] byArray, String string) {
        this.PH_();
        this.iH_();
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n = 10;
        int n2 = -1836570336;
        ArrayUtil.writeInt(byArray2, n, n2);
        n = byArray.length;
        ArrayUtil.writeInt(byArray2, n, (int)l);
        byArray2[1] = (byte)(byArray2[1] + 1);
        if (byArray2[1] == 0) {
            byArray2[0] = (byte)(byArray2[0] + 1);
        }
        this.MC_.QD_(byArray2, string);
        StaticHeader.setRequestReplyType(2, this.KC_);
    }

    public synchronized int memoryLength() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.LC_ != null) {
            bl = this.LC_.FK_();
        }
        if (this.MC_ != null) {
            bl2 = this.MC_.isDirty();
        }
        this.sync();
        if (this.LC_ != null && (bl || this.GH_ == -1)) {
            this.GH_ = this.LC_.KK_();
        } else if (this.GH_ == -1 && this.EH_ != null) {
            this.GH_ = this.EH_.length;
        }
        if (this.MC_ != null && (bl2 || this.HH_ == -1)) {
            this.HH_ = this.MC_.memoryLength();
        } else if (this.HH_ == -1 && this.FH_ != null) {
            this.HH_ = this.FH_.length;
        }
        int n = 0;
        if (this.supportsOperationHandle()) {
            n += this.getOperationHandle().getMgramListMemoryLength();
        }
        int n2 = XH_ + 20 + this.GH_ + this.HH_ + n;
        return n2;
    }

    public synchronized void saveMemory() {
        if (this.LC_ != null) {
            this.LC_.LK_();
        }
        if (this.MC_ != null) {
            this.MC_.yD_();
        }
    }

    public synchronized int networkLength() {
        int n = 20 + (this.LC_ != null ? this.LC_.JK_() : this.EH_.length) + (this.MC_ != null ? this.MC_.length() : this.FH_.length);
        int n2 = 0;
        if (this.supportsOperationHandle()) {
            n2 += this.getOperationHandle().getMgramListNetworkLength();
        }
        return n + n2;
    }

    public synchronized void macMessageWithMessageKey(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.cH_(iMessageProtection);
        if (this.supportsOperationHandle()) {
            this.getOperationHandle().macMgramListMessagesWithMessageKey(iMessageProtection);
        }
    }

    synchronized void cH_(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.hH_();
        int n = iMessageProtection.getHashSize();
        byte[] byArray = this.LC_.getMessageKey();
        byte[] byArray2 = this.calculateMac(byArray, iMessageProtection);
        this.LC_.setMessageDigest(byArray2);
    }

    public synchronized byte[] getReplyToAddress() {
        this.iH_();
        return this.MC_.SD_();
    }

    public synchronized int getReplyToAddressFormat() {
        this.iH_();
        return this.MC_.TD_();
    }

    public synchronized void setReplyToAddressFormat(int n) {
        this.iH_();
        this.MC_.UD_(n);
    }

    public synchronized String getReplyToAddressString() {
        this.iH_();
        return this.MC_.VD_();
    }

    public synchronized void setReplyToString(String string) {
        this.iH_();
        this.MC_.RD_(string);
    }

    public synchronized void setReply(IMgram iMgram) {
        this.PH_();
        this.iH_();
        StaticHeader.setRequestReplyType(3, this.KC_);
        this.MC_.WD_(iMgram.getReplyToAddress());
        StaticHeader.Sx_(iMgram.getReplyToAddressFormat(), this.KC_);
    }

    public synchronized void setRequestReplyType(int n) {
        this.PH_();
        StaticHeader.setRequestReplyType(n, this.KC_);
    }

    public synchronized int getReplyTracking() throws ENoTrackingNum {
        this.iH_();
        if (!StaticHeader.Tx_(this.KC_) || !this.MC_.YD_()) {
            throw new ENoTrackingNum();
        }
        byte[] byArray = this.MC_.XD_();
        int n = byArray.length - 4;
        return ArrayUtil.readInt(byArray, n);
    }

    public synchronized int getReplyToAddressTracking() throws ENoTrackingNum {
        this.iH_();
        byte[] byArray = this.MC_.SD_();
        int n = byArray.length - 4;
        return ArrayUtil.readInt(byArray, n);
    }

    public void writeMgramToNetworkStream(OutputStream outputStream, ClientSecurityContext clientSecurityContext, ISecureOutputStream iSecureOutputStream, IMessageProtection iMessageProtection) throws IOException {
        this.writeMgramToStream(outputStream, clientSecurityContext, iSecureOutputStream, iMessageProtection, true);
    }

    public void writeMgramToNetworkStream(OutputStream outputStream, int n, ClientSecurityContext clientSecurityContext, ISecureOutputStream iSecureOutputStream, IMessageProtection iMessageProtection) throws IOException {
        this.writeMgramToStream(outputStream, n, clientSecurityContext, iSecureOutputStream, iMessageProtection, true);
    }

    public void writeMgramToStream(OutputStream outputStream) throws IOException {
        this.writeMgramToStream(outputStream, null, null, null, false);
    }

    public void writeMgramToStream(OutputStream outputStream, boolean bl) throws IOException {
        this.writeMgramToStream(outputStream, null, null, null, bl);
    }

    public void writeMgramToStream(OutputStream outputStream, ClientSecurityContext clientSecurityContext, ISecureOutputStream iSecureOutputStream, IMessageProtection iMessageProtection, boolean bl) throws IOException {
        this.writeMgramToStream(outputStream, -1, clientSecurityContext, iSecureOutputStream, iMessageProtection, bl);
    }

    public void writeMgramToStream(OutputStream outputStream, int n, ClientSecurityContext clientSecurityContext, ISecureOutputStream iSecureOutputStream, IMessageProtection iMessageProtection, boolean bl) throws IOException {
        this.writeStaticHeaderToStream(outputStream, n, bl);
        if (this.KC_ != null && StaticHeader.Px_(this.KC_) == 4) {
            return;
        }
        this.writeDynamicHeaderToStream(outputStream, clientSecurityContext, iMessageProtection);
        this.writePayloadToStream(outputStream, iSecureOutputStream);
    }

    public void writeMgramToStreamNonSecure(OutputStream outputStream, boolean bl) throws IOException {
        this.writeMgramToStreamNonSecure(outputStream, -1, bl);
    }

    public void writeMgramToStreamNonSecure(OutputStream outputStream, int n, boolean bl) throws IOException {
        this.writeStaticHeaderToStream(outputStream, n, bl);
        if (this.KC_ != null && StaticHeader.Px_(this.KC_) == 4) {
            return;
        }
        this.writeDynamicHeaderToStream(outputStream, (ClientSecurityContext)null, null);
        if (this.isSecure()) {
            this.LC_.NK_(0);
        }
        this.writePayloadToStream(outputStream, null);
    }

    public void writeStaticHeaderToStream(OutputStream outputStream, boolean bl) throws IOException {
        this.writeStaticHeaderToStream(outputStream, -1, bl);
    }

    public void writeStaticHeaderToStream(OutputStream outputStream, int n, boolean bl) throws IOException {
        this.aH_();
        StaticHeader.iw_(outputStream, this.KC_, n, bl);
        if (this.getType() == 4 && StaticHeader.ow_(this.KC_)) {
            outputStream.write(this.RH_);
        }
    }

    public void writeDynamicHeaderToStream(OutputStream outputStream, ClientSecurityContext clientSecurityContext, IMessageProtection iMessageProtection) throws IOException {
        byte[] byArray = clientSecurityContext == null ? null : clientSecurityContext.getDigestKey();
        this.writeDynamicHeaderToStream(outputStream, byArray, iMessageProtection);
    }

    public void writeDynamicHeaderToStream(OutputStream outputStream, byte[] byArray, IMessageProtection iMessageProtection) throws IOException {
        if (this.isSecure() && iMessageProtection != null) {
            this.hH_();
            if (SecurityLogic.isSKeyDigest(this.getSecurity())) {
                byte[] byArray2 = this.calculateMac(byArray, iMessageProtection);
                this.LC_.setMessageDigest(byArray2);
            }
            this.recalculatePad(iMessageProtection);
            this.LC_.OK_(outputStream, iMessageProtection);
        } else {
            byte[] byArray3;
            DynamicHeader dynamicHeader;
            Mgram mgram = this;
            synchronized (mgram) {
                dynamicHeader = this.LC_;
                byArray3 = this.EH_;
            }
            if (dynamicHeader != null) {
                dynamicHeader.PK_(outputStream);
            } else {
                outputStream.write(byArray3);
            }
        }
    }

    public void writePayloadToStream(OutputStream outputStream, ISecureOutputStream iSecureOutputStream) throws IOException {
        if (this.isSecure()) {
            this.iH_();
            this.MC_.writePreSecureData(outputStream);
            if (SecurityLogic.isSKeyEncryption(this.getSecurity()) && iSecureOutputStream != null) {
                OutputStream outputStream2 = iSecureOutputStream.getOutputStream();
                this.MC_.writeToStream(outputStream2);
                outputStream2.flush();
            } else {
                this.MC_.writeToStream(outputStream);
            }
        } else {
            byte[] byArray;
            Payload payload;
            Mgram mgram = this;
            synchronized (mgram) {
                payload = this.MC_;
                byArray = this.FH_;
            }
            if (payload != null) {
                payload.writePreSecureData(outputStream);
                payload.writeToStream(outputStream);
            } else {
                outputStream.write(byArray);
            }
        }
    }

    public synchronized int serializedLength() {
        this.sync();
        this.hH_();
        this.iH_();
        int n = this.dH_();
        n += this.isEncrypted() ? this.eH_() : this.fH_();
        n += this.isTransactionalPublish() ? 8 : 0;
        n += this.isEnqueuedSizeSet() ? 4 : 0;
        if (this.supportsOperationHandle()) {
            n += this.getOperationHandle().getMgramListSerializedLength();
        }
        return n;
    }

    private int dH_() {
        int n = 4 + this.KC_.length + this.LC_.JK_();
        if (this.isSecure()) {
            n += 4;
        }
        return n;
    }

    private int eH_() {
        int n = 25 + (this.hasSubject() ? StringUtil.lengthUTF(this.getSubject()) : 0) + (this.isGuarenteedInternal() ? 8 : 0) + (this.getSidebandData() == null ? 4 : this.MC_.mD_().getSerializedLength() * 2 + 4 + 4) + 4 + this.MC_.wD_() + 4 + this.MC_.vD_() + 4 + (this.MC_.uC_() == null ? 0 : this.MC_.uC_().length) + 1 + (this.MC_.OE_().getRouting() == null ? 0 : StringUtil.lengthUTF(this.MC_.OE_().getAllRoutingString()) + 1);
        return n;
    }

    private int fH_() {
        int n = this.MC_.length();
        if (this.isSecure()) {
            n += this.getMessagePad();
        }
        return n;
    }

    public synchronized void serialize(OutputStream outputStream, boolean bl) throws IOException {
        byte by = this.getType();
        this.hH_();
        this.iH_();
        this.sync();
        outputStream.write(26);
        StreamUtil.writeBoolean(this.isSecure(), outputStream);
        StreamUtil.writeBoolean(this.MC_.isEncrypted(), outputStream);
        StreamUtil.writeBoolean(this.isEnqueuedSizeSet(), outputStream);
        if (this.isEnqueuedSizeSet()) {
            StreamUtil.writeInt(this.WH_, outputStream);
        }
        int n = 0;
        if (this.isSecure()) {
            n = this.getMessagePad();
            StreamUtil.writeInt(n, outputStream);
        }
        this.writeStaticHeaderToStream(outputStream, bl);
        this.LC_.OK_(outputStream, null);
        if (this.MC_.isEncrypted()) {
            int n2;
            byte[] byArray;
            ISidebandData iSidebandData;
            StreamUtil.writeLong(this.getSenderID(), outputStream);
            StreamUtil.writeLong(this.getSequenceNumber(), outputStream);
            StreamUtil.writeInt(this.getReplyToAddressFormat(), outputStream);
            StreamUtil.writeInt(this.getReplyPriority(), outputStream);
            StreamUtil.writeBoolean(this.hasSubject(), outputStream);
            if (this.hasSubject()) {
                StreamUtil.writeUTF(this.getSubject(), outputStream);
            }
            if (this.isGuarenteedInternal()) {
                StreamUtil.writeLong(this.MC_.getGuarenteedTrackingNum(), outputStream);
            }
            if ((iSidebandData = this.MC_.mD_()) != null) {
                byArray = iSidebandData.getNewByteArray();
                n2 = ArrayUtil.readInt(byArray, 0);
                StreamUtil.writeInt(n2, outputStream);
                outputStream.write(byArray, 0, n2);
                byArray = this.MC_.aD_();
                int n3 = this.MC_.mD_().getSerializedLength();
                StreamUtil.writeInt(n3, outputStream);
                outputStream.write(byArray, 0, n3);
            } else {
                StreamUtil.writeInt(-1, outputStream);
            }
            byArray = this.MC_.PD_();
            StreamUtil.writeInt(this.MC_.wD_(), outputStream);
            outputStream.write(byArray);
            if (this.MC_.tD_()) {
                byArray = this.MC_.bD_();
                StreamUtil.writeInt(this.MC_.vD_(), outputStream);
                outputStream.write(byArray);
            } else {
                StreamUtil.writeInt(0, outputStream);
            }
            if (n > 0) {
                outputStream.write(this.MC_.uC_(), 0, n);
            }
            n2 = this.MC_.RE_();
            StreamUtil.writeInt(this.MC_.RE_(), outputStream);
            if ((n2 & 1) > 0) {
                StreamUtil.writeUTF(this.getRoutingHandle().getAllRoutingString(), outputStream);
            }
            if (this.isTransactionalPublish()) {
                StreamUtil.writeInt(this.getTxnPublishTid(), outputStream);
                StreamUtil.writeInt(this.getTxnPublishTidSeqNo(), outputStream);
            }
            return;
        }
        this.MC_.writeToStream(outputStream);
        if (this.isTransactionalPublish()) {
            StreamUtil.writeInt(this.getTxnPublishTid(), outputStream);
            StreamUtil.writeInt(this.getTxnPublishTidSeqNo(), outputStream);
        }
    }

    public static IMgram unserialize(InputStream inputStream, boolean bl) throws IOException {
        Mgram mgram = new Mgram(false);
        try {
            boolean bl2 = StreamUtil.readBoolean(inputStream);
            boolean bl3 = StreamUtil.readBoolean(inputStream);
            boolean bl4 = StreamUtil.readBoolean(inputStream);
            if (bl4) {
                mgram.setEnqueuedSize(StreamUtil.readInt(inputStream));
            }
            int n = 0;
            if (bl2) {
                n = StreamUtil.readInt(inputStream);
            }
            DynamicHeader dynamicHeader = new DefaultDynamicHeader(mgram);
            if (bl2) {
                dynamicHeader = dynamicHeader.SK_(null);
                dynamicHeader.NK_(n);
            }
            mgram.setDynamicHeader(dynamicHeader);
            mgram.SH_(inputStream, null, bl);
            dynamicHeader.GK_(inputStream);
            byte by = mgram.getType();
            Payload payload = null;
            switch (by) {
                case 3: 
                case 14: {
                    payload = new AckPayload(mgram);
                    break;
                }
                case 27: {
                    payload = new BatchPayload(mgram);
                    break;
                }
                case 28: {
                    payload = new AckListPayload(mgram);
                    break;
                }
                default: {
                    payload = new DefaultPayload(mgram);
                }
            }
            mgram.setPayload(payload);
            if (bl3) {
                boolean bl5;
                int n2;
                byte[] byArray;
                int n3;
                DefaultPayload defaultPayload = (DefaultPayload)payload;
                mgram.setSenderID(StreamUtil.readLong(inputStream));
                mgram.setSequenceNumber(StreamUtil.readLong(inputStream));
                mgram.setReplyToAddressFormat(StreamUtil.readInt(inputStream));
                mgram.setReplyPriority(StreamUtil.readInt(inputStream));
                boolean bl6 = StreamUtil.readBoolean(inputStream);
                if (bl6) {
                    mgram.setSubject(StreamUtil.readUTF(inputStream));
                }
                if (mgram.isGuarenteedInternal()) {
                    mgram.setGuarenteed(StreamUtil.readLong(inputStream));
                }
                if ((n3 = StreamUtil.readInt(inputStream)) != -1) {
                    byArray = new byte[n3];
                    StreamUtil.readBytes(inputStream, byArray, 0, n3);
                    SidebandData sidebandData = new SidebandData();
                    sidebandData.fromByteArray(byArray, 0);
                    mgram.setSidebandData(sidebandData);
                    n3 = StreamUtil.readInt(inputStream);
                    byArray = new byte[n3];
                    StreamUtil.readBytes(inputStream, byArray, 0, n3);
                    defaultPayload.sC_(byArray);
                }
                n3 = StreamUtil.readInt(inputStream);
                byArray = new byte[n3];
                StreamUtil.readBytes(inputStream, byArray, 0, n3);
                defaultPayload.rC_(byArray);
                n3 = StreamUtil.readInt(inputStream);
                byte[] byArray2 = null;
                if (n3 > 0) {
                    byArray2 = new byte[n3];
                    StreamUtil.readBytes(inputStream, byArray2, 0, n3);
                }
                payload.uD_(byArray2, n3);
                if (n > 0) {
                    byte[] byArray3 = new byte[n];
                    StreamUtil.readBytes(inputStream, byArray3, 0, n);
                    defaultPayload.tC_(byArray3);
                }
                boolean bl7 = ((n2 = StreamUtil.readInt(inputStream)) & 1) > 0;
                boolean bl8 = bl5 = (n2 & 2) > 0;
                if (bl7) {
                    defaultPayload.setRouting(StreamUtil.readUTF(inputStream));
                }
                defaultPayload.setGSAPublication(bl5);
                defaultPayload.JD_();
                defaultPayload.ID_();
                mgram.setStatus(3);
            } else {
                payload.FF_(inputStream);
            }
            if (mgram.isTransactionalPublish()) {
                mgram.setTxnPublish(StreamUtil.readInt(inputStream), StreamUtil.readInt(inputStream));
            }
            mgram.bH_(false);
        }
        catch (EMgramVersionMismatch eMgramVersionMismatch) {
            eMgramVersionMismatch.printStackTrace();
        }
        catch (EMgramFormatError eMgramFormatError) {
            eMgramFormatError.printStackTrace();
        }
        return mgram;
    }

    public synchronized byte[] toByteArray() {
        this.hH_();
        this.iH_();
        byte[] byArray = this.KC_;
        byte[] byArray2 = this.LC_.toByteArray();
        byte[] byArray3 = this.MC_.toByteArray();
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = byArray3.length;
        int n4 = n + n2 + n3;
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray, 0, byArray4, 0, n);
        System.arraycopy(byArray2, 0, byArray4, n, n2);
        System.arraycopy(byArray3, 0, byArray4, n + n2, n3);
        return byArray4;
    }

    public byte getVersion() {
        return StaticHeader.Vx_(this.KC_);
    }

    public byte getSessionVersion() {
        return this.RH_;
    }

    public void setPostV22() {
        StaticHeader.jw_(true, this.KC_);
    }

    public Object getLogEvent() {
        return this.JH_;
    }

    public void setLogEvent(Object object) {
        this.JH_ = object;
    }

    public boolean isFromLog() {
        return this.JH_ != null;
    }

    synchronized void gH_(byte by) {
        this.PH_();
        StaticHeader.Wx_(by, this.KC_);
    }

    public void setStatus(int n) {
        this.IC_ = n;
    }

    public int getStatus() {
        return this.IC_;
    }

    public void setDynamicHeaderCache(byte[] byArray) {
        this.EH_ = byArray;
        this.LC_ = null;
    }

    public void setPayloadCache(byte[] byArray) {
        this.FH_ = byArray;
        this.MC_ = null;
    }

    synchronized void hH_() {
        if (this.LC_ == null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.EH_);
            if (this.isSecure()) {
                throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
            }
            this.LC_ = new DefaultDynamicHeader(this);
            try {
                this.LC_.GK_(byteArrayInputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.LC_.RK_();
            this.EH_ = null;
        }
    }

    synchronized void iH_() {
        if (this.MC_ == null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.FH_);
            this.MC_ = this.UH_(this.getType());
            try {
                this.MC_.FF_(byteArrayInputStream);
            }
            catch (EMgramFormatError eMgramFormatError) {
                eMgramFormatError.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.MC_.I_();
            this.FH_ = null;
        }
    }

    public boolean isFromRemoteBroker() {
        return this.aH_;
    }

    public void setFromRemoteBroker(boolean bl) {
        this.aH_ = bl;
    }

    public synchronized void clearTransactionPublish() {
        this.PH_();
        StaticHeader.Bx_(false, this.KC_);
    }

    public boolean isTransactionalPublish() {
        return StaticHeader.Cx_(this.KC_);
    }

    public boolean isTxnPublishFromLog() {
        return this.OH_;
    }

    public void setTxnPublishFromLog(boolean bl) {
        this.OH_ = bl;
    }

    public synchronized void placeMessageKey(IMessageProtection iMessageProtection, byte[] byArray) {
        ProgressSecureRandom.theSecureRandom().nextBytes(byArray);
        byte[] byArray2 = new byte[iMessageProtection.getSecretKeyLength()];
        System.arraycopy(byArray, 0, byArray2, 0, iMessageProtection.getSecretKeyLength());
        this.setMessageKey(byArray2);
    }

    public synchronized void macHeaderWithMessageKey(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.jH_(iMessageProtection);
        if (this.supportsOperationHandle()) {
            this.getOperationHandle().macMgramListHeadersWithMessageKey(iMessageProtection);
        }
    }

    synchronized void jH_(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.hH_();
        int n = iMessageProtection.getHashSize();
        byte[] byArray = this.KC_;
        byte[] byArray2 = this.LC_.getMessageKey();
        byte[] byArray3 = this.macByteArray(byArray, 8, byArray2, byArray2.length, iMessageProtection);
        this.LC_.setMessageDigest(byArray3);
    }

    public synchronized byte[] macByteArray(byte[] byArray, int n, byte[] byArray2, int n2, IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        int n3 = iMessageProtection.getHashSize();
        byte[] byArray3 = new byte[n3];
        iMessageProtection.mac(byArray2, 0, n2, byArray, 0, n, byArray3, 0, n3);
        return byArray3;
    }

    public boolean isTxnEOFMarker() {
        return this.getType() == -2;
    }

    public boolean isTxnSavePointMarker() {
        return this.getType() == -3;
    }

    public synchronized boolean isEncrypted() {
        this.iH_();
        return this.MC_.isEncrypted();
    }

    public synchronized void encryptMessageKey(byte[] byArray, IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        System.arraycopy(this.getMessageKey(), 0, byArray, 0, this.getMessageKey().length);
        iMessageProtection.encryptWithSessionKey(byArray, 0, this.getMessageKey().length, byArray, 0);
    }

    public synchronized void encryptMessageWithMessageKey(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.iH_();
        this.MC_.encryptMessageWithMessageKey(iMessageProtection);
    }

    public synchronized void decryptMessageWithMessageKey(IMessageProtection iMessageProtection) throws ESecurityGeneralException {
        this.iH_();
        this.MC_.BE_(iMessageProtection);
    }

    public void setNextInTxn(IMgram iMgram) {
        this.UH_ = iMgram;
    }

    public IMgram getNextInTxn() {
        return this.UH_;
    }

    public synchronized void setEnqueuedSize(int n) {
        this.VH_ = true;
        this.WH_ = n;
    }

    public synchronized void setTrackedSize(int n) {
        this.iJ_ = true;
        this.jJ_ = n;
    }

    public synchronized int getTrackedSize() {
        if (this.iJ_) {
            return this.jJ_;
        }
        return this.serializedLength();
    }

    public synchronized boolean isTrackedSizeSet() {
        return this.iJ_;
    }

    public boolean isDbTrackingSet() {
        return this.isGuarenteed() || this.kJ_;
    }

    public long getDbTracking() {
        if (!this.isDbTrackingSet()) {
            throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
        }
        return this.isGuarenteed() ? this.getGuarenteedTrackingNum() : this.lJ_;
    }

    public void setDbTracking(long l) {
        this.lJ_ = l;
        this.kJ_ = true;
    }

    public boolean isGuarFormatIncorrect() {
        return this.mJ_;
    }

    public void setGuarFormatIncorrect(boolean bl) {
        this.mJ_ = bl;
    }

    public IMgram correctGuarFormat(IMessageProtection iMessageProtection, IMessageProtection iMessageProtection2, boolean bl) throws ESecurityGeneralException {
        IMgram iMgram = null;
        if (bl) {
            try {
                iMgram = (IMgram)this.protectedClone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        } else {
            iMgram = this;
        }
        if (iMgram.isSecure() && SecurityLogic.isMKeyEncryption(iMgram.getSecurity())) {
            iMgram.getBrokerHandle().decryptMessageWithMessageKey(iMessageProtection2);
        }
        iMgram.getBrokerHandle().setGuarFormatIncorrect(false);
        if (!iMgram.isGuarenteed()) {
            iMgram.setGuarenteed(iMgram.getBrokerHandle().getDbTracking());
        } else {
            iMgram.setReliable();
        }
        if (iMgram.isSecure()) {
            if (SecurityLogic.isMKeyDigest(iMgram.getSecurity())) {
                iMgram.getBrokerHandle().macMessageWithMessageKey(iMessageProtection);
                if (SecurityLogic.isMKeyEncryption(iMgram.getSecurity())) {
                    iMgram.getBrokerHandle().encryptMessageWithMessageKey(iMessageProtection);
                }
            } else if (SecurityLogic.isMKeyMacHeader(iMgram.getSecurity())) {
                iMgram.getBrokerHandle().macHeaderWithMessageKey(iMessageProtection);
            }
        }
        return iMgram;
    }

    public boolean isEnqueuedSizeSet() {
        return this.VH_;
    }

    public synchronized void removeEnqueuedSize() {
        this.VH_ = false;
    }

    public synchronized int getEnqueuedSize() {
        if (this.VH_) {
            return this.WH_;
        }
        return this.memoryLength();
    }

    public synchronized void markLimiterSize() {
        if (this.nJ_ == -1) {
            this.nJ_ = this.memoryLength();
        }
    }

    public int getLimiterSize() {
        if (this.nJ_ == -1) {
            this.markLimiterSize();
        }
        return this.nJ_;
    }

    public synchronized void acknowledgeAndForward(IMessageProtection iMessageProtection, IMgram iMgram) {
        this.setType((byte)12);
        this.getRoutingHandle().setGSAPublication(false);
        this.setPriority(iMgram.getPriority());
        this.setJMSPersistent(iMgram.isJMSPersistent());
        if (iMgram.isTTE()) {
            this.setTTE(iMgram.getTTE());
        }
        if (this.isSecure()) {
            this.setSecurityAttribute(iMgram.getSecurity());
        }
        this.setSubject(iMgram.getSubject());
        this.setDestinationAddress(iMgram.getDestinationAddress());
        this.getRoutingHandle().setRouting(iMgram.getRoutingHandle().getRouting());
    }

    public boolean contains(Object object) {
        if (object instanceof Mgram) {
            Mgram mgram = (Mgram)object;
            if (mgram.equals(this)) {
                return true;
            }
            this.iH_();
            if (this.MC_.contains(mgram)) {
                return true;
            }
        }
        return false;
    }

    public synchronized void acknowledgeAndForward(IMgram iMgram) {
        this.setLogEvent(null);
        this.setSenderID(iMgram.getBrokerHandle().getSenderID());
        this.setGuarenteed(iMgram.getGuarenteedTrackingNum());
    }

    public static Mgram createMgram(InputStream inputStream, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, boolean bl) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(inputStream, iSecureInputStream, iMessageProtection, clientSecurityContext, null, null, bl);
    }

    public static Mgram createMgram(byte by, InputStream inputStream, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, boolean bl) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(by, inputStream, iSecureInputStream, iMessageProtection, clientSecurityContext, null, null, bl);
    }

    public static Mgram createMgram(byte by, InputStream inputStream, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, StreamUtilCounter streamUtilCounter, boolean bl) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(by, inputStream, iSecureInputStream, iMessageProtection, clientSecurityContext, null, streamUtilCounter, bl);
    }

    public static Mgram createMgram(InputStream inputStream, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, IMgramStatusListener iMgramStatusListener, StreamUtilCounter streamUtilCounter, boolean bl) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.OH_(iMgramStatusListener);
        mgram.initMgramFromStream(inputStream, iSecureInputStream, iMessageProtection, clientSecurityContext, bl, streamUtilCounter);
        return mgram;
    }

    public static Mgram createMgram(byte by, InputStream inputStream, ISecureInputStream iSecureInputStream, IMessageProtection iMessageProtection, ClientSecurityContext clientSecurityContext, IMgramStatusListener iMgramStatusListener, StreamUtilCounter streamUtilCounter, boolean bl) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.OH_(iMgramStatusListener);
        mgram.initMgramFromStream(by, inputStream, iSecureInputStream, iMessageProtection, clientSecurityContext, bl, streamUtilCounter);
        return mgram;
    }

    public static Mgram createMgramNonSecure(InputStream inputStream, IMgramStatusListener iMgramStatusListener, StreamUtilCounter streamUtilCounter, boolean bl) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.OH_(iMgramStatusListener);
        mgram.initMgramFromStream(inputStream, null, null, null, bl, streamUtilCounter);
        return mgram;
    }

    public static Mgram createMgramNonSecure(byte by, InputStream inputStream, IMgramStatusListener iMgramStatusListener, StreamUtilCounter streamUtilCounter, boolean bl) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.OH_(iMgramStatusListener);
        mgram.initMgramFromStream(by, inputStream, null, null, null, bl, streamUtilCounter);
        return mgram;
    }

    public void dump() {
        PrintStream printStream = SessionConfig.getLog();
        try {
            PrintStream printStream2 = printStream;
            synchronized (printStream2) {
                printStream.println("==========");
                printStream.println("Mgram Dump");
                printStream.println("==========");
                StaticHeader.Xx_(this.KC_);
                if (this.getType() != 4) {
                    this.hH_();
                    this.LC_.EK_();
                    this.iH_();
                    this.MC_.dump();
                    if (this.SH_) {
                        printStream.println("TTE value is TTL");
                    } else {
                        printStream.println("TTE value is TTE");
                    }
                }
                printStream.println("==========");
            }
        }
        catch (Throwable throwable) {
            printStream.println("Error dumping mgram: " + throwable.toString());
        }
    }

    public synchronized ObjectInput getPayloadInputStreamHandle() {
        this.iH_();
        return this.MC_.getPayloadInputStreamHandle();
    }

    public synchronized ObjectOutput getPayloadOutputStreamHandle() {
        this.iH_();
        return this.MC_.getPayloadOutputStreamHandle();
    }

    public final synchronized IOperationHandle getOperationHandle() {
        this.kH_();
        this.iH_();
        return this.MC_.ME_();
    }

    public final synchronized IBatchHandle getBatchHandle() {
        this.iH_();
        return this.MC_.getBatchHandle();
    }

    void kH_() {
        if (this.getType() != 25 && this.getType() != 27) {
            throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
        }
    }

    public IJMSClientHandle getJMSClientHandle() {
        return this;
    }

    public ISaverOpHandle getSaverOpHandle() {
        this.iH_();
        return this.MC_.getSaverOpHandle();
    }

    public boolean isJMSAsynchronous() {
        return this.eH_;
    }

    public void setJMSAsynchronous(boolean bl) {
        this.eH_ = bl;
    }

    public void setPerMsgEncrypted(boolean bl) {
        this.gJ_ = bl;
    }

    public boolean isPerMsgEncrypted() {
        return this.gJ_;
    }

    public void setConnection(Connection connection) {
        this.hJ_ = connection;
    }

    public Connection getConnection() {
        return this.hJ_;
    }

    static Class lH_(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

