/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramConverterHandle$IDynamicHeader;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.MgramConstants;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.MgramConverter25;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.SecurityLogic;

public class MgramConverter24
extends DebugObject
implements IMgramConverter {
    private IMgramConverter nt_;
    private MgramConverter25 ITB_;
    private progress.message.msg.v25.MgramConverter24 JTB_;
    private ClientSecurityContext ED_;
    private ISecureInputStream CD_;
    private ISecureOutputStream DD_;
    private boolean Ie_;
    private IMessageProtection FD_;
    private IMgramStatusListener JC_;
    private boolean du_;
    private byte[] ID_;
    private IMessageProtection hMB_;

    public MgramConverter24() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        super(DebugState.GLOBAL_DEBUG_ON ? "MgramConverter24" : null);
        Class<?> clazz = Class.forName("progress.message.msg.v24.MgramCreator");
        this.nt_ = (IMgramConverter)clazz.newInstance();
        this.ITB_ = new MgramConverter25();
        this.JTB_ = new progress.message.msg.v25.MgramConverter24();
    }

    public IMgram createMgram(InputStream inputStream) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        progress.message.msg.v25.Mgram mgram = (progress.message.msg.v25.Mgram)this.JTB_.createMgram(inputStream);
        Mgram mgram2 = new Mgram(false);
        byte[] byArray = this.ITB_.SWB_(mgram.getMgramConverterHandle().getInternalStaticHeader());
        mgram2.setStaticHeader(byArray);
        DynamicHeader dynamicHeader = this.ITB_.IWB_(mgram.isSecure(), this.FD_, mgram.getMgramConverterHandle().getInternalDynamicHeader(), null, null, mgram2);
        mgram2.setDynamicHeader(dynamicHeader);
        this.ITB_.FWB_((IMgram)mgram, mgram2);
        return mgram2;
    }

    public IMgram createMgram(byte by, InputStream inputStream) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return null;
    }

    private void TWB_(IMgram iMgram, int n, OutputStream outputStream) throws IOException {
        if (iMgram.getVersion() != 24) {
            progress.message.msg.v25.Mgram mgram = new progress.message.msg.v25.Mgram(false);
            byte[] byArray = this.ITB_.RWB_(iMgram, n);
            mgram.setStaticHeader(byArray);
            IMgramConverterHandle$IDynamicHeader iMgramConverterHandle$IDynamicHeader = iMgram.getMgramConverterHandle().getInternalDynamicHeader();
            boolean bl = iMgram.isSecure();
            if (bl) {
                iMgram.getMgramConverterHandle().recalculatePad(this.FD_);
            }
            mgram.setDynamicHeader(this.ITB_.HWB_(bl, this.FD_, iMgramConverterHandle$IDynamicHeader, null, null, mgram));
            this.ITB_.GWB_(mgram, iMgram);
            this.WWB_(mgram);
            this.JTB_.writeMgramToNetworkStream((IMgram)mgram, n, outputStream);
        } else {
            iMgram.writeMgramToStream(outputStream, this.ED_, this.DD_, this.FD_, this.Ie_);
        }
    }

    public void writeMgramToStreamNonSecure(OutputStream outputStream, IMgram iMgram, boolean bl) throws IOException {
    }

    private void UWB_(IMgram iMgram, int n, OutputStream outputStream) throws IOException {
        if (SecurityLogic.isMKeyEncryption(iMgram.getSecurity()) || iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
            try {
                iMgram = (IMgram)iMgram.protectedClone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        if (SecurityLogic.isMKeyEncryption(iMgram.getSecurity())) {
            iMgram.getBrokerHandle().decryptMessageWithMessageKey(this.hMB_);
        }
        if (iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
            iMgram.getBrokerHandle().setGuarFormatIncorrect(false);
            if (!iMgram.isGuarenteed()) {
                iMgram.setGuarenteed(iMgram.getBrokerHandle().getDbTracking());
            } else {
                iMgram.setReliable();
            }
        }
        progress.message.msg.v25.Mgram mgram = new progress.message.msg.v25.Mgram(false);
        byte[] byArray = this.ITB_.RWB_(iMgram, n);
        mgram.setStaticHeader(byArray);
        IMgramConverterHandle$IDynamicHeader iMgramConverterHandle$IDynamicHeader = iMgram.getMgramConverterHandle().getInternalDynamicHeader();
        progress.message.msg.v25.DynamicHeader dynamicHeader = this.ITB_.HWB_(true, this.FD_, iMgramConverterHandle$IDynamicHeader, null, null, mgram);
        mgram.setDynamicHeader(dynamicHeader);
        this.ITB_.GWB_(mgram, iMgram);
        this.WWB_(mgram);
        IMgramConverterHandle iMgramConverterHandle = mgram.getMgramConverterHandle();
        if (SecurityLogic.isMKeyDigest(mgram.getSecurity())) {
            mgram.getBrokerHandle().macMessageWithMessageKey(this.FD_);
            if (SecurityLogic.isMKeyEncryption(mgram.getSecurity())) {
                mgram.getBrokerHandle().encryptMessageWithMessageKey(this.FD_);
            }
        }
        this.JTB_.messageKeySlicedDelivery((IMgram)mgram, n, outputStream);
    }

    private void VWB_(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream) throws IOException {
        progress.message.msg.v25.Mgram mgram = new progress.message.msg.v25.Mgram(false);
        byte[] byArray = this.ITB_.RWB_(iMgram, n);
        mgram.setStaticHeader(byArray);
        IMgramConverterHandle$IDynamicHeader iMgramConverterHandle$IDynamicHeader = iMgram.getMgramConverterHandle().getInternalDynamicHeader();
        progress.message.msg.v25.DynamicHeader dynamicHeader = this.ITB_.HWB_(true, this.FD_, iMgramConverterHandle$IDynamicHeader, null, null, mgram);
        mgram.setDynamicHeader(dynamicHeader);
        this.ITB_.GWB_(mgram, iMgram);
        this.WWB_(mgram);
        this.JTB_.sessionKeySlicedDelivery((IMgram)mgram, n, clientSecurityContext, outputStream);
    }

    public void secureDeliver(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream) throws IOException {
        this.XWB_(iMgram);
        if (iMgram.getType() == 27) {
            Iterator iterator = iMgram.getBatchHandle().getBatchIterator();
            while (iterator.hasNext()) {
                this.secureDeliver((IMgram)iterator.next(), n, clientSecurityContext, outputStream);
            }
        } else if (iMgram.isSecure() && (SecurityLogic.isMKeyMacHeader(iMgram.getSecurity()) || SecurityLogic.isMKeyDigest(iMgram.getSecurity()))) {
            this.UWB_(iMgram, n, outputStream);
        } else if (iMgram.isSecure() && (SecurityLogic.isSKeyDigest(iMgram.getSecurity()) || SecurityLogic.isSKeyEncryption(iMgram.getSecurity()))) {
            if (iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
                iMgram = iMgram.getBrokerHandle().correctGuarFormat(this.FD_, this.hMB_, true);
            }
            this.VWB_(iMgram, n, clientSecurityContext, outputStream);
        } else {
            if (iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
                iMgram = iMgram.getBrokerHandle().correctGuarFormat(this.FD_, this.hMB_, true);
            }
            this.TWB_(iMgram, n, outputStream);
        }
    }

    public void deliver(IMgram iMgram, OutputStream outputStream) throws IOException {
        this.deliver(iMgram, -1, outputStream);
    }

    public void deliver(IMgram iMgram, int n, OutputStream outputStream) throws IOException {
        this.XWB_(iMgram);
        if (iMgram.getType() == 27) {
            Iterator iterator = iMgram.getBatchHandle().getBatchIterator();
            while (iterator.hasNext()) {
                this.deliver((IMgram)iterator.next(), n, outputStream);
            }
        } else {
            if (iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
                iMgram = iMgram.getBrokerHandle().correctGuarFormat(this.FD_, this.hMB_, true);
            }
            this.TWB_(iMgram, n, outputStream);
        }
    }

    public IMgram unserialize(InputStream inputStream, boolean bl) throws IOException {
        return this.unserialize(inputStream);
    }

    public IMgram unserialize(InputStream inputStream) throws IOException {
        progress.message.msg.v25.Mgram mgram = (progress.message.msg.v25.Mgram)this.JTB_.unserialize(inputStream);
        Mgram mgram2 = new Mgram(false);
        boolean bl = mgram.isSecure();
        if (bl && SecurityLogic.isMKeyEncryption(mgram.getSecurity()) && this.du_) {
            mgram.getBrokerHandle().decryptMessageWithMessageKey(this.hMB_);
        }
        byte[] byArray = this.ITB_.SWB_(mgram.getMgramConverterHandle().getInternalStaticHeader());
        mgram2.setStaticHeader(byArray);
        DynamicHeader dynamicHeader = this.ITB_.IWB_(mgram.isSecure(), this.FD_, mgram.getMgramConverterHandle().getInternalDynamicHeader(), null, null, mgram2);
        mgram2.setDynamicHeader(dynamicHeader);
        this.ITB_.FWB_((IMgram)mgram, mgram2);
        mgram2.setStatus(3);
        if (bl && SecurityLogic.isMKeyDigest(mgram.getSecurity())) {
            mgram2.getBrokerHandle().macMessageWithMessageKey(this.FD_);
        }
        if (bl && SecurityLogic.isMKeyEncryption(mgram.getSecurity()) && this.du_) {
            mgram2.getBrokerHandle().encryptMessageWithMessageKey(this.FD_);
        }
        return mgram2;
    }

    public void serialize(OutputStream outputStream, IMgram iMgram, boolean bl) throws IOException {
        throw new EAssertFailure("Unable to serialize v24 mgrams to the log or database");
    }

    public void initializeConverter(Hashtable hashtable) {
        this.ED_ = (ClientSecurityContext)hashtable.get(MgramConstants.CLIENT_SECURITY_CONTEXT);
        this.CD_ = (ISecureInputStream)hashtable.get(MgramConstants.SECURE_INPUT_STREAM);
        this.DD_ = (ISecureOutputStream)hashtable.get(MgramConstants.SECURE_OUTPUT_STREAM);
        this.FD_ = (IMessageProtection)hashtable.get(MgramConstants.MESSAGE_PROTECTION);
        if (this.FD_ != null) {
            this.ID_ = new byte[this.FD_.getOutputSize(this.FD_.getSecretKeyLength())];
        }
        this.hMB_ = (IMessageProtection)hashtable.get(MgramConstants.DECRYPT_MESSAGE_PROTECTION);
        this.JC_ = (IMgramStatusListener)hashtable.get(MgramConstants.MGRAM_STATUS_LISTENER);
        Boolean bl = (Boolean)hashtable.get(MgramConstants.TTE_TTL_CONVERT);
        this.Ie_ = bl != null ? bl : false;
        Boolean bl2 = (Boolean)hashtable.get(MgramConstants.CAN_BE_ENCRYPTED);
        this.du_ = bl2 != null ? bl2 : false;
        this.nt_.initializeConverter(hashtable);
        this.JTB_.initializeConverter(hashtable);
        this.ITB_.initializeConverter(hashtable);
    }

    private void WWB_(progress.message.msg.v25.Mgram mgram) {
        if (!(mgram.getType() != 2 && mgram.getType() != 12 || mgram.hasSidebandData())) {
            mgram.createSidebandDataIfNeeded();
        }
    }

    private void XWB_(IMgram iMgram) {
        if (iMgram.getType() == 25) {
            throw new EAssertFailure("Unable to send Operation Mgram to version 24 client");
        }
    }

    public byte getVersion() {
        return 24;
    }
}

