/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramConverterHandle$IDynamicHeader;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.MgramConstants;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.DefaultDynamicHeader;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.MgramCreator;
import progress.message.msg.v26.Payload;
import progress.message.msg.v26.SecureDynamicHeader;
import progress.message.msg.v26.SidebandData;
import progress.message.msg.v26.StaticHeader;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.SecurityLogic;

public class MgramConverter25
extends DebugObject
implements IMgramConverter {
    private IMgramConverter nt_;
    private ClientSecurityContext ED_;
    private ISecureInputStream CD_;
    private ISecureOutputStream DD_;
    private boolean Ie_;
    private IMessageProtection FD_;
    private IMgramStatusListener JC_;
    private boolean du_;
    private byte[] ID_;
    private IMessageProtection hMB_;
    private StreamUtilCounter HD_ = null;

    public MgramConverter25() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        super(DebugState.GLOBAL_DEBUG_ON ? "MgramConverter25" : null);
        Class<?> clazz = Class.forName("progress.message.msg.v25.MgramCreator");
        this.nt_ = (IMgramConverter)clazz.newInstance();
    }

    public IMgram createMgram(InputStream inputStream) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Object object;
        if (this.HD_ != null) {
            this.HD_.resetCounter();
        }
        Mgram mgram = new Mgram(false);
        progress.message.msg.v25.Mgram mgram2 = progress.message.msg.v25.Mgram.createMgram((InputStream)inputStream, (ISecureInputStream)this.CD_, (IMessageProtection)this.FD_, (ClientSecurityContext)this.ED_, (IMgramStatusListener)this.JC_, (StreamUtilCounter)this.HD_, (boolean)this.Ie_);
        if (mgram2.supportsOperationHandle()) {
            int n = StreamUtil.readInt(inputStream);
            int n2 = 0;
            while (n2 < n) {
                object = this.createMgram(inputStream);
                mgram2.getOperationHandle().addMgram((IMgram)object);
                ++n2;
            }
        }
        byte[] byArray = mgram2.getMgramConverterHandle().getInternalStaticHeader();
        byte[] byArray2 = this.SWB_(byArray);
        mgram.setStaticHeader(byArray2);
        if (this.Ie_) {
            mgram.getTTE();
        }
        if (StaticHeader.Px_(byArray2) != 4) {
            object = this.IWB_(mgram2.isSecure(), this.FD_, mgram2.getMgramConverterHandle().getInternalDynamicHeader(), null, null, mgram);
            mgram.setDynamicHeader((DynamicHeader)object);
            this.FWB_((IMgram)mgram2, mgram);
        } else if (StaticHeader.ow_(byArray2)) {
            mgram.setSessionVer(StreamUtil.readByte(inputStream));
        }
        return mgram;
    }

    void FWB_(IMgram iMgram, Mgram mgram) throws IOException {
        HashMap hashMap = iMgram.getMgramConverterHandle().getInternalPayload().getPayloadProperties();
        Payload payload = MgramCreator.getPayloadObject(iMgram.getType(), mgram);
        mgram.setPayload(payload);
        if (payload != null) {
            progress.message.msg.v25.SidebandData sidebandData;
            mgram.getMgramConverterHandle().getInternalPayload().setPayloadProperties(hashMap);
            payload.initRemainingPayload();
            payload.KF_();
            if ((iMgram.getType() == 2 || iMgram.getType() == 12 || iMgram.getType() == 25) && (sidebandData = (progress.message.msg.v25.SidebandData)iMgram.getSidebandData()) != null) {
                String string = sidebandData.getAllRoutingString();
                SidebandData sidebandData2 = this.JWB_(sidebandData);
                mgram.setSidebandData(sidebandData2);
                mgram.getRoutingHandle().setGSAPublication(sidebandData.isGSAPublication());
                mgram.getRoutingHandle().setRouting(string);
            }
        }
    }

    progress.message.msg.v25.Payload GWB_(progress.message.msg.v25.Mgram mgram, IMgram iMgram) {
        HashMap hashMap = iMgram.getMgramConverterHandle().getInternalPayload().getPayloadProperties();
        progress.message.msg.v25.Payload payload = progress.message.msg.v25.MgramCreator.getPayloadObject((byte)iMgram.getType(), (progress.message.msg.v25.Mgram)mgram);
        mgram.setPayload(payload);
        if (payload != null) {
            ISidebandData iSidebandData;
            mgram.getMgramConverterHandle().getInternalPayload().setPayloadProperties(hashMap);
            if ((mgram.getType() == 2 || mgram.getType() == 12 || mgram.getType() == 25) && (iSidebandData = iMgram.getSidebandData()) != null) {
                progress.message.msg.v25.SidebandData sidebandData = this.KWB_(iSidebandData);
                sidebandData.setRouting(iMgram.getRoutingHandle().getAllRoutingString());
                sidebandData.setGSAPublication(iMgram.getRoutingHandle().isGSAPublication());
                mgram.setSidebandData((ISidebandData)sidebandData);
            }
        }
        return payload;
    }

    progress.message.msg.v25.DynamicHeader HWB_(boolean bl, IMessageProtection iMessageProtection, IMgramConverterHandle$IDynamicHeader iMgramConverterHandle$IDynamicHeader, byte[] byArray, byte[] byArray2, progress.message.msg.v25.Mgram mgram) throws IOException {
        progress.message.msg.v25.DefaultDynamicHeader defaultDynamicHeader = new progress.message.msg.v25.DefaultDynamicHeader(mgram);
        defaultDynamicHeader.setMessageLength(iMgramConverterHandle$IDynamicHeader.getMessageLength());
        if (bl) {
            defaultDynamicHeader = new progress.message.msg.v25.SecureDynamicHeader(iMessageProtection, (progress.message.msg.v25.DynamicHeader)defaultDynamicHeader);
            if (byArray2 != null) {
                defaultDynamicHeader.setMessageDigest(byArray2);
            } else {
                defaultDynamicHeader.setMessageDigest(iMgramConverterHandle$IDynamicHeader.getDigest());
            }
            if (byArray != null) {
                defaultDynamicHeader.setMessageKey(byArray);
            } else {
                defaultDynamicHeader.setMessageKey(iMgramConverterHandle$IDynamicHeader.getMessageKey());
            }
            defaultDynamicHeader.setMessagePad(iMgramConverterHandle$IDynamicHeader.getMessagePad());
            defaultDynamicHeader.setSecurityAttributeByte(iMgramConverterHandle$IDynamicHeader.getSecurity());
        }
        return defaultDynamicHeader;
    }

    DynamicHeader IWB_(boolean bl, IMessageProtection iMessageProtection, IMgramConverterHandle$IDynamicHeader iMgramConverterHandle$IDynamicHeader, byte[] byArray, byte[] byArray2, Mgram mgram) throws IOException {
        DynamicHeader dynamicHeader = new DefaultDynamicHeader(mgram);
        dynamicHeader.setMessageLength(iMgramConverterHandle$IDynamicHeader.getMessageLength());
        if (bl) {
            dynamicHeader = new SecureDynamicHeader(iMessageProtection, dynamicHeader);
            if (byArray2 != null) {
                dynamicHeader.setMessageDigest(byArray2);
            } else {
                dynamicHeader.setMessageDigest(iMgramConverterHandle$IDynamicHeader.getDigest());
            }
            if (byArray != null) {
                dynamicHeader.setMessageKey(byArray);
            } else {
                dynamicHeader.setMessageKey(iMgramConverterHandle$IDynamicHeader.getMessageKey());
            }
            dynamicHeader.NK_(iMgramConverterHandle$IDynamicHeader.getMessagePad());
            dynamicHeader.MK_(iMgramConverterHandle$IDynamicHeader.getSecurity());
        }
        return dynamicHeader;
    }

    SidebandData JWB_(progress.message.msg.v25.SidebandData sidebandData) {
        sidebandData.setRouting(null);
        SidebandData sidebandData2 = new SidebandData();
        sidebandData2.fromByteArray(sidebandData.getRawSidebandBuffer(), 0);
        return sidebandData2;
    }

    progress.message.msg.v25.SidebandData KWB_(ISidebandData iSidebandData) {
        progress.message.msg.v25.SidebandData sidebandData = new progress.message.msg.v25.SidebandData();
        sidebandData.fromByteArray(iSidebandData.getRawSidebandBuffer(), 0);
        return sidebandData;
    }

    public IMgram createMgram(byte by, InputStream inputStream) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return null;
    }

    private void LWB_(IMgram iMgram, int n, OutputStream outputStream) throws IOException {
        if (iMgram.getVersion() != 25) {
            progress.message.msg.v25.Mgram mgram = this.MWB_(iMgram, n);
            mgram.writeMgramToStream(outputStream, this.ED_, this.DD_, this.FD_, this.Ie_);
        } else {
            iMgram.writeMgramToStream(outputStream, this.ED_, this.DD_, this.FD_, this.Ie_);
        }
    }

    private progress.message.msg.v25.Mgram MWB_(IMgram iMgram, int n) throws IOException {
        progress.message.msg.v25.Mgram mgram = new progress.message.msg.v25.Mgram(false);
        byte[] byArray = this.RWB_(iMgram, n);
        mgram.setStaticHeader(byArray);
        IMgramConverterHandle$IDynamicHeader iMgramConverterHandle$IDynamicHeader = iMgram.getMgramConverterHandle().getInternalDynamicHeader();
        boolean bl = iMgram.isSecure();
        if (bl) {
            iMgram.getMgramConverterHandle().recalculatePad(this.FD_);
        }
        mgram.setDynamicHeader(this.HWB_(bl, this.FD_, iMgramConverterHandle$IDynamicHeader, null, null, mgram));
        this.GWB_(mgram, iMgram);
        return mgram;
    }

    private void NWB_(IMgram iMgram, int n, OutputStream outputStream) throws IOException {
        if (SecurityLogic.isMKeyEncryption(iMgram.getSecurity()) || iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
            try {
                iMgram = (IMgram)iMgram.protectedClone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        if (SecurityLogic.isMKeyEncryption(iMgram.getSecurity())) {
            iMgram.getBrokerHandle().decryptMessageWithMessageKey(this.hMB_);
        }
        if (iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
            iMgram.getBrokerHandle().setGuarFormatIncorrect(false);
            if (!iMgram.isGuarenteed()) {
                iMgram.setGuarenteed(iMgram.getBrokerHandle().getDbTracking());
            } else {
                iMgram.setReliable();
            }
        }
        progress.message.msg.v25.Mgram mgram = this.MWB_(iMgram, n);
        IMgramConverterHandle iMgramConverterHandle = mgram.getMgramConverterHandle();
        if (SecurityLogic.isMKeyDigest(mgram.getSecurity())) {
            mgram.getBrokerHandle().macMessageWithMessageKey(this.FD_);
            if (SecurityLogic.isMKeyEncryption(mgram.getSecurity())) {
                mgram.getBrokerHandle().encryptMessageWithMessageKey(this.FD_);
            }
        } else if (SecurityLogic.isMKeyMacHeader(mgram.getSecurity())) {
            mgram.getBrokerHandle().macHeaderWithMessageKey(this.FD_);
        }
        mgram.getBrokerHandle().encryptMessageKey(this.ID_, this.FD_);
        iMgramConverterHandle.getInternalDynamicHeader().setMessageKey(this.ID_);
        iMgramConverterHandle.recalculatePad(this.FD_);
        mgram.writeMgramToStream(outputStream, this.ED_, this.DD_, this.FD_, this.Ie_);
        this.QWB_(iMgram, n, this.ED_, outputStream);
    }

    private void OWB_(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream) throws IOException {
        progress.message.msg.v25.Mgram mgram = this.MWB_(iMgram, n);
        IMgramConverterHandle iMgramConverterHandle = mgram.getMgramConverterHandle();
        iMgramConverterHandle.recalculatePad(this.FD_);
        byte[] byArray = null;
        if (SecurityLogic.isSKeyDigest(iMgram.getSecurity())) {
            byArray = iMgramConverterHandle.calculateMac(clientSecurityContext.getDigestKey(), this.FD_);
        }
        iMgramConverterHandle.getInternalDynamicHeader().setMessageDigest(byArray);
        mgram.writeMgramToStream(outputStream, clientSecurityContext, this.DD_, this.FD_, this.Ie_);
        this.QWB_(iMgram, n, clientSecurityContext, outputStream);
    }

    public void secureDeliver(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream) throws IOException {
        if (iMgram.getType() == 27) {
            Iterator iterator = iMgram.getBatchHandle().getBatchIterator();
            while (iterator.hasNext()) {
                this.secureDeliver((IMgram)iterator.next(), n, clientSecurityContext, outputStream);
            }
        } else if (iMgram.isSecure() && (SecurityLogic.isMKeyMacHeader(iMgram.getSecurity()) || SecurityLogic.isMKeyDigest(iMgram.getSecurity()))) {
            this.NWB_(iMgram, n, outputStream);
        } else if (iMgram.isSecure() && (SecurityLogic.isSKeyDigest(iMgram.getSecurity()) || SecurityLogic.isSKeyEncryption(iMgram.getSecurity()))) {
            if (iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
                iMgram = iMgram.getBrokerHandle().correctGuarFormat(this.FD_, this.hMB_, true);
            }
            this.OWB_(iMgram, n, clientSecurityContext, outputStream);
        } else {
            if (iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
                iMgram = iMgram.getBrokerHandle().correctGuarFormat(this.FD_, this.hMB_, true);
            }
            this.LWB_(iMgram, n, outputStream);
            this.QWB_(iMgram, n, clientSecurityContext, outputStream);
        }
    }

    public void deliver(IMgram iMgram, OutputStream outputStream) throws IOException {
        this.deliver(iMgram, -1, outputStream);
    }

    public void deliver(IMgram iMgram, int n, OutputStream outputStream) throws IOException {
        if (iMgram.getType() == 27) {
            Iterator iterator = iMgram.getBatchHandle().getBatchIterator();
            while (iterator.hasNext()) {
                this.deliver((IMgram)iterator.next(), n, outputStream);
            }
        } else {
            if (iMgram.getBrokerHandle().isGuarFormatIncorrect()) {
                iMgram = iMgram.getBrokerHandle().correctGuarFormat(this.FD_, this.hMB_, true);
            }
            this.LWB_(iMgram, n, outputStream);
            if (iMgram.supportsOperationHandle()) {
                LinkedList linkedList = iMgram.getOperationHandle().getMgramList();
                if (linkedList != null) {
                    StreamUtil.writeInt(linkedList.size(), outputStream);
                    int n2 = 0;
                    while (n2 < linkedList.size()) {
                        iMgram = (IMgram)linkedList.get(n2);
                        this.deliver(iMgram, n, outputStream);
                        ++n2;
                    }
                } else {
                    StreamUtil.writeInt(0, outputStream);
                }
            }
        }
    }

    public IMgram unserialize(InputStream inputStream, boolean bl) throws IOException {
        return this.unserialize(inputStream);
    }

    public IMgram unserialize(InputStream inputStream) throws IOException {
        IMgram iMgram = this.PWB_(inputStream);
        if (iMgram.supportsOperationHandle()) {
            int n = StreamUtil.readInt(inputStream);
            int n2 = 0;
            while (n2 < n) {
                byte by = StreamUtil.readByte(inputStream);
                IMgram iMgram2 = this.PWB_(inputStream);
                iMgram.getOperationHandle().addMgram(iMgram2);
                ++n2;
            }
        }
        return iMgram;
    }

    private IMgram PWB_(InputStream inputStream) throws IOException {
        Mgram mgram = new Mgram(false);
        IMgram iMgram = progress.message.msg.v25.Mgram.unserialize((InputStream)inputStream);
        boolean bl = false;
        boolean bl2 = iMgram.isSecure();
        if (bl2 && SecurityLogic.isMKeyEncryption(iMgram.getSecurity()) && iMgram.getBrokerHandle().isEncrypted()) {
            iMgram.getBrokerHandle().decryptMessageWithMessageKey(this.hMB_);
            bl = true;
        }
        byte[] byArray = iMgram.getMgramConverterHandle().getInternalStaticHeader();
        byte[] byArray2 = this.SWB_(byArray);
        mgram.setStaticHeader(byArray2);
        DynamicHeader dynamicHeader = this.IWB_(iMgram.isSecure(), this.FD_, iMgram.getMgramConverterHandle().getInternalDynamicHeader(), null, null, mgram);
        mgram.setDynamicHeader(dynamicHeader);
        this.FWB_(iMgram, mgram);
        mgram.setStatus(3);
        if (bl2 && SecurityLogic.isMKeyDigest(iMgram.getSecurity())) {
            mgram.getBrokerHandle().macMessageWithMessageKey(this.FD_);
        }
        if (bl) {
            mgram.getBrokerHandle().encryptMessageWithMessageKey(this.FD_);
        }
        return mgram;
    }

    public void serialize(OutputStream outputStream, IMgram iMgram, boolean bl) throws IOException {
        throw new EAssertFailure("Unable to serialize v25 mgrams to the log or database");
    }

    private void QWB_(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream) throws IOException {
        if (iMgram.supportsOperationHandle()) {
            LinkedList linkedList = iMgram.getOperationHandle().getMgramList();
            if (linkedList != null) {
                StreamUtil.writeInt(linkedList.size(), outputStream);
                int n2 = 0;
                while (n2 < linkedList.size()) {
                    iMgram = (IMgram)linkedList.get(n2);
                    this.secureDeliver(iMgram, n, clientSecurityContext, outputStream);
                    ++n2;
                }
            } else {
                StreamUtil.writeInt(0, outputStream);
            }
        }
    }

    public void writeMgramToStreamNonSecure(OutputStream outputStream, IMgram iMgram, boolean bl) throws IOException {
    }

    public void initializeConverter(Hashtable hashtable) {
        this.ED_ = (ClientSecurityContext)hashtable.get(MgramConstants.CLIENT_SECURITY_CONTEXT);
        this.CD_ = (ISecureInputStream)hashtable.get(MgramConstants.SECURE_INPUT_STREAM);
        this.DD_ = (ISecureOutputStream)hashtable.get(MgramConstants.SECURE_OUTPUT_STREAM);
        this.FD_ = (IMessageProtection)hashtable.get(MgramConstants.MESSAGE_PROTECTION);
        if (this.FD_ != null) {
            this.ID_ = new byte[this.FD_.getOutputSize(this.FD_.getSecretKeyLength())];
        }
        this.hMB_ = (IMessageProtection)hashtable.get(MgramConstants.DECRYPT_MESSAGE_PROTECTION);
        this.JC_ = (IMgramStatusListener)hashtable.get(MgramConstants.MGRAM_STATUS_LISTENER);
        Boolean bl = (Boolean)hashtable.get(MgramConstants.TTE_TTL_CONVERT);
        this.Ie_ = bl != null ? bl : false;
        Boolean bl2 = (Boolean)hashtable.get(MgramConstants.CAN_BE_ENCRYPTED);
        this.du_ = bl2 != null ? bl2 : false;
        this.HD_ = new StreamUtilCounter(true);
        this.nt_.initializeConverter(hashtable);
    }

    byte[] RWB_(IMgram iMgram, int n) {
        byte[] byArray = iMgram.getMgramConverterHandle().getInternalStaticHeader();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        progress.message.msg.v25.StaticHeader.setVersion((byte)25, (byte[])byArray2);
        if (n != -1) {
            progress.message.msg.v25.StaticHeader.setChannel((int)n, (byte[])byArray2);
        }
        return byArray2;
    }

    byte[] SWB_(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        StaticHeader.Wx_((byte)26, byArray2);
        return byArray2;
    }

    public byte getVersion() {
        return 25;
    }
}

