/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import progress.message.msg.IConnectionSyncHandle;
import progress.message.msg.IExtendedTXNRequestHandle;
import progress.message.msg.IFailoverStatusNotificationHandle;
import progress.message.msg.IIDRHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.IOperationHandle;
import progress.message.msg.ITXNRequestHandle;
import progress.message.msg.MgramConstants;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.AckListPayload;
import progress.message.msg.v26.AckPayload;
import progress.message.msg.v26.BatchPayload;
import progress.message.msg.v26.ConnectionSyncPayload;
import progress.message.msg.v26.DefaultDynamicHeader;
import progress.message.msg.v26.DefaultPayload;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.ErrorPayload;
import progress.message.msg.v26.FailoverStatusNotificationPayload;
import progress.message.msg.v26.FlowControlPayload;
import progress.message.msg.v26.IBrokerMgramCreator;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.NackPayload;
import progress.message.msg.v26.Payload;
import progress.message.msg.v26.QueueFlowControlPayload;
import progress.message.msg.v26.SidebandData;
import progress.message.msg.v26.StaticHeader;
import progress.message.msg.v26.TXNRequestPayload;
import progress.message.msg.v26.ik;
import progress.message.msg.v26.rd;
import progress.message.util.ArrayUtil;
import progress.message.util.AutoVec;
import progress.message.util.EAssertFailure;
import progress.message.util.QueueUtil;
import progress.message.util.StreamUtil;
import progress.message.xa.XidImpl;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISaverOp;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;

public class MgramCreator
extends DebugObject
implements IMgramConverter {
    private static Mgram pC_ = null;
    private static byte[] qC_;
    private static byte[] rC_;
    private static byte[] Ww_;
    private static byte[] sC_;
    private static byte[] tC_;
    private static byte[] uC_;
    private static Mgram vC_;
    private static Mgram wC_;
    private static Mgram xC_;
    private static int yC_;
    private static int zC_;
    private static int Xw_;
    private static IBrokerMgramCreator AD_;
    private byte[] BD_ = null;
    private ISecureInputStream CD_ = null;
    private ISecureOutputStream DD_ = null;
    private ClientSecurityContext ED_ = null;
    private IMessageProtection FD_ = null;
    private IMgramStatusListener JC_ = null;
    private boolean GD_ = false;
    private StreamUtilCounter HD_ = null;
    private byte[] ID_ = null;
    private boolean JD_ = false;

    public MgramCreator() {
        super("MgramCreator");
    }

    public void initializeConverter(Hashtable hashtable) {
        Boolean bl;
        this.ED_ = (ClientSecurityContext)hashtable.get(MgramConstants.CLIENT_SECURITY_CONTEXT);
        this.CD_ = (ISecureInputStream)hashtable.get(MgramConstants.SECURE_INPUT_STREAM);
        this.DD_ = (ISecureOutputStream)hashtable.get(MgramConstants.SECURE_OUTPUT_STREAM);
        this.FD_ = (IMessageProtection)hashtable.get(MgramConstants.MESSAGE_PROTECTION);
        this.JC_ = (IMgramStatusListener)hashtable.get(MgramConstants.MGRAM_STATUS_LISTENER);
        Boolean bl2 = (Boolean)hashtable.get(MgramConstants.TTE_TTL_CONVERT);
        if (bl2 != null) {
            this.GD_ = bl2;
        }
        if ((bl = (Boolean)hashtable.get(MgramConstants.IGNORE_SECURITY)) != null) {
            this.JD_ = bl;
        }
        this.HD_ = new StreamUtilCounter(true);
    }

    public IMgram createMgram(InputStream inputStream) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return this.Rt_(inputStream, false);
    }

    private IMgram Rt_(InputStream inputStream, boolean bl) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (this.HD_ != null) {
            this.HD_.resetCounter();
        }
        Mgram mgram = null;
        mgram = !bl ? Mgram.createMgram(inputStream, this.CD_, this.FD_, this.ED_, this.JC_, this.HD_, this.GD_) : Mgram.createMgramNonSecure(inputStream, this.JC_, this.HD_, this.GD_);
        if (mgram.supportsOperationHandle()) {
            int n = StreamUtil.readInt(inputStream);
            int n2 = 0;
            while (n2 < n) {
                IMgram iMgram = this.Rt_(inputStream, false);
                mgram.getOperationHandle().addMgram(iMgram);
                ++n2;
            }
        }
        return mgram;
    }

    public IMgram createMgram(byte by, InputStream inputStream) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return this.St_(by, inputStream, this.JD_);
    }

    private IMgram St_(byte by, InputStream inputStream, boolean bl) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (this.HD_ != null) {
            this.HD_.resetCounter();
        }
        Mgram mgram = null;
        mgram = !bl ? Mgram.createMgram(by, inputStream, this.CD_, this.FD_, this.ED_, this.JC_, this.HD_, this.GD_) : Mgram.createMgramNonSecure(by, inputStream, this.JC_, this.HD_, this.GD_);
        if (mgram.supportsOperationHandle()) {
            int n = StreamUtil.readInt(inputStream);
            int n2 = 0;
            while (n2 < n) {
                IMgram iMgram = this.St_((byte)-1, inputStream, this.JD_);
                mgram.getOperationHandle().addMgram(iMgram);
                ++n2;
            }
        }
        return mgram;
    }

    private void Tt_(IMgram iMgram, OutputStream outputStream) throws IOException {
        iMgram.writeMgramToNetworkStream(outputStream, this.ED_, this.DD_, this.FD_);
    }

    public void deliver(IMgram iMgram, OutputStream outputStream) throws IOException {
        this.deliver(iMgram, -1, outputStream);
    }

    public void deliver(IMgram iMgram, int n, OutputStream outputStream) throws IOException {
        iMgram.writeMgramToNetworkStream(outputStream, n, this.ED_, this.DD_, this.FD_);
        if (iMgram.supportsOperationHandle()) {
            LinkedList linkedList = iMgram.getOperationHandle().getMgramList();
            if (linkedList != null) {
                StreamUtil.writeInt(linkedList.size(), outputStream);
                int n2 = 0;
                while (n2 < linkedList.size()) {
                    iMgram = (IMgram)linkedList.get(n2);
                    this.deliver(iMgram, n, outputStream);
                    ++n2;
                }
            } else {
                StreamUtil.writeInt(0, outputStream);
            }
        }
    }

    public void secureDeliver(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream) throws IOException {
        this.Ut_(iMgram, n, clientSecurityContext, outputStream, false);
    }

    private void Ut_(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream, boolean bl) throws IOException {
        if (iMgram.isSecure() && (SecurityLogic.isMKeyMacHeader(iMgram.getSecurity()) || SecurityLogic.isMKeyDigest(iMgram.getSecurity())) && !bl) {
            this.Vt_(iMgram, n, clientSecurityContext, outputStream);
        } else if (iMgram.isSecure() && (SecurityLogic.isSKeyDigest(iMgram.getSecurity()) || SecurityLogic.isSKeyEncryption(iMgram.getSecurity())) && !bl) {
            this.Xt_(iMgram, n, clientSecurityContext, outputStream);
        } else {
            if (bl) {
                iMgram.writeMgramToStreamNonSecure(outputStream, n, true);
            } else {
                iMgram.writeMgramToNetworkStream(outputStream, n, clientSecurityContext, this.DD_, this.FD_);
            }
            this.Wt_(iMgram, n, clientSecurityContext, outputStream, false);
        }
    }

    private void Vt_(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream) throws IOException {
        IMgramConverterHandle iMgramConverterHandle = iMgram.getMgramConverterHandle();
        iMgramConverterHandle.recalculatePad(this.FD_);
        if (this.ID_ == null) {
            this.ID_ = new byte[this.FD_.getOutputSize(this.FD_.getSecretKeyLength())];
        }
        iMgram.getBrokerHandle().encryptMessageKey(this.ID_, this.FD_);
        StaticHeader.iw_(outputStream, iMgramConverterHandle.getInternalStaticHeader(), n, true);
        iMgramConverterHandle.getInternalDynamicHeader().writeToStream(outputStream, this.FD_, this.ID_, null);
        iMgram.writePayloadToStream(outputStream, null);
        this.Wt_(iMgram, n, clientSecurityContext, outputStream, false);
    }

    private void Wt_(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream, boolean bl) throws IOException {
        if (iMgram.supportsOperationHandle()) {
            LinkedList linkedList = iMgram.getOperationHandle().getMgramList();
            if (linkedList != null) {
                StreamUtil.writeInt(linkedList.size(), outputStream);
                int n2 = 0;
                while (n2 < linkedList.size()) {
                    iMgram = (IMgram)linkedList.get(n2);
                    this.Ut_(iMgram, n, clientSecurityContext, outputStream, bl);
                    ++n2;
                }
            } else {
                StreamUtil.writeInt(0, outputStream);
            }
        }
    }

    private void Xt_(IMgram iMgram, int n, ClientSecurityContext clientSecurityContext, OutputStream outputStream) throws IOException {
        IMgramConverterHandle iMgramConverterHandle = iMgram.getMgramConverterHandle();
        iMgramConverterHandle.recalculatePad(this.FD_);
        byte[] byArray = null;
        if (SecurityLogic.isSKeyDigest(iMgram.getSecurity())) {
            byArray = iMgramConverterHandle.calculateMac(clientSecurityContext.getDigestKey(), this.FD_);
        }
        StaticHeader.iw_(outputStream, iMgramConverterHandle.getInternalStaticHeader(), n, true);
        iMgramConverterHandle.getInternalDynamicHeader().writeToStream(outputStream, this.FD_, null, byArray);
        iMgram.writePayloadToStream(outputStream, this.DD_);
        this.Wt_(iMgram, n, clientSecurityContext, outputStream, false);
    }

    public IMgram unserialize(InputStream inputStream) throws IOException {
        return this.unserialize(inputStream, false);
    }

    public IMgram unserialize(InputStream inputStream, boolean bl) throws IOException {
        IMgram iMgram = Mgram.unserialize(inputStream, bl);
        if (iMgram.supportsOperationHandle()) {
            int n = StreamUtil.readInt(inputStream);
            int n2 = 0;
            while (n2 < n) {
                byte by = StreamUtil.readByte(inputStream);
                IMgram iMgram2 = this.unserialize(inputStream, bl);
                iMgram.getOperationHandle().addMgram(iMgram2);
                ++n2;
            }
        }
        return iMgram;
    }

    public void serialize(OutputStream outputStream, IMgram iMgram) throws IOException {
        this.serialize(outputStream, iMgram, false);
    }

    public void serialize(OutputStream outputStream, IMgram iMgram, boolean bl) throws IOException {
        IOperationHandle iOperationHandle;
        LinkedList linkedList;
        iMgram.getBrokerHandle().serialize(outputStream, bl);
        if (iMgram.supportsOperationHandle() && (linkedList = (iOperationHandle = iMgram.getOperationHandle()).getMgramList()) != null) {
            int n = linkedList.size();
            StreamUtil.writeInt(n, outputStream);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                IMgram iMgram2 = (IMgram)iterator.next();
                this.serialize(outputStream, iMgram2, bl);
            }
        }
    }

    public void writeMgramToStreamNonSecure(OutputStream outputStream, IMgram iMgram, boolean bl) throws IOException {
        IOperationHandle iOperationHandle;
        LinkedList linkedList;
        iMgram.writeMgramToStreamNonSecure(outputStream, bl);
        if (iMgram.supportsOperationHandle() && (linkedList = (iOperationHandle = iMgram.getOperationHandle()).getMgramList()) != null) {
            int n = linkedList.size();
            StreamUtil.writeInt(n, outputStream);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                IMgram iMgram2 = (IMgram)iterator.next();
                this.writeMgramToStreamNonSecure(outputStream, iMgram2, bl);
            }
        }
    }

    public IMgram createMgram(byte[] byArray) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return new Mgram(byArray);
    }

    public IMgram createMgram(boolean bl) {
        return new Mgram(bl);
    }

    public static IMgram buildAck(long l, long l2, short s, int n) {
        return MgramCreator.buildAck(l, l2, s, false, 0L, false, 0, n);
    }

    public static IMgram buildAck(long l, long l2, short s, boolean bl, long l3, boolean bl2, int n, int n2) {
        Mgram mgram = null;
        mgram = new Mgram(false);
        byte[] byArray = new byte[qC_.length];
        System.arraycopy(qC_, 0, byArray, 0, qC_.length);
        byte[] byArray2 = new byte[rC_.length];
        System.arraycopy(rC_, 0, byArray2, 0, rC_.length);
        StaticHeader.setChannel(n2, byArray);
        mgram.setStaticHeader(byArray);
        mgram.setDynamicHeaderCache(byArray2);
        byte[] byArray3 = AckPayload.XXB_(l, l2, s, bl, l3, bl2, n);
        DefaultDynamicHeader.setMessageLength(byArray3.length, byArray2);
        if (bl) {
            StaticHeader.xw_(bl, byArray);
        }
        if (bl2) {
            StaticHeader.Ax_(bl2, byArray);
        }
        mgram.setPayloadCache(byArray3);
        return mgram;
    }

    public static IMgram buildQAck(long l, long l2, short s, boolean bl, long l3, boolean bl2, int n, int n2) {
        IMgram iMgram = null;
        iMgram = MgramCreator.buildAck(l, l2, s, bl, l3, bl2, n, n2);
        iMgram.setType((byte)14);
        return iMgram;
    }

    public static IMgram buildWindowAck(long l, long l2, short s, boolean bl, long l3, boolean bl2, int n, int n2) {
        Mgram mgram = new Mgram(false);
        byte[] byArray = new byte[Ww_.length];
        System.arraycopy(Ww_, 0, byArray, 0, Ww_.length);
        byte[] byArray2 = new byte[rC_.length];
        System.arraycopy(rC_, 0, byArray2, 0, rC_.length);
        StaticHeader.setChannel(n2, byArray);
        mgram.setStaticHeader(byArray);
        mgram.setDynamicHeaderCache(byArray2);
        byte[] byArray3 = AckPayload.YXB_(l, l2, s, bl, l3, bl2, n);
        DefaultDynamicHeader.setMessageLength(byArray3.length, byArray2);
        if (bl) {
            StaticHeader.xw_(bl, byArray);
        }
        if (bl2) {
            StaticHeader.Ax_(bl2, byArray);
        }
        mgram.setPayloadCache(byArray3);
        return mgram;
    }

    public static IMgram buildAckList() {
        Mgram mgram = new Mgram(false);
        mgram.setStaticHeader(StaticHeader.getDefaultByteArray());
        mgram.setDynamicHeader(new DefaultDynamicHeader(mgram));
        mgram.setPayload(new AckListPayload(mgram));
        mgram.setType((byte)28);
        mgram.setPriority((byte)11);
        return mgram;
    }

    public static IMgram buildQueueGetRequestMgram(boolean bl, int n, short s, int n2, String string) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)13);
        mgram.setChannel(n);
        mgram.setSubject(string);
        mgram.setDestinationAddressFormat(3);
        mgram.setDestinationAddress(ArrayUtil.IntToByte(QueueUtil.queueNameToMatchVector(string)));
        byte[] byArray = new byte[6];
        int n3 = 0;
        ArrayUtil.writeShort(byArray, n3, s);
        ArrayUtil.writeInt(byArray, n3 += 2, n2);
        mgram.setBody(byArray);
        if (bl) {
            mgram.setMgramSecure(null);
            mgram.setSecurityAttribute((byte)0);
        }
        mgram.sync();
        return mgram;
    }

    public static IMgram buildQueueOpenRemoteReceiverMgram(boolean bl, int n, String string, String string2) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)30);
        mgram.setChannel(n);
        mgram.setSubject(string);
        mgram.setDestinationAddressFormat(3);
        mgram.setDestinationAddress(ArrayUtil.IntToByte(QueueUtil.queueNameToMatchVector(string)));
        mgram.setRouteLimit(1);
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            StreamUtil.writeUTF(string2 == null ? "" : string2, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byArray = byteArrayOutputStream.toByteArray();
        mgram.setBody(byArray);
        if (bl) {
            mgram.setMgramSecure(null);
            mgram.setSecurityAttribute((byte)0);
        }
        mgram.sync();
        return mgram;
    }

    public static IMgram buildQueueCloseRemoteReceiverMgram(boolean bl, int n, String string, String string2) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)31);
        mgram.setChannel(n);
        mgram.setSubject(string);
        mgram.setDestinationAddressFormat(3);
        mgram.setDestinationAddress(ArrayUtil.IntToByte(QueueUtil.queueNameToMatchVector(string)));
        mgram.setRouteLimit(1);
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            StreamUtil.writeUTF(string2 == null ? "" : string2, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byArray = byteArrayOutputStream.toByteArray();
        mgram.setBody(byArray);
        if (bl) {
            mgram.setMgramSecure(null);
            mgram.setSecurityAttribute((byte)0);
        }
        mgram.sync();
        return mgram;
    }

    public static IMgram buildPingRequest(byte[] byArray, int n) {
        IMgram iMgram = null;
        try {
            iMgram = (IMgram)vC_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        iMgram.setChannel(n);
        iMgram.setBody(byArray);
        return iMgram;
    }

    public static IMgram buildPingReply(IMgram iMgram) {
        IMgram iMgram2 = null;
        try {
            iMgram2 = (IMgram)wC_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        iMgram2.setChannel(iMgram.getChannel());
        iMgram2.setBody(iMgram.getRawBody());
        return iMgram2;
    }

    public static IMgram buildDisconnectRequest(int n, boolean bl) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)7);
        mgram.setPriority((byte)0);
        mgram.setRequestReplyType(2);
        mgram.setChannel(n);
        mgram.setReplyToAddressFormat(0);
        byte[] byArray = new byte[]{bl ? (byte)1 : 0};
        mgram.setBody(byArray);
        return mgram;
    }

    public static IMgram buildFlowControlMgram(byte by, int n) {
        Mgram mgram = new Mgram(false);
        byte[] byArray = new byte[uC_.length];
        System.arraycopy(uC_, 0, byArray, 0, uC_.length);
        byte[] byArray2 = new byte[tC_.length];
        System.arraycopy(tC_, 0, byArray2, 0, tC_.length);
        byte[] byArray3 = new byte[sC_.length];
        System.arraycopy(sC_, 0, byArray3, 0, sC_.length);
        FlowControlPayload.J_(by, byArray);
        StaticHeader.setChannel(n, byArray3);
        mgram.setStaticHeader(byArray3);
        mgram.setDynamicHeaderCache(byArray2);
        mgram.setPayloadCache(byArray);
        return mgram;
    }

    public static IMgram buildVersionMgram(int n, byte by) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)4);
        mgram.gH_(by);
        mgram.setChannel(n);
        mgram.setPostV22();
        return mgram;
    }

    public static IMgram buildVersionMgram(int n, byte by, byte by2) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)4);
        mgram.gH_(by);
        mgram.setChannel(n);
        mgram.setPostV22();
        mgram.setSessionVer(by2);
        return mgram;
    }

    public static IMgram buildConnectMgram(byte[] byArray, int n) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)1);
        mgram.setRequestReplyType(0);
        mgram.setChannel(n);
        mgram.setBody(byArray);
        return mgram;
    }

    public static IMgram buildErrorMgram(int n, int n2, IMgram iMgram, int n3) {
        Mgram mgram = new Mgram(false);
        mgram.setStaticHeader(StaticHeader.getDefaultByteArray());
        mgram.setDynamicHeader(new DefaultDynamicHeader(mgram));
        mgram.setPayload(new ErrorPayload(mgram));
        if (iMgram != null && iMgram.hasID()) {
            mgram.setID(iMgram.getID());
        }
        mgram.setType((byte)-1);
        mgram.setChannel(n3);
        mgram.getErrorHandle().setErrCode(n);
        mgram.getErrorHandle().setErrInfo(n2);
        return mgram;
    }

    public static IMgram buildTxnRequest(boolean bl, int n, int n2, long l, int n3) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_COMMIT_SUBTYPE, false, bl, n, n2, l, n3, null, -1L, false, -1, null);
    }

    public static IMgram buildCommitTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_COMMIT_SUBTYPE, bl, bl2, n, n2, l, n3, null, -1L, false, -1, null);
    }

    public static IMgram buildNoDupCommitTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3, String string, long l2) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE, bl, bl2, n, n2, l, n3, string, l2, false, -1, null);
    }

    public static IMgram buildNoDupChannelCommitTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3, String string, long l2, int n4, String string2) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE, bl, bl2, n, n2, l, n3, string, l2, true, n4, string2);
    }

    public IMgram buildNoDupChannelDeleteTxnRequest(boolean bl, int n, long l, int n2, String string, String string2) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE, bl, false, -1, n, l, n2, string, 0L, true, -1, string2);
    }

    public IMgram buildNoDupChannelUpdateTxnRequest(boolean bl, int n, long l, int n2, String string, long l2, int n3, String string2) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE, bl, false, -1, n, l, n2, string, l2, true, n3, string2);
    }

    public static IMgram buildBeginTxnRequest(boolean bl, int n, long l, int n2) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_BEGIN_SUBTYPE, bl, false, -1, n, l, n2, null, -1L, false, -1, null);
    }

    public static IMgram buildAbortTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_ABORT_SUBTYPE, bl, bl2, n, n2, l, n3, null, -1L, false, -1, null);
    }

    public static IMgram buildGenericTxnRequest(short s, boolean bl, boolean bl2, int n, int n2, long l, int n3, String string, long l2, boolean bl3, int n4, String string2) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)8);
        mgram.setRequestReplyType(0);
        mgram.setPriority((byte)0);
        mgram.setChannel(n3);
        mgram.setPayload(new TXNRequestPayload(mgram));
        ITXNRequestHandle iTXNRequestHandle = mgram.getTXNRequestHandle();
        iTXNRequestHandle.setType(s);
        iTXNRequestHandle.setXonce(bl);
        iTXNRequestHandle.setChained(bl2);
        iTXNRequestHandle.setTID(n);
        iTXNRequestHandle.setReplyTracking(n2);
        iTXNRequestHandle.setClientId(l);
        iTXNRequestHandle.setTransactionId(string);
        iTXNRequestHandle.setLifespan(l2);
        iTXNRequestHandle.setChannelState(n4);
        iTXNRequestHandle.setChannelID(string2);
        mgram.sync();
        return mgram;
    }

    public static IMgram buildTxnReply(short s, int n, int n2, int n3) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)8);
        mgram.setRequestReplyType(3);
        mgram.setPriority((byte)10);
        mgram.setChannel(n3);
        byte[] byArray = new byte[zC_];
        int n4 = 0;
        ArrayUtil.writeShort(byArray, n4, s);
        ArrayUtil.writeInt(byArray, n4 += 2, n2);
        ArrayUtil.writeInt(byArray, n4 += 4, n);
        n4 += 4;
        mgram.setBody(byArray);
        return mgram;
    }

    public static IMgram buildTxnActiveReply(long l, int n, int n2, int n3) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)8);
        mgram.setRequestReplyType(3);
        mgram.setPriority((byte)10);
        mgram.setChannel(n3);
        byte[] byArray = new byte[Xw_];
        int n4 = 0;
        ArrayUtil.writeShort(byArray, n4, (short)13);
        ArrayUtil.writeInt(byArray, n4 += 2, n2);
        ArrayUtil.writeLong(byArray, n4 += 4, l);
        ArrayUtil.writeInt(byArray, n4 += 8, n);
        n4 += 4;
        mgram.setBody(byArray);
        return mgram;
    }

    public IMgram buildExtendedTxnRequest(boolean bl, boolean bl2, int n, int n2, long l, int n3, XidImpl xidImpl, int n4) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)26);
        mgram.setRequestReplyType(0);
        mgram.setPriority((byte)0);
        mgram.setChannel(n3);
        mgram.setPayload(new rd(mgram));
        IExtendedTXNRequestHandle iExtendedTXNRequestHandle = mgram.getExtendedTXNRequestHandle();
        iExtendedTXNRequestHandle.setOp(n4);
        iExtendedTXNRequestHandle.setXonce(bl);
        iExtendedTXNRequestHandle.setChained(bl2);
        iExtendedTXNRequestHandle.setTID(n);
        iExtendedTXNRequestHandle.setReplyTracking(n2);
        iExtendedTXNRequestHandle.setClientId(l);
        iExtendedTXNRequestHandle.setXid(xidImpl);
        mgram.sync();
        return mgram;
    }

    public static IMgram buildGRConvertMgram(long l, long l2, int n, long l3) {
        if (AD_ != null) {
            return AD_.buildGRConvertMgram(l, l2, n, l3);
        }
        throw new EAssertFailure("Cannot create GR convert mgram without broker");
    }

    public IMgram buildFailoverStatusNotification(int n, String[] stringArray, String[] stringArray2) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)21);
        mgram.setPriority((byte)10);
        mgram.setChannel(0);
        mgram.setRouteLimit(1);
        mgram.setMgramNonSecure();
        mgram.setPayload(new FailoverStatusNotificationPayload(mgram));
        IFailoverStatusNotificationHandle iFailoverStatusNotificationHandle = mgram.getFailoverStatusNotificationHandle();
        iFailoverStatusNotificationHandle.setState(n);
        iFailoverStatusNotificationHandle.setLocalURLs(stringArray);
        iFailoverStatusNotificationHandle.setStandbyURLs(stringArray2);
        mgram.sync();
        return mgram;
    }

    public static IMgram buildBatchMgram(IMgram iMgram) {
        Mgram mgram = new Mgram(false);
        mgram.setStaticHeader(StaticHeader.getDefaultByteArray());
        mgram.setDynamicHeader(new DefaultDynamicHeader(mgram));
        BatchPayload batchPayload = new BatchPayload(mgram);
        mgram.setPayload(batchPayload);
        mgram.setType((byte)27);
        batchPayload.UKB_(iMgram);
        return mgram;
    }

    public static IMgram buildTxnBatchMgram(IMgram iMgram, int n) {
        Mgram mgram = new Mgram(false);
        mgram.setStaticHeader(StaticHeader.getDefaultByteArray());
        mgram.setDynamicHeader(new DefaultDynamicHeader(mgram));
        BatchPayload batchPayload = new BatchPayload(mgram);
        mgram.setPayload(batchPayload);
        mgram.setType((byte)27);
        batchPayload.UKB_(iMgram);
        batchPayload.setTid(n);
        return mgram;
    }

    public static IMgram buildOperationMgram(int n) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)25);
        mgram.getOperationHandle().setOperationType(n);
        return mgram;
    }

    public static IMgram buildIDRAckMgram() {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)23);
        mgram.setPriority((byte)12);
        mgram.setRouteLimit(1);
        mgram.setMgramNonSecure();
        mgram.setPayload(new ik(mgram));
        IIDRHandle iIDRHandle = mgram.getIDRHandle();
        iIDRHandle.setSubType((byte)3);
        mgram.sync();
        return mgram;
    }

    public static List buildIDRMgramList(boolean bl, boolean bl2, boolean bl3, List list, List list2, List list3, List list4, List list5, List list6) {
        Vector<Mgram> vector = new Vector<Mgram>();
        byte by = bl ? (byte)1 : 2;
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)23);
        mgram.setPriority((byte)12);
        mgram.setRouteLimit(1);
        mgram.setMgramNonSecure();
        mgram.setPayload(new ik(mgram));
        IIDRHandle iIDRHandle = mgram.getIDRHandle();
        iIDRHandle.setSubType(by);
        iIDRHandle.setMore(false);
        iIDRHandle.setSenderHasDoubt(bl3);
        iIDRHandle.setResponseRequired(bl2);
        iIDRHandle.setDNRPTP(list2);
        iIDRHandle.setDNRPubSub(list);
        iIDRHandle.setUGAPTP(list4);
        iIDRHandle.setUGAPubSub(list3);
        iIDRHandle.setPREP(list6);
        iIDRHandle.setPREQ(list5);
        mgram.sync();
        vector.add(mgram);
        return vector;
    }

    public static IMgram buildConnectionSyncMgram(AutoVec autoVec) {
        Mgram mgram = new Mgram(true);
        mgram.setType((byte)32);
        mgram.setPriority((byte)12);
        mgram.setRouteLimit(1);
        mgram.setMgramNonSecure();
        mgram.setPayload(new ConnectionSyncPayload(mgram));
        IConnectionSyncHandle iConnectionSyncHandle = mgram.getConnectionSyncHandle();
        iConnectionSyncHandle.setConnectionSyncData(autoVec);
        mgram.sync();
        return mgram;
    }

    public static IMgram buildFirstMessageNotification(long l) {
        IMgram iMgram = MgramCreator.buildOperationMgram(1);
        try {
            iMgram.getPayloadOutputStreamHandle().writeLong(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return iMgram;
    }

    public static IMgram buildDeliveryFinished(long l) {
        IMgram iMgram = MgramCreator.buildOperationMgram(21);
        try {
            iMgram.getPayloadOutputStreamHandle().writeLong(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return iMgram;
    }

    public static IMgram buildLastMessageNotification(long l) {
        IMgram iMgram = MgramCreator.buildOperationMgram(2);
        try {
            iMgram.getPayloadOutputStreamHandle().writeLong(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return iMgram;
    }

    public static IMgram buildSingleTargetMessage(long l, IMgram iMgram) {
        IMgram iMgram2 = MgramCreator.buildOperationMgram(3);
        try {
            iMgram2.getPayloadOutputStreamHandle().writeLong(l);
            iMgram2.getOperationHandle().addMgram(iMgram);
            iMgram2.setPriority(iMgram.getPriority());
            iMgram2.setDiscardable(iMgram.isDiscardable());
            iMgram2.setTTE(iMgram.getTTE());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return iMgram2;
    }

    public static IMgram buildLBSTargetMessage(IMgram iMgram, FastVector fastVector) {
        int n = (Integer)fastVector.m_data[0];
        IMgram iMgram2 = MgramCreator.buildOperationMgram(n == 1 ? 13 : 14);
        ObjectOutput objectOutput = iMgram2.getPayloadOutputStreamHandle();
        iMgram2.setRouteLimit(iMgram.getRouteLimit());
        iMgram2.setPriority(iMgram.getPriority());
        iMgram2.setDiscardable(iMgram.isDiscardable());
        iMgram2.setTTE(iMgram.getTTE());
        if (iMgram.isGuarenteed()) {
            iMgram2.setGuarenteed(iMgram.getGuarenteedTrackingNum());
        }
        if (iMgram.isSecure()) {
            iMgram2.setMgramSecure(iMgram.getMessageProtection());
            try {
                iMgram2.setSecurityAttribute(SecurityLogic.AttribsFromPublic((byte)4, SecurityLogic.getPubAttr(iMgram.getSecurity())));
            }
            catch (ESecurityInvalidLogistics eSecurityInvalidLogistics) {
                throw new EAssertFailure(eSecurityInvalidLogistics.getMessage());
            }
        }
        try {
            objectOutput.writeByte(0);
            objectOutput.writeInt(n);
            int n2 = 1;
            while (n2 <= n) {
                objectOutput.writeLong((Long)fastVector.m_data[n2]);
                ++n2;
            }
            objectOutput.writeInt(fastVector.m_count - ++n);
            int n3 = n;
            while (n3 < fastVector.m_count) {
                objectOutput.writeUTF((String)fastVector.m_data[n3]);
                ++n3;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        iMgram2.getOperationHandle().addMgram(iMgram);
        return iMgram2;
    }

    public FastVector unmarshalLBSTargetMessage(IMgram iMgram) {
        FastVector fastVector = new FastVector();
        ObjectInput objectInput = iMgram.getPayloadInputStreamHandle();
        int n = -1;
        int n2 = -1;
        try {
            objectInput.readByte();
            n = objectInput.readInt();
            fastVector.addElement(new Integer(n));
            int n3 = 0;
            while (n3 < n) {
                long l = objectInput.readLong();
                fastVector.addElement(new Long(l));
                ++n3;
            }
            n2 = objectInput.readInt();
            int n4 = 0;
            while (n4 < n2) {
                fastVector.addElement(objectInput.readUTF());
                ++n4;
            }
        }
        catch (IOException iOException) {
            SessionConfig.logMessage(iOException, SessionConfig.getLevelWarning());
            return null;
        }
        return fastVector;
    }

    public static IMgram buildGuarFormatMgram(IMgram iMgram) {
        IMgram iMgram2 = MgramCreator.buildOperationMgram(25);
        if (!iMgram.isGuarenteed()) {
            iMgram2.setReliable();
        } else {
            iMgram2.setGuarenteed(iMgram.getGuarenteedTrackingNum());
        }
        iMgram2.getOperationHandle().addMgram(iMgram);
        return iMgram2;
    }

    public static IMgram buildLBSTargetMessage(IMgram iMgram, int n, byte[] byArray, int n2) {
        IMgram iMgram2 = MgramCreator.buildOperationMgram(n);
        ObjectOutput objectOutput = iMgram2.getPayloadOutputStreamHandle();
        iMgram2.setRouteLimit(iMgram.getRouteLimit());
        iMgram2.setPriority(iMgram.getPriority());
        iMgram2.setDiscardable(iMgram.isDiscardable());
        iMgram2.setTTE(iMgram.getTTE());
        if (iMgram.isGuarenteed()) {
            iMgram2.setGuarenteed(iMgram.getGuarenteedTrackingNum());
        }
        if (iMgram.isSecure()) {
            iMgram2.setMgramSecure(iMgram.getMessageProtection());
            try {
                iMgram2.setSecurityAttribute(SecurityLogic.AttribsFromPublic((byte)4, SecurityLogic.getPubAttr(iMgram.getSecurity())));
            }
            catch (ESecurityInvalidLogistics eSecurityInvalidLogistics) {
                throw new EAssertFailure(eSecurityInvalidLogistics.getMessage());
            }
        }
        try {
            objectOutput.write(byArray, 0, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        iMgram2.getOperationHandle().addMgram(iMgram);
        return iMgram2;
    }

    public static IMgram buildDisconnectReply(int n, boolean bl) {
        if (AD_ != null) {
            return AD_.buildDisconnectReply(n, bl);
        }
        throw new EAssertFailure("Cannot create DisconnectReply without broker");
    }

    public static IMgram buildTxnEOFMarker() {
        if (AD_ != null) {
            return AD_.buildTxnEOFMarker();
        }
        throw new EAssertFailure("Cannot create TxnEOFMarker without broker");
    }

    public static IMgram buildTxnSavePointMarker() {
        if (AD_ != null) {
            return AD_.buildTxnSavePointMarker();
        }
        throw new EAssertFailure("Cannot create TxnSavePointMarker without broker");
    }

    public static IMgram buildRemoteRestorePhasesDoneMgram(long l) {
        IMgram iMgram = MgramCreator.buildOperationMgram(20);
        try {
            iMgram.getPayloadOutputStreamHandle().writeLong(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return iMgram;
    }

    public static IMgram buildResumeMgram(int n, byte[] byArray, int n2, boolean bl) {
        if (AD_ != null) {
            return AD_.buildResumeMgram(n, byArray, n2, bl);
        }
        throw new EAssertFailure("Cannot create Resume without broker");
    }

    public static IMgram buildBlockMgram(int n, byte[] byArray, int n2, boolean bl) {
        if (AD_ != null) {
            return AD_.buildBlockMgram(n, byArray, n2, bl);
        }
        throw new EAssertFailure("Cannot create Block without broker");
    }

    public static IMgram buildNack(long l, int n) {
        if (AD_ != null) {
            return AD_.buildNack(l, n);
        }
        throw new EAssertFailure("Cannot create Nack without broker");
    }

    public static IMgram buildRouteRequest(int n, int n2, long l, int n3, byte[] byArray) {
        if (AD_ != null) {
            return AD_.buildRouteRequest(n, n2, l, n3, byArray);
        }
        throw new EAssertFailure("Cannot create Route Request without broker");
    }

    public static IMgram buildIBConvertMgram(long l, int n) {
        if (AD_ != null) {
            return AD_.buildIBConvertMgram(l, n);
        }
        throw new EAssertFailure("Cannot create IB Convert without broker");
    }

    public static IMgram buildStateEventMgram(IStateEvent iStateEvent, boolean bl) {
        if (AD_ != null) {
            return AD_.buildStateEventMgram(iStateEvent, bl);
        }
        throw new EAssertFailure("Cannot create StateEvent without broker");
    }

    public static IMgram buildDatabaseMgram(ISaverOp iSaverOp) {
        if (AD_ != null) {
            return AD_.buildDatabaseMgram(iSaverOp);
        }
        throw new EAssertFailure("Cannot create DatabaseMgram without broker");
    }

    public static IMgram buildReplicatedMgram(IMgram iMgram, boolean bl) {
        if (AD_ != null) {
            return AD_.buildReplicatedMgram(iMgram, bl);
        }
        throw new EAssertFailure("Cannot create ReplicatedMgram without broker");
    }

    public static ISidebandData buildSidebandData() {
        return new SidebandData();
    }

    public static Payload getPayloadObject(byte by, Mgram mgram) {
        Payload payload;
        switch (by) {
            case 4: {
                return null;
            }
            case 18: 
            case 19: {
                payload = new QueueFlowControlPayload(mgram);
                break;
            }
            case 6: {
                payload = new FlowControlPayload(mgram);
                break;
            }
            case 3: 
            case 14: 
            case 33: {
                payload = new AckPayload(mgram);
                break;
            }
            case 20: {
                payload = new NackPayload(mgram);
                break;
            }
            case -1: {
                payload = new ErrorPayload(mgram);
                break;
            }
            case 21: {
                payload = new FailoverStatusNotificationPayload(mgram);
                break;
            }
            case 23: {
                payload = new ik(mgram);
                break;
            }
            case 27: {
                payload = new BatchPayload(mgram);
                break;
            }
            case 32: {
                payload = new ConnectionSyncPayload(mgram);
                break;
            }
            case 28: {
                payload = new AckListPayload(mgram);
                break;
            }
            case 8: {
                if (!mgram.isReply()) {
                    payload = new TXNRequestPayload(mgram);
                    break;
                }
                payload = null;
                break;
            }
            case 26: {
                if (!mgram.isReply()) {
                    payload = new rd(mgram);
                    break;
                }
                payload = null;
                break;
            }
            default: {
                payload = null;
            }
        }
        if (payload == null && AD_ != null) {
            payload = AD_.getPayloadObject(by, mgram);
        }
        if (payload == null) {
            payload = new DefaultPayload(mgram);
        }
        return payload;
    }

    public byte getVersion() {
        return 26;
    }

    static {
        yC_ = 18;
        zC_ = 10;
        Xw_ = 18;
        AD_ = null;
        qC_ = StaticHeader.getDefaultByteArray();
        Object object = new DefaultDynamicHeader(null);
        ((DynamicHeader)object).setMessageLength(16);
        rC_ = ((DynamicHeader)object).toByteArray();
        StaticHeader.setType((byte)3, qC_);
        StaticHeader.setPriority((byte)11, qC_);
        pC_ = new Mgram(false);
        pC_.setStaticHeader(StaticHeader.getDefaultByteArray());
        pC_.setDynamicHeader(new DefaultDynamicHeader(pC_));
        pC_.setPayload(new AckPayload(pC_));
        pC_.setGuarenteed(0L);
        pC_.setType((byte)3);
        pC_.setPriority((byte)11);
        pC_.sync();
        Ww_ = StaticHeader.getDefaultByteArray();
        StaticHeader.setType((byte)33, Ww_);
        StaticHeader.setPriority((byte)11, Ww_);
        vC_ = new Mgram(false);
        vC_.setStaticHeader(StaticHeader.getDefaultByteArray());
        object = new DefaultDynamicHeader(vC_);
        vC_.setDynamicHeader((DynamicHeader)object);
        DefaultPayload defaultPayload = new DefaultPayload(vC_);
        defaultPayload.UD_(0);
        vC_.setPayload(defaultPayload);
        vC_.setType((byte)0);
        vC_.setPriority((byte)12);
        vC_.setRequestReplyType(2);
        vC_.sync();
        wC_ = new Mgram(false);
        wC_.setStaticHeader(StaticHeader.getDefaultByteArray());
        wC_.setDynamicHeader(new DefaultDynamicHeader(wC_));
        object = new DefaultPayload(wC_);
        ((DefaultPayload)object).UD_(0);
        wC_.setPayload((Payload)object);
        wC_.setType((byte)0);
        wC_.setPriority((byte)12);
        wC_.setRequestReplyType(3);
        wC_.sync();
        xC_ = new Mgram(false);
        sC_ = StaticHeader.getDefaultByteArray();
        object = new DefaultDynamicHeader(null);
        ((DynamicHeader)object).setMessageLength(1);
        tC_ = ((DynamicHeader)object).toByteArray();
        StaticHeader.setType((byte)6, sC_);
        StaticHeader.setPriority((byte)12, sC_);
        StaticHeader.setRequestReplyType(0, sC_);
        uC_ = new FlowControlPayload(null).toByteArray();
        if (SessionConfig.IN_BROKER) {
            try {
                object = Class.forName("progress.message.msg.v26.broker.MgramCreator");
                AD_ = (IBrokerMgramCreator)((Class)object).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

