/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.msg.ITXNRequestHandle;
import progress.message.msg.MgramConstants;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.DefaultPayload;
import progress.message.msg.v26.Mgram;
import progress.message.zclient.EMgramFormatError;

final class TXNRequestPayload
extends DefaultPayload
implements ITXNRequestHandle {
    private static short LG_ = 1;
    private static short MG_ = (short)30;
    private static short NG_ = 1;
    private static short OG_ = (short)32;
    boolean PG_ = false;
    private short QG_;
    private int RG_ = 0;
    private int SG_ = -1;
    private long TG_;
    private String UG_;
    private long VG_ = 0L;
    private int WG_ = -1;
    private String XG_;

    public TXNRequestPayload(Mgram mgram) {
        super(mgram);
    }

    protected void H_(InputStream inputStream, StreamUtilCounter streamUtilCounter) throws IOException, EMgramFormatError {
        super.H_(inputStream, streamUtilCounter);
        this.initRemainingPayload();
    }

    public void initRemainingPayload() throws IOException {
        ObjectInput objectInput = this.getPayloadInputStreamHandle();
        this.QG_ = objectInput.readShort();
        this.RG_ = objectInput.readInt();
        this.SG_ = objectInput.readInt();
        this.TG_ = objectInput.readLong();
        int n = this.getType();
        if (n == MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
            this.UG_ = objectInput.readUTF();
            this.VG_ = objectInput.readLong();
        }
        if (n == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
            this.XG_ = objectInput.readUTF();
            this.WG_ = objectInput.readInt();
        }
    }

    protected void I_() {
        if (this.PG_) {
            return;
        }
        try {
            ObjectOutput objectOutput = this.getPayloadOutputStreamHandle();
            objectOutput.writeShort(this.QG_);
            objectOutput.writeInt(this.RG_);
            objectOutput.writeInt(this.SG_);
            objectOutput.writeLong(this.TG_);
            int n = this.getType();
            if (n == MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
                objectOutput.writeUTF(this.UG_);
                objectOutput.writeLong(this.VG_);
            }
            if (n == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE || n == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
                objectOutput.writeUTF(this.XG_);
                objectOutput.writeInt(this.WG_);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.PG_ = true;
        super.KF_();
    }

    public int getType() {
        return (this.QG_ & MG_) >>> NG_;
    }

    public void setType(int n) {
        this.QG_ = (short)(this.QG_ & ~MG_);
        this.QG_ = (short)(this.QG_ | n << NG_);
    }

    public boolean isChained() {
        return (this.QG_ & LG_) == LG_;
    }

    public void setChained(boolean bl) {
        this.QG_ = bl ? (short)(this.QG_ | LG_) : (short)(this.QG_ & ~LG_);
    }

    public String opStr() {
        int n = this.getType();
        if (n == MgramConstants.TX_REQUEST_ABORT_SUBTYPE) {
            return "abort";
        }
        if (n == MgramConstants.TX_REQUEST_BEGIN_SUBTYPE) {
            return "begin";
        }
        if (n == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE) {
            return "commitchannodup";
        }
        if (n == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
            return "deletechannodup";
        }
        if (n == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE) {
            return "updatechannodup";
        }
        if (n == MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE) {
            return "commitnodup";
        }
        return "commit";
    }

    private String EF_() {
        int n = this.getType();
        if (n == MgramConstants.TX_REQUEST_ABORT_SUBTYPE) {
            return "abort";
        }
        if (n == MgramConstants.TX_REQUEST_BEGIN_SUBTYPE) {
            return "begin";
        }
        if (n == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE) {
            return "commit chan nodup," + this.UG_ + "," + this.VG_ + "," + this.XG_ + "," + this.WG_;
        }
        if (n == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
            return "delete chan nodup," + this.UG_ + "," + this.XG_;
        }
        if (n == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE) {
            return "update chan nodup," + this.UG_ + "," + this.VG_ + "," + this.XG_ + "," + this.WG_;
        }
        if (n == MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE) {
            return "commit nodup," + this.UG_ + "," + this.VG_;
        }
        return "commit";
    }

    public boolean isXonce() {
        return (this.QG_ & OG_) == OG_;
    }

    public void setXonce(boolean bl) {
        this.QG_ = bl ? (short)(this.QG_ | OG_) : (short)(this.QG_ & ~OG_);
    }

    public int getReplyTracking() {
        return this.RG_;
    }

    public int getTID() {
        return this.SG_;
    }

    public long getClientId() {
        return this.TG_;
    }

    public String getTransactionId() {
        return this.UG_;
    }

    public long getLifespan() {
        return this.VG_;
    }

    public String getChannelID() {
        return this.XG_;
    }

    public int getChannelState() {
        return this.WG_;
    }

    public void setReplyTracking(int n) {
        this.RG_ = n;
    }

    public void setTID(int n) {
        this.SG_ = n;
    }

    public void setClientId(long l) {
        this.TG_ = l;
    }

    public void setTransactionId(String string) {
        this.UG_ = string;
    }

    public void setLifespan(long l) {
        this.VG_ = l;
    }

    public void setChannelID(String string) {
        this.XG_ = string;
    }

    public void setChannelState(int n) {
        this.WG_ = n;
    }

    public ITXNRequestHandle getTXNRequestHandle() {
        return this;
    }

    public String summaryString() {
        String string = ",chained";
        if (!this.isChained()) {
            string = "";
        }
        String string2 = ",xo";
        if (!this.isXonce()) {
            string2 = "";
        }
        return "tid=" + this.SG_ + ",cid=" + this.TG_ + ",replyTracking=" + ((long)this.RG_ & 0xFFFFFFFFL) + ",flags=" + this.QG_ + "(" + this.EF_() + string + string2 + ")";
    }
}

