/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net;

import java.io.IOException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Properties;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;
import progress.message.net.prAccessor;
import progress.message.zclient.SessionConfig;

public abstract class ProgressSocketFactory {
    private static Object OYB_ = new Object();
    private static boolean PYB_ = true;
    public static final int TCP = 0;
    public static final int SSL = 1;
    public static final int HTTP = 2;
    public static final int HTTPS = 3;
    private static ProgressSocketFactory[] QYB_;

    public static int getType(String string) throws ESocketConfigException {
        if (string.equalsIgnoreCase("tcp")) {
            return 0;
        }
        if (string.equalsIgnoreCase("ssl")) {
            return 1;
        }
        if (string.equalsIgnoreCase("ssl.iaik")) {
            return 1;
        }
        if (string.equalsIgnoreCase("http")) {
            return 2;
        }
        if (string.equalsIgnoreCase("https")) {
            return 3;
        }
        throw new ESocketConfigException(prAccessor.getString("STR006") + string);
    }

    public static ProgressSocketFactory getFactory(int n) throws ESocketConfigException {
        if (QYB_[n] == null) {
            Object object = OYB_;
            synchronized (object) {
                if (QYB_[n] == null) {
                    ProgressSocketFactory.QYB_[n] = ProgressSocketFactory.ZdB_(n);
                }
            }
        }
        return QYB_[n];
    }

    private static ProgressSocketFactory ZdB_(int n) throws ESocketConfigException {
        String string = "progress.message.net.";
        ProgressSocketFactory progressSocketFactory = null;
        switch (n) {
            case 0: {
                if (!PYB_ || SessionConfig.DISABLE_NIO) {
                    string = string + "tcp.ProgressTcpSocketFactory";
                    break;
                }
                string = string + "tcp.channel.ProgressTcpChannelFactory";
                break;
            }
            case 1: {
                string = string + "ssl.ProgressSslSocketFactory";
                break;
            }
            case 2: {
                string = string + "http.ProgressHttpSocketFactory";
                break;
            }
            case 3: {
                string = string + "https.ProgressHttpsSocketFactory";
                break;
            }
            default: {
                throw new ESocketConfigException(prAccessor.getString("STR007") + n);
            }
        }
        try {
            Class<?> clazz = Class.forName(string);
            progressSocketFactory = (ProgressSocketFactory)clazz.newInstance();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ESocketConfigException(prAccessor.getString("STR008") + throwable);
        }
        return progressSocketFactory;
    }

    public abstract ProgressSocket createProgressSocket(Principal var1, String var2, int var3, Object var4) throws IOException;

    public abstract ProgressServerSocket createProgressServerSocket(Principal var1, int var2, int var3, InetAddress var4) throws IOException;

    public abstract ProgressServerSocket createProgressServerSocket(Principal var1, int var2, int var3, InetAddress var4, Properties var5) throws IOException;

    static {
        try {
            Class.forName("java.nio.channels.SocketChannel");
            Class.forName("progress.message.net.tcp.channel.ProgressTcpChannelFactory");
        }
        catch (Throwable throwable) {
            PYB_ = false;
        }
        QYB_ = new ProgressSocketFactory[4];
    }
}

