/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.StringTokenizer;

public class TCPProxy {
    private TCPProxy() {
    }

    public static Socket connectProxy(String string, int n) throws IOException {
        try {
            String string2 = System.getProperty("TUNNELING_PROXY_HOST");
            int n2 = Integer.getInteger("TUNNELING_PROXY_PORT", -1);
            return TCPProxy.connectProxy(string, n, string2, n2);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static Socket connectProxy(String string, int n, String string2, int n2) throws IOException {
        Socket socket = null;
        if (string2 != null && n2 != -1) {
            socket = new Socket(string2, n2);
            String string3 = null;
            new DataOutputStream(socket.getOutputStream()).writeBytes("CONNECT " + string + ":" + n + " HTTP/1.0\n\n");
            string3 = TCPProxy.getHTTPResponseErrorCode(socket);
            if (!string3.equals("200")) {
                throw new IOException("Proxy server HTTP error: " + string3);
            }
        }
        return socket;
    }

    public static String getHTTPResponseErrorCode(Socket socket) throws IOException {
        String string = "HTTP response syntax error";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String string2 = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        while (!(string2 = bufferedReader.readLine()).equals("")) {
        }
        return string;
    }
}

