/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.channel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class ChannelInputStream
extends InputStream {
    private SocketChannel m_channel = null;
    private ByteBuffer m_currentBuffer = null;

    public ChannelInputStream(SocketChannel socketChannel, int n) throws IOException {
        this.m_channel = socketChannel;
        this.m_currentBuffer = ByteBuffer.allocateDirect(n);
        this.m_currentBuffer.limit(0);
    }

    public void close() throws IOException {
    }

    public final int read() throws IOException {
        int n = 0;
        this.fill(1);
        if (this.m_currentBuffer.remaining() == 0) {
            return -1;
        }
        return n |= 0xFF & this.m_currentBuffer.get();
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.m_currentBuffer.capacity()) {
            int n3 = this.m_currentBuffer.remaining();
            if (n3 > 0) {
                this.m_currentBuffer.get(byArray, n, n3);
                this.m_currentBuffer.clear();
                this.m_currentBuffer.limit(0);
                int n4 = this.m_channel.read(ByteBuffer.wrap(byArray, n += n3, n2 -= n3));
                if (n4 > 0) {
                    n3 += n4;
                }
                return n3;
            }
            return this.m_channel.read(ByteBuffer.wrap(byArray, n, n2));
        }
        if (this.m_currentBuffer.remaining() >= n2) {
            this.m_currentBuffer.get(byArray, n, n2);
            return n2;
        }
        int n5 = this.m_currentBuffer.remaining();
        if (n5 > 0) {
            this.m_currentBuffer.get(byArray, n, n5);
            n += n5;
            n2 -= n5;
        }
        this.fill(n2);
        if (!this.m_currentBuffer.hasRemaining()) {
            if (n5 > 0) {
                return n5;
            }
            return -1;
        }
        int n6 = this.m_currentBuffer.remaining() < n2 ? this.m_currentBuffer.remaining() : n2;
        this.m_currentBuffer.get(byArray, n, n6);
        return n6 + n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fill(int n) throws IOException {
        if (this.m_currentBuffer.remaining() < n) {
            int n2;
            if (this.m_currentBuffer.remaining() == 0) {
                this.m_currentBuffer.clear();
                this.m_currentBuffer.limit(0);
            }
            if ((n2 = this.m_currentBuffer.position() + n) > this.m_currentBuffer.capacity()) {
                n2 = this.m_currentBuffer.capacity();
            }
            this.m_currentBuffer.mark();
            this.m_currentBuffer.position(this.m_currentBuffer.limit());
            this.m_currentBuffer.limit(this.m_currentBuffer.capacity());
            try {
                while (this.m_currentBuffer.position() < n2) {
                    if (this.m_channel.read(this.m_currentBuffer) == -1) break;
                }
                Object var4_3 = null;
                this.m_currentBuffer.limit(this.m_currentBuffer.position());
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_currentBuffer.limit(this.m_currentBuffer.position());
                this.m_currentBuffer.reset();
                throw throwable;
            }
            this.m_currentBuffer.reset();
            {
            }
        }
    }

    public int available() throws IOException {
        return this.m_currentBuffer.remaining();
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public synchronized void mark(int n) {
        throw new UnsupportedOperationException("mark not supported.");
    }

    public long skip(long l) throws IOException {
        throw new UnsupportedOperationException("skip not supported");
    }
}

