/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class ChannelOutputStream
extends OutputStream {
    private SocketChannel m_channel = null;
    private ByteBuffer m_outputBuffer = null;
    private int m_bufferSize = 0;

    public ChannelOutputStream(SocketChannel socketChannel, int n) throws SocketException, IOException {
        this.m_channel = socketChannel;
        if (n >= socketChannel.socket().getSendBufferSize()) {
            n = socketChannel.socket().getSendBufferSize() - 1;
        }
        this.m_bufferSize = n;
        this.m_outputBuffer = ByteBuffer.allocateDirect(this.m_bufferSize);
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
        this.m_outputBuffer.flip();
        this.m_channel.write(this.m_outputBuffer);
        this.m_outputBuffer.clear();
    }

    public boolean hasRoom(int n) {
        return this.m_outputBuffer.remaining() >= n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attemptFlush() throws IOException {
        Object object = this.m_channel.blockingLock();
        synchronized (object) {
            this.m_channel.configureBlocking(false);
            try {
                this.m_outputBuffer.flip();
                this.m_channel.write(this.m_outputBuffer);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_channel.configureBlocking(true);
                throw throwable;
            }
            this.m_channel.configureBlocking(true);
        }
        if (this.m_outputBuffer.hasRemaining()) {
            this.m_outputBuffer.compact();
            return false;
        }
        this.m_outputBuffer.clear();
        return true;
    }

    public final void write(int n) throws IOException {
        if (!this.m_outputBuffer.hasRemaining()) {
            this.flush();
        }
        this.m_outputBuffer.put((byte)n);
    }

    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public final void write(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        block3: {
            if (var3_3 < this.m_outputBuffer.capacity()) ** GOTO lbl19
            if (this.m_outputBuffer.position() > 0) {
                var4_4 = this.m_outputBuffer.remaining();
                this.m_outputBuffer.put(var1_1, var2_2, var4_4);
                var3_3 -= var4_4;
                var2_2 += var4_4;
                this.flush();
            }
            this.m_channel.write(ByteBuffer.wrap(var1_1, var2_2, var3_3));
            break block3;
lbl-1000:
            // 1 sources

            {
                if (!this.m_outputBuffer.hasRemaining()) {
                    this.flush();
                }
                var4_5 = this.m_outputBuffer.remaining() < var3_3 ? this.m_outputBuffer.remaining() : var3_3;
                this.m_outputBuffer.put(var1_1, var2_2, var4_5);
                var2_2 += var4_5;
                var3_3 -= var4_5;
lbl19:
                // 2 sources

                ** while (var3_3 > 0)
            }
        }
    }
}

