/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.tcp.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.security.Principal;
import progress.message.net.channel.ChannelInputStream;
import progress.message.net.channel.ChannelOutputStream;
import progress.message.net.tcp.AbstractTcpSocket;

public class ProgressTcpSocketChannel
extends AbstractTcpSocket {
    public ProgressTcpSocketChannel(Principal principal, String string, int n, Object object) throws UnknownHostException, IOException {
        super(principal, string, n, object);
    }

    ProgressTcpSocketChannel(Socket socket) throws IOException {
        super(socket);
    }

    protected Socket openSocket(String string, int n) throws IOException {
        try {
            this.m_impl = SocketChannel.open(new InetSocketAddress(string, n)).socket();
            return this.m_impl;
        }
        catch (UnresolvedAddressException unresolvedAddressException) {
            IOException iOException = new IOException(unresolvedAddressException.getMessage());
            iOException.initCause(unresolvedAddressException);
            throw iOException;
        }
        catch (UnsupportedAddressTypeException unsupportedAddressTypeException) {
            IOException iOException = new IOException(unsupportedAddressTypeException.getMessage());
            iOException.initCause(unsupportedAddressTypeException);
            throw iOException;
        }
    }

    public InputStream getInputStream(int n) throws IOException {
        return new ChannelInputStream(this.m_impl.getChannel(), n);
    }

    public OutputStream getOutputStream(int n) throws IOException {
        return new ChannelOutputStream(this.m_impl.getChannel(), n);
    }

    public InputStream getInputStream() throws IOException {
        return this.m_impl.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.m_impl.getOutputStream();
    }

    public void close() throws IOException {
        super.close();
    }
}

