/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security.cert;

import java.util.StringTokenizer;
import progress.message.security.cert.ECertificateException;
import progress.message.security.cert.prAccessor;

public class X500Name {
    private String kQB_ = null;
    private String lQB_ = null;
    private String mQB_ = null;
    private String nQB_ = null;
    private String oQB_ = null;
    private String pQB_ = null;
    private String qQB_ = null;
    public static final int CN = 1;
    public static final int OU = 2;
    public static final int O = 3;
    public static final int L = 4;
    public static final int S = 5;
    public static final int C = 6;
    public static final int E = 7;
    private static String rQB_ = ",";

    public X500Name(String string) throws ECertificateException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                if (n == -1) continue;
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                if (string3.equalsIgnoreCase("CN")) {
                    this.setRDN(1, string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("OU")) {
                    this.setRDN(2, string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("O")) {
                    this.setRDN(3, string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("L")) {
                    this.setRDN(4, string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("S") || string3.equalsIgnoreCase("ST")) {
                    this.setRDN(5, string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("C")) {
                    this.setRDN(6, string4);
                    continue;
                }
                if (!string3.equalsIgnoreCase("E") && !string3.equalsIgnoreCase("Email")) continue;
                this.setRDN(7, string4);
            }
        }
        catch (Exception exception) {
            String string5 = prAccessor.getString(prAccessor.getString("STR141"));
            ECertificateException eCertificateException = new ECertificateException(string5 + exception.getMessage());
            eCertificateException.fillInStackTrace();
            throw eCertificateException;
        }
    }

    public void setRDN(int n, String string) throws ECertificateException {
        switch (n) {
            case 6: {
                this.kQB_ = string;
                break;
            }
            case 5: {
                this.lQB_ = string;
                break;
            }
            case 4: {
                this.mQB_ = string;
                break;
            }
            case 3: {
                this.nQB_ = string;
                break;
            }
            case 2: {
                this.oQB_ = string;
                break;
            }
            case 1: {
                this.pQB_ = string;
                break;
            }
            case 7: {
                this.qQB_ = string;
                break;
            }
            default: {
                String string2 = prAccessor.getString(prAccessor.getString("STR142"));
                throw new ECertificateException(string2);
            }
        }
    }

    public String getRDN(int n) throws ECertificateException {
        String string = null;
        switch (n) {
            case 6: {
                string = this.kQB_;
                break;
            }
            case 5: {
                string = this.lQB_;
                break;
            }
            case 4: {
                string = this.mQB_;
                break;
            }
            case 3: {
                string = this.nQB_;
                break;
            }
            case 2: {
                string = this.oQB_;
                break;
            }
            case 1: {
                string = this.pQB_;
                break;
            }
            case 7: {
                string = this.qQB_;
                break;
            }
            default: {
                String string2 = prAccessor.getString(prAccessor.getString("STR142"));
                throw new ECertificateException(string2);
            }
        }
        return string;
    }

    public String toString() {
        String string = null;
        if (this.pQB_ != null) {
            string = string != null ? string + rQB_ : "";
            string = string + "CN=" + this.pQB_;
        }
        if (this.qQB_ != null) {
            string = string != null ? string + rQB_ : "";
            string = string + "E=" + this.qQB_;
        }
        if (this.nQB_ != null) {
            string = string != null ? string + rQB_ : "";
            string = string + "O=" + this.nQB_;
        }
        if (this.oQB_ != null) {
            string = string != null ? string + rQB_ : "";
            string = string + "OU=" + this.oQB_;
        }
        if (this.mQB_ != null) {
            string = string != null ? string + rQB_ : "";
            string = string + "L=" + this.mQB_;
        }
        if (this.lQB_ != null) {
            string = string != null ? string + rQB_ : "";
            string = string + "S=" + this.lQB_;
        }
        if (this.kQB_ != null) {
            string = string != null ? string + rQB_ : "";
            string = string + "C=" + this.kQB_;
        }
        return string;
    }
}

