/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import progress.message.util.EAssertFailure;

public final class ArrayUtil {
    private static final int TRB_ = 500;
    private static byte[] URB_ = new byte[500];

    private ArrayUtil() {
    }

    public static void clear(byte[] byArray) {
        ArrayUtil.clear(byArray, 0, byArray.length);
    }

    public static void clear(byte[] byArray, int n, int n2) {
        if (n2 <= 500) {
            System.arraycopy(URB_, 0, byArray, n, n2);
        } else {
            System.arraycopy(URB_, 0, byArray, n, 500);
            int n3 = n2 / 2;
            int n4 = 500;
            while (n4 < n2) {
                System.arraycopy(byArray, n, byArray, n + n4, n4 <= n3 ? n4 : n2 - n4);
                n4 += n4;
            }
        }
    }

    public static final double readDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(ArrayUtil.readLong(byArray, n));
    }

    public static final float readFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(ArrayUtil.readInt(byArray, n));
    }

    public static final long readLong(byte[] byArray, int n) {
        long l = ((long)byArray[n++] & 0xFFL) << 56;
        l |= ((long)byArray[n++] & 0xFFL) << 48;
        l |= ((long)byArray[n++] & 0xFFL) << 40;
        l |= ((long)byArray[n++] & 0xFFL) << 32;
        l |= ((long)byArray[n++] & 0xFFL) << 24;
        l |= ((long)byArray[n++] & 0xFFL) << 16;
        l |= ((long)byArray[n++] & 0xFFL) << 8;
        return l |= (long)byArray[n] & 0xFFL;
    }

    public static void writeLong(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l >>> 56);
        byArray[n++] = (byte)(l >>> 48);
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 8);
        byArray[n] = (byte)l;
    }

    public static final int readInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24;
        n2 |= (byArray[++n] & 0xFF) << 16;
        n2 |= (byArray[++n] & 0xFF) << 8;
        return n2 |= byArray[++n] & 0xFF;
    }

    public static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >>> 24);
        byArray[n++] = (byte)(n2 >>> 16);
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n] = (byte)n2;
    }

    public static final char readChar(byte[] byArray, int n) {
        byte by = byArray[n++];
        byte by2 = byArray[n];
        return (char)((by << 8) + (by2 << 0));
    }

    public static final long read6ByteLong(byte[] byArray, int n) {
        long l = ((long)byArray[n++] & 0xFFL) << 40;
        l |= ((long)byArray[n++] & 0xFFL) << 32;
        l |= ((long)byArray[n++] & 0xFFL) << 24;
        l |= ((long)byArray[n++] & 0xFFL) << 16;
        l |= ((long)byArray[n++] & 0xFFL) << 8;
        return l |= (long)byArray[n] & 0xFFL;
    }

    public static final int getUTFStringLength(byte[] byArray, int n) {
        int n2 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        return n2 + 2;
    }

    public static int getObjectSize(byte[] byArray, int n) {
        byte by = byArray[n];
        ++n;
        int n2 = 1;
        switch (by) {
            case 0: {
                ++n2;
                break;
            }
            case 1: {
                ++n2;
                break;
            }
            case 9: {
                int n3 = ArrayUtil.readInt(byArray, n);
                n2 += n3 + 4;
                break;
            }
            case 3: {
                ++n2;
                break;
            }
            case 7: {
                n2 += 8;
                break;
            }
            case 6: {
                n2 += 4;
                break;
            }
            case 4: {
                n2 += 4;
                break;
            }
            case 5: {
                n2 += 8;
                break;
            }
            case 2: {
                n2 += 2;
                break;
            }
            case 8: {
                n2 += ArrayUtil.getUTFStringLength(byArray, n);
                break;
            }
            case 10: 
            case 11: {
                n2 += 0;
                break;
            }
            default: {
                throw new EAssertFailure("Unexpected type code found in stream");
            }
        }
        return n2;
    }

    public static Object readObject(byte[] byArray, int n) {
        byte by = byArray[n];
        ++n;
        switch (by) {
            case 0: {
                return new Boolean(byArray[n] != 0);
            }
            case 1: {
                return new Byte(byArray[n]);
            }
            case 9: {
                int n2 = ArrayUtil.readInt(byArray, n);
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n += 4, byArray2, 0, n2);
                return byArray2;
            }
            case 3: {
                return new Character(ArrayUtil.readChar(byArray, n));
            }
            case 7: {
                return new Double(ArrayUtil.readDouble(byArray, n));
            }
            case 6: {
                return new Float(ArrayUtil.readFloat(byArray, n));
            }
            case 4: {
                return new Integer(ArrayUtil.readInt(byArray, n));
            }
            case 5: {
                return new Long(ArrayUtil.readLong(byArray, n));
            }
            case 2: {
                return new Short(ArrayUtil.readShort(byArray, n));
            }
            case 8: {
                return ArrayUtil.getUTFString(byArray, n);
            }
            case 10: 
            case 11: {
                return "";
            }
        }
        throw new EAssertFailure("Unexpected type code found in stream");
    }

    public static void write6ByteLong(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 8);
        byArray[n] = (byte)l;
    }

    public static short readShort(byte[] byArray, int n) {
        int n2 = byArray[n++] << 8;
        return (short)(n2 |= byArray[n] & 0xFF);
    }

    public static void writeShort(byte[] byArray, int n, short s) {
        byArray[n++] = (byte)(s >>> 8);
        byArray[n] = (byte)s;
    }

    public static String getString(byte[] byArray, int n) {
        int n2 = (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        return new String(byArray, n + 1, n2);
    }

    public static String getUTFString(byte[] byArray, int n) {
        int n2 = (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        int n3 = n + 1;
        char[] cArray = new char[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            int n6 = byArray[n3++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n4;
                    cArray[n5++] = (char)n6;
                    break;
                }
                case 12: 
                case 13: {
                    int n7;
                    if ((n4 += 2) > n2) {
                        throw new EAssertFailure("Unexpected UTF format found in stream");
                    }
                    if (((n7 = byArray[n3++] & 0xFF) & 0xC0) != 128) {
                        throw new EAssertFailure("Unexpected UTF format found in stream");
                    }
                    cArray[n5++] = (char)((n6 & 0x1F) << 6 | n7 & 0x3F);
                    break;
                }
                case 14: {
                    if ((n4 += 3) > n2) {
                        throw new EAssertFailure("Unexpected UTF format found in stream");
                    }
                    int n7 = byArray[n3++] & 0xFF;
                    int n8 = byArray[n3++] & 0xFF;
                    if ((n7 & 0xC0) != 128 || (n8 & 0xC0) != 128) {
                        throw new EAssertFailure("Unexpected UTF format found in stream");
                    }
                    cArray[n5++] = (char)((n6 & 0xF) << 12 | (n7 & 0x3F) << 6 | (n8 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new EAssertFailure("Unexpected UTF found in stream");
                }
            }
        }
        return new String(cArray, 0, n5);
    }

    public static String getHexString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            string = string + ArrayUtil.getHexChar(byArray[n]) + " ";
            ++n;
        }
        return string;
    }

    public static String getHexChar(byte by) {
        return ArrayUtil.qTB_((byte)(by >> 4)) + ArrayUtil.qTB_(by);
    }

    private static String qTB_(byte by) {
        switch (by & 0xF) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
            case 3: {
                return "3";
            }
            case 4: {
                return "4";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
            case 9: {
                return "9";
            }
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
        }
        return "?";
    }

    public static int toInt(short s, short s2) {
        return s & 0xFFFF | s2 << 16;
    }

    public static byte[] IntToByte(int[] nArray) {
        byte[] byArray = new byte[4 * nArray.length + 2];
        ArrayUtil.writeShort(byArray, 0, (short)nArray.length);
        int n = 0;
        while (n < nArray.length) {
            ArrayUtil.writeInt(byArray, n * 4 + 2, nArray[n]);
            ++n;
        }
        return byArray;
    }

    public static short toShort(byte by, byte by2) {
        return (short)(by & 0xFF | by2 << 8);
    }

    public static byte[] toBytes(int n) {
        byte[] byArray = new byte[4];
        ArrayUtil.writeInt(byArray, 0, n);
        return byArray;
    }

    public static byte[] toBytes(short[] sArray, int n, int n2) {
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            byArray[n3++] = (byte)(sArray[n4] >>> 8 & 0xFF);
            byArray[n3++] = (byte)(sArray[n4] & 0xFF);
            ++n4;
        }
        return byArray;
    }

    public static byte[] toBytes(short[] sArray) {
        return ArrayUtil.toBytes(sArray, 0, sArray.length);
    }

    public static short[] toShorts(byte[] byArray, int n, int n2) {
        short[] sArray = new short[n2 / 2];
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2 - 1) {
            sArray[n3++] = (short)((byArray[n4] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF);
            n4 += 2;
        }
        return sArray;
    }

    public static short[] toShorts(byte[] byArray) {
        return ArrayUtil.toShorts(byArray, 0, byArray.length);
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (n != nArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int compared(byte[] byArray, byte[] byArray2, boolean bl) {
        int n = byArray.length;
        if (n < byArray2.length) {
            return -1;
        }
        if (n > byArray2.length) {
            return 1;
        }
        if (bl) {
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = byArray[n2] & 0xFF;
                int n4 = byArray2[n2] & 0xFF;
                if (n3 < n4) {
                    return -1;
                }
                if (n3 > n4) {
                    return 1;
                }
                --n2;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                int n6 = byArray[n5] & 0xFF;
                int n7 = byArray2[n5] & 0xFF;
                if (n6 < n7) {
                    return -1;
                }
                if (n6 > n7) {
                    return 1;
                }
                ++n5;
            }
        }
        return 0;
    }

    public static boolean isText(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 < 32 || n3 > 127) {
                switch (n3) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 26: 
                    case 27: 
                    case 155: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ++n2;
        }
        return true;
    }
}

