/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public final class StreamUtil {
    static byte[] weB_ = new byte[255];

    public static short readShort(InputStream inputStream) throws IOException {
        int n = StreamUtil.readByte(inputStream) << 8;
        return (short)(n |= StreamUtil.readByte(inputStream) & 0xFF);
    }

    public static long readLong(InputStream inputStream) throws IOException {
        long l = ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 56;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 48;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 40;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 32;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 24;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 16;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 8;
        return l |= (long)StreamUtil.readByte(inputStream) & 0xFFL;
    }

    public static long read6ByteLong(InputStream inputStream) throws IOException {
        long l = ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 40;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 32;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 24;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 16;
        l |= ((long)StreamUtil.readByte(inputStream) & 0xFFL) << 8;
        return l |= (long)StreamUtil.readByte(inputStream) & 0xFFL;
    }

    public static int readInt(InputStream inputStream) throws IOException {
        int n = (StreamUtil.readByte(inputStream) & 0xFF) << 24;
        n |= (StreamUtil.readByte(inputStream) & 0xFF) << 16;
        n |= (StreamUtil.readByte(inputStream) & 0xFF) << 8;
        return n |= StreamUtil.readByte(inputStream) & 0xFF;
    }

    public static byte[] readUTFString(InputStream inputStream) throws IOException {
        byte by = StreamUtil.readByte(inputStream);
        byte by2 = StreamUtil.readByte(inputStream);
        int n = (by & 0xFF) << 8 | by2 & 0xFF;
        byte[] byArray = new byte[n + 2];
        byArray[0] = by;
        byArray[1] = by2;
        StreamUtil.readBytes(inputStream, byArray, 2, n);
        return byArray;
    }

    public static final String readUTF(InputStream inputStream) throws IOException {
        byte by = StreamUtil.readByte(inputStream);
        byte by2 = StreamUtil.readByte(inputStream);
        int n = (by & 0xFF) << 8 | by2 & 0xFF;
        char[] cArray = new char[n];
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        StreamUtil.readBytes(inputStream, byArray, 0, n);
        while (n2 < n) {
            int n4 = byArray[n2] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by3 = byArray[n2 - 1];
                    if ((by3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | by3 & 0x3F);
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by3 = byArray[n2 - 2];
                    byte by4 = byArray[n2 - 1];
                    if ((by3 & 0xC0) != 128 || (by4 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (by3 & 0x3F) << 6 | (by4 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public static void writeUTF(String string, OutputStream outputStream) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        int n4 = 0;
        while (n4 < n) {
            c = cArray[n4];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n4;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n2 + 2];
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        int n5 = 0;
        while (n5 < n) {
            c = cArray[n5];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n5;
        }
        outputStream.write(byArray);
    }

    public static void skip(InputStream inputStream, int n) throws IOException {
        int n2 = 0;
        if (n > 0) {
            while (n2 < n) {
                int n3 = 0;
                n3 = n - n2 > weB_.length ? inputStream.read(weB_, 0, weB_.length) : (n3 += inputStream.read(weB_, 0, n - n2));
                if (n3 == -1) {
                    throw new EOFException();
                }
                n2 += n3;
            }
        }
    }

    public static void readBytes(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            n3 += n4;
        }
        byArray = null;
    }

    public static final byte readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)(n & 0xFF);
    }

    public static final boolean readBoolean(InputStream inputStream) throws IOException {
        byte by = StreamUtil.readByte(inputStream);
        return by == 1;
    }

    public static void writeLong(long l, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l >>> 56));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)l);
    }

    public static void writeInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >>> 24));
        outputStream.write((byte)(n >>> 16));
        outputStream.write((byte)(n >>> 8));
        outputStream.write((byte)n);
    }

    public static void writeByte(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
    }

    public static void writeShort(short s, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(s >>> 8));
        outputStream.write((byte)s);
    }

    public static void write6ByteLong(long l, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)l);
    }

    public static void writeBoolean(boolean bl, OutputStream outputStream) throws IOException {
        outputStream.write(bl ? 1 : 0);
    }
}

