/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.DataInput;
import java.io.IOException;
import progress.message.util.EMessageFormatException;

public class TypedInputStream {
    static final int E_ = 0;
    static final int F_ = 1;
    static final int G_ = 2;
    static final int H_ = 3;
    static final int I_ = 4;
    static final int J_ = 5;
    static final int K_ = 6;
    static final int L_ = 7;
    static final int M_ = 8;
    static final int N_ = 9;
    static final int gs_ = 10;
    static final int hs_ = 11;
    private int P_ = -1;
    private DataInput Q_ = null;

    public TypedInputStream(DataInput dataInput) {
        this.Q_ = dataInput;
    }

    public boolean readBoolean() throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 0: {
                this.TKB_();
                return this.Q_.readBoolean();
            }
            case 8: {
                this.TKB_();
                return Boolean.valueOf(this.Q_.readUTF());
            }
            case 10: 
            case 11: {
                this.TKB_();
                return false;
            }
        }
        throw new EMessageFormatException("");
    }

    public byte readByte() throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 1: {
                this.TKB_();
                return this.Q_.readByte();
            }
            case 8: {
                this.TKB_();
                return Byte.valueOf(this.Q_.readUTF());
            }
            case 10: 
            case 11: {
                this.TKB_();
                return 0;
            }
        }
        throw new EMessageFormatException("");
    }

    public int readBytes(byte[] byArray) throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 9: {
                this.TKB_();
                int n = this.Q_.readInt();
                int n2 = byArray.length > n ? n : byArray.length;
                this.Q_.readFully(byArray, 0, n2);
                this.Q_.skipBytes(n - n2);
                return n2;
            }
        }
        throw new EMessageFormatException("");
    }

    public char readChar() throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 3: {
                this.TKB_();
                return this.Q_.readChar();
            }
            case 8: {
                this.TKB_();
                String string = this.Q_.readUTF();
                if (string.length() == 0) {
                    return '\u0000';
                }
                return string.charAt(0);
            }
            case 10: 
            case 11: {
                this.TKB_();
                return '\u0000';
            }
        }
        throw new EMessageFormatException("");
    }

    public double readDouble() throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 7: {
                this.TKB_();
                return this.Q_.readDouble();
            }
            case 6: {
                this.TKB_();
                return new Float(this.Q_.readFloat()).doubleValue();
            }
            case 8: {
                this.TKB_();
                return Double.valueOf(this.Q_.readUTF());
            }
        }
        throw new EMessageFormatException("");
    }

    public float readFloat() throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 6: {
                this.TKB_();
                return this.Q_.readFloat();
            }
            case 8: {
                this.TKB_();
                return Float.valueOf(this.Q_.readUTF()).floatValue();
            }
        }
        throw new EMessageFormatException("");
    }

    public int readInt() throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 4: {
                this.TKB_();
                return this.Q_.readInt();
            }
            case 1: {
                this.TKB_();
                return this.Q_.readByte();
            }
            case 2: {
                this.TKB_();
                return this.Q_.readShort();
            }
            case 8: {
                this.TKB_();
                return Integer.valueOf(this.Q_.readUTF());
            }
        }
        throw new EMessageFormatException("");
    }

    public long readLong() throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 5: {
                this.TKB_();
                return this.Q_.readLong();
            }
            case 1: {
                this.TKB_();
                return this.Q_.readByte();
            }
            case 2: {
                this.TKB_();
                return this.Q_.readShort();
            }
            case 4: {
                this.TKB_();
                return this.Q_.readInt();
            }
            case 8: {
                this.TKB_();
                return Long.valueOf(this.Q_.readUTF());
            }
        }
        throw new EMessageFormatException("");
    }

    public Object readObject() throws IOException {
        switch (this.SKB_()) {
            case 0: {
                this.TKB_();
                return new Boolean(this.Q_.readBoolean());
            }
            case 1: {
                this.TKB_();
                return new Byte(this.Q_.readByte());
            }
            case 9: {
                this.TKB_();
                int n = this.Q_.readInt();
                byte[] byArray = new byte[n];
                this.Q_.readFully(byArray);
                return byArray;
            }
            case 3: {
                this.TKB_();
                return new Character(this.Q_.readChar());
            }
            case 7: {
                this.TKB_();
                return new Double(this.Q_.readDouble());
            }
            case 6: {
                this.TKB_();
                return new Float(this.Q_.readFloat());
            }
            case 4: {
                this.TKB_();
                return new Integer(this.Q_.readInt());
            }
            case 5: {
                this.TKB_();
                return new Long(this.Q_.readLong());
            }
            case 2: {
                this.TKB_();
                return new Short(this.Q_.readShort());
            }
            case 8: {
                this.TKB_();
                return this.Q_.readUTF();
            }
            case 10: 
            case 11: {
                this.TKB_();
                return "";
            }
        }
        throw new IOException("Unexpected type code found in stream");
    }

    public short readShort() throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 2: {
                this.TKB_();
                return this.Q_.readShort();
            }
            case 1: {
                this.TKB_();
                return this.Q_.readByte();
            }
            case 8: {
                this.TKB_();
                return Short.valueOf(this.Q_.readUTF());
            }
        }
        throw new EMessageFormatException("");
    }

    public String readString() throws IOException, EMessageFormatException {
        switch (this.SKB_()) {
            case 8: {
                this.TKB_();
                return this.Q_.readUTF();
            }
            case 0: {
                this.TKB_();
                return String.valueOf(this.Q_.readBoolean());
            }
            case 1: {
                this.TKB_();
                return String.valueOf(this.Q_.readByte());
            }
            case 3: {
                this.TKB_();
                return String.valueOf(this.Q_.readChar());
            }
            case 7: {
                this.TKB_();
                return String.valueOf(this.Q_.readDouble());
            }
            case 6: {
                this.TKB_();
                return String.valueOf(this.Q_.readFloat());
            }
            case 4: {
                this.TKB_();
                return String.valueOf(this.Q_.readInt());
            }
            case 5: {
                this.TKB_();
                return String.valueOf(this.Q_.readLong());
            }
            case 2: {
                this.TKB_();
                return String.valueOf(this.Q_.readShort());
            }
            case 10: 
            case 11: {
                this.TKB_();
                return "";
            }
        }
        throw new EMessageFormatException("");
    }

    private int SKB_() throws IOException {
        if (this.P_ == -1) {
            this.P_ = this.Q_.readByte();
        }
        return this.P_;
    }

    private void TKB_() {
        this.P_ = -1;
    }
}

