/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.jclient;

import java.io.DataOutput;
import java.io.IOException;
import javax.jms.MessageFormatException;

public class StreamMessageOutputStream {
    static final int E_ = 0;
    static final int F_ = 1;
    static final int G_ = 2;
    static final int H_ = 3;
    static final int I_ = 4;
    static final int J_ = 5;
    static final int K_ = 6;
    static final int L_ = 7;
    static final int M_ = 8;
    static final int N_ = 9;
    static final int O_ = 10;
    private DataOutput is_ = null;

    public StreamMessageOutputStream(DataOutput dataOutput) {
        this.is_ = dataOutput;
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.is_.writeByte(0);
        this.is_.writeBoolean(bl);
    }

    public void writeByte(byte by) throws IOException {
        this.is_.writeByte(1);
        this.is_.writeByte(by);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.is_.writeByte(9);
        this.is_.writeInt(byArray.length);
        this.is_.write(byArray);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.is_.writeByte(9);
        this.is_.writeInt(n2);
        this.is_.write(byArray, n, n2);
    }

    public void writeChar(char c) throws IOException {
        this.is_.writeByte(3);
        this.is_.writeChar(c);
    }

    public void writeDouble(double d) throws IOException {
        this.is_.writeByte(7);
        this.is_.writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        this.is_.writeByte(6);
        this.is_.writeFloat(f);
    }

    public void writeInt(int n) throws IOException {
        this.is_.writeByte(4);
        this.is_.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.is_.writeByte(5);
        this.is_.writeLong(l);
    }

    public void writeObject(Object object) throws IOException, MessageFormatException {
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object == null) {
            this.writeNull();
        } else {
            throw new MessageFormatException("");
        }
    }

    public void writeShort(short s) throws IOException {
        this.is_.writeByte(2);
        this.is_.writeShort(s);
    }

    public void writeString(String string) throws IOException {
        this.is_.writeByte(8);
        this.is_.writeUTF(string);
    }

    public void writeNull() throws IOException {
        this.is_.writeByte(10);
    }
}

