/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import progress.message.client.EInterrupted;
import progress.message.client.EInterruptedByFailover;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.ETimeout;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.IndexedList;
import progress.message.util.ListNode;
import progress.message.zclient.ClientOutQueue;
import progress.message.zclient.ClientSender;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EFlowControlException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IAckCommitListener;
import progress.message.zclient.IMgramEnqueuedToSendListener;
import progress.message.zclient.IQuencher;
import progress.message.zclient.Job;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.PayloadSenderQueue;
import progress.message.zclient.PayloadWrapper;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.Request;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.mg;
import progress.message.zclient.prAccessor;
import progress.message.zclient.qv;
import progress.message.zclient.xd;
import progress.message.zclient.xonce.IInboundContext;
import progress.message.zclient.xonce.IMsgTracker;
import progress.message.zclient.xonce.IOutboundContext;
import progress.message.zclient.xonce.IRecoveryMutex;

public class ConnectionInfo
extends DebugObject
implements IQuencher,
IInboundContext,
IOutboundContext,
IRecoveryMutex,
IAckCommitListener {
    private Connection iU_;
    private ClientOutQueue od_;
    private PrioQueueLimiter pd_;
    private IndexedList qd_;
    private PrioQueueLimiter rd_;
    private PayloadSenderQueue sd_;
    private int td_;
    private int ud_;
    private int vd_;
    private boolean wd_ = false;
    private boolean xd_ = false;
    private long yd_;
    private int zd_;
    private Hashtable Ae_ = new Hashtable();
    private Hashtable Be_ = new Hashtable();
    private long uG_ = -1L;
    private volatile boolean Ce_ = false;
    private Vector De_;
    private Vector Ee_;
    private boolean Fe_ = false;

    ConnectionInfo(Connection connection) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ConnectionInfo" : null);
        this.iU_ = connection;
        this.od_ = new ClientOutQueue(13);
        this.qd_ = new IndexedList();
        this.pd_ = new PrioQueueLimiter(250000, 5000, 50000, this);
        this.rd_ = new PrioQueueLimiter(250000, 5000, 50000, new mg(this));
        this.sd_ = new PayloadSenderQueue(this, this.od_, this.pd_, this.qd_, this.rd_, connection.getRoutingNodeName());
        this.De_ = new Vector();
        this.Ee_ = new Vector();
    }

    public Connection getConnection() {
        return this.iU_;
    }

    synchronized PayloadWrapper vX_(long l) {
        PayloadWrapper payloadWrapper = null;
        try {
            payloadWrapper = (PayloadWrapper)this.sd_.nack(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return payloadWrapper;
    }

    synchronized IMgram wX_(long l, IMgram iMgram) {
        IMgram iMgram2 = null;
        if (this.handleGuarAckAck(l)) {
            return null;
        }
        ListNode listNode = this.qd_.remove(l);
        if (listNode != null) {
            Object object;
            PayloadWrapper payloadWrapper = (PayloadWrapper)listNode.obj;
            if (!payloadWrapper.isTransacted()) {
                this.rd_.add(-payloadWrapper.getLength(), payloadWrapper.getPriority());
            }
            if ((object = payloadWrapper.getPayload()) instanceof IMgram) {
                iMgram2 = (IMgram)payloadWrapper.getPayload();
            }
        }
        if (iMgram != null && iMgram.isGuarenteed()) {
            switch (iMgram.getType()) {
                case 3: 
                case 14: {
                    this.sendAckAck(iMgram);
                }
            }
        }
        return iMgram2;
    }

    synchronized void xX_() {
        this.notifyAll();
        this.sd_.dumpOutQueue();
        this.HY_(0);
        xd xd2 = null;
        if (this.iU_ != null && (xd2 = this.iU_.GRB_()) != null) {
            xd2.resetMinEnqueuePriority();
        }
    }

    public void dumpOutQueue() {
        this.sd_.dumpOutQueue();
    }

    public void onDisconnectDuringResolution() {
        this.sd_.dumpOutQueue();
        this.HY_(0);
        xd xd2 = null;
        if (this.iU_ != null && (xd2 = this.iU_.GRB_()) != null) {
            xd2.resetMinEnqueuePriority();
        }
    }

    synchronized void yX_() {
    }

    synchronized void zX_(String string, boolean bl) {
        try {
            this.sd_.onBlock(string, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void AY_(String string, boolean bl) {
        this.sd_.onResumeBegin(string, bl);
        if (this.Be_.get(string) != null) {
            this.Ae_.remove(string);
            this.Be_.clear();
            this.NY_();
        }
    }

    synchronized void BY_(String string, boolean bl) {
        this.sd_.onResumeComplete(string, bl);
    }

    synchronized boolean CY_(String string) {
        return this.sd_.isDestinationBlocked(string);
    }

    synchronized boolean DY_(long l) {
        return this.sd_.isAsyncDelivery(l);
    }

    synchronized void EY_() {
        this.notifyAll();
    }

    synchronized PayloadWrapper FY_(long l) {
        PayloadWrapper payloadWrapper;
        ListNode listNode = this.qd_.remove(l);
        if (listNode != null && !(payloadWrapper = (PayloadWrapper)listNode.obj).isTransacted()) {
            this.rd_.add(-payloadWrapper.getLength(), payloadWrapper.getPriority());
        }
        return (PayloadWrapper)listNode.obj;
    }

    public synchronized void setMinEnqueuePriority(int n) {
        this.td_ = n;
        this.notifyAll();
    }

    synchronized void GY_(int n) {
        this.ud_ = n;
        this.notifyAll();
    }

    synchronized void HY_(int n) {
        this.vd_ = n;
        if (this.wd_ && n <= this.zd_) {
            this.wd_ = false;
            this.zd_ = -1;
            if (this.xd_) {
                this.xd_ = false;
                this.KY_();
            }
        }
    }

    synchronized void IY_() {
        int n = this.od_.getEnqueuedBelow(this.vd_);
        if (n > 0) {
            if (!this.wd_) {
                this.wd_ = true;
                this.zd_ = this.od_.getMaxNonEmptyPriorityBelow(this.vd_);
                this.yd_ = System.currentTimeMillis();
                return;
            }
            long l = System.currentTimeMillis() - this.yd_;
            this.xd_ = true;
            this.JY_(l);
        }
    }

    private synchronized void JY_(long l) {
        String string = this.iU_.getPrincipal().getName();
        String string2 = this.iU_.getApplicationId();
        String string3 = SessionConfig.getAdminPrefix(string, string2) + ".pubblocked";
        try {
            Message message = new Message(string3);
            message.writeLong(this.iU_.getClientId());
            message.writeInt(this.vd_);
            message.writeLong(l);
            Label label = new Label();
            label.setPriority((byte)12);
            label.setRouteLimit(1);
            Envelope envelope = new Envelope(message, label);
            this.UY_(envelope, message.getSubject(), null);
        }
        catch (ENetworkFailure eNetworkFailure) {
            // empty catch block
        }
    }

    private synchronized void KY_() {
        String string = this.iU_.getPrincipal().getName();
        String string2 = this.iU_.getApplicationId();
        String string3 = SessionConfig.getAdminPrefix(string, string2) + ".pubresumed";
        try {
            Message message = new Message(string3);
            message.writeLong(this.iU_.getClientId());
            Label label = new Label();
            label.setPriority((byte)12);
            label.setRouteLimit(1);
            Envelope envelope = new Envelope(message, label);
            this.UY_(envelope, message.getSubject(), null);
        }
        catch (ENetworkFailure eNetworkFailure) {
            // empty catch block
        }
    }

    synchronized void LY_() {
        if (this.sd_.checkForBlockedMsgs()) {
            String[] stringArray = this.sd_.getBlockedDestinations();
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < stringArray.length) {
                if (this.Ae_.containsKey(stringArray[n])) {
                    vector.addElement(stringArray[n]);
                    this.Be_.put(stringArray[n], stringArray[n]);
                }
                ++n;
            }
            this.Ae_.clear();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.Ae_.put(stringArray[n2], stringArray[n2]);
                ++n2;
            }
            if (vector.size() > 0) {
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                this.MY_((String[])objectArray);
            }
        } else {
            this.Ae_.clear();
        }
    }

    private synchronized void MY_(String[] stringArray) {
        String string = this.iU_.getPrincipal().getName();
        String string2 = this.iU_.getApplicationId();
        String string3 = SessionConfig.getAdminPrefix(string, string2) + ".sendblocked";
        try {
            Message message = new Message(string3);
            message.writeInt(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("$Q.")) {
                    message.writeUTF(stringArray[n].substring("$Q.".length()));
                } else {
                    message.writeUTF(stringArray[n]);
                }
                ++n;
            }
            Label label = new Label();
            label.setPriority((byte)12);
            label.setRouteLimit(1);
            Envelope envelope = new Envelope(message, label);
            this.UY_(envelope, message.getSubject(), null);
        }
        catch (ENetworkFailure eNetworkFailure) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void NY_() {
        String string = this.iU_.getPrincipal().getName();
        String string2 = this.iU_.getApplicationId();
        String string3 = SessionConfig.getAdminPrefix(string, string2) + ".sendresumed";
        try {
            Message message = new Message(string3);
            Label label = new Label();
            label.setPriority((byte)12);
            label.setRouteLimit(1);
            Envelope envelope = new Envelope(message, label);
            this.UY_(envelope, message.getSubject(), null);
        }
        catch (ENetworkFailure eNetworkFailure) {
            // empty catch block
        }
    }

    synchronized void OY_() {
        this.LY_();
        this.IY_();
    }

    synchronized boolean PY_(byte by) throws ENotConnected, EInterruptedByFailover, InterruptedException {
        return this.QY_(by, false, false, null);
    }

    synchronized boolean QY_(byte by, boolean bl, boolean bl2, String string) throws ENotConnected, EInterruptedByFailover, InterruptedException {
        if (!(by < this.td_ || bl && by < this.ud_)) {
            return true;
        }
        if (this.iU_.YRB_()) {
            return true;
        }
        if (this.SY_() || this.Ce_) {
            throw new ENotConnected();
        }
        do {
            if (bl2 && string != null && this.CY_(string)) {
                return false;
            }
            this.wait();
            if (!this.SY_() && !this.Ce_) continue;
            throw new ENotConnected();
        } while (by < this.td_ || bl && by < this.ud_);
        return true;
    }

    synchronized boolean RY_(byte by, long l) throws ENotConnected, ETimeout, EInterruptedByFailover, InterruptedException {
        if (by >= this.td_) {
            return true;
        }
        if (this.iU_.YRB_()) {
            return true;
        }
        if (this.SY_() || this.Ce_) {
            throw new ENotConnected();
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        while (l2 < l3) {
            this.wait(l3 - l2);
            if (this.SY_() || this.Ce_) {
                throw new ENotConnected();
            }
            if (by >= this.td_) {
                return true;
            }
            l2 = System.currentTimeMillis();
        }
        throw new ETimeout();
    }

    private boolean SY_() throws EInterruptedByFailover {
        if (!this.isFaultTolerant()) {
            return this.TY_().getConnDropped();
        }
        if (this.iU_.inRecoveryState()) {
            throw new EInterruptedByFailover();
        }
        return this.iU_.ERB_() == 1 || this.iU_.ERB_() == 2;
    }

    private ClientSender TY_() {
        return (ClientSender)this.iU_.getSender();
    }

    public synchronized void send(Envelope envelope) throws ENetworkFailure, EInterrupted, EFlowControlException {
        this.send(envelope, null);
    }

    public synchronized void send(Envelope envelope, IMgramEnqueuedToSendListener iMgramEnqueuedToSendListener) throws ENetworkFailure, EInterrupted, EFlowControlException {
        try {
            boolean bl;
            byte by = envelope.getPriority();
            boolean bl2 = envelope.YEC_() && (envelope.isQueueMessage() || !envelope.isDiscardable());
            String string = envelope.getMessage() == null ? null : envelope.getMessage().getSubject();
            boolean bl3 = false;
            String string2 = null;
            String string3 = envelope.getRouting();
            string2 = string3 != null && envelope.isQueueMessage() ? (string3.equals("") ? "::" + string : string3 + "::" + string) : string;
            if (string != null && !string.startsWith("$ISYS.") && this.iU_.isFlowControlDisabled()) {
                if (by < this.vd_) {
                    throw new EFlowControlException(301, prAccessor.getString("STR183"));
                }
                if (envelope.isQueueMessage() || !envelope.isDiscardable()) {
                    bl = this.CY_(string2);
                    if (bl) {
                        if (envelope.isQueueMessage()) {
                            throw new EFlowControlException(311, prAccessor.getString("QUEUE_DEST_BLOCKED"));
                        }
                        throw new EFlowControlException(311, prAccessor.getString("TOPIC_DEST_BLOCKED"));
                    }
                    bl3 = envelope.isAsyncDelivery();
                }
            }
            bl = this.QY_(by, bl2, bl3, string2);
            if (bl3 && !bl) {
                if (envelope.isQueueMessage()) {
                    throw new EFlowControlException(311, prAccessor.getString("QUEUE_DEST_BLOCKED"));
                }
                throw new EFlowControlException(311, prAccessor.getString("TOPIC_DEST_BLOCKED"));
            }
            this.UY_(envelope, string2, iMgramEnqueuedToSendListener);
        }
        catch (InterruptedException interruptedException) {
            throw new EInterrupted();
        }
    }

    public synchronized void send(Envelope envelope, long l) throws ENetworkFailure, ETimeout, EInterrupted, EFlowControlException {
        this.send(envelope, l, null);
    }

    public synchronized void send(Envelope envelope, long l, IMgramEnqueuedToSendListener iMgramEnqueuedToSendListener) throws ENetworkFailure, ETimeout, EInterrupted, EFlowControlException {
        try {
            byte by = envelope.getPriority();
            String string = envelope.getMessage() == null ? null : envelope.getMessage().getSubject();
            String string2 = null;
            String string3 = envelope.getRouting();
            string2 = string3 != null && envelope.isQueueMessage() ? (string3.equals("") ? "::" + string : string3 + "::" + string) : string;
            if (string != null && !string.startsWith("$ISYS.") && this.iU_.isFlowControlDisabled() && by < this.vd_) {
                throw new EFlowControlException(301, prAccessor.getString("STR183"));
            }
            this.RY_(by, l);
            this.UY_(envelope, string2, iMgramEnqueuedToSendListener);
        }
        catch (InterruptedException interruptedException) {
            throw new EInterrupted();
        }
    }

    public synchronized void send(IMgram iMgram) {
        this.send(iMgram, null);
    }

    public synchronized void send(IMgram iMgram, IMgramEnqueuedToSendListener iMgramEnqueuedToSendListener) {
        try {
            if (this.zF_) {
                this.debug("got mgram type " + iMgram.getType() + ", size " + iMgram.networkLength());
            }
            byte by = iMgram.getPriority();
            try {
                this.PY_(by);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            try {
                if (iMgramEnqueuedToSendListener != null) {
                    iMgramEnqueuedToSendListener.enqueuedToSend(iMgram);
                }
                this.sd_.enqueue(iMgram, by);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.TY_().notifyMsgEnqueued();
        }
        catch (ENotConnected eNotConnected) {
        }
        catch (EInterruptedByFailover eInterruptedByFailover) {
            // empty catch block
        }
    }

    private void UY_(Envelope envelope, String string, IMgramEnqueuedToSendListener iMgramEnqueuedToSendListener) throws ENetworkFailure {
        byte by = envelope.getPriority();
        long l = envelope.getGuarTracking();
        long l2 = envelope.getExpirationTime();
        boolean bl = envelope.isAsyncDelivery();
        try {
            envelope.syncAll(this.iU_, this.TY_().getMessageProtection());
        }
        catch (IOException iOException) {
            SessionConfig.logMessage(iOException, SessionConfig.getLevelWarning());
        }
        if (iMgramEnqueuedToSendListener != null) {
            iMgramEnqueuedToSendListener.enqueuedToSend(envelope.getMgram());
        }
        this.sd_.enqueue(envelope.getMgram(), by, l, l2, string, bl);
        this.TY_().notifyMsgEnqueued();
    }

    public synchronized Object getNextMgram() {
        return this.sd_.dequeueAtOrAbove(this.vd_);
    }

    public boolean needsGuarAck() {
        return this.iU_.isFaultToleranceEnabled();
    }

    public void rcvdGuarQMsg(long l, IMsgTracker iMsgTracker) {
        if (this.isXOnce()) {
            this.Ee_.addElement(new Long(l));
        }
    }

    public void rcvdGuarMsg(long l, IMsgTracker iMsgTracker) {
        if (this.isXOnce()) {
            this.De_.addElement(new Long(l));
        }
    }

    public List getGuarQMsgTrkNums() {
        return (List)this.Ee_.clone();
    }

    public List getGuarMsgTrkNums() {
        return (List)this.De_.clone();
    }

    public void sendQAck(long l, IMgram iMgram, short s) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void setQAckPendingConfirm(long l, long l2) {
        throw new UnsupportedOperationException("Acknowldement tracking not supported for client");
    }

    public List getUnconfirmedGuarQAcks() {
        return new Vector();
    }

    public void sendAck(IMgram iMgram, short s) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void sendAck(long l, IMgram iMgram, short s) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void sendAck(long l, IMgram iMgram, long l2, short s) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void sendAckAck(IMgram iMgram) {
        if (iMgram != null && iMgram.isGuarenteed()) {
            switch (iMgram.getType()) {
                case 14: {
                    this.iU_.hl_(iMgram.getGuarenteedTrackingNum(), false, 0, this.iU_.getClientId());
                    break;
                }
                case 3: {
                    this.iU_.gl_(iMgram.getGuarenteedTrackingNum(), false, 0, this.iU_.getClientId());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public void setGuarAckPendingConfirm(long l, long l2) {
        throw new UnsupportedOperationException("Acknowldement tracking not supported for client");
    }

    public List getUnconfirmedGuarAcks() {
        return new Vector();
    }

    public boolean handleGuarQAckAck(long l) {
        return this.handleGuarAckAck(l);
    }

    public boolean handleGuarAckAck(long l) {
        Job job = this.iU_.getJob(l);
        if (job == null || !(job instanceof qv)) {
            return false;
        }
        qv qv2 = (qv)this.iU_.removeJob(l);
        IMgram iMgram = qv2.getAck();
        qv2.setStatus(0);
        Connection connection = iMgram.getJMSClientHandle().getConnection();
        if (connection != null) {
            connection.getConnectionInfo().VY_(iMgram);
        }
        return true;
    }

    void VY_(IMgram iMgram) {
        if (this.isFaultTolerant()) {
            if (iMgram.getType() == 14) {
                this.Ee_.remove(new Long(iMgram.getAckHandle().getTrackingNumber()));
            } else if (iMgram.getType() == 3) {
                this.De_.remove(new Long(iMgram.getAckHandle().getTrackingNumber()));
            } else if (iMgram.getType() == 28) {
                this.WY_(iMgram.getAckListHandle().getPtpList());
                this.WY_(iMgram.getAckListHandle().getPubSubList());
            }
        }
    }

    private void WY_(Collection collection) {
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IMgram iMgram = (IMgram)iterator.next();
                this.VY_(iMgram);
            }
        }
    }

    public void guarQAcksDone(List list) {
        this.Ee_.removeAll(list);
    }

    public void ackCommitted(long l) {
        Long l2 = new Long(l);
        this.Ee_.remove(l2);
        this.De_.remove(l2);
    }

    public void guarAcksDone(List list) {
        this.De_.removeAll(list);
    }

    public void rcvdXORequest(long l, IMgram iMgram) {
    }

    public void prepareXOReply(long l, IMgram iMgram) {
    }

    public void sendReply(int n, IMgram iMgram) {
    }

    public boolean handleXOReplyAck(long l) {
        return false;
    }

    public List getPendingReplies() {
        return new Vector();
    }

    public boolean isFaultTolerant() {
        return this.iU_.isFaultToleranceEnabled();
    }

    public boolean isXOnce() {
        return this.iU_.isFaultToleranceEnabled();
    }

    public IMgram removeQMsgPendingAck(long l) {
        return this.removeMsgPendingAck(l);
    }

    public synchronized IMgram removeMsgPendingAck(long l) {
        return this.XY_(l, true);
    }

    private synchronized IMgram XY_(long l, boolean bl) {
        ListNode listNode = this.qd_.remove(l);
        IMgram iMgram = null;
        if (listNode != null) {
            PayloadWrapper payloadWrapper = (PayloadWrapper)listNode.obj;
            if (!payloadWrapper.isTransacted()) {
                this.rd_.add(-payloadWrapper.getLength(), payloadWrapper.getPriority());
            }
            iMgram = (IMgram)payloadWrapper.getPayload();
        }
        if (bl) {
            this.iU_.terminateJob(l, 0);
        }
        return iMgram;
    }

    Session YY_(int n) {
        return this.getConnection().NRB_(n);
    }

    public void inDoubtQMsgAcked(long l) {
        if (this.handleDoubtTransactedMsgAcked(l)) {
            return;
        }
        this.removeQMsgPendingAck(l);
    }

    public void inDoubtMsgAcked(long l) {
        if (this.handleDoubtTransactedMsgAcked(l)) {
            return;
        }
        this.removeMsgPendingAck(l);
    }

    public boolean handleDoubtTransactedMsgAcked(long l) {
        PayloadWrapper payloadWrapper = (PayloadWrapper)this.qd_.get(l);
        if (payloadWrapper != null && payloadWrapper.isTransacted()) {
            IMgram iMgram = (IMgram)payloadWrapper.getPayload();
            Session session = this.YY_(iMgram.getTxnId());
            if (session != null) {
                session.KIB_(l);
            }
            return true;
        }
        return false;
    }

    public synchronized void allInDoubtMsgsAcked(List list, List list2, List list3) {
        PayloadWrapper payloadWrapper;
        Enumeration enumeration = this.qd_.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            boolean bl2 = false;
            payloadWrapper = (PayloadWrapper)enumeration.nextElement();
            boolean bl3 = bl = payloadWrapper.getType() == 11;
            if ((payloadWrapper.isPersistent() || payloadWrapper.isTransacted()) && !bl) {
                if (list.contains(new Long(payloadWrapper.getTrackingNum())) || list2.contains(new Long(payloadWrapper.getTrackingNum()))) continue;
                this.od_.enqueue(payloadWrapper, payloadWrapper.getPriority());
                this.pd_.add(payloadWrapper.getLength(), payloadWrapper.getPriority());
                continue;
            }
            this.XY_(payloadWrapper.getTrackingNum(), !bl);
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            payloadWrapper = (PayloadWrapper)this.qd_.get(l);
            if (payloadWrapper == null || !payloadWrapper.isTransacted()) continue;
            this.iU_.terminateJob(payloadWrapper.getTrackingNum(), 0);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            payloadWrapper = (PayloadWrapper)this.qd_.get(l);
            if (payloadWrapper == null || !payloadWrapper.isTransacted()) continue;
            this.iU_.terminateJob(payloadWrapper.getTrackingNum(), 0);
        }
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            Request request = this.iU_.getRequest(l);
            if (request == null) continue;
            request.setPendingResponse(true);
        }
        this.TY_().notifyMsgEnqueued();
    }

    public List getPendingRequests() {
        return this.iU_.RRB_();
    }

    public void notifyRequestsPendingReply(List list) {
    }

    public void expireInDoubt() {
    }

    public boolean hasInDoubtState() {
        return this.qd_.count() > 0;
    }

    public void setInDoubtTime() {
        this.uG_ = System.currentTimeMillis();
    }

    public long getInDoubtTime() {
        return this.uG_;
    }

    public synchronized void setClosed() {
        this.Ce_ = true;
        this.notifyAll();
    }

    public boolean isRecovering() {
        return this.Fe_;
    }

    public void setRecovering(boolean bl) {
        this.Fe_ = bl;
    }
}

