/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.io.Serializable;
import progress.message.client.EConnectFailure;
import progress.message.client.EConnectionNotResumable;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.ENetworkFailure;
import progress.message.client.EUserAlreadyConnected;
import progress.message.net.ISocket;
import progress.message.util.AutoVec;
import progress.message.zclient.Connection;
import progress.message.zclient.ConnectionContext;
import progress.message.zclient.IVetoableOnConnectListener;
import progress.message.zclient.ReconnectHelper;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SocketDropHandler;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;
import progress.message.zclient.xonce.IRecoveryMutex;
import progress.message.zclient.xonce.SocketDoubtResolver;

public class FaultTolerantDropHandler
extends SocketDropHandler
implements IDoubtResolverCompletionListener,
IVetoableOnConnectListener {
    private boolean ta_ = false;
    private Connection pa_ = null;
    private volatile SocketDoubtResolver mW_ = null;
    private volatile boolean ua_ = false;
    private volatile IOException va_ = null;
    private Integer wa_ = new Integer(1);

    public FaultTolerantDropHandler(Connection connection) {
        super("FaultTolerantDropHandler");
        this.pa_ = connection;
        this.pa_.getReconnector().setVetoableOnConnectListener(this);
    }

    public void socketDropped(int n, int n2, ConnectionContext connectionContext) {
        Serializable serializable;
        FaultTolerantDropHandler faultTolerantDropHandler = this;
        synchronized (faultTolerantDropHandler) {
            if (this.ta_) {
                return;
            }
            this.ta_ = true;
        }
        connectionContext.waitForPeersToTerminate();
        if (!this.pa_.isFaultToleranceEnabled()) {
            this.forward(n, n2, connectionContext);
            return;
        }
        boolean bl = false;
        Integer n3 = this.wa_;
        synchronized (n3) {
            bl = this.pa_.aRB_().isRecovering();
            if (bl) {
                this.onDisconnectDuringResolution();
                return;
            }
        }
        if (this.pa_.ERB_() == 3) {
            this.pa_.connectionDropped(n, n2, 3);
            return;
        }
        if (this.pa_.ERB_() != 0) {
            this.forward(n, n2, connectionContext);
            return;
        }
        this.pa_.yQB_().waitNoConnectInProgress();
        AutoVec autoVec = this.pa_.cloneBrethren();
        this.JW_(autoVec);
        boolean bl2 = Thread.interrupted();
        int n4 = 0;
        int n5 = 0;
        try {
            if (!this.IW_()) {
                n4 = n;
                n5 = n2;
            }
        }
        catch (EConnectionNotResumable eConnectionNotResumable) {
            n4 = -39;
            serializable = eConnectionNotResumable.getLinkedException();
            n5 = serializable != null ? eConnectionNotResumable.getLinkedException().getErrorId() : 0;
        }
        catch (EUserAlreadyConnected eUserAlreadyConnected) {
            n4 = -39;
            n5 = eUserAlreadyConnected.getErrorId();
        }
        catch (EConnectFailure eConnectFailure) {
            if (eConnectFailure.getErrorId() != 121) {
                SessionConfig.logMessage(eConnectFailure, SessionConfig.getLevelWarning());
            }
            n4 = n;
            n5 = n2;
        }
        catch (ENetworkFailure eNetworkFailure) {
            n4 = n;
            n5 = n2;
        }
        catch (Throwable throwable) {
            SessionConfig.logMessage(throwable, SessionConfig.getLevelWarning());
            n4 = n;
            n5 = n2;
        }
        boolean bl3 = n4 == 0;
        serializable = this.wa_;
        synchronized (serializable) {
            if (bl3 && this.va_ != null) {
                bl3 = false;
                n4 = n;
                n5 = n2;
            }
            this.KW_(bl3, autoVec);
        }
        if (!bl3) {
            this.pa_.WPB_ = null;
            ISocket iSocket = this.pa_.getSocket();
            try {
                if (iSocket != null) {
                    iSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.forward(n4, n5, connectionContext);
        }
    }

    private boolean IW_() throws Throwable {
        ReconnectHelper reconnectHelper = this.pa_.getReconnector();
        return reconnectHelper.connect(true);
    }

    private void JW_(AutoVec autoVec) {
        IRecoveryMutex iRecoveryMutex = this.pa_.aRB_();
        synchronized (iRecoveryMutex) {
            int n = 0;
            while (n < autoVec.size()) {
                Connection connection = (Connection)autoVec.elementAt(n);
                if (connection != null && connection.ERB_() == 0) {
                    connection.XRB_();
                }
                ++n;
            }
        }
    }

    private void KW_(boolean bl, AutoVec autoVec) {
        IRecoveryMutex iRecoveryMutex = this.pa_.aRB_();
        synchronized (iRecoveryMutex) {
            int n = 0;
            while (n < autoVec.size()) {
                Connection connection = (Connection)autoVec.elementAt(n);
                if (connection != null) {
                    connection.WRB_(bl);
                }
                ++n;
            }
        }
    }

    public void onDisconnectDuringResolution() {
        SocketDoubtResolver socketDoubtResolver = this.mW_;
        if (socketDoubtResolver != null) {
            socketDoubtResolver.onDisconnectDuringResolution();
        }
        this.pa_.disallowRecoveryJobs();
        boolean bl = false;
        this.pa_.getConnectionInfo().onDisconnectDuringResolution();
        this.pa_.terminateSyncOps(-5, bl);
        this.failed(socketDoubtResolver, new IOException("asynchronous disconnect"));
    }

    public void onConnect(boolean bl) throws IOException, EGeneralException {
        if (!bl) {
            return;
        }
        try {
            FaultTolerantDropHandler faultTolerantDropHandler = this;
            synchronized (faultTolerantDropHandler) {
                if (this.ta_) {
                    throw new IOException("Connection Drop has already been detected");
                }
                this.pa_.allowRecoveryJobs();
                this.mW_ = new SocketDoubtResolver(this.pa_);
                this.mW_.setCompletionListener(this);
                this.LW_();
            }
            this.mW_.initiateResolution();
            this.MW_();
            if (this.va_ != null) {
                throw this.va_;
            }
            FaultTolerantDropHandler faultTolerantDropHandler2 = this;
            synchronized (faultTolerantDropHandler2) {
                if (this.ta_) {
                    throw new IOException("Connection Drop has already been detected");
                }
                this.LW_();
            }
            this.mW_.initiateSecondaryStateResolution();
            this.MW_();
            if (this.va_ != null) {
                throw this.va_;
            }
            Object var6_6 = null;
            this.pa_.disallowRecoveryJobs();
            this.mW_ = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.pa_.disallowRecoveryJobs();
            this.mW_ = null;
            throw throwable;
        }
    }

    private void LW_() {
        this.ua_ = false;
        this.va_ = null;
    }

    private void MW_() throws EInterrupted {
        Integer n = this.wa_;
        synchronized (n) {
            while (!this.ua_) {
                try {
                    this.wa_.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new EInterrupted();
                }
            }
        }
    }

    public void completed(IDoubtResolver iDoubtResolver, int n) {
        Integer n2 = this.wa_;
        synchronized (n2) {
            if (iDoubtResolver != this.mW_) {
                return;
            }
            if (this.ua_) {
                return;
            }
            this.ua_ = true;
            this.wa_.notifyAll();
        }
    }

    public void failed(IDoubtResolver iDoubtResolver, IOException iOException) {
        Integer n = this.wa_;
        synchronized (n) {
            if (iDoubtResolver != this.mW_) {
                return;
            }
            this.ua_ = true;
            this.va_ = iOException;
            this.wa_.notifyAll();
        }
    }
}

