/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.ETimeout;
import progress.message.zclient.DebugObject;

public abstract class Job
extends DebugObject {
    protected int IC_ = 2;
    protected String Qf_;
    private boolean fAB_ = false;
    public static final int SUCCESS = 0;
    public static final int RUNNING = 1;
    public static final int SUSPENDED = 2;
    public static final int UNINITIALIZED = 3;
    public static final int ERROR = -1;
    public static final int ERROR_PRIVACY_FAILED = -2;
    public static final int ERROR_INTEGRITY_FAILED = -3;
    public static final int ERROR_NONREPUDIATION_FAILED = -4;
    public static final int ERROR_CONNECTION_DROPPED = -5;
    public static final int ERROR_PUBLISH_NOT_AUTHORIZED = -6;
    public static final int ERROR_SUBSCRIBE_NOT_AUTHORIZED = -7;
    public static final int ERROR_GUARANTEE_NOT_AUTHORIZED = -8;
    public static final int ERROR_WRONG_SUBJECT_ADDR = -9;
    public static final int ERROR_GENERAL_SECURITY_ERR = -10;
    public static final int ERROR_TXN_NOT_FOUND = -11;
    public static final int ERROR_TXN_ACCESS_VIOLATION = -12;
    public static final int ERROR_TXN_SEQUENCE_ERR = -13;
    public static final int ERROR_REQUEST_NOSUB_FOR_SUBJECT = -14;
    public static final int ERROR_QUEUE_NOT_FOUND = -15;
    public static final int ERROR_TOO_LARGE_FOR_QUEUE = -16;
    public static final int ERROR_CONNECTION_CLOSING = -17;
    public static final int ERROR_QUEUE_MSG_NACKED_WHILE_FLOW_CONTROL_DISABLED = -18;
    public static final int ERROR_STORE_ERR = -19;
    public static final int ERROR_STORE_INIT_ERR = -20;
    public static final int ERROR_STORE_SIZE_EXCEEDED_ERR = -21;
    public static final int ERROR_INVALID_SELECTOR_ERR = -22;
    public static final int ERROR_TOPIC_MSG_NACKED_WHILE_FLOW_CONTROL_DISABLED = -23;
    public static final int ERROR_INVALID_TTL = -24;
    public static final int ERROR_OLD_VIRTUAL_CLOCK = -25;
    public static final int ERROR_CONNECTION_UNRESUMABLE = -39;

    public void setUnrecoverable(boolean bl) {
        this.fAB_ = bl;
    }

    public boolean getUnrecoverable() {
        return this.fAB_;
    }

    public abstract void start() throws EGeneralException;

    public abstract void suspend();

    public abstract void cancel() throws EGeneralException;

    public abstract void resolve();

    public synchronized void join() throws EInterrupted, EGeneralException {
        try {
            while (this.IC_ > 0) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new EInterrupted();
        }
    }

    public void join(int n) throws EInterrupted, EGeneralException, ETimeout {
        this.joinMillis(n * 1000);
    }

    synchronized void joinMillis(long l) throws EInterrupted, EGeneralException, ETimeout {
        try {
            long l2 = System.currentTimeMillis();
            long l3 = l2 + l;
            while (this.IC_ > 0 && l2 < l3) {
                this.wait(l3 - l2);
                l2 = System.currentTimeMillis();
            }
            if (this.IC_ > 0) {
                throw new ETimeout();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new EInterrupted();
        }
    }

    public synchronized int getStatus() {
        return this.IC_;
    }

    public synchronized String getMessage() {
        return this.Qf_;
    }

    public synchronized boolean isRunning() {
        return this.IC_ == 1;
    }

    public synchronized boolean isComplete() {
        return this.IC_ == 0;
    }

    public synchronized boolean isSuspended() {
        return this.IC_ == 2;
    }

    public synchronized boolean isError() {
        return this.IC_ < 0;
    }

    public synchronized void setStatus(int n) {
        this.IC_ = n;
        this.notifyAll();
    }

    public synchronized void setStatus(int n, String string) {
        this.IC_ = n;
        this.Qf_ = string;
        this.notifyAll();
    }
}

