/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Enumeration;
import java.util.Stack;
import progress.message.util.DebugState;
import progress.message.util.IndexedList;
import progress.message.util.PriorityQueue;
import progress.message.zclient.BlockedDestList;
import progress.message.zclient.ClientOutQueue;
import progress.message.zclient.ClientSenderQueue;
import progress.message.zclient.PayloadWrapper;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.xonce.IOutboundContext;

public class PayloadSenderQueue
extends ClientSenderQueue {
    public PayloadSenderQueue(IOutboundContext iOutboundContext, ClientOutQueue clientOutQueue, PrioQueueLimiter prioQueueLimiter, IndexedList indexedList, PrioQueueLimiter prioQueueLimiter2, String string) {
        super(iOutboundContext, clientOutQueue, prioQueueLimiter, indexedList, prioQueueLimiter2, string);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("PayloadSenderQueue");
        }
    }

    public synchronized void enqueue(Object object, int n) throws Exception {
        this.enqueue(object, n, 0L, 0L, null, false);
    }

    public synchronized void enqueue(Object object, int n, long l, long l2, String string, boolean bl) {
        PayloadWrapper payloadWrapper = new PayloadWrapper(object, n, l, l2, string, bl, this.hJB_);
        if ((string = payloadWrapper.getDestination()) != null && this.wd_.containsKey(string)) {
            if (payloadWrapper.isDiscardable()) {
                return;
            }
            BlockedDestList blockedDestList = (BlockedDestList)this.wd_.get(string);
            blockedDestList.addUnsent(payloadWrapper);
        } else {
            this.od_.enqueue(payloadWrapper, payloadWrapper.getPriority());
        }
        this.pd_.add(payloadWrapper.getLength(), payloadWrapper.getPriority());
        if (payloadWrapper.isNackable()) {
            this.qd_.appendNoDup(payloadWrapper.getTrackingNum(), (Object)payloadWrapper);
            if (!payloadWrapper.isTransacted()) {
                this.rd_.add(payloadWrapper.getLength(), payloadWrapper.getPriority());
            } else if (this.zF_) {
                this.debug(payloadWrapper.getLength() + " bytes of txn msg " + payloadWrapper.getTrackingNum() + " NOT accounted for pending msg limiter");
            }
        } else if (this.ojB_.isXOnce() && (payloadWrapper.isPersistent() || payloadWrapper.isTransacted()) && !payloadWrapper.isDiscardable() && !payloadWrapper.isAsyncDelivery()) {
            this.qd_.appendNoDup(payloadWrapper.getTrackingNum(), (Object)payloadWrapper);
            if (!payloadWrapper.isTransacted()) {
                this.rd_.add(payloadWrapper.getLength(), payloadWrapper.getPriority());
            } else if (this.zF_) {
                this.debug(payloadWrapper.getLength() + " bytes of txn msg " + payloadWrapper.getTrackingNum() + " NOT accounted for pending msg limiter");
            }
        }
        this.notifyAll();
    }

    public synchronized Object dequeueAtOrAbove(int n) {
        PayloadWrapper payloadWrapper = (PayloadWrapper)this.od_.dequeueAtOrAbove(n);
        if (payloadWrapper == null) {
            return null;
        }
        Object object = payloadWrapper.getPayload();
        if (object == null) {
            return null;
        }
        this.pd_.add(-payloadWrapper.getLength(), payloadWrapper.getPriority());
        this.notifyAll();
        return object;
    }

    public synchronized Object dequeue(int n) {
        PayloadWrapper payloadWrapper = (PayloadWrapper)this.od_.dequeue(n);
        if (payloadWrapper == null) {
            return null;
        }
        Object object = payloadWrapper.getPayload();
        if (object == null) {
            return null;
        }
        this.pd_.add(-payloadWrapper.getLength(), n);
        this.notifyAll();
        return object;
    }

    public synchronized void onBlock(String string, boolean bl) throws Exception {
        BlockedDestList blockedDestList = (BlockedDestList)this.wd_.get(string);
        if (blockedDestList == null) {
            blockedDestList = new BlockedDestList(string);
            this.wd_.put(string, blockedDestList);
        }
        if (bl) {
            blockedDestList.setForRoutingQueue();
        }
        PriorityQueue priorityQueue = new PriorityQueue(this.od_.getNumPriorities());
        String string2 = null;
        PayloadWrapper payloadWrapper = null;
        while (!this.od_.isEmpty()) {
            payloadWrapper = (PayloadWrapper)this.od_.dequeue();
            string2 = payloadWrapper.getDestination();
            if (string2 != null && string2.equals(string)) {
                if (payloadWrapper.isDiscardable()) continue;
                blockedDestList.addUnsent(payloadWrapper);
                continue;
            }
            priorityQueue.enqueue(payloadWrapper, payloadWrapper.getPriority());
        }
        payloadWrapper = null;
        while (!priorityQueue.isEmpty()) {
            payloadWrapper = (PayloadWrapper)priorityQueue.dequeue();
            this.od_.enqueue(payloadWrapper, payloadWrapper.getPriority());
        }
    }

    public synchronized void onResumeBegin(String string, boolean bl) {
        BlockedDestList blockedDestList = (BlockedDestList)this.wd_.get(string);
        if (blockedDestList != null) {
            BlockedDestList blockedDestList2 = blockedDestList;
            synchronized (blockedDestList2) {
                blockedDestList.setResuming(true);
                Stack stack = blockedDestList.buildOrderedNackStack();
                while (!stack.isEmpty()) {
                    PayloadWrapper payloadWrapper = (PayloadWrapper)stack.pop();
                    this.od_.enqueue(payloadWrapper, payloadWrapper.getPriority());
                }
            }
        }
    }

    public void onResumeComplete(String string, boolean bl) {
        BlockedDestList blockedDestList = (BlockedDestList)this.wd_.remove(string);
        if (blockedDestList != null) {
            BlockedDestList blockedDestList2 = blockedDestList;
            synchronized (blockedDestList2) {
                blockedDestList.setResuming(false);
                Stack stack = blockedDestList.buildOrderedUnsentStack();
                while (!stack.isEmpty()) {
                    PayloadWrapper payloadWrapper = (PayloadWrapper)stack.pop();
                    this.od_.enqueue(payloadWrapper, payloadWrapper.getPriority());
                }
            }
        }
    }

    public synchronized Object nack(long l) throws Exception {
        PayloadWrapper payloadWrapper = (PayloadWrapper)this.qd_.get(l);
        if (payloadWrapper == null) {
            return payloadWrapper;
        }
        String string = payloadWrapper.getDestination();
        BlockedDestList blockedDestList = (BlockedDestList)this.wd_.get(string);
        if (blockedDestList != null) {
            BlockedDestList blockedDestList2 = blockedDestList;
            synchronized (blockedDestList2) {
                if (blockedDestList.isResuming()) {
                    this.od_.enqueue(payloadWrapper, payloadWrapper.getPriority());
                    this.pd_.add(payloadWrapper.getLength(), payloadWrapper.getPriority());
                } else {
                    blockedDestList.addNacked(payloadWrapper);
                    this.pd_.add(payloadWrapper.getLength(), payloadWrapper.getPriority());
                }
            }
        } else {
            this.od_.enqueue(payloadWrapper, payloadWrapper.getPriority());
            this.pd_.add(payloadWrapper.getLength(), payloadWrapper.getPriority());
            return payloadWrapper;
        }
        return payloadWrapper;
    }

    public synchronized String[] getBlockedDestinations() {
        int n = this.wd_.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        Enumeration enumeration = this.wd_.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public boolean isAsyncDelivery(long l) {
        boolean bl = false;
        PayloadWrapper payloadWrapper = (PayloadWrapper)this.qd_.get(l);
        if (payloadWrapper != null) {
            bl = payloadWrapper.isAsyncDelivery();
        }
        return bl;
    }
}

