/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.msg.IMgram;
import progress.message.zclient.Envelope;
import progress.message.zclient.Label;
import progress.message.zclient.Message;

public class PayloadWrapper {
    public Object m_payload = null;
    public boolean m_isNackable;
    public int m_priority;
    public long m_trackingNum;
    public int m_length;
    public long m_expTm;
    public String m_dest;
    public boolean m_asyncDelivery;
    public boolean m_isQueueMessage;
    public boolean m_isDiscardable;
    public boolean m_isPersistent;
    public boolean m_isTransacted;
    public byte m_type;

    public PayloadWrapper(Object object, int n, long l, long l2, String string, boolean bl, String string2) {
        String string3 = null;
        this.m_payload = object;
        if (object instanceof IMgram) {
            String string4;
            IMgram iMgram = (IMgram)object;
            this.m_isPersistent = iMgram.isJMSPersistent();
            this.m_isTransacted = iMgram.hasTxn();
            this.m_type = iMgram.getType();
            if (iMgram.isPTP() || iMgram.getType() == 11) {
                this.m_isNackable = true;
                this.m_isQueueMessage = true;
                string3 = iMgram.getSubject();
            } else if (iMgram.isPubSub()) {
                this.m_isNackable = true;
                this.m_isQueueMessage = false;
                string3 = iMgram.getSubject();
            } else {
                this.m_isQueueMessage = false;
            }
            if (iMgram.isDiscardable() || !iMgram.isGuarenteed()) {
                this.m_isNackable = false;
            }
            this.m_priority = iMgram.getPriority();
            this.m_isDiscardable = iMgram.isDiscardable();
            this.m_dest = string3 == null ? string : ((string4 = iMgram.getRoutingHandle().getRouting()) != null && !iMgram.isPubSub() ? (string4.equals("") ? "::" + string3 : string4 + "::" + string3) : string3);
            this.m_trackingNum = iMgram.isGuarenteed() ? iMgram.getGuarenteedTrackingNum() : l;
            this.m_expTm = iMgram.isTTE() ? iMgram.getTTE() : l2;
            this.m_asyncDelivery = bl;
            this.m_length = iMgram.memoryLength();
        } else if (object instanceof Envelope) {
            String string5;
            Envelope envelope = (Envelope)object;
            Label label = envelope.getLabel();
            Message message = envelope.getMessage();
            IMgram iMgram = envelope.getMgram();
            this.m_type = iMgram.getType();
            this.m_isPersistent = iMgram.isJMSPersistent();
            this.m_isTransacted = iMgram.hasTxn();
            this.m_isNackable = !iMgram.isDiscardable() && iMgram.isGuarenteed();
            this.m_isQueueMessage = envelope.isQueueMessage();
            this.m_priority = label != null ? (int)label.getPriority() : n;
            this.m_dest = message != null ? ((string3 = message.getSubject()) == null ? string : ((string5 = envelope.getRouting()) != null && envelope.isQueueMessage() ? (string5.equals("") ? "::" + string3 : string5 + "::" + string3) : string3)) : string;
            this.m_length = envelope.length();
            this.m_trackingNum = envelope.getGuarTracking();
            this.m_expTm = label != null ? label.getExpirationTime() : l2;
            this.m_asyncDelivery = bl;
            this.m_isDiscardable = envelope.isDiscardable();
        } else {
            this.m_isNackable = false;
            this.m_isQueueMessage = false;
            this.m_isDiscardable = false;
            this.m_isPersistent = false;
            this.m_isTransacted = false;
            this.m_priority = n;
            this.m_dest = string;
            this.m_length = 0;
            this.m_trackingNum = l;
            this.m_expTm = l2;
            this.m_asyncDelivery = bl;
        }
    }

    public Object getPayload() {
        return this.m_payload;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public long getTrackingNum() {
        return this.m_trackingNum;
    }

    public short getType() {
        return this.m_type;
    }

    public boolean isQueueMessage() {
        return this.m_isQueueMessage;
    }

    public boolean isDiscardable() {
        return this.m_isDiscardable;
    }

    public boolean isPersistent() {
        return this.m_isPersistent;
    }

    public boolean isTransacted() {
        return this.m_isTransacted;
    }

    public boolean isNackable() {
        return this.m_isNackable;
    }

    public long getExpirationTime() {
        return this.m_expTm;
    }

    public String getDestination() {
        return this.m_dest;
    }

    public int getLength() {
        return this.m_length;
    }

    public boolean isAsyncDelivery() {
        return this.m_asyncDelivery;
    }
}

