/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.util.EAssertFailure;
import progress.message.zclient.IQuencher;
import progress.message.zclient.SessionConfig;

public final class PrioQueueLimiter {
    public int m_normSize;
    public final int[] m_normStopSize = new int[10];
    public final int[] m_normStartSize = new int[10];
    public int m_hiSize;
    public final int m_hiStopSize;
    public final int m_hiStartSize;
    public int m_minPriority = 0;
    public IQuencher m_quencher;
    private boolean ZFB_;

    public PrioQueueLimiter(int n, int n2, int n3, IQuencher iQuencher) {
        int n4 = 0;
        while (n4 <= 9) {
            this.m_normStopSize[n4] = n - (9 - n4) * n2;
            this.m_normStartSize[n4] = this.m_normStopSize[n4] - SessionConfig.FLOW_CONTROL_RESTART_THRESHOLD;
            if (this.m_normStopSize[n4] < 0 || this.m_normStartSize[n4] < 0) {
                System.out.println("WARNING: PrioQueueLimiter constructed with incorrectly chosen parameters: max = " + n + ", min per prio = " + n2 + ", hi prio = " + n3);
                new Exception().printStackTrace();
            }
            ++n4;
        }
        this.m_hiStopSize = n3;
        this.m_hiStartSize = n3 - SessionConfig.FLOW_CONTROL_RESTART_THRESHOLD;
        this.m_quencher = iQuencher;
    }

    public void add(int n, int n2) {
        this.updateSize(n, n2);
        this.updateMinPriority(n);
    }

    public void updateSize(int n, int n2) {
        this.m_normSize += n;
        if (n2 == 10) {
            this.m_hiSize += n;
        }
        if (this.m_normSize < 0 || this.m_hiSize < 0) {
            if (SessionConfig.IN_BROKER) {
                if (!this.ZFB_) {
                    SessionConfig.logMessage("Negative queue size: " + n + " " + this.m_normStopSize[9], SessionConfig.getLevelWarning());
                    this.ZFB_ = true;
                }
            } else {
                throw new EAssertFailure("negative queue size");
            }
        }
    }

    public void updateMinPriority(int n) {
        int n2 = this.m_minPriority;
        if (n > 0) {
            while (n2 <= 9 && this.m_normStopSize[n2] <= this.m_normSize) {
                ++n2;
            }
            if (n2 == 10 && this.m_hiSize >= this.m_hiStopSize) {
                ++n2;
            }
        } else {
            if (n2 == 11 && (this.m_hiSize < this.m_hiStartSize || this.m_normSize < this.m_normStartSize[9])) {
                --n2;
            }
            if (n2 <= 10) {
                while (n2 > 0 && this.m_normStartSize[n2 - 1] > this.m_normSize) {
                    --n2;
                }
            }
        }
        if (n2 != this.m_minPriority) {
            this.m_minPriority = n2;
            this.m_quencher.setMinEnqueuePriority(this.m_minPriority);
        }
    }

    public boolean hasRoom(int n, int n2) {
        if (n2 == 10) {
            return this.m_hiSize + n <= this.m_hiStopSize || this.m_normSize == 0 || this.m_normSize + n <= this.m_normStopSize[9];
        }
        if (n2 <= 9) {
            return this.m_normSize == 0 || this.m_normSize + n <= this.m_normStopSize[n2];
        }
        return true;
    }

    public void reset() {
        this.m_normSize = 0;
        this.m_hiSize = 0;
        if (this.m_minPriority != 0) {
            this.m_minPriority = 0;
            this.m_quencher.setMinEnqueuePriority(this.m_minPriority);
        }
    }

    public int size() {
        return this.m_normSize;
    }
}

