/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.PrintStream;
import progress.message.resources.prMessageFormat;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.prAccessor;

public class SecurityLogic {
    public static final byte INITIATOR = 1;
    public static final byte ROUTER_TOPIC = 2;
    public static final byte RESPONSE = 3;
    public static final byte ROUTER_QUEUE = 4;
    public static final int NONE = 0;
    public static final int INTEGRITY = 1;
    public static final int PRIVACY = 2;
    public static final byte SA_NONE = 0;
    public static final byte SA_QUERY = 1;
    public static final byte SA_ENCRYPT_MESSAGE_SESSION_KEY = 2;
    public static final byte SA_ENCRYPT_MESSAGE_MESSAGE_KEY = 4;
    public static final byte SA_MAC_HEADER_MESSAGE_KEY = 8;
    public static final byte SA_MAC_MESSAGE_SESSION_KEY = 16;
    public static final byte SA_MAC_MESSAGE_MESSAGE_KEY = 32;

    public static boolean isQuery(byte by) {
        return (by & 1) > 0;
    }

    public static boolean isMKeyEncryption(byte by) {
        return (by & 4) > 0;
    }

    public static boolean isSKeyEncryption(byte by) {
        return (by & 2) > 0;
    }

    public static boolean isBaseSecurity(byte by) {
        return by == 0;
    }

    public static boolean isMKeyMacHeader(byte by) {
        return (by & 8) > 0;
    }

    public static boolean isMKeyDigest(byte by) {
        return (by & 0x20) > 0;
    }

    public static boolean isSKeyDigest(byte by) {
        return (by & 0x10) > 0;
    }

    public static boolean isNoProtection(byte by) {
        return by == 0;
    }

    public static byte getPubAttr(byte by) {
        if ((by & 1) > 0) {
            throw new EAssertFailure(prAccessor.getString("STR123"));
        }
        switch (by) {
            case 0: 
            case 8: {
                return 0;
            }
            case 16: 
            case 32: {
                return 1;
            }
            case 18: 
            case 36: {
                return 2;
            }
        }
        throw new EAssertFailure(prAccessor.getString("STR124"));
    }

    public static byte AttribsFromPrivate(byte by, byte by2) throws ESecurityInvalidLogistics {
        switch (by) {
            case 1: {
                throw new ESecurityInvalidLogistics();
            }
            case 4: {
                throw new ESecurityInvalidLogistics();
            }
            case 2: {
                switch (by2) {
                    case 0: 
                    case 8: {
                        return 8;
                    }
                    case 16: 
                    case 32: {
                        return 32;
                    }
                    case 18: 
                    case 36: {
                        return 36;
                    }
                }
                throw new ESecurityInvalidLogistics();
            }
            case 3: {
                switch (by2) {
                    case 0: 
                    case 8: {
                        return 0;
                    }
                    case 16: 
                    case 32: {
                        return 16;
                    }
                    case 18: 
                    case 36: {
                        return 18;
                    }
                }
                throw new ESecurityInvalidLogistics();
            }
        }
        throw new ESecurityInvalidLogistics();
    }

    public static byte AttribsFromPublic(byte by, byte by2) throws ESecurityInvalidLogistics {
        switch (by) {
            case 1: 
            case 4: {
                switch ((short)by2) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 18;
                    }
                }
                throw new EAssertFailure(prMessageFormat.format(prAccessor.getString("STR125"), new Object[]{Byte.toString(by2)}));
            }
            case 2: {
                switch ((short)by2) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 32;
                    }
                    case 2: {
                        return 36;
                    }
                }
                throw new EAssertFailure(prMessageFormat.format(prAccessor.getString("STR126"), new Object[]{Byte.toString(by2)}));
            }
            case 3: {
                throw new ESecurityInvalidLogistics();
            }
        }
        throw new ESecurityInvalidLogistics();
    }

    public static byte AttribsFromQuery(byte by) {
        switch ((short)by) {
            case 0: {
                return 8;
            }
            case 1: {
                return 32;
            }
            case 2: {
                return 36;
            }
        }
        throw new EAssertFailure(prAccessor.getString("STR127"));
    }

    public static byte getQueryAttribs() {
        return 19;
    }

    public static boolean verifyQuery(byte by) {
        return by == SecurityLogic.getQueryAttribs();
    }

    private static boolean qBB_(int n, int n2) {
        return (n & n2) > 0;
    }

    public static void debugPrintPrivate(byte by) {
        System.out.print("flags[");
        if (by == 0) {
            System.out.println("SA_NONE]");
            return;
        }
        if (SecurityLogic.isQuery(by)) {
            System.out.print("SA_QUERY ");
        }
        if (SecurityLogic.isMKeyMacHeader(by)) {
            System.out.print("SA_MAC_HEADER_MESSAGE_KEY");
        }
        if (SecurityLogic.isSKeyEncryption(by)) {
            System.out.print("SA_ENCRYPT_MESSAGE_SESSION_KEY ");
        }
        if (SecurityLogic.isMKeyEncryption(by)) {
            System.out.print("SA_ENCRYPT_MESSAGE_MESSAGE_KEY ");
        }
        if (SecurityLogic.isSKeyDigest(by)) {
            System.out.print("SA_MAC_MESSAGE_SESSION_KEY ");
        }
        if (SecurityLogic.isMKeyDigest(by)) {
            System.out.print("SA_MAC_MESSAGE_MESSAGE_KEY ");
        }
        System.out.println("]");
    }

    public static void debugPrintPublic(byte by) {
        SecurityLogic.debugPrint(System.out, by);
        System.out.println();
    }

    public static void debugPrint(PrintStream printStream, byte by) {
        printStream.print("flags[");
        if (by == 0) {
            printStream.print("NONE ]");
        } else if (by == 1) {
            printStream.print("INTEGRITY ]");
        } else if (by == 2) {
            printStream.print("PRIVACY ]");
        }
    }
}

