/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import progress.message.client.EAlreadyInTransaction;
import progress.message.client.EChannelTransactionFailure;
import progress.message.client.EEmptyEnvelope;
import progress.message.client.EEnvelopeIsNotRequest;
import progress.message.client.EGeneralException;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.EInterrupted;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidTTLException;
import progress.message.client.EMessageTypeMismatch;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENoSubscribersFound;
import progress.message.client.ENotConnected;
import progress.message.client.ENotInTransaction;
import progress.message.client.EParameterIsNull;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ESubjectNotSet;
import progress.message.client.ETimeout;
import progress.message.client.ETransactionAlreadyPrepared;
import progress.message.client.ETransactionFailure;
import progress.message.client.ETransactionRollbackByBroker;
import progress.message.client.EUnknownTransaction;
import progress.message.client.EUnusableConnection;
import progress.message.client.EUsage;
import progress.message.client.EXADuplicateXidException;
import progress.message.client.EXAThereIsNoXidException;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.resources.prMessageFormat;
import progress.message.util.ArrayUtil;
import progress.message.util.ISizedEnumeration;
import progress.message.util.LongHashTable;
import progress.message.xa.XidImpl;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.IMessage;
import progress.message.zclient.IMgramEnqueuedToSendListener;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.Publication;
import progress.message.zclient.Request;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Solicitation;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectTree;
import progress.message.zclient.Subscription;
import progress.message.zclient.kb;
import progress.message.zclient.prAccessor;
import progress.message.zclient.xonce.AAFJobResolver;

public class Session {
    private static final short BIB_ = 0;
    private static final short CIB_ = 1;
    private static final short DIB_ = 2;
    private static final short EIB_ = 3;
    private static final short Zf_ = 4;
    protected Connection pH_;
    private short FIB_;
    private int SG_;
    private Vector GIB_;
    private FastVector HIB_;
    private FastVector IIB_;
    private boolean JIB_ = false;
    private LongHashTable KIB_ = new LongHashTable();
    private boolean LIB_ = false;
    private ArrayList MIB_;
    private PrioQueueLimiter NIB_ = null;
    private boolean OIB_ = false;
    private int PIB_ = 0;
    public static final int ASYNC = 0;
    public static final int SYNC = -1;

    public Session(Connection connection) throws EGeneralException, EParameterIsNull, EUnusableConnection {
        if (connection == null) {
            throw new EParameterIsNull("parent");
        }
        if (connection.hRB_()) {
            throw new EUnusableConnection();
        }
        this.pH_ = connection;
        this.FIB_ = 0;
        this.GIB_ = new Vector();
        this.HIB_ = new FastVector();
        this.IIB_ = new FastVector();
        connection.JRB_(this);
    }

    void oHB_(int n) {
        ArrayList arrayList = this.MIB_;
        synchronized (arrayList) {
            this.PIB_ = n;
            this.MIB_.notifyAll();
        }
    }

    public Session(Connection connection, boolean bl) throws EGeneralException, EParameterIsNull, EUnusableConnection {
        this(connection);
        this.JIB_ = bl;
    }

    public Session(Connection connection, int n) throws EGeneralException, EParameterIsNull, EUnusableConnection {
        this(connection, true);
        this.SG_ = n;
        this.FIB_ = (short)4;
        if (n != -1) {
            connection.LRB_(this, n);
        }
    }

    public boolean isXATxn() {
        return this.JIB_;
    }

    public void close() {
        this.pH_.KRB_(this);
        if (this.SG_ != -1) {
            this.pH_.MRB_(this.SG_);
        }
        this.OIB_ = true;
    }

    public boolean isClosing() {
        return this.OIB_;
    }

    public Connection getConnection() {
        return this.pH_;
    }

    public void publish(IMessage iMessage) throws EParameterIsNull, ESubjectNotSet, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.publish(iMessage, -1, false);
    }

    public void publish(Envelope envelope) throws EParameterIsNull, EEmptyEnvelope, ESubjectNotSet, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.publish(envelope, -1, false);
    }

    public Message request(IMessage iMessage) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(iMessage, null);
    }

    public Message request(IMessage iMessage, IJobResolver iJobResolver) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(iMessage, -1, iJobResolver);
    }

    public Envelope requestEnvelope(IMessage iMessage) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.requestEnvelope(iMessage, null);
    }

    public Envelope requestEnvelope(IMessage iMessage, IJobResolver iJobResolver) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.requestEnvelope(iMessage, -1, iJobResolver);
    }

    public Message request(Envelope envelope) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(envelope, null);
    }

    public Message request(Envelope envelope, IJobResolver iJobResolver) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(envelope, -1, iJobResolver);
    }

    public Envelope requestEnvelope(Envelope envelope) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.requestEnvelope(envelope, null);
    }

    public Envelope requestEnvelope(Envelope envelope, IJobResolver iJobResolver) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.requestEnvelope(envelope, -1, iJobResolver);
    }

    public Solicitation solicit(IMessage iMessage, MessageHandler messageHandler) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (!iMessage.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        return this.solicitInternal(this.AIB_(iMessage), messageHandler, -1);
    }

    public void reply(IMessage iMessage, Envelope envelope) throws EParameterIsNull, EEnvelopeIsNotRequest, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (!envelope.isRequest()) {
            throw new EEnvelopeIsNotRequest();
        }
        if (iMessage == null) {
            throw new EParameterIsNull("reply.responseMessage");
        }
        Envelope envelope2 = new Envelope(iMessage, (Label)envelope.getLabel().clone());
        this.yHB_(envelope2, envelope, -1, false);
    }

    public void reply(Envelope envelope, Envelope envelope2) throws EEmptyEnvelope, EEnvelopeIsNotRequest, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (envelope.getMessage() == null) {
            throw new EEmptyEnvelope();
        }
        envelope.setTimestamp(System.currentTimeMillis());
        Envelope envelope3 = (Envelope)envelope.clone();
        if (envelope.getLabel() != null) {
            envelope3.setLabel((Label)envelope.getLabel().clone());
        }
        this.yHB_(envelope3, envelope2, -1, false);
    }

    public Subscription subscribe(String string) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.subscribe(string, null, false);
    }

    public Subscription subscribe(String string, String string2, boolean bl) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.subscribe(string, string2, bl, 0);
    }

    public Subscription subscribe(String string, String string2, boolean bl, int n) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (string == null || string.equals("")) {
            throw new EInvalidSubjectSyntax(prAccessor.getString("STR128"));
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        return this.vHB_(string, this.pH_.getSubjectTree().getSubjectNode(string).getDeliveryLabel(), string2, bl, false, n);
    }

    public Subscription submitSubscription(String string, Label label) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.vHB_(string, label, null, false, false, 0);
    }

    public Subscription submitSubscription(String string, Label label, String string2, boolean bl, boolean bl2) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.submitSubscription(string, label, string2, bl, bl2, 0);
    }

    public Subscription submitSubscription(String string, Label label, String string2, boolean bl, boolean bl2, int n) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (string == null || string.equals("")) {
            throw new EInvalidSubjectSyntax(prAccessor.getString("STR128"));
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        return this.vHB_(string, label, string2, bl, bl2, n);
    }

    public Subscription submitSubscription(String string) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.vHB_(string, this.pH_.getSubjectTree().getSubjectNode(string).getDeliveryLabel(), null, false, false, 0);
    }

    public Subscription submitSubscription(String string, String string2, boolean bl, boolean bl2, int n) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (string == null || string.equals("")) {
            throw new EInvalidSubjectSyntax(prAccessor.getString("STR128"));
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        return this.vHB_(string, this.pH_.getSubjectTree().getSubjectNode(string).getDeliveryLabel(), string2, bl, false, n);
    }

    public void unsubscribe(String string) throws EParameterIsNull, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (string == null) {
            throw new EParameterIsNull("subjectExp");
        }
        if (!this.pH_.hierarchicallyConnected()) {
            Object object = this.pH_.FRB_();
            synchronized (object) {
                Subscription[] subscriptionArray = this.pH_.getSubscriptions(string);
                int n = 0;
                while (n < subscriptionArray.length) {
                    this.pH_.Tl_(subscriptionArray[n].getSubjectName());
                    ++n;
                }
                throw new ENotConnected();
            }
        }
        Object object = this.pH_.FRB_();
        synchronized (object) {
            Subscription[] subscriptionArray = this.pH_.getSubscriptions(string);
            int n = 0;
            while (n < subscriptionArray.length) {
                subscriptionArray[n].YT_(true);
                ++n;
            }
        }
    }

    public void unsubscribe(String string, boolean bl) throws EParameterIsNull, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.unsubscribe(string);
    }

    public void acknowledgeQmsg(Envelope envelope, long l, Connection connection) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!envelope.YEC_() || envelope.gEC_() || envelope.forwardAcknowledged()) {
            return;
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        this.setTxnMgrUsed(true);
        switch (this.FIB_) {
            case 0: {
                long l2 = envelope.getGuarTracking();
                envelope = null;
                this.pH_.uRB_(l2, false, 0, l, connection);
                break;
            }
            case 1: {
                this.CIB_();
            }
            case 2: {
                long l3 = envelope.getGuarTracking();
                FastVector fastVector = this.HIB_;
                synchronized (fastVector) {
                    this.HIB_.addElement(envelope);
                    this.IIB_.addElement(new Long(l));
                }
                this.pH_.hl_(l3, true, this.SG_, l);
                break;
            }
            case 3: 
            case 4: {
                throw new ETransactionAlreadyPrepared("");
            }
        }
    }

    public void acknowledge(Envelope envelope) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.acknowledge(envelope, false);
    }

    public void acknowledge(Envelope envelope, boolean bl) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.acknowledge(envelope, bl, -1L);
    }

    public void batchAck(Envelope envelope, long l) throws ENetworkFailure, EGeneralException {
        if (envelope.gEC_()) {
            return;
        }
        this.setTxnMgrUsed(true);
        if (!envelope.YEC_()) {
            envelope.dEC_(this.pH_, false, false);
            return;
        }
        ArrayList<Envelope> arrayList = (ArrayList<Envelope>)this.KIB_.get(l);
        if (arrayList == null) {
            arrayList = new ArrayList<Envelope>();
            this.KIB_.put(l, (Object)arrayList);
        }
        arrayList.add(envelope);
    }

    public void discardBatchedAcks() {
        LongHashTable longHashTable = this.KIB_;
        synchronized (longHashTable) {
            this.KIB_.clear();
        }
    }

    public void sendBatchedAcks(boolean bl) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        LongHashTable longHashTable = this.KIB_;
        synchronized (longHashTable) {
            try {
                this.pHB_(this.KIB_, bl);
                Object var4_3 = null;
                this.KIB_.clear();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.KIB_.clear();
                throw throwable;
            }
        }
    }

    private void pHB_(LongHashTable longHashTable, boolean bl) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (longHashTable != null && longHashTable.size() > 0) {
            IMgram iMgram = null;
            long l = -1L;
            ISizedEnumeration iSizedEnumeration = longHashTable.keyList();
            while (iSizedEnumeration.hasMoreElements()) {
                long l2 = (Long)iSizedEnumeration.nextElement();
                ArrayList arrayList = (ArrayList)longHashTable.get(l2);
                if (arrayList == null || arrayList.size() <= 0) continue;
                if (iMgram == null) {
                    iMgram = MgramFactory.getMgramFactory().buildAckList();
                    if (!bl) {
                        l = this.pH_.genPubTrackingNum();
                        iMgram.setGuarenteed(l);
                    }
                }
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    Envelope envelope = (Envelope)iterator.next();
                    switch (this.FIB_) {
                        case 0: {
                            if (!envelope.YEC_()) {
                                envelope.dEC_(this.pH_, bl, true);
                                break;
                            }
                            long l3 = envelope.getGuarTracking();
                            if (!envelope.isQueueMessage()) {
                                iMgram.getAckListHandle().addAck(l3, this.pH_.getChannel());
                                break;
                            }
                            iMgram.getAckListHandle().addQAck(l3, l2, false, 0L, false, 0, this.pH_.getChannel());
                            break;
                        }
                        case 1: {
                            this.CIB_();
                        }
                        case 2: {
                            long l3 = envelope.getGuarTracking();
                            FastVector fastVector = this.HIB_;
                            synchronized (fastVector) {
                                this.HIB_.addElement(envelope);
                                this.IIB_.addElement(new Long(l2));
                            }
                            if (!envelope.isQueueMessage()) {
                                iMgram.getAckListHandle().addAck(l3, l2, false, 0L, true, this.SG_, this.pH_.getChannel());
                                break;
                            }
                            iMgram.getAckListHandle().addQAck(l3, l2, false, 0L, true, this.SG_, this.pH_.getChannel());
                            break;
                        }
                        case 3: 
                        case 4: {
                            throw new ETransactionAlreadyPrepared("");
                        }
                    }
                }
            }
            if (iMgram != null) {
                if (this.FIB_ == 0) {
                    if (bl) {
                        this.pH_.send(iMgram);
                        this.pH_.getConnectionInfo().VY_(iMgram);
                    } else {
                        this.pH_.vRB_(l, iMgram, this.pH_);
                    }
                } else {
                    this.pH_.send(iMgram);
                }
            }
        }
    }

    void qHB_() throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (this.HIB_.m_count == 0 || this.FIB_ != 2) {
            return;
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        long l = -1L;
        IMgram iMgram = MgramFactory.getMgramFactory().buildAckList();
        int n = 0;
        while (n < this.HIB_.m_count) {
            Envelope envelope = (Envelope)this.HIB_.m_data[n];
            long l2 = (Long)this.IIB_.m_data[n];
            long l3 = envelope.getGuarTracking();
            if (!envelope.isQueueMessage()) {
                iMgram.getAckListHandle().addAck(l3, l2, false, 0L, true, this.SG_, this.pH_.getChannel());
            } else {
                iMgram.getAckListHandle().addQAck(l3, l2, false, 0L, true, this.SG_, this.pH_.getChannel());
            }
            ++n;
        }
        this.pH_.send(iMgram);
    }

    public void acknowledge(Envelope envelope, boolean bl, long l) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (envelope.gEC_()) {
            return;
        }
        this.setTxnMgrUsed(true);
        if (!envelope.YEC_()) {
            envelope.dEC_(this.pH_, bl, false);
            return;
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        switch (this.FIB_) {
            case 0: {
                envelope.dEC_(this.pH_, bl, false);
                break;
            }
            case 1: {
                this.CIB_();
            }
            case 2: {
                long l2 = envelope.getGuarTracking();
                FastVector fastVector = this.HIB_;
                synchronized (fastVector) {
                    this.HIB_.addElement(envelope);
                    this.IIB_.addElement(new Long(l));
                }
                this.pH_.gl_(l2, true, this.SG_, l);
                break;
            }
            case 3: 
            case 4: {
                throw new ETransactionAlreadyPrepared("");
            }
        }
    }

    public void beginWork() throws EUnusableConnection, EAlreadyInTransaction, ETransactionFailure, EGeneralException {
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        if (this.FIB_ != 0) {
            throw new EAlreadyInTransaction();
        }
        this.CIB_();
    }

    public void rollbackWork() throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.rollbackWork(false);
    }

    public void rollbackWork(boolean bl) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.rollbackWork(bl, true, null);
    }

    public void rollbackWork(boolean bl, Object object) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.rollbackWork(bl, true, object);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void rollbackWork(boolean var1_1, boolean var2_2, Object var3_3) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionFailure, ENotConnected, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.pH_.MRB_(this.SG_);
        this.LIB_();
        var4_4 = prAccessor.getString("STR131");
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        var5_5 = false;
        var6_6 = 0;
        switch (this.FIB_) {
            case 0: {
                throw new ENotInTransaction(prAccessor.getString("STR132"));
            }
            case 2: 
            case 4: {
                if (!var2_2) {
                    this.FIB_ = 0;
                    break;
                }
                try {
                    if (this.isXATxn()) {
                        if (var3_3 == null) {
                            throw new EParameterIsNull("xid");
                        }
                        var9_7 = this.rHB_(var1_1, var3_3, 7);
                        var10_9 = 0;
                        var8_12 = ArrayUtil.readShort((byte[])var9_7, var10_9);
                        var10_9 += 2;
                        var10_9 += 4;
                        if (var8_12 == 0 && var1_1) {
                            var6_6 = ArrayUtil.readInt((byte[])var9_7, var10_9);
                            var5_5 = true;
                        }
                    } else {
                        var9_7 = this.GIB_(var1_1);
                        var10_10 = var9_7;
                        this.pH_.send(var9_7.WmB_(), (IMgramEnqueuedToSendListener)var10_10);
                        var9_7.join();
                        var11_15 = var9_7.UmB_();
                        var12_16 = 0;
                        var13_17 = var11_15.getRawBody();
                        var8_12 = ArrayUtil.readShort(var13_17, var12_16);
                        var12_16 += 2;
                        var12_16 += 4;
                        if (var1_1) {
                            var6_6 = ArrayUtil.readInt(var13_17, var12_16);
                            var12_16 += 4;
                            var5_5 = true;
                        }
                    }
                    switch (var8_12) {
                        case 2: {
                            if (this.FIB_ == 4) {
                                this.FIB_ = 0;
                                throw new EUnknownTransaction("");
                            }
                        }
                        case 0: {
                            this.FIB_ = 0;
                            ** break;
                        }
                        case 3: {
                            throw new ETransactionFailure(125, prAccessor.getString("STR132"));
                        }
                        case 12: {
                            if (var3_3 == null) {
                                throw new EXAThereIsNoXidException("null");
                            }
                            throw new EXAThereIsNoXidException(var3_3.toString());
                        }
                        case 11: {
                            if (var3_3 == null) {
                                throw new EXADuplicateXidException("null");
                            }
                            throw new EXADuplicateXidException(var3_3.toString());
                        }
                        case 6: {
                            throw new ETransactionFailure(158, SessionConfig.ERRMSG_TXN_ACC_VIOL);
                        }
                    }
                    throw new ETransactionFailure(124, var4_4);
lbl63:
                    // 1 sources

                    break;
                }
                catch (ENoSubscribersFound var7_18) {
                    throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
                }
                catch (ENotConnected var8_13) {
                    throw var8_13;
                }
                catch (EGeneralException var9_8) {
                    throw var9_8;
                }
                catch (IOException var10_11) {
                    throw new ETransactionFailure(124, var4_4);
                }
            }
            case 1: 
            case 3: {
                this.FIB_ = 0;
            }
        }
        var7_19 = 0;
        while (var7_19 < this.GIB_.size()) {
            ((Solicitation)this.GIB_.elementAt(var7_19)).cancel();
            ++var7_19;
        }
        this.GIB_.removeAllElements();
        var8_14 = this.HIB_;
        synchronized (var8_14) {
            this.HIB_.m_count = 0;
            this.IIB_.m_count = 0;
        }
        if (var5_5) {
            this.sHB_(var6_6);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean prepareWork(Object object) throws ENotInTransaction, ETransactionAlreadyPrepared, ETransactionRollbackByBroker, EUnusableConnection, ETransactionFailure, ENotConnected, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        String string = prAccessor.getString("STR133");
        String string2 = prAccessor.getString("STR134");
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        switch (this.FIB_) {
            case 0: {
                throw new ENotInTransaction(prAccessor.getString("STR132"));
            }
            case 3: 
            case 4: {
                throw new ETransactionAlreadyPrepared("");
            }
            case 1: {
                this.FIB_ = (short)3;
                return true;
            }
            case 2: {
                try {
                    short s;
                    if (this.isXATxn()) {
                        if (object == null) {
                            throw new EParameterIsNull("xid");
                        }
                        byte[] byArray = this.rHB_(false, object, 2);
                        int n = 0;
                        s = ArrayUtil.readShort(byArray, n);
                    } else {
                        Message message = new Message(this.pH_.getAdminPrefix() + ".prepareTransaction");
                        message.writeInt(this.SG_);
                        message.writeUTF((String)object);
                        Message message2 = this.request((IMessage)message, (IJobResolver)this.pH_);
                        s = message2.readShort();
                    }
                    switch (s) {
                        case 0: {
                            this.FIB_ = (short)4;
                            return true;
                        }
                        case 2: 
                        case 4: {
                            this.FIB_ = 0;
                            throw new ETransactionRollbackByBroker("");
                        }
                        case 3: {
                            throw new ETransactionFailure(125, string2);
                        }
                        case 12: {
                            if (object != null) throw new EXAThereIsNoXidException(object.toString());
                            throw new EXAThereIsNoXidException("null");
                        }
                        case 6: {
                            throw new ETransactionFailure(158, SessionConfig.ERRMSG_TXN_ACC_VIOL);
                        }
                    }
                    throw new ETransactionFailure(124, string);
                }
                catch (ENoSubscribersFound eNoSubscribersFound) {
                    throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
                }
                catch (ENotConnected eNotConnected) {
                    throw eNotConnected;
                }
                catch (EGeneralException eGeneralException) {
                    throw eGeneralException;
                }
                catch (IOException iOException) {
                    throw new ETransactionFailure(124, string);
                }
            }
        }
        return true;
    }

    private byte[] rHB_(boolean bl, Object object, int n) throws EInterrupted, ENotConnected, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        Connection connection = this.pH_;
        Request request = new Request(null, connection);
        int n2 = this.pH_.addRequest(request);
        IMgram iMgram = MgramFactory.getMgramFactory().buildExtendedTxnRequest(this.pH_.isFaultToleranceEnabled(), bl, this.SG_, n2, this.pH_.getClientId(), this.pH_.getChannel(), (XidImpl)object, n);
        request.VmB_(iMgram);
        request.setXonce(this.pH_.isFaultToleranceEnabled());
        Request request2 = request;
        this.pH_.send(request.WmB_(), (IMgramEnqueuedToSendListener)request2);
        if (!this.pH_.hierarchicallyConnected()) {
            this.pH_.jRB_(n2);
            throw new ENotConnected();
        }
        request.join();
        IMgram iMgram2 = request.UmB_();
        byte[] byArray = iMgram2.getRawBody();
        return byArray;
    }

    public void commitWork() throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(false, null, -1L, null);
    }

    public synchronized void commitWork(boolean bl, String string, long l) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(bl, string, l, null);
    }

    public synchronized void commitWork(boolean bl, String string, long l, boolean bl2, int n, String string2) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(bl, string, l, null, bl2, n, string2);
    }

    public synchronized void commitWork(boolean bl, Object object) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(bl, null, -1L, object);
    }

    public synchronized void commitWork(boolean bl, String string, long l, Object object) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(bl, string, l, object, false, 14, "");
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void commitWork(boolean var1_1, String var2_2, long var3_3, Object var5_4, boolean var6_5, int var7_6, String var8_7) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        var9_8 = prAccessor.getString("STR135");
        var10_9 = prAccessor.getString("STR136");
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        var11_10 = false;
        var12_11 = 0;
        switch (this.FIB_) {
            case 0: {
                throw new ENotInTransaction(prAccessor.getString("STR132"));
            }
            case 1: 
            case 3: {
                this.FIB_ = 0;
                break;
            }
            case 2: 
            case 4: {
                try {
                    var13_12 = null;
                    var13_12 = this.isXATxn() != false ? this.FIB_(var1_1, (XidImpl)var5_4) : this.EIB_(var1_1, var2_2, var3_3, var6_5, var7_6, var8_7);
                    var15_14 = var13_12;
                    this.pH_.send(var13_12.WmB_(), (IMgramEnqueuedToSendListener)var15_14);
                    var13_12.join();
                    var16_16 = var13_12.UmB_();
                    var17_17 = 0;
                    var18_18 = var16_16.getRawBody();
                    var14_19 = ArrayUtil.readShort(var18_18, var17_17);
                    var17_17 += 2;
                    var17_17 += 4;
                    var19_21 = -1L;
                    if (var14_19 == 13) {
                        var19_21 = ArrayUtil.readLong(var18_18, var17_17);
                        var17_17 += 8;
                    }
                    if (var1_1) {
                        var12_11 = ArrayUtil.readInt(var18_18, var17_17);
                        var17_17 += 4;
                        var11_10 = true;
                    }
                    switch (var14_19) {
                        case 0: {
                            this.FIB_ = 0;
                            this.uHB_();
                            ** break;
                        }
                        case 2: {
                            if (this.FIB_ == 4) {
                                this.FIB_ = 0;
                                throw new EUnknownTransaction("");
                            }
                        }
                        case 4: {
                            this.FIB_ = 0;
                            this.tHB_();
                            if (var11_10) {
                                this.sHB_(var12_11);
                            }
                            throw new ETransactionRollbackByBroker("");
                        }
                        case 3: {
                            throw new ETransactionFailure(125, var10_9);
                        }
                        case 12: {
                            if (var5_4 == null) {
                                throw new EXAThereIsNoXidException("null");
                            }
                            throw new EXAThereIsNoXidException(var5_4.toString());
                        }
                        case 11: {
                            if (var5_4 == null) {
                                throw new EXADuplicateXidException("null");
                            }
                            throw new EXADuplicateXidException(var5_4.toString());
                        }
                        case 6: {
                            throw new ETransactionFailure(158, SessionConfig.ERRMSG_TXN_ACC_VIOL);
                        }
                        case 13: {
                            var19_21 = var19_21 > 0L ? System.currentTimeMillis() + var19_21 : System.currentTimeMillis();
                            var21_22 = new EChannelTransactionFailure(var14_19, "Channel active");
                            var21_22.setTime(var19_21);
                            throw var21_22;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            this.FIB_ = 0;
                            this.tHB_();
                            if (var11_10) {
                                this.sHB_(var12_11);
                            }
                            throw new ETransactionFailure(var14_19, "Duplicate Transaction Detection exception");
                        }
                    }
                    throw new ETransactionFailure(124, var9_8);
lbl73:
                    // 1 sources

                    break;
                }
                catch (ENoSubscribersFound var13_13) {
                    throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
                }
                catch (EGeneralException var14_20) {
                    throw var14_20;
                }
                catch (IOException var15_15) {
                    throw new ETransactionFailure(124, var9_8);
                }
            }
        }
        this.tHB_();
        if (var11_10) {
            this.sHB_(var12_11);
        }
    }

    public int getTid() {
        return this.SG_;
    }

    private void sHB_(int n) {
        if (this.SG_ != -1) {
            this.pH_.MRB_(this.SG_);
        }
        this.SG_ = n;
        this.FIB_ = (short)2;
        this.pH_.LRB_(this, this.SG_);
    }

    private void tHB_() throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.GIB_.removeAllElements();
        FastVector fastVector = this.HIB_;
        synchronized (fastVector) {
            int n = 0;
            while (n < this.HIB_.m_count) {
                ((Envelope)this.HIB_.m_data[n]).dEC_(this.pH_, false, true);
                ++n;
            }
            this.HIB_.m_count = 0;
            this.IIB_.m_count = 0;
        }
        this.LIB_();
    }

    private void uHB_() {
        FastVector fastVector = this.HIB_;
        synchronized (fastVector) {
            int n = 0;
            while (n < this.HIB_.m_count) {
                ((Envelope)this.HIB_.m_data[n]).setUserAcked();
                ++n;
            }
        }
    }

    public boolean isInWorkScope() {
        return this.FIB_ != 0;
    }

    public int updateChannelDupDetectInfo(String string, String string2, long l, int n) throws IOException {
        Request request;
        Request request2 = request = this.HIB_(string, l, n, string2);
        this.pH_.send(request.WmB_(), (IMgramEnqueuedToSendListener)request2);
        request.join();
        IMgram iMgram = request.UmB_();
        int n2 = 0;
        byte[] byArray = iMgram.getRawBody();
        short s = ArrayUtil.readShort(byArray, n2);
        n2 += 2;
        return s;
    }

    public int deleteChannelDupDetectInfo(String string, String string2) throws IOException {
        Request request;
        Request request2 = request = this.IIB_(string, string2);
        this.pH_.send(request.WmB_(), (IMgramEnqueuedToSendListener)request2);
        request.join();
        IMgram iMgram = request.UmB_();
        int n = 0;
        byte[] byArray = iMgram.getRawBody();
        short s = ArrayUtil.readShort(byArray, n);
        n += 2;
        return s;
    }

    public Publication publish(IMessage iMessage, int n, boolean bl) throws EParameterIsNull, ESubjectNotSet, ETimeout, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (iMessage == null) {
            throw new EParameterIsNull(SessionConfig.PARAM_IS_NULL);
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (!iMessage.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        Subject subject = this.pH_.getSubjectTree().getSubjectNode(iMessage.getSubject());
        Envelope envelope = new Envelope(iMessage, subject.getPublishLabel());
        envelope.VEC_();
        return this.publishInternal(envelope, n, bl, false);
    }

    public Publication publish(Envelope envelope, int n, boolean bl) throws EParameterIsNull, EEmptyEnvelope, ESubjectNotSet, ETimeout, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (envelope == null) {
            throw new EParameterIsNull("envelope");
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message message = envelope.getMessage();
        if (message == null) {
            throw new EEmptyEnvelope();
        }
        if (!message.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        envelope.setTimestamp(System.currentTimeMillis());
        if (SessionConfig.IN_BROKER) {
            envelope = (Envelope)envelope.clone();
        }
        envelope.VEC_();
        return this.publishInternal(envelope, n, bl, false);
    }

    public Publication publish(Envelope envelope, int n, boolean bl, boolean bl2) throws EParameterIsNull, EEmptyEnvelope, ESubjectNotSet, ETimeout, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (envelope == null) {
            throw new EParameterIsNull("envelope");
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message message = envelope.getMessage();
        if (message == null) {
            throw new EEmptyEnvelope();
        }
        if (!message.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        envelope.setTimestamp(System.currentTimeMillis());
        envelope.VEC_();
        return this.publishInternal(envelope, n, bl, !bl2);
    }

    public Publication publishAsIs(Envelope envelope, int n, boolean bl) throws EParameterIsNull, EEmptyEnvelope, ESubjectNotSet, ETimeout, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (envelope == null) {
            throw new EParameterIsNull("envelope");
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message message = envelope.getMessage();
        if (message == null) {
            throw new EEmptyEnvelope();
        }
        if (!message.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        envelope.setTimestamp(System.currentTimeMillis());
        return this.publishInternal(envelope, n, bl, false);
    }

    public Subscription submitSubscription(String string, Label label, Date date) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException, EInvalidTTLException {
        if (string == null || string.equals("")) {
            throw new EInvalidSubjectSyntax(prAccessor.getString("STR130"));
        }
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        label.setExpiration(date);
        return this.submitSubscription(string, label);
    }

    public Message request(IMessage iMessage, int n) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(iMessage, n, null);
    }

    public Message request(IMessage iMessage, int n, IJobResolver iJobResolver) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (!iMessage.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        SubjectTree subjectTree = this.pH_.getSubjectTree();
        Subject subject = subjectTree.getSubjectNode(iMessage.getSubject());
        Envelope envelope = new Envelope(iMessage, subject.getPublishLabel());
        IMessage iMessage2 = this.zHB_(envelope, n, iJobResolver);
        return (Message)iMessage2;
    }

    public Message requestAdmin(IMessage iMessage, int n) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.requestAdmin(iMessage, n, null);
    }

    public Message requestAdmin(IMessage iMessage, int n, IJobResolver iJobResolver) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (!iMessage.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        SubjectTree subjectTree = this.pH_.getSubjectTree();
        Subject subject = subjectTree.getSubjectNode(iMessage.getSubject());
        Envelope envelope = new Envelope(iMessage, (Label)subject.getPublishLabel().clone());
        envelope.getLabel().setPriority((byte)12);
        IMessage iMessage2 = this.zHB_(envelope, n, iJobResolver);
        return (Message)iMessage2;
    }

    public Envelope requestEnvelope(IMessage iMessage, int n) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.requestEnvelope(iMessage, n, null);
    }

    public Envelope requestEnvelope(IMessage iMessage, int n, IJobResolver iJobResolver) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (!iMessage.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        SubjectTree subjectTree = this.pH_.getSubjectTree();
        Subject subject = subjectTree.getSubjectNode(iMessage.getSubject());
        Envelope envelope = new Envelope(iMessage, subject.getPublishLabel());
        return new Envelope(this.zHB_(envelope, n, iJobResolver));
    }

    public Message request(Envelope envelope, int n) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(envelope, n, null);
    }

    public Message request(Envelope envelope, int n, IJobResolver iJobResolver) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message message = envelope.getMessage();
        if (message == null) {
            throw new EEmptyEnvelope();
        }
        if (!message.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        if (SessionConfig.DEBUG) {
            System.out.println("request: " + envelope.toString());
        }
        envelope.setTimestamp(System.currentTimeMillis());
        IMessage iMessage = this.zHB_((Envelope)envelope.clone(), n, iJobResolver);
        return (Message)iMessage;
    }

    public Envelope requestEnvelope(Envelope envelope, int n) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.requestEnvelope(envelope, n, null);
    }

    public Envelope requestEnvelope(Envelope envelope, int n, IJobResolver iJobResolver) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message message = envelope.getMessage();
        if (message == null) {
            throw new EEmptyEnvelope();
        }
        if (!message.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        if (SessionConfig.DEBUG) {
            System.out.println("request: " + envelope.toString());
        }
        envelope.setTimestamp(System.currentTimeMillis());
        return new Envelope(this.zHB_((Envelope)envelope.clone(), n, iJobResolver));
    }

    public Solicitation solicit(Envelope envelope, MessageHandler messageHandler) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message message = envelope.getMessage();
        if (message == null) {
            throw new EEmptyEnvelope();
        }
        if (!message.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        envelope.setTimestamp(System.currentTimeMillis());
        Envelope envelope2 = (Envelope)envelope.clone();
        envelope2.VEC_();
        return this.solicitInternal(envelope2, messageHandler, -1);
    }

    public Publication reply(IMessage iMessage, Envelope envelope, boolean bl) throws EEnvelopeIsNotRequest, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Envelope envelope2 = new Envelope(iMessage, (Label)envelope.getLabel().clone());
        return this.yHB_(envelope2, envelope, 0, bl);
    }

    public Publication reply(Envelope envelope, Envelope envelope2, boolean bl) throws EEmptyEnvelope, EEnvelopeIsNotRequest, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (!envelope2.isRequest()) {
            throw new EEnvelopeIsNotRequest();
        }
        envelope.setTimestamp(System.currentTimeMillis());
        Envelope envelope3 = (Envelope)envelope.clone();
        if (envelope.getLabel() != null) {
            envelope3.setLabel((Label)envelope.getLabel().clone());
        }
        return this.yHB_(envelope3, envelope2, 0, bl);
    }

    Subscription vHB_(String string, Label label, String string2, boolean bl, boolean bl2, int n) throws ENetworkFailure, ESecurityPolicyViolation, EInvalidTTLException, EGeneralException {
        Object object = this.pH_.FRB_();
        synchronized (object) {
            Subscription subscription = this.pH_.Ul_(string);
            if (string2 != null) {
                subscription.cT_(string2);
                subscription.dT_(bl);
            }
            subscription.XT_(bl2);
            subscription.setFlowToDisk(n);
            try {
                subscription.setDeliveryLabel(label);
                subscription.setStatus(1);
                Subscription subscription2 = subscription;
                return subscription2;
            }
            catch (EGeneralException eGeneralException) {
                if (subscription.getStatus() == 3) {
                    subscription.setStatus(0);
                    this.pH_.Tl_(string);
                }
                throw eGeneralException;
            }
        }
    }

    protected Message wHB_(String string, Label label, String string2, boolean bl, boolean bl2, int n) throws EInvalidSubjectSyntax {
        Message message = new Message(SessionConfig.getAdminPrefix(this.pH_.getEffectiveUid(), this.pH_.getApplicationId()) + ".subscribe");
        try {
            message.writeUTF(string);
            label.serialize(message);
            message.writeUTF(string2 == null ? "" : string2);
            message.writeBoolean(bl);
            message.writeBoolean(bl2);
            message.writeInt(n);
            return message;
        }
        catch (IOException iOException) {
            throw new EInvalidSubjectSyntax(prMessageFormat.format(prAccessor.getString("STR138"), new Object[]{iOException.toString()}));
        }
    }

    protected Message xHB_(String string) throws EInvalidSubjectSyntax {
        Message message = new Message(SessionConfig.getAdminPrefix(this.pH_.getEffectiveUid(), this.pH_.getApplicationId()) + ".unsubscribe");
        try {
            message.writeInt(0);
            message.writeUTF(string);
            return message;
        }
        catch (IOException iOException) {
            throw new EInvalidSubjectSyntax(prMessageFormat.format(prAccessor.getString("STR138"), new Object[]{iOException.toString()}));
        }
    }

    public Publication publishInternal(Envelope envelope, int n, boolean bl, boolean bl2) throws EInterrupted, ETimeout, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        return this.publishInternal(envelope, n, bl, bl2, null);
    }

    public Publication publishInternal(Envelope envelope, int n, boolean bl, boolean bl2, Request request) throws EInterrupted, ETimeout, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        boolean bl3;
        boolean bl4 = bl3 = envelope.getMgram().getType() == 11;
        if (!bl2) {
            switch (this.FIB_) {
                case 0: {
                    break;
                }
                case 1: {
                    this.CIB_();
                }
                case 2: {
                    envelope.XEC_(this.SG_);
                    break;
                }
                case 3: 
                case 4: {
                    throw new ETransactionAlreadyPrepared("");
                }
            }
        }
        kb kb2 = new kb(this, request, envelope);
        if (n == 0 && !bl) {
            this.pH_.send(envelope, (IMgramEnqueuedToSendListener)kb2);
            return null;
        }
        long l = this.pH_.genPubTrackingNum();
        envelope.WEC_(l);
        AAFJobResolver aAFJobResolver = null;
        if (bl3) {
            aAFJobResolver = new AAFJobResolver(envelope, this.pH_);
        }
        Publication publication = new Publication(this.pH_, envelope.getMessage().getSubject(), aAFJobResolver);
        if (bl3) {
            kb2 = new kb(this, publication, envelope);
            publication.setStatus(3);
        }
        if (request != null) {
            request.XmB_(publication);
        }
        if (this.pH_.YRB_()) {
            this.pH_.addJobForRecoveryPurposes(l, publication);
        } else {
            this.pH_.addJob(l, publication);
        }
        if (!this.pH_.hierarchicallyConnected()) {
            this.pH_.removeJob(l);
            throw new ENotConnected();
        }
        switch (n) {
            case -1: {
                try {
                    this.pH_.send(envelope, (IMgramEnqueuedToSendListener)kb2);
                }
                catch (EGeneralException eGeneralException) {
                    this.pH_.removeJob(l);
                    throw eGeneralException;
                }
                publication.join();
                break;
            }
            case 0: {
                try {
                    this.pH_.send(envelope, (IMgramEnqueuedToSendListener)kb2);
                    break;
                }
                catch (EGeneralException eGeneralException) {
                    this.pH_.removeJob(l);
                    throw eGeneralException;
                }
            }
            default: {
                long l2 = (long)n * 1000L;
                long l3 = System.currentTimeMillis() + l2;
                try {
                    this.pH_.send(envelope, l2, kb2);
                }
                catch (EGeneralException eGeneralException) {
                    this.pH_.removeJob(l);
                    throw eGeneralException;
                }
                publication.joinMillis(l3 - System.currentTimeMillis());
            }
        }
        if (publication.getStatus() == -3) {
            throw new EIntegrityCompromised();
        }
        return bl ? publication : null;
    }

    private Publication yHB_(Envelope envelope, Envelope envelope2, int n, boolean bl) throws EEnvelopeIsNotRequest, ETimeout, EInterrupted, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        envelope.VEC_();
        envelope.setReply(envelope2);
        return this.publishInternal(envelope, n, bl, false);
    }

    private IMessage zHB_(Envelope envelope, int n, IJobResolver iJobResolver) throws ETimeout, EInterrupted, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        envelope.VEC_();
        Request request = new Request(envelope, iJobResolver);
        int n2 = this.pH_.addRequest(request);
        envelope.setRequest(n2, this.pH_.getClientAddr(), this.pH_.getClientAddrSubject());
        Label label = (Label)envelope.getLabel().clone();
        label.setReplyPriority((byte)10);
        envelope.setLabel(label);
        boolean bl = n != -1 && n != 0;
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        this.publishInternal(envelope, n, false, true, request);
        if (bl) {
            long l2 = (long)n * 1000L - (System.currentTimeMillis() - l);
            if (l2 <= 0L) {
                throw new ETimeout(SessionConfig.REQ_TIMEOUT);
            }
            request.joinMillis(l2);
        } else {
            request.join();
        }
        Message message = request.TmB_().getMessage();
        return message;
    }

    public Solicitation solicitInternal(Envelope envelope, MessageHandler messageHandler, int n) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.pH_.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message message = envelope.getMessage();
        if (message == null) {
            throw new EEmptyEnvelope();
        }
        if (!message.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
        switch (this.FIB_) {
            case 0: {
                break;
            }
            case 1: {
                this.CIB_();
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                throw new ETransactionAlreadyPrepared("");
            }
        }
        this.pH_.addMessageHandler(messageHandler);
        Solicitation solicitation = this.pH_.iRB_(envelope, messageHandler);
        envelope.setRequest(solicitation.getTracking(), this.pH_.getClientAddr(), this.pH_.getClientAddrSubject());
        if (this.FIB_ == 2) {
            this.GIB_.addElement(solicitation);
        }
        try {
            this.publishInternal(envelope, n, false, false);
        }
        catch (EGeneralException eGeneralException) {
            solicitation.cancel();
            throw eGeneralException;
        }
        return solicitation;
    }

    protected Envelope AIB_(IMessage iMessage) {
        SubjectTree subjectTree = this.pH_.getSubjectTree();
        Subject subject = subjectTree.getSubjectNode(iMessage.getSubject());
        return new Envelope(iMessage, subject.getPublishLabel());
    }

    public boolean isPublishAllowed(String string) {
        return this.BIB_("PUBLISH", string);
    }

    public boolean isSubscribeAllowed(String string) {
        return this.BIB_("SUBSCRIBE", string);
    }

    public boolean isGuaranteedAllowed(String string) {
        return this.BIB_("GUARANTEE", string);
    }

    private boolean BIB_(String string, String string2) {
        boolean bl = false;
        if (this.pH_.hRB_() || !this.pH_.hierarchicallyConnected() || string2 == null || string2.compareTo("") == 0) {
            return bl;
        }
        try {
            Message message = new Message(this.pH_.getAdminPrefix() + "." + "isOperationAllowed");
            message.writeUTF(string);
            message.writeUTF(string2);
            Connection connection = this.pH_;
            Message message2 = this.request((IMessage)message, (IJobResolver)connection);
            bl = message2.readBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private void CIB_() throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        try {
            Request request;
            Request request2 = request = this.DIB_();
            this.pH_.send(request.WmB_(), (IMgramEnqueuedToSendListener)request2);
            request.join();
            IMgram iMgram = request.UmB_();
            int n = 0;
            byte[] byArray = iMgram.getRawBody();
            short s = ArrayUtil.readShort(byArray, n);
            n += 2;
            this.sHB_(ArrayUtil.readInt(byArray, n += 4));
        }
        catch (ENoSubscribersFound eNoSubscribersFound) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
        }
        catch (EGeneralException eGeneralException) {
            throw eGeneralException;
        }
        catch (IOException iOException) {
            throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
        }
    }

    private Request DIB_() {
        Connection connection = this.pH_;
        Request request = new Request(null, connection);
        int n = this.pH_.addRequest(request);
        IMgram iMgram = MgramFactory.getMgramFactory().buildBeginTxnRequest(this.pH_.isFaultToleranceEnabled(), n, this.pH_.getClientId(), this.pH_.getChannel());
        request.VmB_(iMgram);
        request.setXonce(this.pH_.isFaultToleranceEnabled());
        return request;
    }

    private Request EIB_(boolean bl, String string, long l, boolean bl2, int n, String string2) {
        Connection connection = this.pH_;
        Request request = new Request(null, connection);
        int n2 = this.pH_.addRequest(request);
        IMgram iMgram = null;
        iMgram = string == null ? MgramFactory.getMgramFactory().buildCommitTxnRequest(this.pH_.isFaultToleranceEnabled(), bl, this.SG_, n2, this.pH_.getClientId(), this.pH_.getChannel()) : (!bl2 ? MgramFactory.getMgramFactory().buildNoDupCommitTxnRequest(this.pH_.isFaultToleranceEnabled(), bl, this.SG_, n2, this.pH_.getClientId(), this.pH_.getChannel(), string, l) : MgramFactory.getMgramFactory().buildNoDupChannelCommitTxnRequest(this.pH_.isFaultToleranceEnabled(), bl, this.SG_, n2, this.pH_.getClientId(), this.pH_.getChannel(), string, l, n, string2));
        request.VmB_(iMgram);
        request.setXonce(this.pH_.isFaultToleranceEnabled());
        return request;
    }

    private Request FIB_(boolean bl, Object object) {
        Connection connection = this.pH_;
        Request request = new Request(null, connection);
        int n = this.pH_.addRequest(request);
        IMgram iMgram = MgramFactory.getMgramFactory().buildExtendedTxnRequest(this.pH_.isFaultToleranceEnabled(), bl, this.SG_, n, this.pH_.getClientId(), this.pH_.getChannel(), (XidImpl)object, 3);
        request.VmB_(iMgram);
        request.setXonce(this.pH_.isFaultToleranceEnabled());
        return request;
    }

    private Request GIB_(boolean bl) {
        Connection connection = this.pH_;
        Request request = new Request(null, connection);
        int n = this.pH_.addRequest(request);
        IMgram iMgram = MgramFactory.getMgramFactory().buildAbortTxnRequest(this.pH_.isFaultToleranceEnabled(), bl, this.SG_, n, this.pH_.getClientId(), this.pH_.getChannel());
        request.VmB_(iMgram);
        request.setXonce(this.pH_.isFaultToleranceEnabled());
        return request;
    }

    public void setTxnMgrUsed(boolean bl) {
        this.LIB_ = bl;
    }

    public boolean isTxnMgrUsed() {
        return this.LIB_;
    }

    private Request HIB_(String string, long l, int n, String string2) {
        Connection connection = this.pH_;
        Request request = new Request(null, connection);
        int n2 = this.pH_.addRequest(request);
        IMgram iMgram = MgramFactory.getMgramFactory().buildNoDupChannelUpdateTxnRequest(this.pH_.isFaultToleranceEnabled(), n2, this.pH_.getClientId(), this.pH_.getChannel(), string, l, n, string2);
        request.VmB_(iMgram);
        request.setXonce(this.pH_.isFaultToleranceEnabled());
        return request;
    }

    private Request IIB_(String string, String string2) {
        Connection connection = this.pH_;
        Request request = new Request(null, connection);
        int n = this.pH_.addRequest(request);
        IMgram iMgram = MgramFactory.getMgramFactory().buildNoDupChannelDeleteTxnRequest(this.pH_.isFaultToleranceEnabled(), n, this.pH_.getClientId(), this.pH_.getChannel(), string, string2);
        request.VmB_(iMgram);
        request.setXonce(this.pH_.isFaultToleranceEnabled());
        return request;
    }

    public void beginGlobalTransaction(Object object) throws EUnusableConnection, EAlreadyInTransaction, ETransactionFailure, EXADuplicateXidException, ENotConnected, EGeneralException {
        if (!this.isXATxn()) {
            throw new EUsage(99, "non XA txn should not start by this method.");
        }
        if (object == null) {
            throw new EParameterIsNull("xid");
        }
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        if (this.FIB_ != 0) {
            throw new EAlreadyInTransaction();
        }
        try {
            byte[] byArray = this.rHB_(false, object, 0);
            int n = 0;
            short s = ArrayUtil.readShort(byArray, n);
            n += 2;
            switch (s) {
                case 0: {
                    this.SG_ = ArrayUtil.readInt(byArray, n += 4);
                    this.FIB_ = (short)2;
                    this.pH_.LRB_(this, this.SG_);
                    break;
                }
                case 11: {
                    throw new EXADuplicateXidException(object.toString());
                }
                default: {
                    throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
                }
            }
        }
        catch (ESecurityPolicyViolation eSecurityPolicyViolation) {
            throw eSecurityPolicyViolation;
        }
        catch (ENoSubscribersFound eNoSubscribersFound) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
        }
        catch (EXADuplicateXidException eXADuplicateXidException) {
            throw eXADuplicateXidException;
        }
        catch (EInterrupted eInterrupted) {
            throw eInterrupted;
        }
        catch (ENotConnected eNotConnected) {
            throw eNotConnected;
        }
        catch (ENetworkFailure eNetworkFailure) {
            throw eNetworkFailure;
        }
        catch (EGeneralException eGeneralException) {
            throw eGeneralException;
        }
        catch (IOException iOException) {
            throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
        }
    }

    public void resumeGlobalTransaction(Object object) throws EUnusableConnection, ETransactionFailure, EXAThereIsNoXidException, ENotConnected, EGeneralException {
        if (object == null) {
            throw new EParameterIsNull("xid");
        }
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        try {
            byte[] byArray = this.rHB_(false, object, 5);
            int n = 0;
            short s = ArrayUtil.readShort(byArray, n);
            n += 2;
            switch (s) {
                case 0: {
                    this.FIB_ = (short)2;
                    break;
                }
                case 12: {
                    throw new EXAThereIsNoXidException(object.toString());
                }
                case 2: {
                    throw new ETransactionFailure(126, "txn(" + this.SG_ + ") not found in broker.");
                }
                case 3: {
                    throw new ETransactionFailure(126, "txn(" + this.SG_ + ") sequence error in broker.");
                }
                default: {
                    throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
                }
            }
        }
        catch (ENoSubscribersFound eNoSubscribersFound) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
        }
        catch (ENotConnected eNotConnected) {
            throw eNotConnected;
        }
        catch (IOException iOException) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"));
        }
    }

    public void joinGlobalTransaction(Object object) throws EUnusableConnection, ETransactionFailure, EXAThereIsNoXidException, ENotConnected, EGeneralException {
        if (object == null) {
            throw new EParameterIsNull("xid");
        }
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        try {
            byte[] byArray = this.rHB_(false, object, 4);
            short s = ArrayUtil.readShort(byArray, 0);
            switch (s) {
                case 0: {
                    this.FIB_ = (short)2;
                    break;
                }
                case 12: {
                    throw new EXAThereIsNoXidException(object.toString());
                }
                case 2: {
                    throw new ETransactionFailure(126, "txn(" + this.SG_ + ") not found in broker.");
                }
                case 3: {
                    throw new ETransactionFailure(126, "txn(" + this.SG_ + ") sequence error in broker.");
                }
                default: {
                    throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
                }
            }
        }
        catch (ENoSubscribersFound eNoSubscribersFound) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
        }
        catch (ENotConnected eNotConnected) {
            throw eNotConnected;
        }
        catch (IOException iOException) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"));
        }
    }

    public void endGlobalTransaction(Object object) throws EParameterIsNull, EUnusableConnection, ENotConnected, ENetworkFailure, EXAThereIsNoXidException, ETransactionFailure {
        if (object == null) {
            throw new EParameterIsNull("xid");
        }
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        try {
            byte[] byArray = this.rHB_(false, object, 1);
            int n = 0;
            short s = ArrayUtil.readShort(byArray, n);
            switch (s) {
                case 0: {
                    break;
                }
                case 12: {
                    throw new EXAThereIsNoXidException(object.toString());
                }
                case 2: {
                    throw new ETransactionFailure(126, "txn(" + this.SG_ + ") not found in broker.");
                }
                case 3: {
                    throw new ETransactionFailure(126, "txn(" + this.SG_ + ") sequence error in broker.");
                }
                default: {
                    throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
                }
            }
        }
        catch (ENoSubscribersFound eNoSubscribersFound) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
        }
        catch (ENotConnected eNotConnected) {
            throw eNotConnected;
        }
        catch (IOException iOException) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"));
        }
    }

    public void suspendGlobalTransaction(Object object) throws EParameterIsNull, EUnusableConnection, ENotConnected, ENetworkFailure, EXAThereIsNoXidException, ETransactionFailure {
        if (object == null) {
            throw new EParameterIsNull("xid");
        }
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        try {
            byte[] byArray = this.rHB_(false, object, 6);
            short s = ArrayUtil.readShort(byArray, 0);
            switch (s) {
                case 0: {
                    break;
                }
                case 12: {
                    throw new EXAThereIsNoXidException(object.toString());
                }
                case 2: {
                    throw new ETransactionFailure(126, "txn(" + this.SG_ + ") not found in broker.");
                }
                case 3: {
                    throw new ETransactionFailure(126, "txn(" + this.SG_ + ") sequence error in broker.");
                }
                default: {
                    throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
                }
            }
        }
        catch (ENoSubscribersFound eNoSubscribersFound) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
        }
        catch (ENotConnected eNotConnected) {
            throw eNotConnected;
        }
        catch (IOException iOException) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"));
        }
    }

    public Vector getPreparedGlobalTransactions() throws EUnusableConnection, ENetworkFailure, ETransactionFailure {
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        Vector<Object> vector = new Vector<Object>();
        try {
            Message message = null;
            message = new Message(this.pH_.getAdminPrefix() + ".getPreparedGlobalTransactions");
            Connection connection = this.pH_;
            Message message2 = this.request((IMessage)message, (IJobResolver)this.pH_);
            int n = message2.readInt();
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(message2.readObject());
                ++n2;
            }
        }
        catch (ENoSubscribersFound eNoSubscribersFound) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ENetworkFailure(176, "ClassNotFound from rep.readObject()");
        }
        catch (IOException iOException) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"));
        }
        return vector;
    }

    public boolean isThereXid(Object object) throws EParameterIsNull, EUnusableConnection, ENetworkFailure, ETransactionFailure {
        if (object == null) {
            throw new EParameterIsNull("xid");
        }
        if (this.pH_.hRB_()) {
            throw new EUnusableConnection();
        }
        boolean bl = false;
        try {
            Message message = null;
            message = new Message(this.pH_.getAdminPrefix() + ".isThereXid");
            message.writeObject(object);
            Connection connection = this.pH_;
            Message message2 = this.request((IMessage)message, (IJobResolver)this.pH_);
            bl = message2.readBoolean();
        }
        catch (ENoSubscribersFound eNoSubscribersFound) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
        }
        catch (IOException iOException) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"));
        }
        return bl;
    }

    void JIB_(Envelope envelope) {
        if (this.MIB_ == null) {
            this.MIB_ = new ArrayList();
        }
        ArrayList arrayList = this.MIB_;
        synchronized (arrayList) {
            if (SessionConfig.DEBUG) {
                System.out.println("adding " + envelope.getMgram().memoryLength() + " bytes to txn buffer limiter");
            }
            if (SessionConfig.DEBUG) {
                System.out.println("adding msg " + envelope.getGuarTracking() + " of txn " + envelope.getMgram().getTxnId() + " to pending storage ack list");
            }
            this.MIB_.add(new Long(envelope.getGuarTracking()));
        }
    }

    void KIB_(long l) {
        int n;
        Vector<Long> vector = new Vector<Long>();
        ArrayList arrayList = this.MIB_;
        synchronized (arrayList) {
            n = this.MIB_.indexOf(new Long(l));
            int n2 = 0;
            while (n2 <= n) {
                long l2 = (Long)this.MIB_.remove(0);
                vector.add(new Long(l2));
                ++n2;
            }
        }
        n = 0;
        while (n < vector.size()) {
            long l3 = (Long)vector.elementAt(n);
            if (SessionConfig.DEBUG) {
                System.out.println("receivedStorageAck(): removing msg " + l3 + " from pending storage ack list");
            }
            IMgram iMgram = this.pH_.getConnectionInfo().wX_(l3, null);
            this.pH_.terminateJob(l3, 0);
            if (iMgram != null && SessionConfig.DEBUG) {
                System.out.println("receivedStorageAck(): subtracting " + iMgram.memoryLength() + " from txn buffer limiter");
            }
            ++n;
        }
    }

    void LIB_() {
        if (!this.pH_.isFaultToleranceEnabled() || this.MIB_ == null) {
            return;
        }
        ArrayList arrayList = this.MIB_;
        synchronized (arrayList) {
            if (this.MIB_.isEmpty()) {
                return;
            }
            Iterator iterator = ((AbstractList)this.MIB_).iterator();
            while (iterator.hasNext()) {
                IMgram iMgram;
                long l = (Long)iterator.next();
                iterator.remove();
                if (SessionConfig.DEBUG) {
                    System.out.println("removeAllPendingTxnMsgs(): removing msg " + l + " from pending storage ack list");
                }
                if ((iMgram = this.pH_.getConnectionInfo().wX_(l, null)) == null || !SessionConfig.DEBUG) continue;
                System.out.println("removeAllPendingTxnMsgs(): subtracting " + iMgram.memoryLength() + " from txn buffer limiter");
            }
        }
    }

    void MIB_(long l, IMgram iMgram) {
        ArrayList arrayList = this.MIB_;
        synchronized (arrayList) {
            ((AbstractCollection)this.MIB_).remove(new Long(l));
        }
    }
}

