/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import progress.message.zclient.DebugObject;
import progress.message.zclient.WeightedItem;
import progress.message.zclient.zu;

public class WeightedItemTable
extends DebugObject {
    private HashMap fVB_ = new HashMap();
    private zu gVB_ = new zu(this);

    public void removeItem(Object object) {
        this.fVB_.remove(object);
    }

    public void loadInitialItems(Object object, long l) {
        this.fVB_.clear();
        WeightedItem weightedItem = new WeightedItem(object, l);
        weightedItem.setSecondaryWeight(0L);
        this.fVB_.put(object, weightedItem);
    }

    public void loadInitialItems(Object[] objectArray, long l) {
        this.loadInitialItems(objectArray, 0, l);
    }

    public void loadInitialItems(Object[] objectArray, int n, long l) {
        this.fVB_.clear();
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (n3 + n) % n2;
            Object object = objectArray[n4];
            WeightedItem weightedItem = new WeightedItem(object, l);
            weightedItem.setSecondaryWeight(n3);
            this.fVB_.put(object, weightedItem);
            ++n3;
        }
    }

    public WeightedItem updateItem(Object object, long l) {
        WeightedItem weightedItem = (WeightedItem)this.fVB_.get(object);
        if (weightedItem != null) {
            weightedItem.setWeight(l);
        } else {
            weightedItem = new WeightedItem(object, l);
            weightedItem.setSecondaryWeight(this.fVB_.size() + 1);
            this.fVB_.put(object, weightedItem);
        }
        return weightedItem;
    }

    public long totalWeight() {
        long l = 0L;
        Set set = this.fVB_.entrySet();
        Iterator iterator = set.iterator();
        Map.Entry entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            WeightedItem weightedItem = (WeightedItem)entry.getValue();
            l += weightedItem.getWeight();
        }
        return l;
    }

    public long size() {
        return this.fVB_.size();
    }

    public void clear() {
        this.fVB_.clear();
    }

    public Collection sort() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.fVB_.values());
        Collections.sort(arrayList, this.gVB_);
        return arrayList;
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer("WeightedItemTable Dump\n");
        Collection collection = this.sort();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            WeightedItem weightedItem = (WeightedItem)iterator.next();
            stringBuffer.append("WEIGHT=" + weightedItem.getWeight() + ",ITEM=" + weightedItem.getItem() + "\n");
        }
        stringBuffer.append("End Of Dump\n");
        return stringBuffer.toString();
    }
}

