/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import progress.message.client.EGeneralException;
import progress.message.msg.IMgram;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramFactory;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.xonce.IIDRInboundSupport;
import progress.message.zclient.xonce.IIDROutboundSupport;
import progress.message.zclient.xonce.IIDRTransport;

public abstract class BaseIDRTransport
extends DebugObject
implements IIDRTransport {
    protected IIDROutboundSupport ia_;
    protected IIDRInboundSupport Gw_;
    protected String s_;
    protected boolean Qz_ = false;

    public abstract void close();

    public abstract void abort();

    public abstract void handleIDR(Envelope var1);

    protected abstract void Sw_(IMgram var1) throws EGeneralException;

    protected abstract void Tw_(IMgram var1) throws EGeneralException;

    protected abstract void Uw_(IMgram var1, Envelope var2) throws EGeneralException;

    protected abstract void Vw_(IMgram var1) throws EGeneralException;

    public BaseIDRTransport(boolean bl, String string, IIDROutboundSupport iIDROutboundSupport, IIDRInboundSupport iIDRInboundSupport) {
        super("BaseIDRTransport");
        this.Qz_ = bl;
        this.s_ = string;
        this.ia_ = iIDROutboundSupport;
        this.Gw_ = iIDRInboundSupport;
    }

    public void initiateIDRProtocol() throws EGeneralException, IOException {
        List list = null;
        boolean bl2 = false;
        if (this.ia_ != null) {
            int n;
            boolean bl = false;
            list = this.ia_.getPREQTrackNums();
            if (list != null) {
                n = list.size();
            }
            bl2 = this.ia_.hasGuaranteedMessagesPending() || n > 0;
        }
        boolean bl = bl2 || this.Qz_;
        int n = this.Gw_.getDNRTrackNums(1).size() + this.Gw_.getDNRTrackNums(0).size() + this.Gw_.getUGATrackNums(1).size() + this.Gw_.getUGATrackNums(0).size();
        if (this.zF_) {
            this.debug("sendIDRRequest: " + this.s_ + ": sending IDR request, num=" + n);
        }
        boolean bl3 = n > 0;
        List list2 = MgramFactory.getMgramFactory().buildIDRMgramList(true, bl, bl2, this.Gw_.getDNRTrackNums(1), this.Gw_.getDNRTrackNums(0), this.Gw_.getUGATrackNums(1), this.Gw_.getUGATrackNums(0), list, this.Gw_.getPREPTrackNums());
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            IMgram iMgram = (IMgram)listIterator.next();
            if (listIterator.hasNext() || !bl2 && !this.Qz_) {
                this.Sw_(iMgram);
                continue;
            }
            this.Tw_(iMgram);
        }
        if (!bl2 && !this.Qz_) {
            this.Zw_();
            this.aw_();
        }
    }

    private List Ww_(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    private void Xw_(Envelope envelope) throws EGeneralException, IOException {
        if (this.zF_) {
            this.debug("sendIDRReply: " + this.s_);
        }
        boolean bl = false;
        List list = null;
        boolean bl2 = false;
        if (this.ia_ != null) {
            int n = 0;
            list = this.ia_.getPREQTrackNums();
            if (list != null) {
                n = list.size();
            }
            bl2 = this.ia_.hasGuaranteedMessagesPending() || n > 0;
        }
        List list2 = MgramFactory.getMgramFactory().buildIDRMgramList(false, false, bl2, this.Gw_.getDNRTrackNums(1), this.Gw_.getDNRTrackNums(0), this.Gw_.getUGATrackNums(1), this.Gw_.getUGATrackNums(0), list, this.Gw_.getPREPTrackNums());
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            IMgram iMgram = (IMgram)listIterator.next();
            if (envelope != null) {
                this.Uw_(iMgram, envelope);
                continue;
            }
            this.Vw_(iMgram);
        }
    }

    private void Yw_() throws EGeneralException, IOException {
        if (this.zF_) {
            this.debug("sendIDRAcknowledgement: " + this.s_);
        }
        IMgram iMgram = MgramFactory.getMgramFactory().buildIDRAckMgram();
        this.Sw_(iMgram);
    }

    public void handleIDR(IMgram iMgram) throws IOException {
        ObjectInput objectInput = iMgram.getPayloadInputStreamHandle();
        this.interpretIDR(objectInput, null);
    }

    public void interpretIDR(Envelope envelope) throws IOException {
        this.interpretIDR(envelope.getMessage(), envelope);
    }

    public void interpretIDR(DataInput dataInput, Envelope envelope) throws IOException {
        byte by = dataInput.readByte();
        if (by == 3) {
            this.aw_();
            this.Zw_();
            return;
        }
        boolean bl = dataInput.readBoolean();
        boolean bl2 = dataInput.readBoolean();
        boolean bl3 = dataInput.readBoolean();
        int n = 0;
        try {
            while (true) {
                byte by2 = dataInput.readByte();
                long l = dataInput.readLong();
                int n2 = 1;
                n2 = (by2 & MgramConstants.MASK_CATEGORY) == MgramConstants.MASK_PTP_VAL ? 0 : 1;
                if ((by2 & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_DNR_VAL) {
                    if (this.ia_ != null) {
                        this.ia_.dnrReceived(l, n2);
                    }
                } else if ((by2 & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_UGA_VAL) {
                    if (this.ia_ != null) {
                        this.ia_.ugaReceived(l, n2);
                    }
                } else if ((by2 & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_PREP_VAL) {
                    if (this.ia_ != null) {
                        this.ia_.PREPReceived(l);
                    }
                } else if ((by2 & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_PREQ_VAL && this.Gw_ != null) {
                    this.Gw_.PREQReceived(l);
                }
                ++n;
            }
        }
        catch (EOFException eOFException) {
            if (!bl) {
                if (by == 2) {
                    if (this.zF_) {
                        this.debug("handleReply: " + this.s_ + ": no more (nonfinal) replies");
                    }
                    this.aw_();
                    this.Zw_();
                    this.Yw_();
                } else if (bl3) {
                    this.Xw_(envelope);
                } else {
                    this.aw_();
                    this.Zw_();
                }
            }
            return;
        }
    }

    public void setIDRInboundSupport(IIDRInboundSupport iIDRInboundSupport) {
        this.Gw_ = iIDRInboundSupport;
    }

    public void setIDROutboundSupport(IIDROutboundSupport iIDROutboundSupport) {
        this.ia_ = iIDROutboundSupport;
    }

    private void Zw_() {
        if (this.zF_) {
            this.debug("informLocalSenderComplete: " + this.s_);
        }
        if (this.ia_ == null) {
            return;
        }
        this.ia_.allDNRsReceived();
        this.ia_.allUGAsReceived();
        this.ia_.allPREPsReceived();
    }

    private void aw_() {
        if (this.zF_) {
            this.debug("informLocalReceiverComplete: " + this.s_);
        }
        this.Gw_.allDNRsConfirmed();
        this.Gw_.allUGAsConfirmed();
        this.Gw_.allPREQsReceived();
    }
}

