/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.zclient.ClientSecurityContext;

public class ConnectionSyncData {
    private static final byte VO_ = 0;
    private int Wb_;
    private long TG_;
    private int eU_;
    private boolean wH_;
    private ClientSecurityContext ED_;
    private short LY_;

    public ConnectionSyncData() {
    }

    public ConnectionSyncData(int n, long l, int n2, boolean bl, ClientSecurityContext clientSecurityContext, short s) {
        this.eU_ = n;
        this.TG_ = l;
        this.Wb_ = n2;
        this.wH_ = bl;
        this.ED_ = clientSecurityContext;
        this.LY_ = s;
    }

    public int getChannel() {
        return this.eU_;
    }

    public long getClientId() {
        return this.TG_;
    }

    public ClientSecurityContext getClientSecurityContext() {
        return this.ED_;
    }

    public int getState() {
        return this.Wb_;
    }

    public boolean getDeliveryStarted() {
        return this.wH_;
    }

    public short getAckMode() {
        return this.LY_;
    }

    public void setChannel(int n) {
        this.eU_ = n;
    }

    public void setClientId(long l) {
        this.TG_ = l;
    }

    public void setClientSecurityContext(ClientSecurityContext clientSecurityContext) {
        this.ED_ = clientSecurityContext;
    }

    public void setState(int n) {
        this.Wb_ = n;
    }

    public void setDeliveryStarted(boolean bl) {
        this.wH_ = bl;
    }

    public void setAckMode(short s) {
        this.LY_ = s;
    }

    public void serialize(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(0);
        dataOutput.writeLong(this.TG_);
        dataOutput.writeInt(this.eU_);
        dataOutput.writeInt(this.Wb_);
        dataOutput.writeBoolean(this.wH_);
        dataOutput.writeShort(this.LY_);
        if (this.ED_ != null) {
            dataOutput.writeBoolean(true);
            this.ED_.writeToStream(dataOutput, (short)-1);
        } else {
            dataOutput.writeBoolean(false);
        }
    }

    public static ConnectionSyncData deserialize(DataInput dataInput) throws IOException {
        ConnectionSyncData connectionSyncData = new ConnectionSyncData();
        dataInput.readByte();
        connectionSyncData.TG_ = dataInput.readLong();
        connectionSyncData.eU_ = dataInput.readInt();
        connectionSyncData.Wb_ = dataInput.readInt();
        connectionSyncData.wH_ = dataInput.readBoolean();
        connectionSyncData.LY_ = dataInput.readShort();
        if (dataInput.readBoolean()) {
            connectionSyncData.ED_ = ClientSecurityContext.getClientSecurityContext(dataInput, (short)-1);
        }
        return connectionSyncData;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Channel=" + this.eU_);
        stringBuffer.append(",ClientId=" + this.TG_);
        stringBuffer.append(",State=" + this.Wb_);
        stringBuffer.append(",deliveryStarted=" + this.wH_);
        stringBuffer.append(",ackmode=" + this.LY_);
        return stringBuffer.toString();
    }
}

