/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.Hashtable;
import java.util.Iterator;
import progress.message.msg.IErrorHandle;
import progress.message.msg.IFlowControlHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IStateEventHandle;
import progress.message.msg.ITXNRequestHandle;
import progress.message.util.ArrayUtil;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.Connection;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.Request;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.IMgramTraceHelper;

public class MgramTrace {
    private static byte[] kWB_ = new byte[]{-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 26, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 32, 23, 25, 33, 28, 24, 22, 29, 34, 27};
    private static final int lh_ = 1;
    private static final int th_ = 9;
    private static String[] lWB_ = new String[]{"ZERO", "CLIENT_HELLO_SUBTYPE", "BROKER_HELLO_SUBTYPE", "CLIENT_ID_SUBTYPE", "CHALLENGE_1_SUBTYPE", "CHALLENGE_2_SUBTYPE", "RESPONSE_SUBTYPE", "SUCCESS_SUBTYPE", "SEC_DISABLED_SUBTYPE", "BROKER_REDIRECTED_SUBTYPE"};
    private static String[] mWB_ = new String[]{"TXN_FILE_EOF_MARKER", "ERROR", "PING", "CONNECT", "NORMAL", "ACK", "VERSION", "IB_CONVERT", "FLOW_CONTROL", "DISCONNECT", "TXN_REQUEST", "EXTENDED_TXN_REQUEST", "QUEUE_ACKFORWARD", "QUEUE_NORMAL", "QUEUE_GET", "QUEUE_ACK", "GR_CONVERT", "GR_ROUTEINFO", "BLOCK", "RESUME", "NACK", "FAILOVER_STATUS_NOTIFICATION", "CONNECTION_SYNC", "IDR", "OPERATION", "WINDOWED_TXN_ACK", "ACK_LIST", "STATE_EVENT", "FT_CONVERT", "DATABASE", "REPLICATION_REQUEST_REPLY", "BATCH"};
    private static Hashtable nWB_;
    private static Hashtable oWB_;
    private static IMgramTraceHelper pWB_;

    private static IMgramTraceHelper IbB_() throws Exception {
        if (pWB_ != null) {
            return pWB_;
        }
        pWB_ = SessionConfig.IN_BROKER ? (IMgramTraceHelper)Class.forName("progress.message.broker.BrokerMgramTraceHelper").newInstance() : (IMgramTraceHelper)Class.forName("progress.message.zclient.xonce.ClientMgramTraceHelper").newInstance();
        return pWB_;
    }

    public static byte stringToType(String string) {
        Byte by = (Byte)nWB_.get(string);
        if (by == null) {
            return -1;
        }
        return by;
    }

    public static String typeToString(byte by) {
        String string = (String)oWB_.get(new Byte(by));
        if (string == null) {
            string = Byte.toString(by);
        }
        return string;
    }

    public static void diagnose(String string, BaseConnection baseConnection, IMgram iMgram) {
        String string2 = MgramTrace.diagnosticString(string, baseConnection, iMgram);
        if (string2 != null) {
            System.out.println(string2);
        }
    }

    public static String subTypeString(IMgram iMgram) {
        String string = "UNKNOWN";
        switch (iMgram.getType()) {
            case 8: {
                ITXNRequestHandle iTXNRequestHandle = iMgram.getTXNRequestHandle();
                if (iMgram.isReply()) break;
                string = iMgram.getTXNRequestHandle().opStr();
                break;
            }
            case 26: {
                if (iMgram.isReply()) break;
                string = iMgram.getExtendedTXNRequestHandle().opStr();
                break;
            }
            case 1: {
                byte by = iMgram.getRawBody()[0];
                if (by < 0 || by > lWB_.length - 1) {
                    string = Integer.toString(by);
                    break;
                }
                string = lWB_[by];
                break;
            }
        }
        return string;
    }

    public static String diagnosticString(String string, BaseConnection baseConnection, IMgram iMgram) {
        String string2 = MgramTrace.typeToString(iMgram.getType());
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        int n = 0;
        block1 : switch (iMgram.getType()) {
            case 0: {
                string5 = string5 + MgramTrace.MbB_(baseConnection, iMgram);
                break;
            }
            case -1: {
                IErrorHandle iErrorHandle = iMgram.getErrorHandle();
                string2 = string2 + ",errcode=" + iErrorHandle.getErrCode() + ",errinfo=" + iErrorHandle.getErrInfo();
                break;
            }
            case 6: {
                IFlowControlHandle iFlowControlHandle = iMgram.getFlowControlHandle();
                string2 = string2 + ",minpri=" + iFlowControlHandle.getMinPriority();
                break;
            }
            case 8: {
                if (!iMgram.isReply()) {
                    string2 = string2 + "=" + iMgram.getTXNRequestHandle().summaryString();
                } else {
                    byte[] byArray = iMgram.getRawBody();
                    short s = ArrayUtil.readShort(byArray, 0);
                    int n2 = ArrayUtil.readInt(byArray, 2);
                    string2 = string2 + "=" + n2 + ",status=" + s;
                }
                string3 = "GUAR=" + iMgram.getGuarenteedTrackingNum();
                string5 = MgramTrace.MbB_(baseConnection, iMgram);
                break;
            }
            case 26: {
                if (!iMgram.isReply()) {
                    string2 = string2 + "=" + iMgram.getExtendedTXNRequestHandle().summaryString();
                } else {
                    byte[] byArray = iMgram.getRawBody();
                    short s = ArrayUtil.readShort(byArray, 0);
                    int n3 = ArrayUtil.readInt(byArray, 2);
                    string2 = string2 + "=" + n3 + ",status=" + s;
                }
                string3 = "GUAR=" + iMgram.getGuarenteedTrackingNum();
                string5 = MgramTrace.MbB_(baseConnection, iMgram);
                break;
            }
            case 16: {
                n = 0;
                byte[] byArray = iMgram.getRawBody();
                long l = ArrayUtil.readLong(byArray, n);
                string2 = string2 + ",subtype=" + l;
                break;
            }
            case 7: {
                string3 = "GUAR=" + iMgram.getGuarenteedTrackingNum();
                break;
            }
            case 18: 
            case 19: {
                string5 = MgramTrace.MbB_(baseConnection, iMgram);
                string2 = string2 + "=" + iMgram.getQueueFlowControlHandle().getFlowDestination();
                break;
            }
            case 3: 
            case 14: {
                string2 = string2 + "=" + iMgram.getAckHandle().getTrackingNumber() + ":CLIENTID:" + iMgram.getAckHandle().getClientID();
                if (iMgram.isGuarenteed()) {
                    string3 = "GUAR=" + iMgram.getGuarenteedTrackingNum();
                }
                if (!iMgram.hasTxn()) break;
                string4 = "TX=" + iMgram.getTxnId();
                break;
            }
            case 28: {
                string2 = string2 + "=" + iMgram.getAckListHandle().summaryString();
                break;
            }
            case 20: {
                string2 = string2 + "=" + iMgram.getAckHandle().getTrackingNumber();
                if (!iMgram.isGuarenteed()) break;
                string3 = "GUAR=" + iMgram.getGuarenteedTrackingNum();
                break;
            }
            case 4: {
                string2 = string2 + "=Mgram=" + iMgram.getVersion() + ",Session=" + iMgram.getSessionVersion();
                break;
            }
            case 21: {
                string2 = string2 + "=" + iMgram.getFailoverStatusNotificationHandle().summaryString();
                break;
            }
            case 32: {
                string2 = string2 + "=" + iMgram.getConnectionSyncHandle().summaryString();
                break;
            }
            case 1: {
                string2 = string2 + "=" + MgramTrace.getConnectSubtype(iMgram);
                break;
            }
            case 23: {
                string2 = string2 + "=" + iMgram.getIDRHandle().summaryString();
                break;
            }
            case 33: {
                string2 = string2 + "=" + iMgram.getWindowAckHandle().windowAckSummaryString();
                break;
            }
            case 27: {
                string3 = "GUAR=" + iMgram.getGuarenteedTrackingNum();
                string7 = "SECURE=" + MgramTrace.LbB_(iMgram);
                string8 = "PRI=" + iMgram.getPriority();
                if (iMgram.hasTxn()) {
                    string4 = "TX=" + iMgram.getTxnId();
                }
                string2 = string2 + "=SIZE-" + iMgram.getBatchHandle().getBatchSize();
                Iterator iterator = iMgram.getBatchHandle().getBatchIterator();
                string2 = string2 + "=GUARS-";
                while (iterator.hasNext()) {
                    IMgram iMgram2 = (IMgram)iterator.next();
                    if (!iMgram2.isGuarenteed()) continue;
                    string2 = string2 + iMgram2.getGuarenteedTrackingNum() + ",";
                }
                break;
            }
            case 25: {
                try {
                    switch (iMgram.getOperationHandle().getOperationType()) {
                        case 1: {
                            string2 = string2 + "=FIRST_MSG_NOTIFICATION-" + iMgram.getPayloadInputStreamHandle().readLong();
                            break block1;
                        }
                        case 2: {
                            string2 = string2 + "=LAST_MSG_NOTIFICATION-" + iMgram.getPayloadInputStreamHandle().readLong();
                            break block1;
                        }
                        case 3: {
                            string2 = string2 + "=SINGLE_TARGET_MSG:TARGET=" + iMgram.getPayloadInputStreamHandle().readLong();
                            string3 = "GUAR=" + ((IMgram)iMgram.getOperationHandle().getMgramList().getFirst()).getGuarenteedTrackingNum();
                            string6 = "SUCC=" + ((IMgram)iMgram.getOperationHandle().getMgramList().getFirst()).isSuccessor();
                            string9 = MgramTrace.propsStr((IMgram)iMgram.getOperationHandle().getMgramList().getFirst());
                            break block1;
                        }
                        case 20: {
                            string2 = string2 + "=REMOTE_RESTORE_PHASES_DONE-" + iMgram.getPayloadInputStreamHandle().readLong();
                            break block1;
                        }
                        case 15: {
                            string2 = string2 + "=CWADS_PING-" + iMgram.getPayloadInputStreamHandle().readLong();
                            break block1;
                        }
                        case 16: {
                            string2 = string2 + "=CWADS_PING_REPLY-" + iMgram.getPayloadInputStreamHandle().readLong();
                            break block1;
                        }
                        case 17: {
                            string2 = string2 + "=CWADS_LIST_XFER_OP-" + iMgram.getPayloadInputStreamHandle().readLong();
                            break block1;
                        }
                        case 18: {
                            string2 = string2 + "=CWADS_LIST_XFER_REPLY_OP-" + iMgram.getPayloadInputStreamHandle().readLong();
                            break block1;
                        }
                        case 19: {
                            string2 = string2 + "=CWADS_INFO_OP-" + iMgram.getPayloadInputStreamHandle().readLong();
                            break block1;
                        }
                    }
                    string2 = string2 + "=UNKNOWN OPERATION";
                }
                catch (IOException iOException) {
                    SessionConfig.logMessage("Error Tracing operation mgram!", iOException, SessionConfig.getLevelWarning());
                }
                break;
            }
            case 13: {
                n = 0;
                byte[] byArray = iMgram.getRawBody();
                short s = ArrayUtil.readShort(byArray, n);
                int n4 = ArrayUtil.readInt(byArray, n += 2);
                String string10 = s == 2 ? "RCVNOWAIT" : "RCVWAIT";
                string2 = string2 + ",subtype=" + string10 + ",prefetch=" + n4;
                break;
            }
            case 24: {
                IStateEventHandle iStateEventHandle = iMgram.getStateEventHandle();
                IStateEvent iStateEvent = iStateEventHandle.getStateEvent();
                char[] cArray = new char[]{iStateEvent.canBeDelayed() ? (char)'D' : '-', iStateEvent.isAction() ? (char)'A' : '-', iStateEvent.mustBeBuffered() ? (char)'B' : '-', iStateEvent.usesClientRegistry() ? (char)'C' : '-', iStateEvent.usesSubscriptionTable() ? (char)'S' : '-', iStateEvent.utilizeActionProcessor() ? (char)'P' : '-'};
                string2 = string2 + ",state=" + iStateEvent + ",flags=" + new String(cArray);
                break;
            }
            default: {
                string3 = "GUAR=" + iMgram.getGuarenteedTrackingNum();
                string5 = MgramTrace.MbB_(baseConnection, iMgram);
                string6 = "SUCC=" + iMgram.isSuccessor();
                string7 = "SECURE=" + MgramTrace.LbB_(iMgram);
                string8 = "PRI=" + iMgram.getPriority();
                if (iMgram.hasTxn()) {
                    string4 = "TX=" + iMgram.getTxnId();
                }
                string9 = MgramTrace.propsStr(iMgram);
            }
        }
        String string11 = MgramTrace.getSocketId(baseConnection);
        String string12 = MgramTrace.getApplicationId(baseConnection, iMgram) + "-" + MgramTrace.JbB_(baseConnection, iMgram);
        String string13 = MgramTrace.getSubject(iMgram);
        return string + ":" + string11 + ":" + string12 + ":" + string2 + ":" + string3 + ":" + string4 + ":" + string6 + ":" + string8 + ":" + string7 + ":" + string5 + ":" + ":" + string13 + ":" + string9;
    }

    public static String propsStr(IMgram iMgram) {
        Hashtable hashtable = null;
        String string = "";
        if (iMgram.hasSidebandData()) {
            hashtable = iMgram.getSidebandData().getProperties();
        }
        if (hashtable != null && hashtable.size() > 0) {
            Object v;
            Object k;
            Iterator iterator = hashtable.keySet().iterator();
            if (iterator.hasNext()) {
                k = iterator.next();
                v = hashtable.get(k);
                string = string + k + "=" + v;
            }
            while (iterator.hasNext()) {
                k = iterator.next();
                v = hashtable.get(k);
                string = string + "," + k + "=" + v;
            }
        }
        return string;
    }

    public static String getConnectSubtype(IMgram iMgram) {
        byte by = iMgram.getRawBody()[0];
        if (by < 0 || by > lWB_.length - 1) {
            return Integer.toString(by);
        }
        if (by == 1) {
            return lWB_[by] + MgramTrace.getExtendedHelloOptions(iMgram);
        }
        if (by == 9) {
            return lWB_[by] + MgramTrace.getRedirectUrls(iMgram);
        }
        return lWB_[by];
    }

    public static String getSocketId(BaseConnection baseConnection) {
        try {
            return MgramTrace.IbB_().getSocketId(baseConnection);
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public static String getRedirectUrls(IMgram iMgram) {
        String string = "";
        try {
            if (iMgram.getRawBody().length > 1) {
                ObjectInput objectInput = iMgram.getPayloadInputStreamHandle();
                objectInput.readByte();
                string = ",url=" + objectInput.readUTF();
            }
        }
        catch (IOException iOException) {
            SessionConfig.logMessage("Error Tracing connect redirect mgram!", iOException, SessionConfig.getLevelWarning());
        }
        return string;
    }

    public static String getExtendedHelloOptions(IMgram iMgram) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = "";
        try {
            if (iMgram.getRawBody().length > 2) {
                ObjectInput objectInput = iMgram.getPayloadInputStreamHandle();
                objectInput.readByte();
                objectInput.readByte();
                short s = objectInput.readShort();
                bl = (s & 1) > 0;
                bl2 = (s & 8) > 0;
                bl4 = (s & 2) > 0;
                bl3 = (s & 0x10) > 0;
                boolean bl6 = bl5 = (s & 4) > 0;
                if (bl2) {
                    objectInput.readUTF();
                }
                if (bl3) {
                    ClientConnectParms clientConnectParms = ClientConnectParms.unserialize(objectInput);
                    string = clientConnectParms.toString();
                }
            }
        }
        catch (IOException iOException) {
            SessionConfig.logMessage("Error Tracing operation mgram!", iOException, SessionConfig.getLevelWarning());
        }
        return ",lb=" + bl + ",ft=" + bl4 + ",resume=" + bl5 + ",cparms=" + string;
    }

    public static String getApplicationId(BaseConnection baseConnection, IMgram iMgram) {
        try {
            return MgramTrace.IbB_().getApplicationId(baseConnection, iMgram);
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public static String getSubject(IMgram iMgram) {
        String string = new String("");
        try {
            switch (iMgram.getType()) {
                case 3: {
                    break;
                }
                default: {
                    string = iMgram.getSubject();
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string == null ? "" : string;
    }

    private static String JbB_(BaseConnection baseConnection, IMgram iMgram) {
        try {
            return MgramTrace.IbB_().getUserId(baseConnection, iMgram);
        }
        catch (Exception exception) {
            return "???";
        }
    }

    private static String KbB_(Connection connection, long l) {
        Request request = connection.getRequest(l);
        IMgram iMgram = null;
        if (request != null) {
            iMgram = request.getRequest().getMgram();
        }
        if (iMgram == null) {
            return "";
        }
        return "," + iMgram.getSubject();
    }

    private static String LbB_(IMgram iMgram) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!iMgram.isSecure()) {
            return "false";
        }
        byte by = 0;
        try {
            by = iMgram.getSecurity();
        }
        catch (Throwable throwable) {
            return "??";
        }
        if (by == 0) {
            stringBuffer.append("NONE");
            return stringBuffer.toString();
        }
        stringBuffer.append(SecurityLogic.isQuery(by) ? "Q" : "NQ");
        stringBuffer.append(SecurityLogic.isSKeyDigest(by) ? ",SD" : "");
        stringBuffer.append(SecurityLogic.isSKeyEncryption(by) ? ",SE" : "");
        stringBuffer.append(SecurityLogic.isMKeyDigest(by) ? ",MD" : "");
        stringBuffer.append(SecurityLogic.isMKeyMacHeader(by) ? ",MM" : "");
        stringBuffer.append(SecurityLogic.isMKeyEncryption(by) ? ",ME" : "");
        return stringBuffer.toString();
    }

    private static String MbB_(BaseConnection baseConnection, IMgram iMgram) {
        String string = "REQUEST/REPLY=";
        String string2 = "";
        try {
            if (iMgram.isReply()) {
                string = "REPLY=";
                long l = (long)iMgram.getReplyTracking() & 0xFFFFFFFFL;
                if (baseConnection instanceof Connection) {
                    string2 = string + l + MgramTrace.KbB_((Connection)baseConnection, l);
                }
            } else if (iMgram.isRequest()) {
                string = "REQUEST=";
                string2 = string + ((long)iMgram.getReplyToAddressTracking() & 0xFFFFFFFFL);
            }
        }
        catch (Throwable throwable) {
            string2 = string + "???";
        }
        return string2;
    }

    static {
        pWB_ = null;
        oWB_ = new Hashtable();
        nWB_ = new Hashtable();
        int n = 0;
        while (n < kWB_.length) {
            Byte by = new Byte(kWB_[n]);
            oWB_.put(by, mWB_[n]);
            nWB_.put(mWB_[n], by);
            ++n;
        }
    }
}

