/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client;

import java.lang.reflect.Constructor;
import java.rmi.RMISecurityManager;
import java.security.AccessControlException;
import java.security.Permission;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.CurrentHelper;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import weblogic.corba.client.cluster.ClusterInterceptor;
import weblogic.corba.client.naming.ClientORBHelper;
import weblogic.corba.client.naming.ReferenceHelperImpl;
import weblogic.corba.client.security.ClientSecurityManager;
import weblogic.corba.client.security.SecurityInterceptor;
import weblogic.corba.client.security.SubjectManagerImpl;
import weblogic.corba.client.spi.ServiceManager;
import weblogic.corba.client.transaction.TransactionHelperImpl;
import weblogic.corba.client.transaction.TransactionInterceptor;
import weblogic.corba.client.utils.HeartbeatMonitorDelegateImpl;
import weblogic.corba.client.utils.VersionInterceptor;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.rmi.extensions.server.HeartbeatMonitorDelegate;
import weblogic.rmi.extensions.server.ReferenceHelper;
import weblogic.security.subject.SubjectManager;
import weblogic.transaction.TransactionHelper;

public class ClientORBInitializer
extends LocalObject
implements ORBInitializer {
    private static final boolean DEBUG = ClientORBInitializer.getDebug();
    private static boolean initialized = false;
    private static HeartbeatMonitorDelegate hbm;
    static /* synthetic */ Class class$org$omg$PortableInterceptor$Current;
    static /* synthetic */ Class class$org$omg$IOP$Codec;
    static /* synthetic */ Class class$java$lang$Integer;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.startup");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final synchronized void initialize() {
        if (!initialized) {
            ReferenceHelper.setReferenceHelper(new ReferenceHelperImpl());
            ORBHelper.setORBHelper(new ClientORBHelper());
            TransactionHelper.setTransactionHelper(new TransactionHelperImpl());
            ServiceManager.setSecurityManager(new ClientSecurityManager());
            try {
                SubjectManager.setSubjectManager(new SubjectManagerImpl());
            }
            catch (AccessControlException accessControlException) {
                ((SubjectManagerImpl)SubjectManager.getSubjectManager()).addDelegate();
            }
            hbm = new HeartbeatMonitorDelegateImpl();
            try {
                if (System.getSecurityManager() == null) {
                    System.setSecurityManager(new RMISecurityManager(){

                        public void checkPermission(Permission permission) {
                        }
                    });
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            initialized = true;
        }
    }

    public static final HeartbeatMonitorDelegate getHeartbeatMonitorDelegate() {
        return hbm;
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
        if (DEBUG) {
            ClientORBInitializer.p("pre_init()");
        }
        if (!initialized) {
            ClientORBInitializer.initialize();
        }
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
        if (DEBUG) {
            ClientORBInitializer.p("post_init()");
        }
        try {
            Current current = CurrentHelper.narrow((Object)oRBInitInfo.resolve_initial_references("PICurrent"));
            CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)oRBInitInfo.resolve_initial_references("CodecFactory"));
            Encoding encoding = new Encoding(0, 1, 2);
            Codec codec = codecFactory.create_codec(encoding);
            int n = oRBInitInfo.allocate_slot_id();
            ClusterInterceptor clusterInterceptor = new ClusterInterceptor(current, codec, n);
            oRBInitInfo.add_client_request_interceptor((ClientRequestInterceptor)clusterInterceptor);
            oRBInitInfo.register_initial_reference(clusterInterceptor.name(), (Object)clusterInterceptor);
            if (DEBUG) {
                ClientORBInitializer.p("ClusterInterceptor created on slot " + n);
            }
            int n2 = oRBInitInfo.allocate_slot_id();
            TransactionInterceptor transactionInterceptor = new TransactionInterceptor(current, codec, n2);
            oRBInitInfo.add_client_request_interceptor((ClientRequestInterceptor)transactionInterceptor);
            oRBInitInfo.register_initial_reference(transactionInterceptor.name(), (Object)transactionInterceptor);
            if (DEBUG) {
                ClientORBInitializer.p("TransactionInterceptor created on slot " + n2);
            }
            int n3 = oRBInitInfo.allocate_slot_id();
            SecurityInterceptor securityInterceptor = new SecurityInterceptor(current, codec, n3);
            oRBInitInfo.add_client_request_interceptor((ClientRequestInterceptor)securityInterceptor);
            oRBInitInfo.register_initial_reference(securityInterceptor.name(), (Object)securityInterceptor);
            if (DEBUG) {
                ClientORBInitializer.p("SecurityInterceptor created on slot " + n3);
            }
            VersionInterceptor versionInterceptor = new VersionInterceptor(codec);
            oRBInitInfo.add_client_request_interceptor((ClientRequestInterceptor)versionInterceptor);
            oRBInitInfo.register_initial_reference(versionInterceptor.name(), (Object)versionInterceptor);
            if (DEBUG) {
                ClientORBInitializer.p("done initializing");
            }
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                throwable.printStackTrace();
            }
            INTERNAL iNTERNAL = new INTERNAL(throwable.getMessage());
            iNTERNAL.initCause(throwable);
            throw iNTERNAL;
        }
    }

    private static void installServiceInterceptor(String string, ORBInitInfo oRBInitInfo, Current current, Codec codec) {
        try {
            int n = oRBInitInfo.allocate_slot_id();
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{class$org$omg$PortableInterceptor$Current == null ? (class$org$omg$PortableInterceptor$Current = ClientORBInitializer.class$("org.omg.PortableInterceptor.Current")) : class$org$omg$PortableInterceptor$Current, class$org$omg$IOP$Codec == null ? (class$org$omg$IOP$Codec = ClientORBInitializer.class$("org.omg.IOP.Codec")) : class$org$omg$IOP$Codec, class$java$lang$Integer == null ? (class$java$lang$Integer = ClientORBInitializer.class$("java.lang.Integer")) : class$java$lang$Integer};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            ClientRequestInterceptor clientRequestInterceptor = (ClientRequestInterceptor)constructor.newInstance(current, codec, new Integer(n));
            oRBInitInfo.add_client_request_interceptor(clientRequestInterceptor);
        }
        catch (Exception exception) {
            ClientORBInitializer.p("Error: " + string + " not installed: " + exception.getMessage());
        }
    }

    protected static void p(String string) {
        System.err.println("<ClientORBInitializer> " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

