/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.ServiceContext;
import weblogic.corba.client.cluster.ClusterComponent;
import weblogic.corba.client.cluster.VendorInfoCluster;
import weblogic.corba.client.cluster.VendorInfoClusterHelper;
import weblogic.corba.iiop.cluster.PrimarySecondarySelector;
import weblogic.corba.iiop.cluster.RandomSelector;
import weblogic.corba.iiop.cluster.RoundRobinSelector;
import weblogic.corba.iiop.cluster.Selector;
import weblogic.corba.iiop.cluster.ServerAffinitySelector;
import weblogic.corba.iiop.cluster.StickySelector;

public final class TargetInfo {
    private static final boolean DEBUG = false;
    private static final HashMap objectTable = new HashMap();
    static final TargetInfo NULL_TARGET_INFO = new TargetInfo();
    VendorInfoCluster clusterContext;
    ClusterComponent clusterComponent;
    private Object[] replicas;
    private static final Object[] OBJECT_ARRAY_TYPE = new Object[0];
    private long version;
    private ServiceContext versionContext;
    private final Selector selector;
    private int current;
    private ThreadLocal inInvoke = new ThreadLocal(){

        protected java.lang.Object initialValue() {
            return new Boolean(false);
        }
    };

    private TargetInfo() {
        this.selector = null;
    }

    TargetInfo(ClusterComponent clusterComponent, Codec codec) {
        this.clusterComponent = clusterComponent;
        this.replicas = clusterComponent.replicas;
        this.version = clusterComponent.version;
        this.createVersionClusterContext(codec);
        this.current = 0;
        this.selector = clusterComponent.algorithm.equals("random") ? RandomSelector.SELECTOR : (clusterComponent.algorithm.equals("round-robin") ? RoundRobinSelector.SELECTOR : (clusterComponent.algorithm.endsWith("-affinity") ? ServerAffinitySelector.SELECTOR : (clusterComponent.algorithm.equals("primary-secondary") ? PrimarySecondarySelector.SELECTOR : StickySelector.SELECTOR)));
    }

    final long getVersion() {
        return this.version;
    }

    final ServiceContext getVersionContext() {
        return this.versionContext;
    }

    private void createVersionClusterContext(Codec codec) {
        try {
            VendorInfoCluster vendorInfoCluster = new VendorInfoCluster(this.version, new Object[0]);
            Any any = ORB.init().create_any();
            VendorInfoClusterHelper.insert(any, vendorInfoCluster);
            byte[] byArray = codec.encode_value(any);
            this.versionContext = new ServiceContext(1111834883, byArray);
        }
        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
            // empty catch block
        }
    }

    final Object[] getReplicas() {
        return this.replicas;
    }

    final boolean invoking() {
        return (Boolean)this.inInvoke.get();
    }

    final void setInvoking(boolean bl) {
        this.inInvoke.set(new Boolean(bl));
    }

    final boolean onlyOneTarget() {
        return this.replicas == null || this.replicas.length <= 1;
    }

    final Object selectNextTarget() {
        if (this.replicas == null || this.replicas.length == 0) {
            return null;
        }
        int n = this.current;
        if (!this.clusterComponent.stickToFirstServer) {
            this.current = this.selector.select(this.current, this.replicas.length);
        }
        if (n == this.current) {
            return null;
        }
        return this.replicas[this.current];
    }

    final Object selectFailoverTarget() {
        this.current = this.selector.select(this.current, this.replicas.length);
        return this.replicas[this.current];
    }

    private static final ObjectKey delegate(Object object) {
        return new ObjectKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTargetInfo(Object object, VendorInfoCluster vendorInfoCluster, Codec codec) {
        if (vendorInfoCluster != null) {
            HashMap hashMap = objectTable;
            synchronized (hashMap) {
                int n;
                TargetInfo targetInfo = (TargetInfo)objectTable.get(TargetInfo.delegate(object));
                for (n = 0; n < targetInfo.replicas.length; ++n) {
                    if (targetInfo.replicas[n] == object || TargetInfo.delegate(targetInfo.replicas[n]).equals(TargetInfo.delegate(object))) continue;
                    objectTable.remove(TargetInfo.delegate(targetInfo.replicas[n]));
                }
                targetInfo.clusterContext = vendorInfoCluster;
                targetInfo.version = vendorInfoCluster.version;
                targetInfo.createVersionClusterContext(codec);
                targetInfo.replicas = vendorInfoCluster.replicas;
                for (n = 0; n < targetInfo.replicas.length; ++n) {
                    objectTable.put(TargetInfo.delegate(targetInfo.replicas[n]), targetInfo);
                }
            }
        }
    }

    public void removeMember(Object object) {
        if (this.replicas.length > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.replicas.length - 1);
            for (int i = 0; i < this.replicas.length; ++i) {
                if (this.replicas[i]._is_equivalent(object)) continue;
                arrayList.add(this.replicas[i]);
            }
            this.replicas = arrayList.toArray(OBJECT_ARRAY_TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetInfo findOrCreateTargetInfo(Object object, ClusterComponent clusterComponent, Codec codec) {
        TargetInfo targetInfo = null;
        HashMap hashMap = objectTable;
        synchronized (hashMap) {
            targetInfo = (TargetInfo)objectTable.get(TargetInfo.delegate(object));
            if (targetInfo == null) {
                if (clusterComponent != null) {
                    targetInfo = new TargetInfo(clusterComponent, codec);
                    objectTable.put(TargetInfo.delegate(object), targetInfo);
                    for (int i = 0; i < targetInfo.replicas.length; ++i) {
                        objectTable.put(TargetInfo.delegate(targetInfo.replicas[i]), targetInfo);
                    }
                } else {
                    objectTable.put(TargetInfo.delegate(object), NULL_TARGET_INFO);
                }
            }
        }
        return targetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetInfo findTargetInfo(Object object) {
        TargetInfo targetInfo = null;
        HashMap hashMap = objectTable;
        synchronized (hashMap) {
            targetInfo = (TargetInfo)objectTable.get(TargetInfo.delegate(object));
        }
        return targetInfo;
    }

    protected static void p(String string) {
        System.err.println("<TargetInfo> " + string);
    }

    private static final class ObjectKey {
        private final int hash;
        private final ObjectImpl obj;
        private final Delegate del;
        private static final String OBJECT_ID = "IDL:omg.org/CORBA/Object:1.0";
        private static final int OBJECT_HASH = "IDL:omg.org/CORBA/Object:1.0".hashCode();

        ObjectKey(Object object) {
            this.obj = (ObjectImpl)object;
            this.del = this.obj._get_delegate();
            this.hash = this.del.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(java.lang.Object object) {
            try {
                if (this.hashCode() != object.hashCode()) {
                    return false;
                }
                ObjectKey objectKey = (ObjectKey)object;
                if (!(this.obj._ids()[0].equals(objectKey.obj._ids()[0]) || this.obj._ids().length != 1 || objectKey.obj._ids().length != 1 || this.obj._ids()[0].equals(OBJECT_ID) || objectKey.obj._ids()[0].equals(OBJECT_ID))) {
                    return false;
                }
                return this.del.equals((Object)this.obj, (java.lang.Object)objectKey.obj);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }
}

