/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.http;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import weblogic.corba.client.http.TunneledServerSocket;
import weblogic.corba.client.http.TunneledSocket;
import weblogic.corba.client.iiop.BiDirSocketFactory;

public class TunneledSocketFactory
extends BiDirSocketFactory {
    private String scheme;
    private int tunnelPort;
    private String tunnelHost;
    private Hashtable clusterMembers = new Hashtable();
    private String tunnelCookiePrefix;
    private static Hashtable tunnelTable = new Hashtable();
    static final String HTTP_SCHEME = "http";

    public TunneledSocketFactory() {
        if (DEBUG) {
            TunneledSocketFactory.p("initialized");
        }
        this.scheme = HTTP_SCHEME;
    }

    public void setProtocolName(String string) {
        this.scheme = string;
    }

    public String getProtocolName() {
        return this.scheme;
    }

    public Hashtable getClusterMembers() {
        return this.clusterMembers;
    }

    public void setClusterMembers(Hashtable hashtable) {
        this.clusterMembers = hashtable;
    }

    public String getTunnelHost() {
        return this.tunnelHost;
    }

    public int getTunnelPort() {
        return this.tunnelPort;
    }

    public String getTunnelCookiePrefix() {
        return this.tunnelCookiePrefix;
    }

    public void setTunnelCookiePrefix(String string) {
        this.tunnelCookiePrefix = string;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        if (DEBUG) {
            TunneledSocketFactory.p("createServerSocket(" + n + ")");
        }
        TunneledServerSocket tunneledServerSocket = new TunneledServerSocket(n, this);
        return tunneledServerSocket;
    }

    public Socket createSocket(String string, int n) throws IOException {
        String string2 = (String)tunnelTable.get(string + ":" + n);
        if (this.tunnelHost == null) {
            if (string2 != null) {
                int n2 = string2.indexOf(58);
                this.tunnelHost = string2.substring(0, n2);
                this.tunnelPort = Integer.parseInt(string2.substring(n2 + 1));
            } else {
                this.tunnelHost = string;
                this.tunnelPort = n;
            }
        }
        if (string2 == null) {
            tunnelTable.put(string + ":" + n, this.tunnelHost + ":" + this.tunnelPort);
        }
        if (DEBUG) {
            TunneledSocketFactory.p("createSocket(" + this.tunnelHost + ":" + this.tunnelPort + " -> " + string + ":" + n + ")");
        }
        return new TunneledSocket(this.tunnelHost, this.tunnelPort, string, n, this);
    }

    protected static void p(String string) {
        System.err.println("<TunneledSocketFactory> " + string);
    }
}

