/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import weblogic.corba.client.http.TunneledSocketFactory;
import weblogic.corba.client.iiop.BiDirSocketFactory;
import weblogic.corba.client.iiop.BiDirSocketImpl;
import weblogic.corba.iiop.http.TunnelUtils;

public class TunneledSocketImpl
extends BiDirSocketImpl {
    private String connectionID;
    private String backendServerID;
    private String host;
    private int port;
    private Hashtable cookies = new Hashtable();
    private static final String TUNNELING_URL_EXTENSION = "/a.tun";
    private static final int READ_PIPE_SIZE = 1024;
    private static final boolean DEBUG = TunneledSocketImpl.getDebug();
    private static final Properties customHeaders = TunneledSocketImpl.getCustomHeaders();

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.http");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static final Properties getCustomHeaders() {
        try {
            String string = System.getProperty("weblogic.corba.client.customHeaders");
            return TunnelUtils.getProperties(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private TunneledSocketFactory getTunnelFactory() {
        if (this.factory instanceof TunneledSocketFactory) {
            return (TunneledSocketFactory)this.factory;
        }
        return null;
    }

    public TunneledSocketImpl(BiDirSocketFactory biDirSocketFactory, String string, int n) {
        super(biDirSocketFactory);
        this.host = string;
        this.port = n;
    }

    public TunneledSocketImpl(BiDirSocketFactory biDirSocketFactory) {
        super(biDirSocketFactory);
    }

    private TunneledSocketImpl(TunneledSocketImpl tunneledSocketImpl, boolean bl) throws IOException {
        super(tunneledSocketImpl, bl);
    }

    private InetSocketAddress getInetSocketAddr(String string, int n) {
        InetSocketAddress inetSocketAddress;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            inetSocketAddress = new InetSocketAddress(inetAddress, n);
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            inetSocketAddress = new InetSocketAddress(string, n);
        }
        return inetSocketAddress;
    }

    public void updateClusterMembers(URLConnection uRLConnection) {
        String string = uRLConnection.getHeaderField("WL-List");
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = uRLConnection.getHeaderField("WL-Scheme");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "!");
            String string4 = stringTokenizer2.nextToken();
            String string5 = stringTokenizer2.nextToken();
            String string6 = stringTokenizer2.nextToken();
            if (string2.equals("https")) {
                string6 = stringTokenizer2.nextToken();
            }
            hashtable.put(string5 + ":" + string6, string4);
            if (!DEBUG) continue;
            this.p("updateClusterMembers(" + string5 + ":" + string6 + ")" + string4);
        }
        this.getTunnelFactory().setClusterMembers(hashtable);
    }

    private void readCookies(URLConnection uRLConnection) {
        int n = 1;
        String string = null;
        String string2 = null;
        while ((string2 = uRLConnection.getHeaderFieldKey(n++)) != null) {
            if (!string2.equals("Set-Cookie")) continue;
            string2 = uRLConnection.getHeaderField(n - 1);
            int n2 = string2.indexOf(";");
            if (n2 != -1) {
                string2 = string2.substring(0, n2);
            }
            if ((n2 = string2.indexOf("=")) == -1 || n2 >= string2.length() - 1) continue;
            string = string2.substring(0, n2);
            string2 = string2.substring(n2 + 1, string2.length());
            this.cookies.put(string, string2);
        }
    }

    private void writeCookies(URLConnection uRLConnection) {
        String string;
        Hashtable hashtable = this.getTunnelFactory().getClusterMembers();
        String string2 = this.getTunnelFactory().getTunnelCookiePrefix();
        String string3 = (String)hashtable.get(this.host + ":" + this.port);
        if (string3 != null) {
            string = (String)this.cookies.get("JSESSIONID");
            if (string2 != null) {
                string = string2 + string3;
                this.cookies.put("JSESSIONID", string);
            }
        }
        string = null;
        Iterator iterator = this.cookies.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            string = string != null ? string + "; " : "";
            String string5 = (String)this.cookies.get(string4);
            if (string2 == null && string4.equals("JSESSIONID")) {
                this.getTunnelFactory().setTunnelCookiePrefix(string5.substring(0, string5.indexOf("!") + 1));
            }
            string = string + string4 + "=" + string5;
        }
        if (DEBUG) {
            this.p("writeCookies " + string);
        }
        if (string != null) {
            uRLConnection.setRequestProperty("Cookie", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectInternal() throws IOException {
        String string = URLEncoder.encode(this.getTunnelFactory().getProtocolName() + " dummy WLREQS " + "8.1.4.0" + " dummy \n");
        URLConnection uRLConnection = null;
        try {
            uRLConnection = this.createURLConnection("/bea_wls_internal/iiop/ClientLogin/a.tun?wl-login=" + string + "&rand=" + TunnelUtils.getNextRandom() + "&" + "HL" + "=" + 12);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                this.p(iOException.getMessage());
            }
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            this.readCookies(uRLConnection);
            this.updateClusterMembers(uRLConnection);
            String string2 = uRLConnection.getHeaderField("WL-Result");
            if (string2 == null) {
                TunneledSocketImpl.throwProtocolException("Tunneling result unspecified - is the HTTP server at host: '" + this.host + "' and port: '" + this.port + "' a WebLogic Server?");
            }
            if (!string2.equals("OK")) {
                TunneledSocketImpl.throwProtocolException("Tunneling result not OK, result: '" + string2 + "'");
            }
            String string3 = uRLConnection.getHeaderField("WL-Version");
            this.connectionID = uRLConnection.getHeaderField("Conn-Id");
            if (this.connectionID == null) {
                TunneledSocketImpl.throwProtocolException("Tunneling could not ascertain a connection ID from the server");
            }
            this.backendServerID = uRLConnection.getHeaderField("WL-Dest");
            TunnelUtils.readConnectionParams(new DataInputStream(inputStream));
        }
        finally {
            TunnelUtils.drainStream(inputStream);
        }
        if (DEBUG) {
            this.p("tunneled connect() succesful to host: '" + this.host + "' port: '" + this.port + "' connectionID: '" + this.connectionID + "'");
        }
    }

    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        super.connect(socketAddress, n);
    }

    protected BiDirSocketImpl createServerImpl() throws IOException {
        return new TunneledSocketImpl(this, true);
    }

    public void run() {
        byte[] byArray = new byte[1024];
        InputStream inputStream = null;
        try {
            while (!this.isClosed()) {
                inputStream = null;
                String string = null;
                int n = -1;
                while (!this.isClosed()) {
                    String string2;
                    if (DEBUG) {
                        this.p("recv()");
                    }
                    long l = System.currentTimeMillis();
                    URLConnection uRLConnection = this.createURLConnection("/bea_wls_internal/iiop/ClientRecv/a.tun" + TunnelUtils.getRequestArgs(this.connectionID));
                    inputStream = uRLConnection.getInputStream();
                    if (DEBUG) {
                        this.p("run(): got connection in " + (System.currentTimeMillis() - l) + "ms");
                    }
                    this.readCookies(uRLConnection);
                    string = uRLConnection.getHeaderField("WL-Result");
                    if (DEBUG) {
                        Iterator<Map.Entry<String, List<String>>> iterator = uRLConnection.getHeaderFields().entrySet().iterator();
                        string2 = "";
                        while (iterator.hasNext()) {
                            Map.Entry<String, List<String>> entry = iterator.next();
                            string2 = string2 + "<" + entry.getKey() + "=" + entry.getValue() + ">, ";
                        }
                        this.p("run(): headers: " + string2);
                    }
                    if (string == null) {
                        TunneledSocketImpl.throwProtocolException("Tunneling result unspecified - is the HTTP server at host: '" + this.host + "' and port: '" + this.port + "' a WebLogic Server?");
                    }
                    if (string.equals("RETRY")) {
                        if (DEBUG) {
                            this.p("run(): retry request");
                        }
                        inputStream.close();
                        continue;
                    }
                    boolean bl = false;
                    try {
                        string2 = uRLConnection.getHeaderField("WL-Type");
                        if (string2 != null) {
                            n = Integer.parseInt(string2);
                            switch (n) {
                                case 0: 
                                case 2: 
                                case 3: {
                                    bl = true;
                                }
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (!string.equals("OK") || n < 0) {
                        TunnelUtils.drainStream(inputStream);
                        TunneledSocketImpl.throwProtocolException("Tunneling result not OK, result: '" + string + "', id: '" + this.connectionID + "'");
                    }
                    int n2 = 0;
                    l = System.currentTimeMillis();
                    while ((n2 = inputStream.read(byArray)) >= 0) {
                        if (bl) {
                            if (DEBUG) {
                                this.p("run(): received ServerSocket request: " + n + " " + n2 + " bytes in " + (System.currentTimeMillis() - l) + "ms");
                            }
                            ((TunneledSocketImpl)this.serverImpl).outpipe.write(byArray, 0, n2);
                        } else {
                            if (DEBUG) {
                                this.p("run(): received Socket response: " + n + " " + n2 + " bytes in " + (System.currentTimeMillis() - l) + "ms");
                            }
                            this.outpipe.write(byArray, 0, n2);
                        }
                        l = System.currentTimeMillis();
                    }
                    if (bl) {
                        ((TunneledSocketImpl)this.serverImpl).outpipe.flush();
                    } else {
                        this.outpipe.flush();
                    }
                    inputStream.close();
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                throwable.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.outpipe.close();
            ((TunneledSocketImpl)this.serverImpl).outpipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected URLConnection createURLConnection(String string) throws IOException {
        String string2 = this.getTunnelFactory().getTunnelHost();
        int n = this.getTunnelFactory().getTunnelPort();
        if (string2 == null) {
            string2 = this.host;
            n = this.port;
        }
        if (DEBUG) {
            this.p("createURLConnection() " + string2 + ":" + n + " -> " + this.host + ":" + this.port + " url=" + string);
        }
        URL uRL = new URL(this.getTunnelFactory().getProtocolName(), string2, n, string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        TunnelUtils.setCustomRequestProperties(customHeaders, uRLConnection);
        this.writeCookies(uRLConnection);
        if (this.backendServerID != null) {
            uRLConnection.setRequestProperty("WL-Dest", this.backendServerID);
        }
        return uRLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed()) {
            throw new IOException("The tunnel is closed");
        }
        if (DEBUG) {
            this.p("send()");
        }
        URLConnection uRLConnection = this.createURLConnection("/bea_wls_internal/iiop/ClientSend/a.tun" + TunnelUtils.getRequestArgs(this.connectionID));
        InputStream inputStream = null;
        try {
            uRLConnection.setDoOutput(true);
            OutputStream outputStream = uRLConnection.getOutputStream();
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            inputStream = uRLConnection.getInputStream();
            this.readCookies(uRLConnection);
            String string = uRLConnection.getHeaderField("WL-Result");
            if (string == null) {
                TunneledSocketImpl.throwProtocolException("Tunneling result unspecified - is the HTTP server at host: '" + this.host + "' and port: '" + this.port + "' a WebLogic Server?");
            }
            if (!string.equals("OK")) {
                TunneledSocketImpl.throwProtocolException("Tunneling result not OK, result: '" + string + "', id: '" + this.connectionID + "'");
            }
        }
        catch (Throwable throwable) {
            TunnelUtils.drainStream(inputStream);
            throw throwable;
        }
        TunnelUtils.drainStream(inputStream);
    }

    private final void p(String string) {
        System.out.println("<TunneledSocketImpl (" + System.identityHashCode(this) + ")>: " + string);
    }

    private static void throwProtocolException(String string) throws ProtocolException {
        ProtocolException protocolException = new ProtocolException(string);
        if (DEBUG) {
            protocolException.printStackTrace();
        }
        throw protocolException;
    }
}

