/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.iiop;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketImpl;
import weblogic.corba.client.iiop.BiDirSocket;
import weblogic.corba.client.iiop.BiDirSocketFactory;
import weblogic.corba.client.iiop.BiDirSocketImpl;

public class BiDirServerSocket
extends ServerSocket {
    private static final boolean DEBUG = BiDirServerSocket.getDebug();
    private BiDirSocketImpl myImpl = null;
    private BiDirSocketFactory factory;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.iiop");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public BiDirServerSocket(int n, BiDirSocketFactory biDirSocketFactory) throws IOException {
        super(n);
        this.factory = biDirSocketFactory;
    }

    public int getLocalPort() {
        return this.factory.getLocalAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() throws IOException {
        if (DEBUG) {
            BiDirServerSocket.p("accept()");
        }
        this.myImpl = this.factory.getOrQueueServerSocket(this);
        BiDirServerSocket biDirServerSocket = this;
        synchronized (biDirServerSocket) {
            while (this.myImpl == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            BiDirSocketImpl biDirSocketImpl = this.myImpl;
            this.myImpl = null;
            if (DEBUG) {
                BiDirServerSocket.p("accept() succeeded");
            }
            return this.createSocket(biDirSocketImpl);
        }
    }

    protected Socket createSocket(SocketImpl socketImpl) throws IOException {
        return new BiDirSocket(socketImpl, new InetSocketAddress(((BiDirSocketImpl)socketImpl).getServerHost(), ((BiDirSocketImpl)socketImpl).getServerPort()));
    }

    public synchronized void accept(BiDirSocketImpl biDirSocketImpl) {
        if (DEBUG) {
            BiDirServerSocket.p("accept(" + biDirSocketImpl + ")");
        }
        this.myImpl = biDirSocketImpl;
        this.notify();
    }

    private static final void p(String string) {
        System.out.println("<BiDirServerSocket>: " + string);
    }
}

