/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.iiop;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IIOP.ListenPoint;
import weblogic.corba.client.ClientORBInitializer;
import weblogic.corba.client.cluster.DummySocket;
import weblogic.corba.client.iiop.BiDirInterceptor;
import weblogic.corba.client.iiop.BiDirServerSocket;
import weblogic.corba.client.iiop.BiDirSocket;
import weblogic.corba.client.iiop.BiDirSocketImpl;
import weblogic.corba.client.utils.ORBWrapper;
import weblogic.rmi.extensions.server.HeartbeatMonitorListener;

public class BiDirSocketFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory {
    protected static final boolean DEBUG = BiDirSocketFactory.getDebug();
    private final LinkedList serverSockets;
    private final LinkedList serverImpls;
    private boolean initialized;
    private ServerSocket dummySocket;
    private InetSocketAddress localAddress;
    private boolean peerGone;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.iiop");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public BiDirSocketFactory() {
        block3: {
            this.serverSockets = new LinkedList();
            this.serverImpls = new LinkedList();
            this.initialized = false;
            this.peerGone = false;
            if (DEBUG) {
                BiDirSocketFactory.p("initialized");
            }
            try {
                this.dummySocket = new ServerSocket(0);
                this.localAddress = new InetSocketAddress(InetAddress.getLocalHost(), this.dummySocket.getLocalPort());
            }
            catch (IOException iOException) {
                if (!DEBUG) break block3;
                iOException.printStackTrace();
            }
        }
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        if (DEBUG) {
            BiDirSocketFactory.p("createServerSocket(" + n + ")");
        }
        BiDirServerSocket biDirServerSocket = new BiDirServerSocket(n, this);
        return biDirServerSocket;
    }

    public Socket createSocket(String string, int n) throws IOException {
        if (DEBUG) {
            BiDirSocketFactory.p("createSocket(" + string + ":" + n + ")");
        }
        try {
            return new BiDirSocket(string, n, this);
        }
        catch (SocketException socketException) {
            if (socketException instanceof ConnectException || socketException instanceof NoRouteToHostException) {
                if (DEBUG) {
                    BiDirSocketFactory.p("created DummySocket()");
                }
                return new DummySocket();
            }
            throw socketException;
        }
    }

    public Socket createSocket(String string, int n, Socket socket) throws IOException {
        if (DEBUG) {
            BiDirSocketFactory.p("createSocket(" + string + ":" + n + ")");
        }
        return new BiDirSocket(string, n, socket, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeInterceptor(final ORB oRB) {
        if (DEBUG) {
            BiDirSocketFactory.p("initializeInterceptor(" + oRB + ")");
        }
        if (!this.initialized) {
            BiDirSocketFactory biDirSocketFactory = this;
            synchronized (biDirSocketFactory) {
                block8: {
                    if (!this.initialized) {
                        try {
                            this.initialized = true;
                            BiDirInterceptor biDirInterceptor = (BiDirInterceptor)oRB.resolve_initial_references("BiDirInterceptor");
                            biDirInterceptor.setListenPoint(new ListenPoint(this.localAddress.getAddress().getHostAddress(), (short)this.localAddress.getPort()));
                            biDirInterceptor.setDeferredRegistration(new Runnable(){

                                public void run() {
                                    try {
                                        ClientORBInitializer.getHeartbeatMonitorDelegate().addHeartbeatMonitorListener(new ORBWrapper(oRB), new BiDirListener());
                                    }
                                    catch (INTERNAL iNTERNAL) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                        catch (InvalidName invalidName) {
                            if (!DEBUG) break block8;
                            invalidName.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BiDirSocketImpl getOrQueueServerSocket(ServerSocket serverSocket) {
        if (DEBUG) {
            BiDirSocketFactory.p("getOrQueueServerSocket(" + serverSocket + ")");
        }
        LinkedList linkedList = this.serverSockets;
        synchronized (linkedList) {
            try {
                return (BiDirSocketImpl)this.serverImpls.removeFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.serverSockets.add(serverSocket);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acceptOrQueueServerImpl(BiDirSocketImpl biDirSocketImpl) {
        if (DEBUG) {
            BiDirSocketFactory.p("acceptOrQueueServerImpl(" + biDirSocketImpl + ")");
        }
        LinkedList linkedList = this.serverSockets;
        synchronized (linkedList) {
            try {
                ((BiDirServerSocket)this.serverSockets.removeFirst()).accept(biDirSocketImpl);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.serverImpls.add(biDirSocketImpl);
            }
        }
    }

    boolean isPeerGone() {
        return this.peerGone;
    }

    protected static void p(String string) {
        System.err.println("<BiDirSocketFactory> " + string);
    }

    private final class BiDirListener
    implements HeartbeatMonitorListener {
        private BiDirListener() {
        }

        public void callback(Exception exception) {
            BiDirSocketFactory.this.peerGone = true;
        }
    }
}

