/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.iiop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import weblogic.corba.client.iiop.BiDirSocketFactory;
import weblogic.kernel.KernelStatus;

public class BiDirSocketImpl
extends SocketImpl
implements Runnable {
    private boolean closed = false;
    private boolean server = false;
    protected String host;
    private PipedInputStream inpipe;
    protected PipedOutputStream outpipe;
    private BiDirOutputStream out;
    protected BiDirSocketImpl serverImpl = null;
    protected BiDirSocketFactory factory;
    private Socket realSocket;
    private OutputStream realOut;
    protected static final int MSG_HEADER_LENGTH = 12;
    protected static final int MSG_TYPE_POS = 7;
    private static final int READ_PIPE_SIZE = 1024;
    private static final boolean DEBUG = BiDirSocketImpl.getDebug();
    private static int GIOP_FLAGS_POS = 6;
    private static int GIOP_SIZE_POS = 8;
    private static ThreadGroup responseReaderThreadGroup = null;
    private static boolean hasThreadGroupAccess = true;
    static /* synthetic */ Class class$weblogic$corba$client$iiop$BiDirSocketImpl;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.iiop");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public BiDirSocketImpl(BiDirSocketFactory biDirSocketFactory) {
        this.factory = biDirSocketFactory;
        this.localport = biDirSocketFactory.getLocalAddress().getPort();
        this.out = new BiDirOutputStream(this);
    }

    public BiDirSocketImpl(Socket socket, BiDirSocketFactory biDirSocketFactory) {
        this(biDirSocketFactory);
        this.realSocket = socket;
    }

    protected BiDirSocketImpl(BiDirSocketImpl biDirSocketImpl, boolean bl) throws IOException {
        this.out = new BiDirOutputStream(biDirSocketImpl);
        this.server = bl;
        this.inpipe = new PipedInputStream();
        this.outpipe = new PipedOutputStream(this.inpipe);
        this.host = biDirSocketImpl.host;
        this.address = biDirSocketImpl.address;
        this.factory = biDirSocketImpl.factory;
        this.closed = false;
    }

    boolean isServer() {
        return this.server;
    }

    protected void create(boolean bl) throws IOException {
        if (DEBUG) {
            this.p("create(" + bl + ")");
        }
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        if (DEBUG) {
            this.p("connect(" + inetAddress + ", " + n + ")");
        }
        this.connect(new InetSocketAddress(inetAddress, n));
    }

    protected void connect(String string, int n) throws IOException {
        if (DEBUG) {
            this.p("connect(" + string + ", " + n + ")");
        }
        this.connect(new InetSocketAddress(string, n));
    }

    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        if (DEBUG) {
            this.p("connect(" + socketAddress + ", " + n + ")");
        }
        this.connect((InetSocketAddress)socketAddress);
    }

    protected void bind(InetAddress inetAddress, int n) throws IOException {
        if (DEBUG) {
            this.p("bind(" + inetAddress + ", " + n + ")");
        }
    }

    protected void listen(int n) throws IOException {
        if (DEBUG) {
            this.p("listen(" + n + ")");
        }
    }

    protected synchronized void accept(SocketImpl socketImpl) throws IOException {
        if (DEBUG) {
            this.p("accept(" + socketImpl + ")");
        }
    }

    protected InputStream getInputStream() throws IOException {
        if (DEBUG) {
            this.p("getInputStream()");
        }
        if (this.inpipe == null || this.isClosed()) {
            throw new IOException("The connection is closed");
        }
        return this.inpipe;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (DEBUG) {
            this.p("getOutputStream()");
        }
        if (this.out == null || this.isClosed()) {
            throw new IOException("The connection is closed");
        }
        return this.out;
    }

    protected int available() throws IOException {
        if (DEBUG) {
            this.p("available()");
        }
        if (this.inpipe == null || this.isClosed()) {
            throw new IOException("The tunnel is closed");
        }
        return this.inpipe.available();
    }

    protected synchronized void close() throws IOException {
        if (DEBUG) {
            this.p("close()");
        }
        this.inpipe.close();
        this.out.close();
        this.closed = true;
        if (this.realOut != null) {
            this.realOut.close();
        }
        if (this.realSocket != null) {
            this.realSocket.close();
        }
    }

    protected synchronized boolean isClosed() {
        return this.closed;
    }

    protected void shutdownInput() throws IOException {
        if (DEBUG) {
            this.p("shutdownInput()");
        }
    }

    protected void shutdownOutput() throws IOException {
        if (DEBUG) {
            this.p("shutdownOutput()");
        }
    }

    protected void sendUrgentData(int n) throws IOException {
        if (DEBUG) {
            this.p("sendUrgentData(" + n + ")");
        }
    }

    public Object getOption(int n) throws SocketException {
        if (DEBUG) {
            this.p("getOption(" + n + ")");
        }
        return null;
    }

    public void setOption(int n, Object object) throws SocketException {
        if (DEBUG) {
            this.p("setOption(" + n + ", " + object + ")");
        }
        if (this.realSocket != null) {
            switch (n) {
                case 1: {
                    this.realSocket.setTcpNoDelay((Boolean)object);
                }
            }
        }
    }

    private synchronized void connect(InetSocketAddress inetSocketAddress) throws IOException {
        if (DEBUG) {
            this.p("connect(" + inetSocketAddress + ")");
        }
        if (this.isServer()) {
            return;
        }
        this.host = inetSocketAddress.getHostName();
        this.port = inetSocketAddress.getPort();
        this.address = inetSocketAddress.getAddress();
        this.connectInternal();
        if (DEBUG) {
            this.p("connect() succesful to " + this.host + ":" + this.port);
        }
        this.closed = false;
        this.inpipe = new PipedInputStream();
        this.outpipe = new PipedOutputStream(this.inpipe);
        this.serverImpl = this.createServerImpl();
        this.factory.acceptOrQueueServerImpl(this.serverImpl);
        Thread thread = BiDirSocketImpl.createResponseThread(this);
        thread.setDaemon(true);
        thread.start();
    }

    protected BiDirSocketImpl createServerImpl() throws IOException {
        return new BiDirSocketImpl(this, true);
    }

    protected void connectInternal() throws IOException {
        if (this.realSocket == null) {
            this.realSocket = new Socket(this.host, this.port);
        }
        this.realSocket.setSoTimeout(60000);
        this.realOut = this.realSocket.getOutputStream();
    }

    BiDirSocketImpl getServerImpl() {
        return this.serverImpl;
    }

    public int getServerPort() {
        return this.getPort();
    }

    public String getServerHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block32: {
            byte[] byArray = new byte[1024];
            InputStream inputStream = null;
            inputStream = this.realSocket.getInputStream();
            while (!this.isClosed()) {
                Object var3_3 = null;
                int n = -1;
                boolean bl = false;
                long l = System.currentTimeMillis();
                this.readBytes(inputStream, byArray, 0, 12);
                n = byArray[7];
                switch (n) {
                    case 0: 
                    case 2: 
                    case 3: {
                        bl = true;
                    }
                }
                if (n < 0) {
                    throw new ProtocolException("Bad inbound GIOP message");
                }
                int n2 = BiDirSocketImpl.getMsgLength(byArray);
                int n3 = BiDirSocketImpl.min(n2 - 12, 1012);
                this.readBytes(inputStream, byArray, 12, n3);
                n3 += 12;
                if (DEBUG) {
                    this.p("run(): reading GIOP message: " + n + " of length: " + n2);
                }
                do {
                    n2 -= n3;
                    if (bl) {
                        if (DEBUG) {
                            this.p("run(): received ServerSocket request: " + n + " " + n3 + " bytes in " + (System.currentTimeMillis() - l) + "ms");
                        }
                        this.serverImpl.outpipe.write(byArray, 0, n3);
                    } else {
                        if (DEBUG) {
                            this.p("run(): received Socket response: " + n + " " + n3 + " bytes in " + (System.currentTimeMillis() - l) + "ms");
                        }
                        this.outpipe.write(byArray, 0, n3);
                    }
                    l = System.currentTimeMillis();
                    n3 = BiDirSocketImpl.min(n2, 1024);
                } while (n2 > 0 && this.readBytes(inputStream, byArray, 0, n3));
                if (bl) {
                    this.serverImpl.outpipe.flush();
                } else {
                    this.outpipe.flush();
                }
                if (!DEBUG) continue;
                this.p("run(): dispatched message");
            }
            Object var11_11 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.outpipe.close();
                this.serverImpl.outpipe.close();
            }
            catch (IOException iOException) {}
            break block32;
            {
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    if (DEBUG) {
                        throwable.printStackTrace();
                    }
                    Object var11_12 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.outpipe.close();
                        this.serverImpl.outpipe.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.outpipe.close();
                    this.serverImpl.outpipe.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private final boolean readBytes(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            try {
                int n3 = inputStream.read(byArray, n, n2);
                if (n3 <= 0) {
                    throw new IOException("End of stream");
                }
                n2 -= n3;
                n += n3;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.factory.isPeerGone()) {
                    if (DEBUG) {
                        this.p("readBytes(): timed out, giving up");
                    }
                    throw socketTimeoutException;
                }
                if (!DEBUG) continue;
                this.p("readBytes(): timed out, retrying");
            }
        }
        return true;
    }

    protected synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed()) {
            throw new IOException("The tunnel is closed");
        }
        this.realOut.write(byArray, n, n2);
    }

    protected static final int getMsgLength(byte[] byArray) {
        byte by = (byte)(byArray[GIOP_FLAGS_POS] & 1);
        int n = GIOP_SIZE_POS;
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        int n4 = byArray[n++] & 0xFF;
        int n5 = byArray[n++] & 0xFF;
        if (by == 0) {
            return 12 + (n2 << 24 | n3 << 16 | n4 << 8 | n5);
        }
        return 12 + (n5 << 24 | n4 << 16 | n3 << 8 | n2);
    }

    private static final int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    private final void p(String string) {
        System.out.println("<BiDirSocketImpl (" + System.identityHashCode(this) + ")>: " + string);
    }

    private static Thread createResponseThread(Runnable runnable) {
        String string = "Tunneling Response Thread";
        if (!KernelStatus.isApplet()) {
            return new Thread(runnable, string);
        }
        BiDirSocketImpl.initializeResponseReaderThreadGroup();
        if (hasThreadGroupAccess && responseReaderThreadGroup != null) {
            return new Thread(responseReaderThreadGroup, runnable, string);
        }
        return new Thread(runnable, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeResponseReaderThreadGroup() {
        if (hasThreadGroupAccess && responseReaderThreadGroup == null) {
            Class clazz = class$weblogic$corba$client$iiop$BiDirSocketImpl == null ? (class$weblogic$corba$client$iiop$BiDirSocketImpl = BiDirSocketImpl.class$("weblogic.corba.client.iiop.BiDirSocketImpl")) : class$weblogic$corba$client$iiop$BiDirSocketImpl;
            synchronized (clazz) {
                if (responseReaderThreadGroup == null) {
                    try {
                        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                        while (true) {
                            if (threadGroup.getName().equals("main") && threadGroup.getParent().getName().equals("system")) {
                                ThreadGroup threadGroup2 = threadGroup;
                                responseReaderThreadGroup = new ThreadGroup(threadGroup2, "Response Reader ThreadGroup"){

                                    public String toString() {
                                        return "ResponseReaderThreadGroup(name=" + this.getName() + ", parent=" + this.getParent() + ")";
                                    }
                                };
                                return;
                            }
                            threadGroup = threadGroup.getParent();
                        }
                    }
                    catch (SecurityException securityException) {
                        System.out.println(" +++ <Warining> Don't have permissions to access ThreadGroup.  We strongly recommend to use signed applet.");
                        System.out.println(" +++ <Warining> Proceed further without creating ThreadGroup.");
                        hasThreadGroupAccess = false;
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class BiDirOutputStream
    extends OutputStream {
        private BiDirSocketImpl sock;

        private BiDirOutputStream(BiDirSocketImpl biDirSocketImpl) {
            this.sock = biDirSocketImpl;
        }

        public void write(int n) throws IOException {
            throw new IOException("write(int) not supported");
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.sock.write(byArray, n, n2);
        }

        public void close() throws IOException {
        }
    }
}

