/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import java.util.HashMap;
import javax.security.auth.Subject;
import org.omg.IOP.ServiceContext;

public class ClientSecurityContext {
    private static long nextClientContextId = 0L;
    private static HashMap statefulClientContextTable = new HashMap();
    private long contextId;
    private ServiceContext contextMessage;
    private Subject subject;

    public ClientSecurityContext(long l, Subject subject) {
        this.contextId = l;
        this.subject = subject;
    }

    public ServiceContext getMessageInContext() {
        return this.contextMessage;
    }

    public long getContextId() {
        return this.contextId;
    }

    public void setMessageInContext(ServiceContext serviceContext) {
        this.contextMessage = serviceContext;
    }

    public static final synchronized ClientSecurityContext allocateClientContext(Subject subject) {
        ClientSecurityContext clientSecurityContext = (ClientSecurityContext)statefulClientContextTable.get(subject);
        if (clientSecurityContext == null) {
            clientSecurityContext = new ClientSecurityContext(++nextClientContextId, subject);
            statefulClientContextTable.put(subject, clientSecurityContext);
            statefulClientContextTable.put(new Long(clientSecurityContext.getContextId()), clientSecurityContext);
        }
        return clientSecurityContext;
    }

    public static final synchronized ClientSecurityContext getClientContext(Subject subject) {
        return (ClientSecurityContext)statefulClientContextTable.get(subject);
    }

    public static final synchronized ClientSecurityContext getClientContext(long l) {
        return (ClientSecurityContext)statefulClientContextTable.get(new Long(l));
    }

    public static final synchronized ClientSecurityContext removeClientContext(long l) {
        ClientSecurityContext clientSecurityContext = (ClientSecurityContext)statefulClientContextTable.remove(new Long(l));
        statefulClientContextTable.remove(clientSecurityContext.subject);
        return clientSecurityContext;
    }

    public static final synchronized long getNextClientContextId() {
        return ++nextClientContextId;
    }
}

