/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import weblogic.corba.client.spi.SecurityManager;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.security.subject.SubjectProxy;

public final class ClientSecurityManager
implements SecurityManager {
    private static final boolean DEBUG = false;
    private static AbstractSubject kernelId = null;

    public ClientSecurityManager() {
        try {
            kernelId = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public final void pushSubject(Hashtable hashtable, Context context) throws NamingException {
        PasswordCredential passwordCredential = ClientSecurityManager.getEnvSecurityUser(hashtable);
        if (passwordCredential != null) {
            HashSet<PasswordCredential> hashSet = new HashSet<PasswordCredential>();
            hashSet.add(passwordCredential);
            SubjectProxy subjectProxy = new SubjectProxy(new Subject(false, new HashSet(), hashSet, new HashSet()));
            SubjectManager.getSubjectManager().pushSubject(kernelId, subjectProxy);
        }
    }

    public final void popSubject() {
        SubjectManager.getSubjectManager().popSubject(kernelId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PasswordCredential getEnvSecurityUser(Hashtable hashtable) throws IllegalArgumentException {
        try {
            Object v = hashtable.get("java.naming.security.credentials");
            String string = (String)hashtable.get("java.naming.security.principal");
            PasswordCredential passwordCredential = null;
            if (passwordCredential != null) {
                return passwordCredential;
            }
            if (v instanceof PasswordCredential) {
                return (PasswordCredential)v;
            }
            if (v instanceof String) {
                if (string == null) throw new IllegalArgumentException("The 'java.naming.security.principal' property has not been specified");
                passwordCredential = new PasswordCredential(string, (String)v);
            } else if (v == null) {
                if (string != null) {
                    passwordCredential = new PasswordCredential(string, null);
                }
            } else if (v != null && !(v instanceof SSLContext)) {
                throw new IllegalArgumentException("The 'java.naming.security.credentials' property must be either a password String, an instance of PasswordCredential or an instance of SSLContext.");
            }
            if (passwordCredential == null) return passwordCredential;
            hashtable.put("java.naming.security.credentials", passwordCredential);
            return passwordCredential;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("The 'java.naming.security.credentials' property must be either a password String or an instance of PasswordCredential.");
        }
    }

    static void p(String string) {
        System.err.println("<ClientSecurityManager> " + string);
    }
}

