/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.AccessController;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.MessageInContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import weblogic.corba.client.security.ClientSecurityContext;
import weblogic.corba.client.security.CompoundSecMechListImpl;
import weblogic.corba.client.security.EstablishContextImpl;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.security.subject.SubjectProxy;

public final class SecurityInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final boolean DEBUG = SecurityInterceptor.getDebug();
    public static final String NAME = "SecurityInterceptor";
    public static final int SecurityAttributeService = 15;
    private AbstractSubject kernelId = null;
    public int CEMinor = 1;
    public int CEMajorInvalidEvidence = 1;
    public int CEMajorInvalidMechanism = 2;
    public int CEMajorConflictingEvidence = 3;
    public int CEMajorNoContext = 4;
    private Current piCurrent;
    private Codec codec;
    private int slot;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.security");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public SecurityInterceptor(Current current, Codec codec, int n) {
        this.piCurrent = current;
        this.codec = codec;
        this.slot = n;
        try {
            this.kernelId = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public String name() {
        return NAME;
    }

    public void setSubject(Subject subject) {
        try {
            Any any = ORB.init().create_any();
            if (subject != null) {
                any.insert_Value((Serializable)subject);
            }
            this.piCurrent.set_slot(this.slot, any);
        }
        catch (InvalidSlot invalidSlot) {
            throw new SecurityException(invalidSlot.getMessage());
        }
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (DEBUG) {
            SecurityInterceptor.p("send_request(<" + Integer.toHexString(clientRequestInfo.effective_target()._hash(Integer.MAX_VALUE)) + ">." + clientRequestInfo.operation() + ")");
        }
        try {
            AbstractSubject abstractSubject = SubjectManager.getSubjectManager().getCurrentSubject(this.kernelId);
            if (abstractSubject == SubjectProxy.ANON) {
                return;
            }
            if (abstractSubject != null) {
                Subject subject = ((SubjectProxy)abstractSubject).getSubject();
                if (subject != null) {
                    ClientSecurityContext clientSecurityContext = ClientSecurityContext.getClientContext(subject);
                    if (clientSecurityContext != null && clientSecurityContext.getMessageInContext() != null) {
                        if (DEBUG) {
                            SecurityInterceptor.p("adding MessageInContext");
                        }
                        clientRequestInfo.add_request_service_context(clientSecurityContext.getMessageInContext(), true);
                    } else {
                        TaggedComponent[] taggedComponentArray = clientRequestInfo.get_effective_components(33);
                        if (DEBUG) {
                            SecurityInterceptor.p("adding security context from " + taggedComponentArray.length + " components for " + subject);
                        }
                        clientRequestInfo.add_request_service_context(this.createEstablishContext(taggedComponentArray[0], subject), true);
                    }
                } else if (DEBUG) {
                    SecurityInterceptor.p("null security context for " + Thread.currentThread());
                }
            } else if (DEBUG) {
                SecurityInterceptor.p("no security context for " + Thread.currentThread());
            }
        }
        catch (UserException userException) {
            if (DEBUG) {
                SecurityInterceptor.p("couldn't marshal security context: " + (Object)((Object)userException));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (DEBUG) {
                SecurityInterceptor.p("couldn't marshal security context: " + unsupportedEncodingException);
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            switch (bAD_PARAM.minor) {
                case 1330446364: {
                    if (!DEBUG) break;
                    SecurityInterceptor.p("no mech list in request target for: " + clientRequestInfo.operation() + "()");
                    break;
                }
                default: {
                    if (DEBUG) {
                        bAD_PARAM.printStackTrace();
                    }
                    if (DEBUG) {
                        SecurityInterceptor.p("couldn't marshal security context: " + (Object)((Object)bAD_PARAM));
                    }
                    throw bAD_PARAM;
                }
            }
        }
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            SecurityInterceptor.p("send_poll(" + clientRequestInfo.operation() + ")");
        }
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        block4: {
            if (DEBUG) {
                SecurityInterceptor.p("receive_reply(" + clientRequestInfo.operation() + ")");
            }
            try {
                CompleteEstablishContext completeEstablishContext = this.getCompleteEstablishContext(clientRequestInfo);
                if (completeEstablishContext != null && completeEstablishContext.context_stateful) {
                    ClientSecurityContext.getClientContext(completeEstablishContext.client_context_id).setMessageInContext(this.createMessageInContext(completeEstablishContext.client_context_id));
                }
            }
            catch (UserException userException) {
                if (!DEBUG) break block4;
                userException.printStackTrace();
            }
        }
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        block9: {
            if (DEBUG) {
                SecurityInterceptor.p("receive_exception(" + clientRequestInfo.operation() + ")");
            }
            try {
                ContextError contextError = this.getContextError(clientRequestInfo);
                if (contextError != null) {
                    if (contextError.minor_status == this.CEMinor && contextError.major_status == this.CEMajorNoContext && ClientSecurityContext.getClientContext(contextError.client_context_id) != null) {
                        ClientSecurityContext.removeClientContext(contextError.client_context_id);
                        if (DEBUG) {
                            SecurityInterceptor.p("client context not valid, retrying");
                        }
                        throw new ForwardRequest(clientRequestInfo.effective_target());
                    }
                    if (DEBUG) {
                        SecurityInterceptor.p("SAS authentication failed: " + contextError);
                    }
                }
            }
            catch (TypeMismatch typeMismatch) {
                if (DEBUG) {
                    typeMismatch.printStackTrace();
                }
            }
            catch (FormatMismatch formatMismatch) {
                if (!DEBUG) break block9;
                formatMismatch.printStackTrace();
            }
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            SecurityInterceptor.p("receive_other(" + clientRequestInfo.operation() + ")");
        }
    }

    private ServiceContext createEstablishContext(TaggedComponent taggedComponent, Subject subject) throws InvalidTypeForEncoding, UnsupportedEncodingException, FormatMismatch, TypeMismatch {
        Any any = this.codec.decode_value(taggedComponent.component_data, CompoundSecMechListHelper.type());
        CompoundSecMechListImpl compoundSecMechListImpl = new CompoundSecMechListImpl(CompoundSecMechListHelper.extract(any), this.codec);
        SASContextBody sASContextBody = new SASContextBody();
        EstablishContextImpl establishContextImpl = new EstablishContextImpl(compoundSecMechListImpl, subject, this.codec);
        sASContextBody.establish_msg(establishContextImpl.getContext());
        SASContextBodyHelper.insert(any, sASContextBody);
        byte[] byArray = this.codec.encode_value(any);
        return new ServiceContext(15, byArray);
    }

    private ServiceContext createMessageInContext(long l) throws InvalidTypeForEncoding, FormatMismatch {
        SASContextBody sASContextBody = new SASContextBody();
        sASContextBody.in_context_msg(new MessageInContext(l, false));
        Any any = ORB.init().create_any();
        SASContextBodyHelper.insert(any, sASContextBody);
        byte[] byArray = this.codec.encode_value(any);
        return new ServiceContext(15, byArray);
    }

    private CompleteEstablishContext getCompleteEstablishContext(ClientRequestInfo clientRequestInfo) throws TypeMismatch, FormatMismatch {
        try {
            ServiceContext serviceContext = clientRequestInfo.get_reply_service_context(15);
            if (DEBUG) {
                SecurityInterceptor.p("found SAS context for " + clientRequestInfo.operation() + "()");
            }
            Any any = this.codec.decode_value(serviceContext.context_data, SASContextBodyHelper.type());
            SASContextBody sASContextBody = SASContextBodyHelper.extract(any);
            switch (sASContextBody.discriminator()) {
                case 1: {
                    return sASContextBody.complete_msg();
                }
                case 4: {
                    throw new MARSHAL("CSI authentication error");
                }
            }
            throw new MARSHAL("Unsupported CSI reply");
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (bAD_PARAM.minor != 1330446362) {
                throw bAD_PARAM;
            }
            return null;
        }
    }

    private ContextError getContextError(ClientRequestInfo clientRequestInfo) throws TypeMismatch, FormatMismatch {
        if (clientRequestInfo.reply_status() != 1) {
            return null;
        }
        try {
            Any any;
            SASContextBody sASContextBody;
            ServiceContext serviceContext = clientRequestInfo.get_reply_service_context(15);
            if (DEBUG) {
                SecurityInterceptor.p("found SAS ContextError for " + clientRequestInfo.operation() + "()");
            }
            if ((sASContextBody = SASContextBodyHelper.extract(any = this.codec.decode_value(serviceContext.context_data, SASContextBodyHelper.type()))).discriminator() == 4) {
                return sASContextBody.error_msg();
            }
            return null;
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (bAD_PARAM.minor != 1330446362) {
                throw bAD_PARAM;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    protected static void p(String string) {
        System.err.println("<SecurityInterceptor> " + string);
    }
}

