/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.transaction;

import java.io.Serializable;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import weblogic.corba.j2ee.transaction.TransactionManagerImpl;

public final class TransactionInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final boolean DEBUG = TransactionInterceptor.getDebug();
    public static final String NAME = "TransactionInterceptor";
    private static final int TX_CONTEXT = 0;
    private Current piCurrent;
    private Codec codec;
    private int slot;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.ots");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public TransactionInterceptor(Current current, Codec codec, int n) {
        this.piCurrent = current;
        this.codec = codec;
        this.slot = n;
    }

    public String name() {
        return NAME;
    }

    public void setTransaction(UserTransaction userTransaction) throws SystemException {
        try {
            Any any = ORB.init().create_any();
            if (userTransaction != null) {
                any.insert_Value((Serializable)((Object)userTransaction));
            }
            this.piCurrent.set_slot(this.slot, any);
        }
        catch (InvalidSlot invalidSlot) {
            throw new SystemException(invalidSlot.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new SystemException(classCastException.getMessage());
        }
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (DEBUG) {
            TransactionInterceptor.p("send_request(<" + Integer.toHexString(clientRequestInfo.effective_target()._hash(Integer.MAX_VALUE)) + ">." + clientRequestInfo.operation() + ")");
        }
        try {
            TransactionManagerImpl transactionManagerImpl;
            Any any = clientRequestInfo.get_slot(this.slot);
            if (!any.type().kind().equals(TCKind.tk_null) && (transactionManagerImpl = (TransactionManagerImpl)any.extract_Value()).get_txcontext() != null) {
                clientRequestInfo.add_request_service_context(this.createTxContext(transactionManagerImpl.get_txcontext()), true);
            }
        }
        catch (InvalidSlot invalidSlot) {
            // empty catch block
        }
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            TransactionInterceptor.p("send_poll(" + clientRequestInfo.operation() + ")");
        }
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            TransactionInterceptor.p("receive_reply(" + clientRequestInfo.operation() + ")");
        }
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (DEBUG) {
            TransactionInterceptor.p("receive_exception(" + clientRequestInfo.operation() + ")");
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) {
        if (DEBUG) {
            TransactionInterceptor.p("receive_other(" + clientRequestInfo.operation() + ")");
        }
    }

    private PropagationContext getTxContext(ClientRequestInfo clientRequestInfo) {
        try {
            ServiceContext serviceContext = clientRequestInfo.get_reply_service_context(0);
            if (DEBUG) {
                TransactionInterceptor.p("found tx context for " + clientRequestInfo.operation() + "()");
            }
            Any any = this.codec.decode_value(serviceContext.context_data, PropagationContextHelper.type());
            return PropagationContextHelper.extract(any);
        }
        catch (TypeMismatch typeMismatch) {
            if (DEBUG) {
                TransactionInterceptor.p("bad tx context in request target for: " + clientRequestInfo.operation() + "()");
            }
        }
        catch (FormatMismatch formatMismatch) {
            if (DEBUG) {
                TransactionInterceptor.p("bad tx context in request target for: " + clientRequestInfo.operation() + "()");
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            switch (bAD_PARAM.minor) {
                case 1330446362: {
                    if (!DEBUG) break;
                    TransactionInterceptor.p("no tx context in request target for: " + clientRequestInfo.operation() + "()");
                    break;
                }
                default: {
                    if (DEBUG) {
                        bAD_PARAM.printStackTrace();
                    }
                    throw bAD_PARAM;
                }
            }
        }
        return null;
    }

    private ServiceContext createTxContext(PropagationContext propagationContext) {
        try {
            if (DEBUG) {
                TransactionInterceptor.p("createTxContext(" + propagationContext + ")");
            }
            Any any = ORB.init().create_any();
            PropagationContextHelper.insert(any, propagationContext);
            byte[] byArray = this.codec.encode_value(any);
            return new ServiceContext(0, byArray);
        }
        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
            if (DEBUG) {
                TransactionInterceptor.p("couldn't marshal tx context");
            }
            return null;
        }
    }

    protected static void p(String string) {
        System.err.println("<TransactionInterceptor> " + string);
    }
}

