/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import weblogic.corba.client.transaction.TransactionHelperImpl;
import weblogic.corba.j2ee.naming.EndPointInfo;
import weblogic.corba.j2ee.naming.NameParser;
import weblogic.corba.j2ee.naming.ORBInfo;
import weblogic.corba.j2ee.naming.Utils;
import weblogic.corba.orb.ORBHelperImpl;
import weblogic.jndi.WLInitialContextFactory;
import weblogic.kernel.KernelStatus;
import weblogic.transaction.TransactionHelper;

public class ORBHelper {
    public static final String ORB_INITIAL_HOST = "org.omg.CORBA.ORBInitialHost";
    public static final String ORB_INITIAL_PORT = "org.omg.CORBA.ORBInitialPort";
    public static final String ORB_INITIAL_REF = "org.omg.CORBA.ORBInitRef";
    public static final String ORB_DEFAULT_INITIAL_REF = "org.omg.CORBA.ORBDefaultInitRef";
    public static final String ORB_CLASS_PROP = "org.omg.CORBA.ORBClass";
    public static final String ORB_NAMING_PROP = "java.naming.corba.orb";
    public static final String SUN_SOCKET_FACTORY = "com.sun.CORBA.connection.ORBSocketFactoryClass";
    public static final String SUN_LISTEN_SOCKET = "com.sun.CORBA.connection.ORBListenSocket";
    public static final String SUN_FRAGMENT = "com.sun.CORBA.giop.ORBGIOP12BuffMgr";
    public static final String ORB_INITIALIZER = "org.omg.PortableInterceptor.ORBInitializerClass.";
    public static final String BI_DIR_ORBINIT = "weblogic.corba.client.iiop.BiDirORBInitializer";
    public static final String CLIENT_ORBINIT = "weblogic.corba.client.ClientORBInitializer";
    public static final String BI_DIR_SOCKET_FACTORY = "weblogic.corba.client.iiop.BiDirORBSocketFactory";
    public static final String BI_DIR_SSL_SOCKET_FACTORY = "weblogic.corba.client.iiop.BiDirSSLORBSocketFactory";
    public static final String SSL_SOCKET_FACTORY = "weblogic.corba.client.security.SSLORBSocketFactory";
    public static final String TUNNEL_SOCKET_FACTORY = "weblogic.corba.client.http.TunneledORBSocketFactory";
    public static final String TUNNEL_SSL_SOCKET_FACTORY = "weblogic.corba.client.http.TunneledSSLORBSocketFactory";
    public static final String CLUSTER_SOCKET_FACTORY = "weblogic.corba.client.cluster.ORBSocketFactory";
    public static final String NATIVE_TX_HELPER = "weblogic.corba.server.transaction.TransactionHelperImpl";
    public static final String ENABLE_SERVER_AFFINITY = "weblogic.jndi.enableServerAffinity";
    public static final String ORB_PROTOCOL = "weblogic.corba.orb.ORBProtocol";
    private static final boolean DEBUG = false;
    private static final String FALSE_PROP = "false";
    private static ORBHelper singleton;
    private static boolean enableIIOPClient;
    private static boolean thinClient;
    private static final boolean enableBiDir;
    private HashMap orbs = new HashMap();
    private HashMap sslCtxCache = new HashMap();
    private HashMap urlCache = new HashMap();
    private ORBInfo currentinfo = null;

    private static final boolean getBiDir() {
        try {
            return Boolean.getBoolean("weblogic.corba.client.bidir");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static ORBHelper getORBHelper() {
        if (singleton == null) {
            if (thinClient) {
                new WLInitialContextFactory();
            } else {
                ORBHelper.createORBHelper();
            }
        }
        return singleton;
    }

    public static synchronized void createORBHelper() {
        if (singleton == null) {
            String string = "";
            string = KernelStatus.isApplet() ? FALSE_PROP : System.getProperty("weblogic.system.iiop.enableClient");
            if (!FALSE_PROP.equals(string)) {
                enableIIOPClient = true;
                singleton = new ORBHelperImpl();
            } else {
                singleton = new ORBHelper();
            }
        }
    }

    public static synchronized void setORBHelper(ORBHelper oRBHelper) {
        singleton = oRBHelper;
    }

    private static boolean getServerAffinity(Hashtable hashtable) {
        return hashtable == null ? false : Boolean.valueOf((String)hashtable.get(ENABLE_SERVER_AFFINITY));
    }

    public synchronized ORB getORB(String string, Hashtable hashtable) throws NamingException {
        NameParser.URLInfo uRLInfo = this.parseURL(string);
        boolean bl = ORBHelper.getServerAffinity(hashtable);
        ORBInfo oRBInfo = this.getCachedORB(bl ? uRLInfo.getKey() : uRLInfo.getNextKey(), hashtable);
        if (oRBInfo != null) {
            return oRBInfo.getORB();
        }
        ORB oRB = null;
        if (string != null) {
            EndPointInfo endPointInfo = uRLInfo.getAddress();
            oRB = this.createORB(hashtable, endPointInfo, uRLInfo.getProtocol(), uRLInfo.serviceName + "=" + uRLInfo.getURL());
            oRBInfo = this.cacheORBAndCreateURL(uRLInfo.getKey(), oRB, uRLInfo);
        } else {
            oRB = this.createORB(hashtable, null, null, null);
            oRBInfo = this.createORBInfo(oRB);
            this.setCurrent(oRBInfo);
        }
        return oRBInfo.getORB();
    }

    private synchronized ORBInfo getCachedORB(String string, Hashtable hashtable) {
        ORBInfo oRBInfo = null;
        if (string != null && (oRBInfo = (ORBInfo)this.orbs.get(string)) != null) {
            this.setCurrent(oRBInfo);
            return oRBInfo;
        }
        if (hashtable != null && hashtable.get(ORB_NAMING_PROP) != null) {
            oRBInfo = this.cacheORB(string, (ORB)hashtable.get(ORB_NAMING_PROP));
        }
        return oRBInfo;
    }

    private ORBInfo cacheORB(String string, ORB oRB) {
        ORBInfo oRBInfo = this.createORBInfo(oRB);
        this.orbs.put(string, oRBInfo);
        this.setCurrent(oRBInfo);
        return oRBInfo;
    }

    private ORBInfo cacheORBAndCreateURL(String string, ORB oRB, NameParser.URLInfo uRLInfo) {
        ORBInfo oRBInfo = this.cacheORB(string, oRB);
        oRBInfo.setClusterURL(uRLInfo.getClusterURL());
        return oRBInfo;
    }

    private ORB createORB(Hashtable hashtable, EndPointInfo endPointInfo, String string, String string2) {
        java.lang.Object v;
        Properties properties = new Properties();
        if (hashtable != null) {
            properties.putAll((Map<?, ?>)hashtable);
        }
        if (properties.getProperty(ORB_CLASS_PROP) == null && this.getORBClass() != null) {
            properties.setProperty(ORB_CLASS_PROP, this.getORBClass());
        }
        if (endPointInfo != null) {
            if (endPointInfo.getPort() > 0) {
                properties.put(ORB_INITIAL_PORT, Integer.toString(endPointInfo.getPort()));
            }
            properties.put(ORB_PROTOCOL, string);
            if (string == "iiops") {
                properties.put(SUN_FRAGMENT, "0");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                properties.put(SUN_SOCKET_FACTORY, BI_DIR_SSL_SOCKET_FACTORY);
            } else if (string == "http") {
                properties.put(SUN_FRAGMENT, "0");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                properties.put(SUN_SOCKET_FACTORY, TUNNEL_SOCKET_FACTORY);
            } else if (string == "https") {
                properties.put(SUN_FRAGMENT, "0");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                properties.put(SUN_SOCKET_FACTORY, TUNNEL_SSL_SOCKET_FACTORY);
            } else if (thinClient) {
                properties.put(SUN_FRAGMENT, "0");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                if (enableBiDir) {
                    properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                    properties.put(SUN_SOCKET_FACTORY, BI_DIR_SOCKET_FACTORY);
                } else {
                    properties.put(SUN_SOCKET_FACTORY, CLUSTER_SOCKET_FACTORY);
                }
            }
            properties.put(ORB_INITIAL_HOST, endPointInfo.getHost());
            properties.put(ORB_INITIAL_REF, string2);
        }
        ORB oRB = ORB.init((String[])new String[0], (Properties)properties);
        if (hashtable != null && (v = hashtable.get("java.naming.security.credentials")) != null && v instanceof SSLContext) {
            this.sslCtxCache.put(oRB, v);
        }
        return oRB;
    }

    public final SSLContext getSSLContext(ORB oRB) {
        return (SSLContext)this.sslCtxCache.get(oRB);
    }

    public String getORBClass() {
        return null;
    }

    public ORB getLocalORB() throws NamingException {
        Properties properties = new Properties();
        if (this.getORBClass() != null) {
            properties.setProperty(ORB_CLASS_PROP, this.getORBClass());
        }
        return ORB.init((String[])new String[0], (Properties)properties);
    }

    public ORBInfo getCurrent() {
        return this.currentinfo;
    }

    public void setCurrent(ORBInfo oRBInfo) {
        this.currentinfo = oRBInfo;
    }

    public ORBInfo createORBInfo(ORB oRB) {
        return new ORBInfo(oRB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getORBReference(String string, Hashtable hashtable, String string2) throws NamingException {
        NameParser.URLInfo uRLInfo = this.parseURL(string);
        if (uRLInfo == null) {
            throw new InvalidNameException("url `" + string + "' is invalid");
        }
        boolean bl = ORBHelper.getServerAffinity(hashtable);
        for (int i = 0; i < uRLInfo.addressList.length; ++i) {
            String string3 = uRLInfo.getKey();
            ORBInfo oRBInfo = this.getCachedORB(string3, hashtable);
            if (oRBInfo == null) continue;
            try {
                Object object = oRBInfo.getORB().resolve_initial_references(string2);
                if (!bl) {
                    uRLInfo.getNextAddress();
                }
                oRBInfo.setClusterURL(uRLInfo.getClusterURL());
                return object;
            }
            catch (InvalidName invalidName) {
                throw Utils.wrapNamingException((Exception)((java.lang.Object)invalidName), "Couldn't resolve initial reference: " + string2);
            }
            catch (SystemException systemException) {
                ORBHelper oRBHelper = this;
                synchronized (oRBHelper) {
                    this.orbs.remove(string3);
                    this.setCurrent(null);
                }
                if (!ORBHelper.isRecoverableORBFailure(systemException)) {
                    throw Utils.wrapNamingException((Exception)((java.lang.Object)systemException), "Couldn't resolve initial reference: " + string2);
                }
                uRLInfo.getNextAddress();
            }
        }
        return this.getORBReferenceWithRetry(uRLInfo, hashtable, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getORBReferenceWithRetry(NameParser.URLInfo uRLInfo, Hashtable hashtable, String string) throws NamingException {
        ORB oRB = null;
        Object object = null;
        int n = 0;
        boolean bl = ORBHelper.getServerAffinity(hashtable);
        while (object == null) {
            EndPointInfo endPointInfo = uRLInfo.getAddress();
            String string2 = uRLInfo.getKey();
            oRB = this.createORB(hashtable, endPointInfo, uRLInfo.getProtocol(), uRLInfo.serviceName + "=" + uRLInfo.getURL());
            try {
                object = oRB.resolve_initial_references(string);
                if (!bl) {
                    uRLInfo.getNextAddress();
                }
                ORBHelper oRBHelper = this;
                synchronized (oRBHelper) {
                    if (this.getCachedORB(string2, hashtable) == null) {
                        this.cacheORBAndCreateURL(string2, oRB, uRLInfo);
                    }
                }
            }
            catch (InvalidName invalidName) {
                throw Utils.wrapNamingException((Exception)((java.lang.Object)invalidName), "Couldn't resolve initial reference: " + string);
            }
            catch (SystemException systemException) {
                if (!ORBHelper.isRecoverableORBFailure(systemException) || ++n >= uRLInfo.addressList.length) {
                    throw Utils.wrapNamingException((Exception)((java.lang.Object)systemException), "Couldn't connect to any host");
                }
                uRLInfo.getNextAddress();
            }
        }
        return object;
    }

    private final synchronized NameParser.URLInfo parseURL(String string) throws InvalidNameException {
        NameParser.URLInfo uRLInfo = (NameParser.URLInfo)this.urlCache.get(string);
        if (uRLInfo == null) {
            uRLInfo = NameParser.parseURL(string);
            this.urlCache.put(string, uRLInfo);
        }
        return uRLInfo;
    }

    public void pushTransactionHelper() {
        if (enableIIOPClient) {
            TransactionHelper.pushTransactionHelper(ORBHelper.createTxHelper(NATIVE_TX_HELPER));
        } else {
            TransactionHelper.pushTransactionHelper(new TransactionHelperImpl());
        }
    }

    static boolean isRecoverableORBFailure(SystemException systemException) {
        return (systemException instanceof COMM_FAILURE || systemException instanceof MARSHAL || systemException instanceof OBJECT_NOT_EXIST || systemException instanceof BAD_PARAM && systemException.minor == 1330446344) && (systemException.completed.value() == 1 || systemException.completed.value() == 2);
    }

    private static TransactionHelper createTxHelper(String string) {
        try {
            return (TransactionHelper)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new Error(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException.toString());
        }
    }

    protected static void p(String string) {
        System.err.println("<ORBHelper> " + string);
    }

    static {
        enableIIOPClient = false;
        thinClient = false;
        enableBiDir = ORBHelper.getBiDir();
        try {
            Class.forName(CLUSTER_SOCKET_FACTORY);
            if (!KernelStatus.isServer()) {
                thinClient = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

