/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import javax.naming.CannotProceedException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import weblogic.corba.cos.naming.NamingContextAnyHelper;
import weblogic.corba.cos.naming.NamingContextAnyPackage.CannotProceed;
import weblogic.corba.cos.naming.NamingContextAnyPackage.NotFound;
import weblogic.corba.cos.naming.NamingContextAnyPackage.WNameComponent;
import weblogic.corba.j2ee.naming.NameParser;

public final class Utils {
    private static final boolean DEBUG = false;

    public static NamingException wrapNamingException(Exception exception, String string) throws NamingException {
        NamingException namingException = null;
        if (exception instanceof InvalidName) {
            namingException = new InvalidNameException(string);
        } else if (exception instanceof org.omg.CORBA.ORBPackage.InvalidName) {
            namingException = new InvalidNameException(string);
        } else if (exception instanceof org.omg.CosNaming.NamingContextPackage.NotFound) {
            org.omg.CosNaming.NamingContextPackage.NotFound notFound = (org.omg.CosNaming.NamingContextPackage.NotFound)exception;
            string = string + ": `" + Utils.nameComponentToString(notFound.rest_of_name) + "'" + Utils.notFoundReasonToString(notFound.why);
            namingException = new NameNotFoundException(string);
        } else if (exception instanceof NotFound) {
            NotFound notFound = (NotFound)((java.lang.Object)exception);
            string = string + ": `" + Utils.nameComponentToString(notFound.rest_of_name) + "'" + Utils.notFoundReasonToString(notFound.why);
            namingException = new NameNotFoundException(string);
        } else if (exception instanceof org.omg.CosNaming.NamingContextPackage.CannotProceed) {
            org.omg.CosNaming.NamingContextPackage.CannotProceed cannotProceed = (org.omg.CosNaming.NamingContextPackage.CannotProceed)exception;
            string = string + ": unresolved name `" + Utils.nameComponentToString(cannotProceed.rest_of_name) + "'";
            namingException = new CannotProceedException(string);
        } else if (exception instanceof CannotProceed) {
            CannotProceed cannotProceed = (CannotProceed)((java.lang.Object)exception);
            string = string + ": unresolved name `" + Utils.nameComponentToString(cannotProceed.rest_of_name) + "'";
            namingException = new CannotProceedException(string);
        } else {
            namingException = exception instanceof AlreadyBound ? new NameAlreadyBoundException(string) : new NamingException(string);
        }
        namingException.setRootCause(exception);
        return namingException;
    }

    public static SystemException unwrapNamingException(SystemException systemException, NamingException namingException) {
        if (namingException.getRootCause() instanceof SystemException) {
            return (SystemException)namingException.getRootCause();
        }
        systemException.initCause((Throwable)namingException);
        return systemException;
    }

    public static SystemException initCORBAExceptionWithCause(SystemException systemException, Throwable throwable) {
        systemException.initCause(throwable);
        return systemException;
    }

    public static final NamingContext narrowContext(Object object) {
        if (object._is_a(NamingContextAnyHelper.id())) {
            return NamingContextAnyHelper.narrow(object);
        }
        return NamingContextHelper.narrow((Object)object);
    }

    public static final NameComponent[] stringToNameComponent(String string) throws NamingException {
        string = NameParser.getNameString(string);
        while (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        string = string.replace('.', '/');
        int n = 1;
        String string2 = string;
        while (string2.indexOf(47) != -1) {
            ++n;
            string2 = string2.substring(string2.indexOf(47) + 1);
        }
        NameComponent[] nameComponentArray = new NameComponent[n];
        string2 = string;
        n = 0;
        while (string2.indexOf(47) != -1) {
            nameComponentArray[n] = new NameComponent(string2.substring(0, string2.indexOf(47)), "");
            ++n;
            string2 = string2.substring(string2.indexOf(47) + 1);
        }
        nameComponentArray[n] = new NameComponent(string2, "");
        return nameComponentArray;
    }

    public static final WNameComponent[] stringToWNameComponent(String string) throws NamingException {
        return Utils.nameToWName(Utils.stringToNameComponent(string));
    }

    public static final WNameComponent[] nameToWName(NameComponent[] nameComponentArray) throws NamingException {
        WNameComponent[] wNameComponentArray = new WNameComponent[nameComponentArray.length];
        for (int i = 0; i < nameComponentArray.length; ++i) {
            wNameComponentArray[i] = new WNameComponent(nameComponentArray[i].id, nameComponentArray[i].kind);
        }
        return wNameComponentArray;
    }

    public static final String nameComponentToString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (nameComponentArray != null || nameComponentArray.length > 0) {
            for (int i = 0; i < nameComponentArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("/");
                }
                stringBuffer.append(nameComponentArray[i].id);
                if (nameComponentArray[i].kind.length() <= 0) continue;
                stringBuffer.append("/").append(nameComponentArray[i].kind);
            }
        }
        return stringBuffer.toString();
    }

    public static final String nameComponentToString(WNameComponent[] wNameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (wNameComponentArray != null || wNameComponentArray.length > 0) {
            for (int i = 0; i < wNameComponentArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("/");
                }
                stringBuffer.append(wNameComponentArray[i].id);
                if (wNameComponentArray[i].kind.length() <= 0) continue;
                stringBuffer.append("/").append(wNameComponentArray[i].kind);
            }
        }
        return stringBuffer.toString();
    }

    private static final String notFoundReasonToString(NotFoundReason notFoundReason) {
        switch (notFoundReason.value()) {
            case 0: {
                return " could not be found.";
            }
            case 1: {
                return " is not a naming context.";
            }
            case 2: {
                return " is not a remote object.";
            }
        }
        return null;
    }
}

